/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.gui;

import com.miui.theme.tool.os.OS;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.util.ThemeHelper;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Observable;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class NewThemeDialog
extends Observable
implements ActionListener {
    private JDialog dialog = new JDialog();
    private JButton scanBtn;
    private JButton saveBtn;
    private JButton cancelBtn;
    private JTextField nameField;
    private JTextField pathField;
    private Container parent;

    public NewThemeDialog(Container parentContainer) {
        this.parent = parentContainer;
        this.dialog.setModal(true);
        this.dialog.setSize(400, 200);
        this.dialog.setTitle(ResourceFactory.getString("new_theme_title"));
        this.dialog.setResizable(false);
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints gc = new GridBagConstraints();
        this.dialog.setLayout(layout);
        gc.fill = 1;
        gc.anchor = 17;
        JLabel nameLabel = new JLabel(ResourceFactory.getString("new_theme_themename"));
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridwidth = 1;
        layout.setConstraints(nameLabel, gc);
        this.dialog.add(nameLabel);
        this.nameField = new JTextField(ResourceFactory.getString("new_theme_default_name"));
        gc.gridx = 1;
        gc.gridy = 0;
        gc.gridwidth = 3;
        gc.weightx = 0.8;
        layout.setConstraints(this.nameField, gc);
        this.dialog.add(this.nameField);
        JLabel pathLabel = new JLabel(ResourceFactory.getString("new_theme_themepath"));
        gc.gridx = 0;
        gc.gridy = 1;
        gc.gridwidth = 1;
        gc.weightx = 0.0;
        layout.setConstraints(pathLabel, gc);
        this.dialog.add(pathLabel);
        this.pathField = new JTextField(ThemeHelper.sLastClosedInfo.get("mtzPath"));
        gc.gridx = 1;
        gc.gridy = 1;
        gc.gridwidth = 3;
        gc.weightx = 0.8;
        layout.setConstraints(this.pathField, gc);
        this.dialog.add(this.pathField);
        this.scanBtn = new JButton(ResourceFactory.getString("global_scan"));
        gc.gridx = 4;
        gc.gridy = 1;
        gc.gridwidth = 1;
        gc.weightx = 0.0;
        layout.setConstraints(this.scanBtn, gc);
        this.dialog.add(this.scanBtn);
        this.saveBtn = new JButton(ResourceFactory.getString("global_save"));
        gc.gridx = 1;
        gc.gridy = 2;
        gc.gridwidth = 1;
        gc.weightx = 0.0;
        layout.setConstraints(this.saveBtn, gc);
        this.dialog.add(this.saveBtn);
        this.cancelBtn = new JButton(ResourceFactory.getString("global_cancel"));
        gc.gridx = 2;
        gc.gridy = 2;
        gc.gridwidth = 1;
        gc.weightx = 0.0;
        layout.setConstraints(this.cancelBtn, gc);
        this.dialog.add(this.cancelBtn);
        this.scanBtn.addActionListener(this);
        this.saveBtn.addActionListener(this);
        this.cancelBtn.addActionListener(this);
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.setLocationRelativeTo(this.parent);
    }

    public void openDialog() {
        this.dialog.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.scanBtn) {
            JFileChooser jfc = new JFileChooser();
            jfc.setDialogTitle(ResourceFactory.getString("new_theme_choose_path_title"));
            jfc.setVisible(true);
            jfc.setCurrentDirectory(new File(ThemeHelper.sLastClosedInfo.get("mtzPath")));
            jfc.setFileSelectionMode(1);
            jfc.addActionListener(this);
            int state = jfc.showOpenDialog(this.dialog);
            if (state == 0) {
                String srcFolder;
                File f = jfc.getSelectedFile();
                ThemeHelper.sThemeFolderPath = srcFolder = f.getAbsolutePath().trim();
                this.pathField.setText(srcFolder);
                if (f.getParent() != null) {
                    ThemeHelper.sLastClosedInfo.put("mtzPath", f.getParent());
                }
            }
        } else if (e.getSource() == this.saveBtn) {
            String name = this.nameField.getText();
            String path = this.pathField.getText();
            if (ThemeHelper.isNullOrEmpty(name)) {
                JOptionPane.showMessageDialog(this.dialog, ResourceFactory.getString("new_theme_tip_no_name"));
                return;
            }
            if (ThemeHelper.isNullOrEmpty(path)) {
                JOptionPane.showMessageDialog(this.dialog, ResourceFactory.getString("new_theme_tip_illegal_path"));
                return;
            }
            File pathFile = new File(path);
            if (!pathFile.exists()) {
                pathFile.mkdirs();
            }
            if (!pathFile.isDirectory()) {
                JOptionPane.showMessageDialog(this.dialog, ResourceFactory.getString("new_theme_tip_illegal_path"));
                return;
            }
            try {
                File f = new File(String.valueOf(path) + File.separator + name);
                if (f.exists()) {
                    int choice = JOptionPane.showConfirmDialog(this.dialog, String.valueOf(name) + " " + ResourceFactory.getString("new_theme_tip_exist"), ResourceFactory.getString("global_confirm_dlg_title"), 0);
                    if (choice != 0) {
                        return;
                    }
                    OS.rmDir(String.valueOf(path) + File.separator + name);
                }
                f.mkdir();
                ThemeHelper.sThemeFolderPath = String.valueOf(path) + File.separator + name;
                ThemeHelper.sThemeName = name;
                this.newThemeCompleted();
            }
            catch (Exception exception) {}
        } else if (e.getSource() == this.cancelBtn) {
            this.dialog.dispose();
        }
    }

    public void newThemeCompleted() {
        super.setChanged();
        this.notifyObservers();
        this.dialog.dispose();
    }
}

