/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.icons;

import com.miui.theme.tool.icons.TFilter;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.util.ThemeHelper;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import miui.imagefilters.IImageFilter;
import miui.imagefilters.ImageData;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class TransformFilter {
    public static final String TF_ICON_TRANSFORM = "IconTransform";
    public static final String TF_NAME = "name";
    public static final String TF_VALUE = "value";
    public static final String TF_CONFIG = "Config";
    public static final String TF_CONFIG_NAME_USEMODICON = "UseModIcon";
    public static final String TF_POINTS_MAPPING = "PointsMapping";
    public static final String TF_ICON_FILTERS = "IconFilters";
    public static final String TF_POINT = "Point";
    public static final String TF_POINT_FROMX = "fromX";
    public static final String TF_POINT_FROMY = "fromY";
    public static final String TF_POINT_TOX = "toX";
    public static final String TF_POINT_TOY = "toY";
    public static final String TF_FILTER = "Filter";
    public static final String TF_FILTER_NAME = "name";
    public static final String TF_FILTER_PARAM = "Param";
    public static final String FILTER_HSL = "Hsl";
    public static final String FILTER_HSL_HUEMODIFY = "HueModify";
    public static final String FILTER_HSL_HUEADJUST = "HueAdjust";
    public static final String FILTER_HSL_SATURATIONMODIFY = "SaturationModify";
    public static final String FILTER_HSL_SATURATIONADJUST = "SaturationAdjust";
    public static final String FILTER_HSL_LIGHTNESSMODIFY = "LightnessModify";
    public static final String FILTER_HSL_LIGHTNESSADJUST = "LightnessAdjust";
    public static final String FILTER_EDGES = "Edges";
    public static final String FILTER_LEVELS = "Levels";
    public static final String FILTER_LEVELS_INPUTMIN = "InputMin";
    public static final String FILTER_LEVELS_INPUTMIDDLE = "InputMiddle";
    public static final String FILTER_LEVELS_INPUTMAX = "InputMax";
    public static final String FILTER_LEVELS_OUTPUTMIN = "OutputMin";
    public static final String FILTER_LEVELS_OUTPUTMAX = "OutputMax";
    public static final String FILTER_GRAYSCALE = "GrayScale";
    public static final String FILTER_GRAYSCALE_BLACKCOLOR = "BlackColor";
    public static final String FILTER_GRAYSCALE_WHITECOLOR = "WhiteColor";
    public static final String FILTER_BLENDIMAGE = "BlendImage";
    public boolean mUseModIcon = true;
    private File mFilterFile;
    public List<Float> mPointsMappingFrom = new ArrayList<Float>();
    public List<Float> mPointsMappingTo = new ArrayList<Float>();
    public List<TFilter> mFilters = new ArrayList<TFilter>();

    public TransformFilter(File filterFile) {
        this.mFilterFile = filterFile;
    }

    public void load() {
        if (this.mFilterFile.exists()) {
            SAXBuilder builder = new SAXBuilder();
            try {
                Document document = builder.build(this.mFilterFile);
                Element iconTransformNode = document.getRootElement();
                if (!iconTransformNode.getName().equals(TF_ICON_TRANSFORM)) {
                    return;
                }
                for (Element r : iconTransformNode.getChildren()) {
                    if (r.getName().equals(TF_CONFIG)) {
                        if (!r.getAttributeValue("name").equalsIgnoreCase(TF_CONFIG_NAME_USEMODICON)) continue;
                        this.mUseModIcon = Boolean.parseBoolean(r.getAttributeValue(TF_VALUE));
                        continue;
                    }
                    if (r.getName().equals(TF_POINTS_MAPPING)) {
                        for (Element point : r.getChildren()) {
                            if (!point.getName().equals(TF_POINT)) continue;
                            this.mPointsMappingFrom.add(Float.valueOf(Float.parseFloat(point.getAttributeValue(TF_POINT_FROMX))));
                            this.mPointsMappingFrom.add(Float.valueOf(Float.parseFloat(point.getAttributeValue(TF_POINT_FROMY))));
                            this.mPointsMappingTo.add(Float.valueOf(Float.parseFloat(point.getAttributeValue(TF_POINT_TOX))));
                            this.mPointsMappingTo.add(Float.valueOf(Float.parseFloat(point.getAttributeValue(TF_POINT_TOY))));
                        }
                        continue;
                    }
                    if (!r.getName().equals(TF_ICON_FILTERS)) continue;
                    for (Element filter : r.getChildren()) {
                        if (!filter.getName().equals(TF_FILTER)) continue;
                        TFilter tf = new TFilter();
                        tf.mName = filter.getAttributeValue("name");
                        ArrayList<Map.Entry<String, String>> paramEntrys = new ArrayList<Map.Entry<String, String>>();
                        for (Element param : filter.getChildren()) {
                            if (!param.getName().equals(TF_FILTER_PARAM)) continue;
                            AbstractMap.SimpleEntry<String, String> paramEntry = new AbstractMap.SimpleEntry<String, String>(param.getAttributeValue("name"), param.getAttributeValue(TF_VALUE));
                            paramEntrys.add(paramEntry);
                        }
                        tf.mParamEntrys = paramEntrys;
                        this.mFilters.add(tf);
                    }
                }
            }
            catch (JDOMException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void save() {
        Element iconTransform = new Element(TF_ICON_TRANSFORM);
        if (!this.mUseModIcon) {
            Element useModIcon = new Element(TF_CONFIG);
            useModIcon.setAttribute("name", TF_CONFIG_NAME_USEMODICON);
            useModIcon.setAttribute(TF_VALUE, Boolean.FALSE.toString());
            iconTransform.addContent((Content)useModIcon);
        }
        if (this.mPointsMappingFrom.size() > 0) {
            Element pointsMapping = new Element(TF_POINTS_MAPPING);
            int i = 0;
            while (i < this.mPointsMappingFrom.size() / 2) {
                Element point = new Element(TF_POINT);
                point.setAttribute(TF_POINT_FROMX, "" + this.mPointsMappingFrom.get(2 * i));
                point.setAttribute(TF_POINT_FROMY, "" + this.mPointsMappingFrom.get(2 * i + 1));
                point.setAttribute(TF_POINT_TOX, "" + this.mPointsMappingTo.get(2 * i));
                point.setAttribute(TF_POINT_TOY, "" + this.mPointsMappingTo.get(2 * i + 1));
                pointsMapping.addContent((Content)point);
                ++i;
            }
            iconTransform.addContent((Content)pointsMapping);
        }
        Element iconFilters = new Element(TF_ICON_FILTERS);
        if (this.mFilters.size() > 0) {
            for (TFilter tf : this.mFilters) {
                Element filter = new Element(TF_FILTER);
                filter.setAttribute("name", tf.mName);
                if (tf.mParamEntrys != null) {
                    for (Map.Entry<String, String> entry : tf.mParamEntrys) {
                        Element param = new Element(TF_FILTER_PARAM);
                        param.setAttribute("name", entry.getKey());
                        param.setAttribute(TF_VALUE, entry.getValue());
                        filter.addContent((Content)param);
                    }
                }
                iconFilters.addContent((Content)filter);
            }
            iconTransform.addContent((Content)iconFilters);
        }
        XMLOutputter outputter = new XMLOutputter();
        try {
            if (!this.mFilterFile.getParentFile().exists()) {
                this.mFilterFile.getParentFile().mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(this.mFilterFile);
            Format format = Format.getPrettyFormat();
            format.setEncoding(ThemeHelper.CHARSET);
            format.setIndent("    ");
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, ThemeHelper.CHARSET);
            outputter.setFormat(format);
            outputter.output(new Document(iconTransform), (Writer)osw);
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Image render(BufferedImage image) {
        ImageData imgData = ImageData.bufferedImageToImageData(image);
        for (TFilter tf : this.mFilters) {
            IImageFilter filter = IImageFilter.Factory.create(tf.mName, tf.mParamEntrys);
            filter.process(imgData);
        }
        BufferedImage bi = ImageData.imageDataToBufferedImage(imgData);
        Image img = GUIUtil.scaleImage(bi, GUIUtil.HDPI_SIZE, 4);
        bi = new BufferedImage(img.getWidth(null), img.getHeight(null), 6);
        Graphics g = bi.getGraphics();
        g.drawImage(img, 0, 0, null);
        if (this.mPointsMappingTo.size() == 8) {
            g.setColor(Color.RED);
            int i = 0;
            while (i < this.mPointsMappingTo.size() / 2) {
                g.drawLine(this.f2i(this.mPointsMappingTo.get(i * 2)), this.f2i(this.mPointsMappingTo.get(i * 2 + 1)), this.f2i(this.mPointsMappingTo.get((i + 1) % 4 * 2)), this.f2i(this.mPointsMappingTo.get((i + 1) % 4 * 2 + 1)));
                ++i;
            }
        }
        return bi;
    }

    int f2i(Float f) {
        int v = (int)f.floatValue();
        if (v == GUIUtil.HDPI_SIZE) {
            v = GUIUtil.HDPI_SIZE - 1;
        }
        return v;
    }
}

