/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.module;

import com.android.internal.util.FastXmlSerializer;
import com.miui.theme.tool.util.ThemeHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class MIUIThemeValues {
    public static final int THEME_VALUES_TYPE = 0;
    public static final int THEME_VALUES_NAME = 1;
    public static final int THEME_VALUES_VALUE = 2;
    public static final int THEME_VALUES_PACKAGE = 3;
    public static final String THEME_VALUES_ATTRIBUTE_NAME = "name";
    public static final String THEME_VALUES_ATTRIBUTE_PACKAGE = "package";
    public static final String THEME_VALUES_ROOT_NODE = "MIUI_Theme_Values";
    File mThemeValuesFile;
    Vector<Vector<String>> mThemeValues;

    public void setXmlFile(File themeValuesFile) {
        this.mThemeValuesFile = themeValuesFile;
    }

    public void parse() {
        this.mThemeValues = new Vector();
        SAXBuilder builder = new SAXBuilder();
        try {
            Document document = builder.build(this.mThemeValuesFile);
            Element themeValuesNode = document.getRootElement();
            for (Element ele : themeValuesNode.getChildren()) {
                Vector<String> vs = new Vector<String>();
                vs.add(0, ele.getName());
                vs.add(1, ele.getAttributeValue(THEME_VALUES_ATTRIBUTE_NAME));
                vs.add(2, ele.getText());
                vs.add(3, ele.getAttributeValue(THEME_VALUES_ATTRIBUTE_PACKAGE));
                if (vs.get(1) == null || vs.get(0) == null) continue;
                if (vs.get(2) == null) {
                    vs.set(2, "");
                }
                if (vs.get(3) == null) {
                    vs.set(3, "");
                }
                this.mThemeValues.add(vs);
            }
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Vector<Vector<String>> getThemeValuesFromFile(File themeValuesFile) {
        if (!themeValuesFile.exists()) {
            return new Vector<Vector<String>>();
        }
        MIUIThemeValues tv = new MIUIThemeValues();
        tv.setXmlFile(themeValuesFile);
        tv.parse();
        return tv.getAll();
    }

    public static void saveThemeValuesFromToFile(File themeValuesFile, Vector<Vector<String>> values) {
        MIUIThemeValues mtv = new MIUIThemeValues();
        mtv.setXmlFile(themeValuesFile);
        mtv.setAll(values);
        mtv.save();
    }

    public void setAll(Vector<Vector<String>> themeValues) {
        this.mThemeValues = themeValues;
    }

    Vector<Vector<String>> getAll() {
        return this.mThemeValues;
    }

    public void save() {
        FastXmlSerializer out = new FastXmlSerializer();
        try {
            FileOutputStream fos = new FileOutputStream(this.mThemeValuesFile);
            out.setOutput(fos, ThemeHelper.CHARSET);
            out.startDocument(null, true);
            out.startTag(null, THEME_VALUES_ROOT_NODE);
            for (Vector<String> vs : this.mThemeValues) {
                out.startTag(null, vs.get(0));
                if (vs.get(1).equals("miui_password_unlock_screen_edittext_horizontal_padding")) {
                    System.out.println(vs);
                }
                out.attribute(null, THEME_VALUES_ATTRIBUTE_NAME, vs.get(1));
                if (!vs.get(3).equals("")) {
                    out.attribute(null, THEME_VALUES_ATTRIBUTE_PACKAGE, vs.get(3));
                }
                out.text(vs.get(2));
                out.endTag(null, vs.get(0));
            }
            out.endTag(null, THEME_VALUES_ROOT_NODE);
            out.flush();
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

