/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.os;

import com.miui.theme.tool.os.LogOutputThread;
import com.miui.theme.tool.os.OS;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.util.ThemeHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class CmdUtils {
    static Logger logger = Logger.getLogger(CmdUtils.class.getName());
    public static final String THEME_LOC = "/sdcard/MIUI/theme/";
    public static final String IMPORT_APPS_APK_FILE = "tools" + File.separator + "ShowApps.apk";
    public static final String IMPORT_APPS_APK_COMPONENT_NAME = "com.miui.themetool/com.miui.themetool.ShowAppsActivity";
    public static final String SHOWAPP_APK_PACKAGE_NAME = "com.miui.themetool";
    public static final String INTENT_GENERATE = "generate";
    public static final String INTENT_GENERATE_APPINFO = "appinfo";
    public static final String INTENT_GENERATE_ICONS = "icons";
    public static final String SYSTEM_THEME_PATH = "/data/system/theme";
    public static final String THEME_NAME = "MIUIThemeToolGenerated.mtz";
    public static final String SYSTEM_THEME_CUSTOMIZED_ICONS_PATH = "/data/system/customized_icons/";
    public static final String SYSTEM_THEME_CLOCK_PATH = "/data/data/com.miui.home/app_clock_bak/*";
    public static final String THEME_WALLPAPER_PATH = "wallpaper" + File.separator + "default_wallpaper.jpg";
    public static final String SYSTEM_WALLPAPER_PATH = "/data/data/com.android.settings/files/wallpaper";
    public static final String JLB_SYSTEM_WALLPAPER_PATH = "/data/system/users/0/wallpaper";
    public static final String THEME_LOCKSCREEN_WALLPAPER_PATH = "wallpaper" + File.separator + "default_lock_wallpaper.jpg";
    public static final String SYSTEM_LOCKSCREEN_WALLPAPER_PATH = "/data/system/theme/lock_wallpaper";

    public static String[] initS() {
        String[] s = new String[3];
        s[0] = "sh";
        s[1] = "-c";
        if (OS.getOS() == 1) {
            s[0] = "cmd";
            s[1] = "/c";
        }
        String path = ThemeHelper.getUserDir();
        path = CmdUtils.convertPathSpace(path);
        s[2] = String.valueOf(path) + File.separator;
        return s;
    }

    public static String convertPathSpace(String path) {
        int i = 0;
        while (i < path.length()) {
            if (path.charAt(i) == ' ') {
                path = path.subSequence(0, i) + "\" \"" + path.substring(i + 1, path.length());
                i += 2;
            }
            ++i;
        }
        return path;
    }

    public static boolean adb_push_MIUIThemeToolGenerated(String src) {
        return CmdUtils.adb_push(src, "/sdcard/MIUI/theme/MIUIThemeToolGenerated.mtz");
    }

    public static boolean adb_push(String src, String dest) {
        String[] s = CmdUtils.initS();
        logger.info(src);
        s[2] = String.valueOf(s[2]) + CmdUtils.makeCommand("push \"" + src + "\" \"" + dest + "\"");
        return CmdUtils.run(s);
    }

    public static boolean adb_pull(String source) {
        return CmdUtils.adb_pull(source, "");
    }

    public static boolean adb_pull(String source, String dest) {
        if (!dest.isEmpty()) {
            dest = "\"" + dest + "\"";
        }
        String[] s = CmdUtils.initS();
        s[2] = String.valueOf(s[2]) + CmdUtils.makeCommand("pull \"" + source + "\" " + dest);
        return CmdUtils.run(s);
    }

    public static boolean adb_shell_applyTheme(boolean fullApply, long applyFlag) {
        String[] s = CmdUtils.initS();
        String theme_file_path = "theme_file_path";
        if (ThemeHelper.isFreeThemeManager()) {
            theme_file_path = "file_path";
        }
        String command = "shell am start -n com.android.thememanager/com.android.thememanager.ApplyThemeForScreenshot -e \"" + theme_file_path + "\" \"" + THEME_LOC + THEME_NAME + "\" " + " -e \"api_called_from\" \"ThemeEditor_" + ThemeHelper.getVersion() + "\"";
        if (!fullApply) {
            command = String.valueOf(command) + " -e \"theme_remove_flags\" \"0\"";
            command = String.valueOf(command) + " -e \"theme_apply_flags\" \"" + applyFlag + "\"";
        }
        s[2] = String.valueOf(s[2]) + CmdUtils.makeCommand(command);
        return CmdUtils.run(s);
    }

    public static boolean adb_shell_start(String componentName) {
        return CmdUtils.adb_shell_start(componentName, null);
    }

    public static boolean adb_shell_start(String componentName, HashMap<String, String> args) {
        String arguments = "";
        if (args != null) {
            for (String key : args.keySet()) {
                arguments = String.valueOf(arguments) + " -e \"" + key + "\" \"" + args.get(key) + "\"";
            }
        }
        String[] s = CmdUtils.initS();
        s[2] = String.valueOf(s[2]) + CmdUtils.makeCommand("shell am start -n " + componentName + arguments);
        return CmdUtils.run(s);
    }

    public static boolean aapt_dump_resources(File apkFile) {
        String[] s = CmdUtils.initS();
        String apkFilePath = apkFile.getAbsolutePath();
        if (apkFilePath.contains(" ")) {
            apkFilePath = "\"" + apkFilePath + "\"";
        }
        s[2] = OS.getOS() == 3 ? String.valueOf(s[2]) + "tools" + File.separator + "aapt-mac dump --values resources " + apkFilePath + " >values.txt" : String.valueOf(s[2]) + "tools" + File.separator + "aapt dump --values resources " + apkFilePath + " >values.txt";
        logger.debug(s[2]);
        return CmdUtils.run(s);
    }

    public static String aapt_get_package_name(File apkFile) {
        String line;
        BufferedReader br;
        String packageName;
        String badging;
        block6: {
            String[] s = CmdUtils.initS();
            String apkFilePath = apkFile.getAbsolutePath();
            if (apkFilePath.contains(" ")) {
                apkFilePath = "\"" + apkFilePath + "\"";
            }
            badging = "badging.txt";
            s[2] = OS.getOS() == 3 ? String.valueOf(s[2]) + "tools" + File.separator + "aapt-mac dump badging " + apkFilePath + " >" + badging : String.valueOf(s[2]) + "tools" + File.separator + "aapt dump badging " + apkFilePath + " >" + badging;
            logger.debug(s[2]);
            CmdUtils.run(s);
            File f = new File(badging);
            if (!f.exists()) {
                return null;
            }
            packageName = null;
            br = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            line = br.readLine();
            if (line.contains("package: name=")) break block6;
            return null;
        }
        try {
            int start = line.indexOf("'");
            int end = line.indexOf("'", start + 1);
            packageName = line.substring(start + 1, end);
            br.close();
            OS.rmFile(badging);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return packageName;
    }

    public static boolean apktool(String apkFilePath, String pkg) {
        String[] s = CmdUtils.initS();
        if (apkFilePath.contains(" ")) {
            apkFilePath = "\"" + apkFilePath + "\"";
        }
        String str = System.getProperty("user.dir").trim();
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) == ' ') {
                str = str.subSequence(0, i) + "\" \"" + str.substring(i + 1, str.length());
                i += 2;
            }
            ++i;
        }
        s[2] = OS.getOS() == 3 ? String.valueOf(s[2]) + "tools" + File.separator + "apktool-mac d -f --keep-broken-res " + apkFilePath + " " + str + File.separator + pkg + File.separator : String.valueOf(s[2]) + "tools" + File.separator + "apktool d -f --keep-broken-res " + apkFilePath + " " + str + File.separator + pkg + File.separator;
        logger.info(s[2]);
        Runtime rt = Runtime.getRuntime();
        Process ps = null;
        try {
            ps = rt.exec(s);
            InputStream stderr = ps.getErrorStream();
            InputStreamReader isr = new InputStreamReader(stderr);
            BufferedReader br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null) {
            }
            ps.waitFor();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean apktool_install(String apkFilePath, String alias) {
        String[] s = CmdUtils.initS();
        if (apkFilePath.contains(" ")) {
            apkFilePath = "\"" + apkFilePath + "\"";
        }
        String str = System.getProperty("user.dir").trim();
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) == ' ') {
                str = str.subSequence(0, i) + "\" \"" + str.substring(i + 1, str.length());
                i += 2;
            }
            ++i;
        }
        s[2] = OS.getOS() == 3 ? String.valueOf(s[2]) + "tools" + File.separator + "apktool-mac if " + apkFilePath + " " + alias : String.valueOf(s[2]) + "tools" + File.separator + "apktool if " + apkFilePath + " " + alias;
        return CmdUtils.run(s);
    }

    public static boolean adb_install(String apkName) {
        GUIUtil.alert(ResourceFactory.getString("install_apk_alert"));
        String[] s = CmdUtils.initS();
        s[2] = String.valueOf(s[2]) + CmdUtils.makeCommand("install -r \"" + apkName + "\"");
        return CmdUtils.run(s);
    }

    public static boolean adb_uninstall(String apkPkgName) {
        String[] s = CmdUtils.initS();
        s[2] = String.valueOf(s[2]) + CmdUtils.makeCommand("uninstall \"" + apkPkgName + "\"");
        return CmdUtils.run(s);
    }

    public static boolean runShell(String batName, String[] args) {
        String[] s = CmdUtils.initS();
        s[2] = batName;
        if (args != null && args.length > 0) {
            int i = 0;
            while (i < args.length) {
                s[2] = String.valueOf(s[2]) + " '" + args[i] + "' ";
                ++i;
            }
        }
        return CmdUtils.run(s);
    }

    public static void hideFileInWin(String FilePath) {
        try {
            Runtime.getRuntime().exec("attrib +H \"" + FilePath + "\"");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean deleteDir(String dir) {
        String[] s = CmdUtils.initS();
        s[2] = OS.getOS() == 1 ? "rd /s/q \"" + dir + "\"" : "rm -rf \"" + dir + "\"";
        logger.debug(s[2]);
        return CmdUtils.run(s);
    }

    public static boolean deleteFile(String file) {
        String[] s = CmdUtils.initS();
        s[2] = OS.getOS() == 1 ? "del /f/s/q \"" + file + "\"" : "rm -rf \"" + file + "\"";
        logger.debug(s[2]);
        return CmdUtils.run(s);
    }

    public static boolean moveFile(String source, String dest) {
        String[] s = CmdUtils.initS();
        s[2] = OS.getOS() == 1 ? "move /Y \"" + source + "\" \"" + dest + "\"" : "mv -f \"" + source + "\" \"" + dest + "\"";
        logger.debug(s[2]);
        return CmdUtils.run(s);
    }

    public static boolean renameFile(String source, String dest) {
        String[] s = CmdUtils.initS();
        s[2] = OS.getOS() == 1 ? "ren \"" + source + "\" \"" + dest + "\"" : "mv -f \"" + source + "\" \"" + dest + "\"";
        logger.debug(s[2]);
        return CmdUtils.run(s);
    }

    public static boolean copyFile(String source, String dest) {
        String[] s = CmdUtils.initS();
        s[2] = OS.getOS() == 1 ? "copy /Y \"" + source + "\" \"" + dest + "\"" : "cp -f \"" + source + "\" \"" + dest + "\"";
        logger.debug(s[2]);
        return CmdUtils.run(s);
    }

    public static boolean copyDir(String source, String dest) {
        String[] s = CmdUtils.initS();
        if (OS.getOS() == 1) {
            s[2] = "xcopy /E/Y \"" + source + "\" \"" + dest + File.separator + "\"";
        } else {
            File destFile = new File(dest);
            if (destFile.exists()) {
                CmdUtils.deleteDir(destFile.getAbsolutePath());
            }
            s[2] = "cp -rf \"" + source + "\"" + " \"" + dest + "\"";
        }
        logger.debug(s[2]);
        return CmdUtils.run(s);
    }

    public static boolean openAndSelectFileInWindows(String filePath) {
        String[] s = CmdUtils.initS();
        s[2] = "explorer /select," + filePath;
        return CmdUtils.run(s);
    }

    private static synchronized boolean run(String[] s) {
        if (ThemeHelper.isInnerUserMode()) {
            if (s.length == 3) {
                logger.info(s[2].toString());
            } else {
                logger.info(s[0].toString());
            }
        }
        Runtime rt = Runtime.getRuntime();
        Process ps = null;
        try {
            boolean flag;
            ps = rt.exec(s);
            BufferedReader inputBufferedReader = new BufferedReader(new InputStreamReader(ps.getInputStream()));
            new LogOutputThread("i", inputBufferedReader).start();
            BufferedReader errorBufferedReader = new BufferedReader(new InputStreamReader(ps.getErrorStream()));
            new LogOutputThread("e", errorBufferedReader).start();
            if (ps.waitFor() == 0) {
                flag = true;
            } else {
                flag = false;
                logger.debug(s[2]);
                logger.debug("Failure exec");
                byte[] b = new byte[100];
                logger.debug(ps.getErrorStream().read(b));
                logger.debug(new String(b));
            }
            return flag;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static synchronized void runNoWait(String[] s) {
        logger.info(s[2].toString());
        Runtime rt = Runtime.getRuntime();
        Process ps = null;
        try {
            ps = rt.exec(s, null, new File(ThemeHelper.getUserDir()).getParentFile());
            BufferedReader inputBufferedReader = new BufferedReader(new InputStreamReader(ps.getInputStream()));
            new LogOutputThread("i", inputBufferedReader).start();
            BufferedReader errorBufferedReader = new BufferedReader(new InputStreamReader(ps.getErrorStream()));
            new LogOutputThread("e", errorBufferedReader).start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean openNinePatchEditor(String path) {
        String[] s = CmdUtils.initS();
        File file = new File(path);
        if (!file.exists()) {
            return false;
        }
        path = file.getAbsolutePath();
        path = CmdUtils.convertPathSpace(path);
        s[2] = OS.getOS() == 3 ? String.valueOf(s[2]) + "tools" + File.separator + "draw9patch-mac " + path : String.valueOf(s[2]) + "tools" + File.separator + "draw9patch " + path;
        logger.debug(s[2]);
        CmdUtils.runNoWait(s);
        return true;
    }

    public static boolean adb_shell_applyThemeSpecial(String srcTmpPath) {
        String locakscreenThemeWallpaper;
        if (!CmdUtils.adb_root()) {
            logger.info("root fail");
            return false;
        }
        if (!CmdUtils.adb_rm(SYSTEM_THEME_PATH)) {
            logger.info("rm fail");
            return false;
        }
        if (!CmdUtils.adb_push(srcTmpPath, SYSTEM_THEME_PATH)) {
            logger.info("push fail");
            return false;
        }
        String themeWallpaper = String.valueOf(srcTmpPath) + File.separator + THEME_WALLPAPER_PATH;
        if (new File(themeWallpaper).exists()) {
            if (!CmdUtils.adb_push(themeWallpaper, SYSTEM_WALLPAPER_PATH)) {
                logger.info("push wallpaper fail");
                return false;
            }
            if (!CmdUtils.adb_push(themeWallpaper, JLB_SYSTEM_WALLPAPER_PATH)) {
                logger.info("push wallpaper jlb fail");
                return false;
            }
        }
        if (new File(locakscreenThemeWallpaper = String.valueOf(srcTmpPath) + File.separator + THEME_LOCKSCREEN_WALLPAPER_PATH).exists() && !CmdUtils.adb_push(locakscreenThemeWallpaper, SYSTEM_LOCKSCREEN_WALLPAPER_PATH)) {
            logger.info("push lockscreen wallpaper fail");
            return false;
        }
        CmdUtils.adb_rm(SYSTEM_THEME_CUSTOMIZED_ICONS_PATH);
        CmdUtils.adb_rm(SYSTEM_THEME_CLOCK_PATH);
        CmdUtils.adb_kill_system_server();
        return true;
    }

    public static boolean adb_kill_system_server() {
        String[] s = CmdUtils.initS();
        s[2] = String.valueOf(s[2]) + CmdUtils.makeCommand("shell busybox pkill system_server");
        return CmdUtils.run(s);
    }

    public static boolean adb_reboot() {
        String[] s = CmdUtils.initS();
        s[2] = String.valueOf(s[2]) + CmdUtils.makeCommand("reboot");
        return CmdUtils.run(s);
    }

    private static String makeCommand(String command) {
        if (OS.getOS() == 3) {
            return "tools" + File.separator + "adb-mac " + command;
        }
        return "tools" + File.separator + "adb " + command;
    }

    public static boolean adb_root() {
        String[] s = CmdUtils.initS();
        s[2] = String.valueOf(s[2]) + CmdUtils.makeCommand("root");
        boolean result = CmdUtils.run(s);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static boolean adb_rm(String systemThemePath) {
        String[] s = CmdUtils.initS();
        s[2] = String.valueOf(s[2]) + CmdUtils.makeCommand("shell rm -r " + systemThemePath);
        return CmdUtils.run(s);
    }

    public static synchronized boolean adb_killServer() {
        String[] s = CmdUtils.initS();
        s[2] = String.valueOf(s[2]) + CmdUtils.makeCommand("kill-server");
        return CmdUtils.run(s);
    }

    public static boolean adb_devices() {
        String[] s = CmdUtils.initS();
        s[2] = String.valueOf(s[2]) + CmdUtils.makeCommand("devices");
        return CmdUtils.run(s);
    }

    public static void startEditor() {
        String parentPath = String.valueOf(new File(ThemeHelper.getUserDir()).getParent()) + File.separator;
        String[] s = CmdUtils.initS();
        if (OS.getOS() == 1) {
            s[2] = String.valueOf(parentPath) + "MIUIThemeEditor.exe";
        } else if (OS.getOS() == 2) {
            s[2] = "chmod 777 " + parentPath + "start-linux.sh";
            CmdUtils.run(s);
            s[2] = String.valueOf(parentPath) + "start-linux.sh";
        } else {
            return;
        }
        CmdUtils.runNoWait(s);
    }
}

