/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.resourceeditor;

import com.miui.theme.tool.gui.MainFrame;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.resourceeditor.CenterEditorPanel;
import com.miui.theme.tool.resourceeditor.CenterReplacePanel;
import com.miui.theme.tool.resourceeditor.Resource;
import com.miui.theme.tool.resourceeditor.Screenshot;
import com.miui.theme.tool.resourceeditor.ScreenshotTree;
import com.miui.theme.tool.resourceeditor.ScreenshotXml;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.util.GridBagHelper;
import com.miui.theme.tool.util.ThemeHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileFilter;
import java.util.Collections;
import java.util.HashMap;
import java.util.UUID;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class ResourceMainPanel
extends JPanel
implements ActionListener,
TreeSelectionListener {
    private static boolean editable = false;
    private boolean editModeFlag = false;
    public JButton mChangeEditMode;
    private String mPackageName;
    public Vector<ScreenshotXml> mScreenshotXmls = new Vector();
    public String mPackageTemplatePath;
    private final JScrollPane mScreenshotScroll = new JScrollPane();
    private JPanel mCenterPanel = new JPanel();
    private JPanel mLeftPanel = new JPanel();
    public JButton mCaptureScreenButton;
    public static final int LEFT_PANEL_WIDTH = 200;
    public JButton mDeleteScreenButton;
    public JPanel mRightPanel = new JPanel();
    private JScrollPane mRightPanelScroll = new JScrollPane(this.mRightPanel);
    public String mPackageReplacePath;
    private JButton mSaveButton;
    private JButton mRefreshButton;
    ScreenshotTree mScreenshotTree;
    ScreenshotXml mCurrentScreenshotXml;
    private JButton mViewButton;
    private JButton mReplaceScreenButton;
    private Resource[] mResourceClipboard;
    public String mPackageResourceCatalogPath;

    public static boolean isEditable() {
        return editable;
    }

    public static void setEditable(boolean editable) {
        ResourceMainPanel.editable = editable;
    }

    public Resource[] getResourceClipboard() {
        return this.mResourceClipboard;
    }

    public void setResourceClipboard(Resource[] clipboard) {
        this.mResourceClipboard = clipboard;
    }

    public ResourceMainPanel(String packageName) {
        if (ThemeHelper.isInnerUserMode()) {
            ResourceMainPanel.setEditable(true);
        }
        this.initComponents(packageName);
        this.initLayout();
    }

    private void initComponents(String packageName) {
        this.mPackageName = ThemeHelper.clearDesc(packageName);
        this.mPackageTemplatePath = String.valueOf(ThemeHelper.getTemplatePath()) + File.separator + this.mPackageName;
        this.mPackageReplacePath = String.valueOf(ThemeHelper.sThemeFolderPath) + File.separator + this.mPackageName;
        this.mPackageResourceCatalogPath = String.valueOf(ThemeHelper.getResourceCatalogPath()) + File.separator + this.mPackageName;
        this.loadResources();
        this.mScreenshotTree = new ScreenshotTree(packageName);
        this.mScreenshotTree.addTreeSelectionListener(this);
        this.mScreenshotTree.setVector(this.mScreenshotXmls);
        this.mScreenshotScroll.setViewportView(this.mScreenshotTree);
        this.mScreenshotTree.addMouseMotionListener(new MouseAdapter(){
            ScreenshotXml mCurrentMotionXml;

            @Override
            public void mouseMoved(MouseEvent e) {
                TreePath path = ResourceMainPanel.this.mScreenshotTree.getPathForLocation(e.getX(), e.getY());
                if (path == null) {
                    return;
                }
                Object o = path.getLastPathComponent();
                if (o instanceof DefaultMutableTreeNode && (o = ((DefaultMutableTreeNode)o).getUserObject()) instanceof ScreenshotXml) {
                    this.mCurrentMotionXml = (ScreenshotXml)o;
                    ResourceMainPanel.this.mScreenshotTree.setToolTipText(this.getCompleteInfo());
                }
            }

            private String getCompleteInfo() {
                HashMap<String, StringBuilder> hintFolderMap = new HashMap<String, StringBuilder>();
                for (Resource r : this.mCurrentMotionXml.mResources) {
                    int i = 0;
                    while (i < r.mPaths.size()) {
                        String path = String.valueOf(ResourceMainPanel.this.mPackageReplacePath) + File.separator + r.mPaths.get(i);
                        if (!hintFolderMap.containsKey(ThemeHelper.getFolderName(path))) {
                            hintFolderMap.put(ThemeHelper.getFolderName(path), new StringBuilder());
                        }
                        String color = new File(path).exists() ? "green" : "red";
                        ((StringBuilder)hintFolderMap.get(ThemeHelper.getFolderName(path))).append("<font color='" + color + "'>" + r.mPathDescriptions.get(i) + " " + ThemeHelper.getFileName(path) + "</font><br />");
                        ++i;
                    }
                }
                StringBuilder hintOutput = new StringBuilder("<html>");
                for (String key : hintFolderMap.keySet()) {
                    hintOutput.append("<font color='blue'>");
                    hintOutput.append(key);
                    hintOutput.append("</font>");
                    hintOutput.append(":<br />");
                    hintOutput.append((CharSequence)hintFolderMap.get(key));
                }
                hintOutput.append("</font></html>");
                return hintOutput.toString();
            }
        });
        this.mScreenshotScroll.setHorizontalScrollBarPolicy(31);
        this.mCaptureScreenButton = new JButton(ResourceFactory.getString("capture_screen"));
        this.mCaptureScreenButton.addActionListener(this);
        this.mSaveButton = new JButton(ResourceFactory.getString("save"));
        this.mSaveButton.addActionListener(this);
        this.mRefreshButton = new JButton(ResourceFactory.getString("refresh"));
        this.mRefreshButton.addActionListener(this);
        this.mViewButton = new JButton(ResourceFactory.getString("view"));
        this.mViewButton.addActionListener(this);
        this.mReplaceScreenButton = new JButton(ResourceFactory.getString("replace_screen"));
        this.mReplaceScreenButton.addActionListener(this);
        this.mDeleteScreenButton = new JButton(ResourceFactory.getString("delete_screen"));
        this.mDeleteScreenButton.addActionListener(this);
        this.mChangeEditMode = new JButton(ResourceFactory.getString("enter_edit_mode"));
        this.mChangeEditMode.addActionListener(this);
        this.setEditModeVisible(false);
        if (!ResourceMainPanel.isEditable()) {
            this.mChangeEditMode.setVisible(false);
        }
        this.mScreenshotTree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 69 && e.isControlDown()) {
                    ResourceMainPanel.this.mChangeEditMode.setVisible(!ResourceMainPanel.this.mChangeEditMode.isVisible());
                    ResourceMainPanel.setEditable(ResourceMainPanel.this.mChangeEditMode.isVisible());
                    if (ResourceMainPanel.this.mChangeEditMode.isVisible()) {
                        ResourceMainPanel.this.clickEditMode();
                    }
                }
            }
        });
    }

    private void initLayout() {
        this.mLeftPanel.setLayout(new GridBagLayout());
        GridBagHelper.addComponent(this.mLeftPanel, this.mChangeEditMode, 0, 0, 2, 1, 0, 0, 0, 0, 1.0, 0.0, 1, 10);
        GridBagHelper.addComponent(this.mLeftPanel, this.mSaveButton, 0, 1, 1, 1, 0, 0, 0, 0, 1.0, 0.0, 1, 10);
        GridBagHelper.addComponent(this.mLeftPanel, this.mRefreshButton, 1, 1, 1, 1, 0, 0, 0, 0, 1.0, 0.0, 1, 10);
        GridBagHelper.addComponent(this.mLeftPanel, this.mScreenshotScroll, 0, 2, 2, 1, 0, 0, 0, 0, 1.0, 1.0, 1, 10);
        GridBagHelper.addComponent(this.mLeftPanel, this.mCaptureScreenButton, 0, 3, 1, 1, 0, 0, 0, 0, 1.0, 0.0, 1, 10);
        GridBagHelper.addComponent(this.mLeftPanel, this.mReplaceScreenButton, 1, 3, 1, 1, 0, 0, 0, 0, 1.0, 0.0, 1, 10);
        GridBagHelper.addComponent(this.mLeftPanel, this.mViewButton, 0, 4, 1, 1, 0, 0, 0, 0, 1.0, 0.0, 1, 10);
        GridBagHelper.addComponent(this.mLeftPanel, this.mDeleteScreenButton, 1, 4, 1, 1, 0, 0, 0, 0, 1.0, 0.0, 1, 10);
        GroupLayout gl = new GroupLayout(this);
        this.setLayout(gl);
        gl.setHorizontalGroup(gl.createSequentialGroup().addComponent(this.mLeftPanel, 200, 200, 200).addComponent(this.mCenterPanel, -1, 500, Short.MAX_VALUE).addComponent(this.mRightPanelScroll, -1, 500, Short.MAX_VALUE));
        gl.setVerticalGroup(gl.createParallelGroup().addComponent(this.mLeftPanel).addComponent(this.mCenterPanel).addComponent(this.mRightPanelScroll));
    }

    private void clickEditMode() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ResourceMainPanel.this.mChangeEditMode.doClick();
                System.out.println("do click");
            }
        });
    }

    private void defaultSelect() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ResourceMainPanel.this.mScreenshotXmls.size() <= 0) {
                    ResourceMainPanel.this.mCurrentScreenshotXml = null;
                    ResourceMainPanel.this.initContent();
                    return;
                }
            }
        });
    }

    private void initContent() {
        this.alert2("");
        this.mCenterPanel.removeAll();
        this.mCenterPanel.setLayout(new BorderLayout());
        this.mRightPanel.removeAll();
        if (this.mScreenshotXmls.size() > 0 && this.mCurrentScreenshotXml != null) {
            CenterReplacePanel.unbindWindowFocusListener();
            if (this.editModeFlag) {
                CenterEditorPanel cep = new CenterEditorPanel(this);
                this.mCenterPanel.add((Component)cep, "Center");
            } else {
                CenterReplacePanel crp = new CenterReplacePanel(this);
                this.mCenterPanel.add((Component)crp, "Center");
            }
        }
        this.validate();
        this.repaint();
    }

    private void loadResources() {
        this.mScreenshotXmls.clear();
        File resources = new File(this.mPackageTemplatePath);
        if (resources.exists()) {
            File[] listFiles = resources.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.getName().toLowerCase().endsWith(ScreenshotXml.SCREENSHOT_SUFFIX) || file.getName().toLowerCase().endsWith(".png");
                }
            });
            long startTime = System.currentTimeMillis();
            File[] fileArray = listFiles;
            int n = listFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile()) {
                    String fileName = file.getName();
                    String xmlFileName = ResourceMainPanel.mapSuffixtoXML(fileName);
                    File xmlFile = new File(String.valueOf(this.mPackageTemplatePath) + File.separator + xmlFileName);
                    ScreenshotXml sx = new ScreenshotXml(file, xmlFile);
                    this.mScreenshotXmls.add(sx);
                    if (xmlFile.exists()) {
                        sx.parse();
                    }
                }
                ++n2;
            }
            Collections.sort(this.mScreenshotXmls);
            new Thread(){

                @Override
                public void run() {
                    for (ScreenshotXml sx : ResourceMainPanel.this.mScreenshotXmls) {
                        sx.matchResource(ResourceMainPanel.this.mPackageResourceCatalogPath);
                    }
                }
            }.start();
        }
    }

    static String mapSuffixtoXML(String name) {
        return String.valueOf(name.substring(0, name.length() - 3)) + "xml";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.mChangeEditMode)) {
            if (this.editModeFlag) {
                this.exitEditMode();
            } else {
                this.enterEditMode();
            }
            this.initContent();
        } else if (e.getSource().equals(this.mCaptureScreenButton)) {
            this.onSave();
            try {
                String fileName = String.valueOf(UUID.randomUUID().toString()) + ScreenshotXml.SCREENSHOT_SUFFIX;
                this.captureScreen(fileName);
                this.loadResources();
                this.mScreenshotTree.setVector(this.mScreenshotXmls);
            }
            catch (Exception ex) {
                GUIUtil.alert(ex.getMessage());
            }
        } else if (e.getSource().equals(this.mDeleteScreenButton)) {
            if (this.mCurrentScreenshotXml == null) {
                return;
            }
            ScreenshotXml screenshotXml = this.mCurrentScreenshotXml;
            screenshotXml.mFile.delete();
            if (screenshotXml.mFile.exists()) {
                GUIUtil.alert(String.valueOf(ResourceFactory.getString("delete_fail")) + screenshotXml.mFile.getName());
                return;
            }
            screenshotXml.mXmlFile.delete();
            if (screenshotXml.mXmlFile.exists()) {
                GUIUtil.alert(String.valueOf(ResourceFactory.getString("delete_fail")) + screenshotXml.mXmlFile.getName());
                return;
            }
            this.mScreenshotXmls.remove(screenshotXml);
            this.mCurrentScreenshotXml = null;
            this.refreshTree();
            this.initContent();
        } else if (e.getSource().equals(this.mSaveButton)) {
            this.onSave();
        } else if (e.getSource().equals(this.mRefreshButton)) {
            this.refreshTree();
        } else if (e.getSource().equals(this.mViewButton)) {
            if (this.mCurrentScreenshotXml == null) {
                return;
            }
            ThemeHelper.openInExplorer(this.mCurrentScreenshotXml.mFile);
        } else if (e.getSource().equals(this.mReplaceScreenButton)) {
            if (this.mCurrentScreenshotXml == null) {
                return;
            }
            try {
                Screenshot.sScreenshotQuality = ScreenshotXml.SCREENSHOT_QUALITY;
                Screenshot.captureScreen(this.mCurrentScreenshotXml.mFile.getAbsolutePath());
                this.initContent();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    void refreshTree() {
        Collections.sort(this.mScreenshotXmls);
        this.mScreenshotTree.setVector(this.mScreenshotXmls);
    }

    private void onSave() {
        for (ScreenshotXml screenshotXml : this.mScreenshotXmls) {
            screenshotXml.save();
        }
        this.alert2(ResourceFactory.getString("success"));
    }

    private void captureScreen(String fileName) throws Exception {
        String version;
        File mPackageTemplateDir = new File(this.mPackageTemplatePath);
        if (!mPackageTemplateDir.exists()) {
            mPackageTemplateDir.mkdirs();
        }
        final String pngFilePath = String.valueOf(this.mPackageTemplatePath) + File.separator + fileName;
        Screenshot.sScreenshotQuality = ScreenshotXml.SCREENSHOT_QUALITY;
        Screenshot.captureScreen(pngFilePath);
        if (!new File(pngFilePath).exists()) {
            return;
        }
        ScreenshotXml sx = new ScreenshotXml(new File(pngFilePath), new File(ResourceMainPanel.mapSuffixtoXML(pngFilePath)));
        sx.mVersion = version = ThemeHelper.getRomIncrementalVersion();
        sx.save();
        this.mScreenshotXmls.add(sx);
        this.refreshTree();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ResourceMainPanel.this.mScreenshotXmls.size() <= 0) {
                    return;
                }
                DefaultMutableTreeNode defaultNode = ResourceMainPanel.this.mScreenshotTree.mTagNodes.get("");
                int i = 0;
                while (i < defaultNode.getChildCount()) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)defaultNode.getChildAt(i);
                    ScreenshotXml screenshotXml = (ScreenshotXml)node.getUserObject();
                    if (screenshotXml.mFile.getName().equals(pngFilePath)) {
                        ResourceMainPanel.this.mScreenshotTree.setSelectionPath(new TreePath(node.getPath()));
                        break;
                    }
                    ++i;
                }
            }
        });
    }

    private void alert2(String str) {
        MainFrame.getInstance().getThemeEditPanel().mModuleState.setText(str);
    }

    private void enterEditMode() {
        this.editModeFlag = true;
        this.mChangeEditMode.setText(ResourceFactory.getString("exit_edit_mode"));
        this.setEditModeVisible(true);
        this.mRightPanel.removeAll();
        this.validate();
        MainFrame.getInstance().mCompressChoicePanel.setVisible(false);
    }

    private void setEditModeVisible(boolean flag) {
        this.mCaptureScreenButton.setVisible(flag);
        this.mDeleteScreenButton.setVisible(flag);
        this.mSaveButton.setVisible(flag);
        this.mRefreshButton.setVisible(flag);
        this.mViewButton.setVisible(flag);
        this.mReplaceScreenButton.setVisible(flag);
    }

    private void exitEditMode() {
        this.editModeFlag = false;
        this.mChangeEditMode.setText(ResourceFactory.getString("enter_edit_mode"));
        this.setEditModeVisible(false);
        this.mRightPanel.removeAll();
        this.validate();
        MainFrame.getInstance().mCompressChoicePanel.setVisible(true);
    }

    public boolean hasScreenshot() {
        return this.mScreenshotXmls.size() > 0;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.mScreenshotTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        if (node.isLeaf() && !node.isRoot()) {
            this.mCurrentScreenshotXml = (ScreenshotXml)node.getUserObject();
            if (this.mCurrentScreenshotXml != null) {
                this.mCurrentScreenshotXml.matchResource(this.mPackageResourceCatalogPath);
            }
            this.initContent();
        }
    }
}

