/*
 * Decompiled with CFR 0.152.
 */
package miui.imagefilters;

public class ImageFilterUtils {
    static final float COLOR_TO_GRAYSCALE_FACTOR_R = 0.299f;
    static final float COLOR_TO_GRAYSCALE_FACTOR_G = 0.587f;
    static final float COLOR_TO_GRAYSCALE_FACTOR_B = 0.114f;

    public static int HslToRgb(float[] hsl) {
        return ImageFilterUtils.HslToRgb(hsl[0], hsl[1], hsl[2]);
    }

    public static int HslToRgb(float h, float s, float l) {
        int r;
        int g;
        int b;
        if (s == 0.0f) {
            g = b = (int)(l * 255.0f);
            r = b;
        } else {
            float q = l < 0.5f ? l * (1.0f + s) : l + s - l * s;
            float p = 2.0f * l - q;
            float Hk = h / 360.0f;
            float[] T = new float[]{Hk + 0.33333334f, Hk, Hk - 0.33333334f};
            int i = 0;
            while (i < 3) {
                if (T[i] < 0.0f) {
                    int n = i;
                    T[n] = (float)((double)T[n] + 1.0);
                } else if (T[i] > 1.0f) {
                    int n = i;
                    T[n] = (float)((double)T[n] - 1.0);
                }
                T[i] = T[i] * 6.0f < 1.0f ? p + (q - p) * 6.0f * T[i] : ((double)T[i] * 2.0 < 1.0 ? q : ((double)T[i] * 3.0 < 2.0 ? p + (q - p) * (0.6666667f - T[i]) * 6.0f : p));
                ++i;
            }
            r = (int)((double)T[0] * 255.0);
            g = (int)((double)T[1] * 255.0);
            b = (int)((double)T[2] * 255.0);
        }
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static int HsvToRgb(float h, float s, float v) {
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        if (s == 0.0f) {
            g = b = v;
            r = b;
        } else {
            float sectorPos = h / 60.0f;
            int sectorNumber = (int)Math.floor(sectorPos);
            float fractionalSector = sectorPos - (float)sectorNumber;
            float p = v * (1.0f - s);
            float q = v * (1.0f - s * fractionalSector);
            float t = v * (1.0f - s * (1.0f - fractionalSector));
            switch (sectorNumber) {
                case 0: {
                    r = v;
                    g = t;
                    b = p;
                    break;
                }
                case 1: {
                    r = q;
                    g = v;
                    b = p;
                    break;
                }
                case 2: {
                    r = p;
                    g = v;
                    b = t;
                    break;
                }
                case 3: {
                    r = p;
                    g = q;
                    b = v;
                    break;
                }
                case 4: {
                    r = t;
                    g = p;
                    b = v;
                    break;
                }
                case 5: {
                    r = v;
                    g = p;
                    b = q;
                }
            }
        }
        int nr = (int)(r * 255.0f);
        int ng = (int)(g * 255.0f);
        int nb = (int)(b * 255.0f);
        return 0xFF000000 | nr << 16 | ng << 8 | nb;
    }

    public static void RgbToHsl(int color, float[] hsl) {
        ImageFilterUtils.RgbToHsl(0xFF & color >>> 16, 0xFF & color >>> 8, 0xFF & color, hsl);
    }

    public static void RgbToHsl(int red, int green, int blue, float[] hsl) {
        float min;
        float h = 0.0f;
        float s = 0.0f;
        float l = 0.0f;
        float r = (float)red / 255.0f;
        float g = (float)green / 255.0f;
        float b = (float)blue / 255.0f;
        float max = Math.max(r, Math.max(g, b));
        if (max == (min = Math.min(r, Math.min(g, b)))) {
            h = 0.0f;
        } else if (max == r && g >= b) {
            h = 60.0f * (g - b) / (max - min);
        } else if (max == r && g < b) {
            h = 60.0f * (g - b) / (max - min) + 360.0f;
        } else if (max == g) {
            h = 60.0f * (b - r) / (max - min) + 120.0f;
        } else if (max == b) {
            h = 60.0f * (r - g) / (max - min) + 240.0f;
        }
        l = (max + min) / 2.0f;
        if (l == 0.0f || max == min) {
            s = 0.0f;
        } else if (0.0f < l && (double)l <= 0.5) {
            s = (max - min) / (max + min);
        } else if ((double)l > 0.5) {
            s = (max - min) / (2.0f - (max + min));
        }
        hsl[0] = h;
        hsl[1] = s;
        hsl[2] = l;
    }

    public static void RgbToHsv(int color, float[] hsv) {
        ImageFilterUtils.RgbToHsv(0xFF & color >>> 16, 0xFF & color >>> 8, 0xFF & color, hsv);
    }

    public static void RgbToHsv(int red, int green, int blue, float[] hsv) {
        float min;
        float h = 0.0f;
        float s = 0.0f;
        float v = 0.0f;
        float r = (float)red / 255.0f;
        float g = (float)green / 255.0f;
        float b = (float)blue / 255.0f;
        float max = Math.max(r, Math.max(g, b));
        if (max == (min = Math.min(r, Math.min(g, b)))) {
            h = 0.0f;
        } else if (max == r && g >= b) {
            h = 60.0f * (g - b) / (max - min);
        } else if (max == r && g < b) {
            h = 60.0f * (g - b) / (max - min) + 360.0f;
        } else if (max == g) {
            h = 60.0f * (b - r) / (max - min) + 120.0f;
        } else if (max == b) {
            h = 60.0f * (r - g) / (max - min) + 240.0f;
        }
        v = max;
        s = max == 0.0f ? 0.0f : (max - min) / max;
        hsv[0] = h;
        hsv[1] = s;
        hsv[2] = v;
    }

    public static void interpolate(float[] hsl1, float[] hsl2, float amount, float[] hslOut) {
        int size = Math.min(hsl1.length, hsl2.length);
        int i = 0;
        while (i < size) {
            hslOut[i] = hsl1[i] + (hsl2[i] - hsl1[i]) * amount;
            ++i;
        }
    }

    public static int interpolate(int inMin, int inMax, int outMin, int outMax, int value) {
        return (int)((float)outMin + (float)value * (float)(outMax - outMin) / (float)(inMax - inMin));
    }

    public static int clamp(int min, int value, int max) {
        if (value <= min) {
            return min;
        }
        if (value >= max) {
            return max;
        }
        return value;
    }

    public static float clamp(float min, float value, float max) {
        if (value <= min) {
            return min;
        }
        if (value >= max) {
            return max;
        }
        return value;
    }

    public static int convertColorToGrayscale(int color) {
        return (int)(0.299f * (float)((color & 0xFF0000) >>> 16) + 0.587f * (float)((color & 0xFF00) >>> 8) + 0.114f * (float)(color & 0xFF));
    }
}

