/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.language;

import com.alee.extended.language.DictionariesTransferHandler;
import com.alee.extended.language.DictionariesTreeEditor;
import com.alee.extended.language.DictionariesTreeRenderer;
import com.alee.laf.tree.WebTree;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.language.data.Dictionary;
import com.alee.managers.language.data.Record;
import com.alee.managers.language.data.Text;
import com.alee.managers.language.data.Tooltip;
import com.alee.managers.language.data.Value;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class DictionariesTree
extends WebTree {
    private DefaultMutableTreeNode root;
    private DefaultTreeModel model;

    public DictionariesTree() {
        this.setEditable(true);
        this.setShowsRootHandles(false);
        this.setSelectionMode(1);
        this.setDragEnabled(true);
        DictionariesTransferHandler.install(this);
        this.root = new DefaultMutableTreeNode(null);
        this.model = new DefaultTreeModel(this.root);
        this.setModel(this.model);
        this.setCellRenderer(new DictionariesTreeRenderer());
        this.setCellEditor(new DictionariesTreeEditor(this));
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                Object object = treeExpansionEvent.getPath().getLastPathComponent();
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                Object object2 = defaultMutableTreeNode.getUserObject();
                if (object2 instanceof Record) {
                    for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                        DictionariesTree.this.expandPath(new TreePath(defaultMutableTreeNode2.getPath()));
                    }
                }
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode;
                if (Hotkey.DELETE.isTriggered(keyEvent) && (defaultMutableTreeNode = DictionariesTree.this.getSelectedNode()) != null && defaultMutableTreeNode.getUserObject() != null) {
                    int n = DictionariesTree.this.getRowForPath(DictionariesTree.this.getSelectionPath());
                    Object object = defaultMutableTreeNode.getUserObject();
                    if (object instanceof Dictionary) {
                        Object object2 = ((DefaultMutableTreeNode)defaultMutableTreeNode.getParent()).getUserObject();
                        if (object2 != null) {
                            Dictionary dictionary = (Dictionary)object2;
                            dictionary.removeSubdictionary((Dictionary)object);
                        }
                    } else if (object instanceof Record) {
                        Object object3 = ((DefaultMutableTreeNode)defaultMutableTreeNode.getParent()).getUserObject();
                        ((Dictionary)object3).removeRecord((Record)object);
                    } else if (object instanceof Value) {
                        Object object4 = ((DefaultMutableTreeNode)defaultMutableTreeNode.getParent()).getUserObject();
                        ((Record)object4).removeValue((Value)object);
                    } else if (object instanceof Text) {
                        Object object5 = ((DefaultMutableTreeNode)defaultMutableTreeNode.getParent()).getUserObject();
                        ((Value)object5).removeText((Text)object);
                    } else if (object instanceof Tooltip) {
                        Object object6 = ((DefaultMutableTreeNode)defaultMutableTreeNode.getParent()).getUserObject();
                        ((Value)object6).removeTooltip((Tooltip)object);
                    }
                    DictionariesTree.this.model.removeNodeFromParent(defaultMutableTreeNode);
                    if (DictionariesTree.this.getRowCount() > n) {
                        DictionariesTree.this.setSelectionRow(n);
                    } else if (n > 0) {
                        DictionariesTree.this.setSelectionRow(n - 1);
                    }
                }
            }
        });
    }

    public void selectAndShow(DefaultMutableTreeNode defaultMutableTreeNode) {
        TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
        this.setSelectionPath(treePath);
        this.scrollPathToVisible(treePath);
    }

    public DefaultMutableTreeNode getSelectedNode() {
        TreePath treePath = this.getSelectionPath();
        if (treePath != null) {
            return (DefaultMutableTreeNode)treePath.getLastPathComponent();
        }
        return null;
    }

    public Object getSelectedValue() {
        TreePath treePath = this.getSelectionPath();
        if (treePath != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            return defaultMutableTreeNode.getUserObject();
        }
        return null;
    }

    public void expandTillRecords() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            Object object = this.getPathForRow(i).getLastPathComponent();
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (object2 != null && !(object2 instanceof Dictionary)) continue;
            this.expandRow(i);
        }
    }

    public void loadDictionary(Dictionary dictionary) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.createDictionaryNode(dictionary);
        this.model.insertNodeInto(defaultMutableTreeNode, this.root, this.root.getChildCount());
    }

    public DefaultMutableTreeNode createDictionaryNode(Dictionary dictionary) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(dictionary);
        if (dictionary.getRecords() != null) {
            for (Record serializable : dictionary.getRecords()) {
                defaultMutableTreeNode.add(this.createRecordNode(serializable));
            }
        }
        if (dictionary.getSubdictionaries() != null) {
            for (Dictionary dictionary2 : dictionary.getSubdictionaries()) {
                defaultMutableTreeNode.add(this.createDictionaryNode(dictionary2));
            }
        }
        return defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode createRecordNode(Record record) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(record);
        if (record.getValues() != null) {
            for (Value value : record.getValues()) {
                defaultMutableTreeNode.add(this.createValueNode(value));
            }
        }
        return defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode createValueNode(Value value) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(value);
        if (value.getTexts() != null) {
            for (Text cloneable : value.getTexts()) {
                defaultMutableTreeNode.add(this.createTextNode(cloneable));
            }
        }
        if (value.getTooltips() != null) {
            for (Tooltip tooltip : value.getTooltips()) {
                defaultMutableTreeNode.add(this.createTooltipNode(tooltip));
            }
        }
        return defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode createTextNode(Text text) {
        return new DefaultMutableTreeNode(text);
    }

    public DefaultMutableTreeNode createTooltipNode(Tooltip tooltip) {
        return new DefaultMutableTreeNode(tooltip);
    }

    public DefaultTreeModel getActualModel() {
        return this.model;
    }
}

