/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.layout;

import com.alee.laf.StyleConstants;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingConstants;

public class ToolbarLayout
implements LayoutManager,
SwingConstants {
    public static final String START = "START";
    public static final String MIDDLE = "MIDDLE";
    public static final String FILL = "FILL";
    public static final String END = "END";
    private Map<Component, String> constraints = new HashMap<Component, String>();
    private int spacing = StyleConstants.contentSpacing;
    private int partsSpacing = StyleConstants.largeContentSpacing;
    private int orientation = 0;
    private Insets margin = null;

    public ToolbarLayout() {
    }

    public ToolbarLayout(int n) {
        this.spacing = n;
    }

    public ToolbarLayout(int n, int n2) {
        this.spacing = n;
        this.orientation = n2;
    }

    public ToolbarLayout(int n, int n2, int n3) {
        this.spacing = n;
        this.partsSpacing = n2;
        this.orientation = n3;
    }

    public Map<Component, String> getConstraints() {
        return this.constraints;
    }

    public void setConstraints(Map<Component, String> map) {
        this.constraints = map;
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int n) {
        this.spacing = n;
    }

    public int getPartsSpacing() {
        return this.partsSpacing;
    }

    public void setPartsSpacing(int n) {
        this.partsSpacing = n;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        this.orientation = n;
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets insets) {
        this.margin = insets;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        if (!(string == null || string.trim().equals("") || string.equals(START) || string.equals(MIDDLE) || string.equals(FILL) || string.equals(END))) {
            throw new IllegalArgumentException("Cannot add to layout: constraint must be null or an empty/'START'/'MIDDLE'/'FILL'/'END' string");
        }
        this.constraints.put(component, string == null || string.trim().equals("") ? START : string);
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.constraints.remove(component);
    }

    @Override
    public void layoutContainer(Container container) {
        block18: {
            Serializable serializable;
            int n;
            Insets insets;
            block16: {
                Serializable serializable2;
                int n2;
                block17: {
                    Serializable serializable3;
                    int n3;
                    insets = this.getActualInsets(container);
                    if (this.orientation != 0) break block16;
                    if (!container.getComponentOrientation().isLeftToRight()) break block17;
                    int n4 = insets.left;
                    for (n3 = 0; n3 < container.getComponentCount(); ++n3) {
                        Component component = container.getComponent(n3);
                        if (this.constraints.get(component) != null && !this.constraints.get(component).trim().equals("") && !this.constraints.get(component).equals(START)) continue;
                        serializable3 = component.getPreferredSize();
                        component.setBounds(n4, insets.top, ((Dimension)serializable3).width, container.getHeight() - insets.top - insets.bottom);
                        n4 += ((Dimension)serializable3).width + this.spacing;
                    }
                    n3 = container.getWidth() - insets.right;
                    if (this.hasElement(END)) {
                        for (int i = container.getComponentCount() - 1; i >= 0; --i) {
                            serializable3 = container.getComponent(i);
                            if (this.constraints.get(serializable3) == null || !this.constraints.get(serializable3).equals(END)) continue;
                            Dimension dimension = ((Component)serializable3).getPreferredSize();
                            ((Component)serializable3).setBounds(n3 -= dimension.width, insets.top, dimension.width, container.getHeight() - insets.top - insets.bottom);
                            n3 -= this.spacing;
                        }
                    }
                    if (n3 <= n4 || !this.hasElement(MIDDLE) && !this.hasElement(FILL)) break block18;
                    for (Component component : container.getComponents()) {
                        if (this.constraints.get(component) == null) continue;
                        if (this.constraints.get(component).equals(MIDDLE)) {
                            Dimension dimension = component.getPreferredSize();
                            component.setBounds(Math.max(n4, (n4 + n3) / 2 - dimension.width / 2), insets.top, Math.min(dimension.width, n3 - n4), container.getHeight() - insets.top - insets.bottom);
                            continue;
                        }
                        if (!this.constraints.get(component).equals(FILL)) continue;
                        component.setBounds(n4, insets.top, Math.max(0, n3 - n4), container.getHeight() - insets.top - insets.bottom);
                    }
                    break block18;
                }
                int n5 = insets.left;
                if (this.hasElement(END)) {
                    for (n2 = container.getComponentCount() - 1; n2 >= 0; --n2) {
                        Component component = container.getComponent(n2);
                        if (this.constraints.get(component) == null || !this.constraints.get(component).equals(END)) continue;
                        serializable2 = component.getPreferredSize();
                        component.setBounds(n5, insets.top, ((Dimension)serializable2).width, container.getHeight() - insets.top - insets.bottom);
                        n5 += ((Dimension)serializable2).width + this.spacing;
                    }
                }
                n2 = container.getWidth() - insets.right;
                for (int i = 0; i < container.getComponentCount(); ++i) {
                    serializable2 = container.getComponent(i);
                    if (this.constraints.get(serializable2) != null && !this.constraints.get(serializable2).trim().equals("") && !this.constraints.get(serializable2).equals(START)) continue;
                    Dimension dimension = ((Component)serializable2).getPreferredSize();
                    ((Component)serializable2).setBounds(n2 -= dimension.width, insets.top, dimension.width, container.getHeight() - insets.top - insets.bottom);
                    n2 -= this.spacing;
                }
                if (n2 <= n5 || !this.hasElement(MIDDLE) && !this.hasElement(FILL)) break block18;
                for (Component component : container.getComponents()) {
                    if (this.constraints.get(component) == null) continue;
                    if (this.constraints.get(component).equals(MIDDLE)) {
                        Dimension dimension = component.getPreferredSize();
                        component.setBounds(Math.max(n5, (n5 + n2) / 2 - dimension.width / 2), insets.top, Math.min(dimension.width, n2 - n5), container.getHeight() - insets.top - insets.bottom);
                        continue;
                    }
                    if (!this.constraints.get(component).equals(FILL)) continue;
                    component.setBounds(n5, insets.top, Math.max(0, n2 - n5), container.getHeight() - insets.top - insets.bottom);
                }
                break block18;
            }
            int n6 = insets.top;
            for (n = 0; n < container.getComponentCount(); ++n) {
                Component component = container.getComponent(n);
                if (this.constraints.get(component) != null && !this.constraints.get(component).equals(START)) continue;
                serializable = component.getPreferredSize();
                component.setBounds(insets.left, n6, container.getWidth() - insets.left - insets.right, ((Dimension)serializable).height);
                n6 += ((Dimension)serializable).height + this.spacing;
            }
            n = container.getHeight() - insets.bottom;
            if (this.hasElement(END)) {
                for (int i = container.getComponentCount() - 1; i >= 0; --i) {
                    serializable = container.getComponent(i);
                    if (this.constraints.get(serializable) == null || !this.constraints.get(serializable).equals(END)) continue;
                    Dimension dimension = ((Component)serializable).getPreferredSize();
                    ((Component)serializable).setBounds(insets.left, n -= dimension.height, container.getWidth() - insets.left - insets.right, dimension.height);
                    n -= this.spacing;
                }
            }
            if (n > n6 && (this.hasElement(MIDDLE) || this.hasElement(FILL))) {
                for (Component component : container.getComponents()) {
                    if (this.constraints.get(component) == null) continue;
                    if (this.constraints.get(component).equals(MIDDLE)) {
                        Dimension dimension = component.getPreferredSize();
                        component.setBounds(insets.left, Math.max(n6, (n6 + n) / 2 - dimension.height / 2), container.getWidth() - insets.left - insets.right, Math.min(dimension.height, n - n6));
                        continue;
                    }
                    if (!this.constraints.get(component).equals(FILL)) continue;
                    component.setBounds(insets.left, n6, container.getWidth() - insets.left - insets.right, Math.max(0, n - n6));
                }
            }
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        int n;
        Insets insets = this.getActualInsets(container);
        Dimension dimension = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
        int n2 = container.getComponentCount();
        for (n = 0; n < n2; ++n) {
            Component component = container.getComponent(n);
            Dimension dimension2 = component.getPreferredSize();
            if (this.orientation == 0) {
                dimension.width = dimension.width + (dimension2.width + (n < n2 - 1 ? this.spacing : 0));
                dimension.height = Math.max(dimension.height, dimension2.height + insets.top + insets.bottom);
                continue;
            }
            dimension.width = Math.max(dimension.width, dimension2.width + insets.left + insets.right);
            dimension.height = dimension.height + (dimension2.height + (n < n2 - 1 ? this.spacing : 0));
        }
        int n3 = n = this.hasElement(START) && this.hasElement(END) && !this.hasElement(MIDDLE) && !this.hasElement(FILL) ? 1 : 0;
        if (this.orientation == 0) {
            if (n != 0) {
                dimension.width += this.partsSpacing;
            }
        } else if (n != 0) {
            dimension.height += this.partsSpacing;
        }
        return dimension;
    }

    private boolean hasElement(String string) {
        return this.constraints.containsValue(string);
    }

    private Insets getActualInsets(Container container) {
        if (this.margin != null) {
            Insets insets = container.getInsets();
            insets.top += this.margin.top;
            insets.left += this.margin.left;
            insets.bottom += this.margin.bottom;
            insets.right += this.margin.right;
            return insets;
        }
        return container.getInsets();
    }
}

