/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.transition;

import com.alee.extended.transition.TransitionListener;
import com.alee.extended.transition.effects.TransitionEffect;
import com.alee.utils.CollectionUtils;
import com.alee.utils.MathUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.Timer;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class ImageTransition
extends JComponent
implements ActionListener {
    private List<TransitionListener> transitionListeners = new ArrayList<TransitionListener>();
    private BufferedImage currentImage = null;
    private BufferedImage otherImage = null;
    private List<TransitionEffect> transitionEffects = new ArrayList<TransitionEffect>();
    private Timer animator = null;
    private boolean animating = false;
    private boolean blocked = false;
    private TransitionEffect actualTransitionEffect = null;

    public ImageTransition() {
        this(null, null);
    }

    public ImageTransition(BufferedImage bufferedImage) {
        this(bufferedImage, null);
    }

    public ImageTransition(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        this.currentImage = bufferedImage;
        this.otherImage = bufferedImage2;
        SwingUtils.setOrientation(this);
        this.setOpaque(false);
    }

    public boolean isAnimating() {
        return this.animator != null && this.animator.isRunning() && this.animating;
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public void setBlocked(boolean bl) {
        this.blocked = bl;
    }

    public Image getCurrentImage() {
        return this.currentImage;
    }

    public void setCurrentImage(BufferedImage bufferedImage) {
        this.currentImage = bufferedImage;
    }

    public BufferedImage getOtherImage() {
        return this.otherImage;
    }

    public void setOtherImage(BufferedImage bufferedImage) {
        this.otherImage = bufferedImage;
    }

    public List<TransitionEffect> getTransitionEffects() {
        return this.transitionEffects;
    }

    public TransitionEffect getTransitionEffect() {
        return this.transitionEffects != null && this.transitionEffects.size() > 0 ? this.transitionEffects.get(0) : null;
    }

    public void addTransitionEffect(TransitionEffect transitionEffect) {
        if (this.transitionEffects == null) {
            this.transitionEffects = new ArrayList<TransitionEffect>();
        }
        this.transitionEffects.add(transitionEffect);
    }

    public void clearTransitionEffects() {
        if (this.transitionEffects != null) {
            this.transitionEffects.clear();
            this.transitionEffects = null;
        }
    }

    public void removeTransitionEffect(TransitionEffect transitionEffect) {
        if (this.transitionEffects != null) {
            this.transitionEffects.remove(transitionEffect);
        }
    }

    public void setTransitionEffect(TransitionEffect transitionEffect) {
        this.transitionEffects = transitionEffect != null ? CollectionUtils.copy(transitionEffect) : null;
    }

    public void setTransitionEffects(List<TransitionEffect> list) {
        this.transitionEffects = list;
    }

    public void setTransitionEffects(TransitionEffect ... transitionEffectArray) {
        this.transitionEffects = transitionEffectArray != null ? CollectionUtils.copy(transitionEffectArray) : null;
    }

    public void destroy() {
        if (this.animator != null && this.animator.isRunning()) {
            this.animator.stop();
            this.animator = null;
        }
        if (this.transitionListeners.size() > 0) {
            this.transitionListeners.clear();
        }
        if (this.currentImage != null) {
            this.currentImage.flush();
            this.currentImage = null;
        }
        if (this.otherImage != null) {
            this.otherImage.flush();
            this.otherImage = null;
        }
    }

    public void changeImage(BufferedImage bufferedImage) {
        if (!this.isAnimating()) {
            this.setOtherImage(bufferedImage);
            this.performTransition();
        }
    }

    public void performTransition() {
        if (this.isAnimating() || this.isBlocked()) {
            return;
        }
        if (this.transitionEffects == null || this.transitionEffects.size() <= 0) {
            this.actualTransitionEffect = null;
        } else if (this.transitionEffects.size() == 1) {
            this.actualTransitionEffect = this.transitionEffects.get(0);
        } else if (this.transitionEffects.size() > 1) {
            this.actualTransitionEffect = this.transitionEffects.get(MathUtils.random(this.transitionEffects.size()));
        }
        this.animator = new Timer("ImageTransition.animator", this.actualTransitionEffect.getAnimationDelay(), (ActionListener)this);
        this.fireTransitionStarted();
        this.animator.start();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.actualTransitionEffect == null || this.actualTransitionEffect.performAnimationTick(this)) {
            this.animator.stop();
            this.finishTransition();
        }
    }

    public void cancelTransition() {
        this.animator.stop();
    }

    private void finishTransition() {
        BufferedImage bufferedImage = this.currentImage;
        this.currentImage = this.otherImage;
        this.otherImage = bufferedImage;
        this.actualTransitionEffect = null;
        this.repaint();
        this.fireTransitionFinished();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.actualTransitionEffect != null && this.actualTransitionEffect.isAnimating() && this.currentImage != null && this.otherImage != null) {
            this.actualTransitionEffect.paint(graphics2D, this);
        } else if (this.currentImage != null) {
            graphics2D.drawImage(this.currentImage, 0, 0, this.getWidth(), this.getHeight(), null);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.currentImage != null) {
            return new Dimension(this.currentImage.getWidth(), this.currentImage.getHeight());
        }
        if (this.otherImage != null) {
            return new Dimension(this.otherImage.getWidth(), this.otherImage.getHeight());
        }
        return new Dimension(0, 0);
    }

    public void addTransitionListener(TransitionListener transitionListener) {
        this.transitionListeners.add(transitionListener);
    }

    public void removeTransitionListener(TransitionListener transitionListener) {
        this.transitionListeners.remove(transitionListener);
    }

    private void fireTransitionStarted() {
        for (TransitionListener transitionListener : CollectionUtils.copy(this.transitionListeners)) {
            transitionListener.transitionStarted();
        }
    }

    private void fireTransitionFinished() {
        for (TransitionListener transitionListener : CollectionUtils.copy(this.transitionListeners)) {
            transitionListener.transitionFinished();
        }
    }
}

