/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.extended.tree.AsyncTreeDataProvider;
import com.alee.extended.tree.FileTreeNode;
import com.alee.extended.tree.WebFileTreeStyle;
import com.alee.utils.CollectionUtils;
import com.alee.utils.FileUtils;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;

public class FileTreeDataProvider
implements AsyncTreeDataProvider<FileTreeNode> {
    private FileFilter fileFilter;
    private List<File> rootFiles;

    public FileTreeDataProvider(File ... fileArray) {
        this.fileFilter = WebFileTreeStyle.fileFilter;
        this.rootFiles = CollectionUtils.copy(fileArray);
    }

    public FileTreeDataProvider(List<File> list) {
        this.fileFilter = WebFileTreeStyle.fileFilter;
        this.rootFiles = list;
    }

    public FileTreeDataProvider(FileFilter fileFilter, File ... fileArray) {
        this.fileFilter = fileFilter;
        this.rootFiles = CollectionUtils.copy(fileArray);
    }

    public FileTreeDataProvider(FileFilter fileFilter, List<File> list) {
        this.fileFilter = fileFilter;
        this.rootFiles = list;
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.fileFilter = fileFilter;
    }

    @Override
    public FileTreeNode getRoot() {
        return new FileTreeNode(null);
    }

    @Override
    public List<FileTreeNode> getChilds(FileTreeNode fileTreeNode) {
        return fileTreeNode.getFile() == null ? this.getRootChilds() : this.getFileChilds(fileTreeNode);
    }

    private List<FileTreeNode> getRootChilds() {
        ArrayList<FileTreeNode> arrayList = new ArrayList<FileTreeNode>();
        for (File file : this.rootFiles) {
            arrayList.add(new FileTreeNode(file));
        }
        return arrayList;
    }

    public List<FileTreeNode> getFileChilds(FileTreeNode fileTreeNode) {
        File file = fileTreeNode.getFile();
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            if (this.fileFilter != null) {
                int n = 0;
                for (int i = fileArray.length - 1; i >= 0; --i) {
                    if (this.fileFilter == null || this.fileFilter.accept(fileArray[i])) continue;
                    fileArray[i] = null;
                    ++n;
                }
                File[] fileArray2 = new File[fileArray.length - n];
                int n2 = 0;
                for (File file2 : fileArray) {
                    if (file2 == null) continue;
                    fileArray2[n2] = file2;
                    ++n2;
                }
                fileArray = fileArray2;
            }
            FileUtils.sortFiles(fileArray);
        } else {
            fileArray = new File[]{};
        }
        ArrayList<FileTreeNode> arrayList = new ArrayList<FileTreeNode>();
        for (File file3 : fileArray) {
            arrayList.add(new FileTreeNode(file3));
        }
        return arrayList;
    }

    @Override
    public boolean isLeaf(FileTreeNode fileTreeNode) {
        return fileTreeNode.getFile() != null && !FileUtils.isDirectory(fileTreeNode.getFile());
    }
}

