/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.table;

import com.alee.laf.table.WebTableCorner;
import com.alee.laf.table.WebTableStyle;
import com.alee.laf.table.editors.WebBooleanEditor;
import com.alee.laf.table.editors.WebGenericEditor;
import com.alee.laf.table.editors.WebNumberEditor;
import com.alee.laf.table.renderers.WebBooleanRenderer;
import com.alee.laf.table.renderers.WebDateRenderer;
import com.alee.laf.table.renderers.WebDoubleRenderer;
import com.alee.laf.table.renderers.WebIconRenderer;
import com.alee.laf.table.renderers.WebNumberRenderer;
import com.alee.laf.table.renderers.WebTableCellRenderer;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.AncestorAdapter;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.AncestorEvent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableUI;

public class WebTableUI
extends BasicTableUI {
    private Color selectionBackground = WebTableStyle.selectionBackground;
    private AncestorAdapter ancestorAdapter;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WebTableUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        SwingUtils.setOrientation(this.table);
        this.table.setOpaque(false);
        this.table.setBackground(WebTableStyle.background);
        this.table.setForeground(WebTableStyle.foreground);
        this.table.setSelectionBackground(WebTableStyle.selectionBackground);
        this.table.setSelectionForeground(WebTableStyle.selectionForeground);
        this.table.setFillsViewportHeight(false);
        this.table.setRowHeight(WebTableStyle.rowHeight);
        this.table.setShowVerticalLines(false);
        this.table.setIntercellSpacing(new Dimension(0, 1));
        this.table.setDefaultRenderer(Object.class, new WebTableCellRenderer());
        this.table.setDefaultRenderer(Number.class, new WebNumberRenderer());
        this.table.setDefaultRenderer(Double.class, new WebDoubleRenderer());
        this.table.setDefaultRenderer(Float.class, new WebDoubleRenderer());
        this.table.setDefaultRenderer(Date.class, new WebDateRenderer());
        this.table.setDefaultRenderer(Icon.class, new WebIconRenderer());
        this.table.setDefaultRenderer(ImageIcon.class, new WebIconRenderer());
        this.table.setDefaultRenderer(Boolean.class, new WebBooleanRenderer());
        this.table.setDefaultEditor(Object.class, new WebGenericEditor());
        this.table.setDefaultEditor(Number.class, new WebNumberEditor());
        this.table.setDefaultEditor(Boolean.class, new WebBooleanEditor());
        this.configureEnclosingScrollPaneUI(this.table);
        this.ancestorAdapter = new AncestorAdapter(){

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
                WebTableUI.this.configureEnclosingScrollPaneUI(WebTableUI.this.table);
            }
        };
        this.table.addAncestorListener(this.ancestorAdapter);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.table.removeAncestorListener(this.ancestorAdapter);
        super.uninstallUI(jComponent);
    }

    protected void configureEnclosingScrollPaneUI(JComponent jComponent) {
        Container container;
        Container container2 = jComponent.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport == null || jViewport.getView() != jComponent) {
                return;
            }
            jScrollPane.setCorner("UPPER_LEADING_CORNER", new WebTableCorner(false));
            jScrollPane.setCorner("UPPER_TRAILING_CORNER", new WebTableCorner(true));
        }
    }
}

