/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.language.data;

import com.alee.managers.language.data.Record;
import com.alee.managers.language.data.Value;
import com.alee.utils.TextUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@XStreamAlias(value="Dictionary")
public final class Dictionary
implements Serializable {
    private static final String ID_PREFIX = "DIC";
    @XStreamAsAttribute
    private String id;
    @XStreamAsAttribute
    private String name;
    @XStreamAsAttribute
    private String prefix;
    @XStreamAsAttribute
    private String author;
    @XStreamAsAttribute
    private String creationDate;
    @XStreamAsAttribute
    private String notes;
    @XStreamImplicit(itemFieldName="record")
    private List<Record> records;
    @XStreamImplicit(itemFieldName="Dictionary")
    private List<Dictionary> subdictionaries;

    public Dictionary() {
        this.setId();
    }

    public Dictionary(String string) {
        this.setId();
        this.setPrefix(string);
    }

    public Dictionary(String string, String string2) {
        this.setId();
        this.setPrefix(string);
        this.setName(string2);
    }

    public Dictionary(String string, String string2, String string3) {
        this.setId();
        this.setPrefix(string);
        this.setName(string2);
        this.setAuthor(string3);
    }

    public Dictionary(String string, String string2, String string3, String string4) {
        this.setId();
        this.setPrefix(string);
        this.setName(string2);
        this.setAuthor(string3);
        this.setCreationDate(string4);
    }

    public Dictionary(String string, String string2, String string3, String string4, String string5) {
        this.setId();
        this.setPrefix(string);
        this.setName(string2);
        this.setAuthor(string3);
        this.setCreationDate(string4);
        this.setNotes(string5);
    }

    public String getId() {
        if (this.id == null) {
            this.setId();
        }
        return this.id;
    }

    public void setId() {
        this.id = TextUtils.generateId(ID_PREFIX);
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String string) {
        this.author = string;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(String string) {
        this.creationDate = string;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String string) {
        this.notes = string;
    }

    public List<Record> getRecords() {
        return this.records;
    }

    public void setRecords(List<Record> list) {
        this.records = list;
    }

    private void checkRecords() {
        if (this.records == null) {
            this.records = new ArrayList<Record>();
        }
    }

    public Record addRecord(String string, String string2, String string3) {
        return this.addRecord(string, new Value(string2, string3));
    }

    public Record addRecord(String string, String string2, Character c, String string3) {
        return this.addRecord(string, new Value(string2, c, string3));
    }

    public Record addRecord(String string, Value ... valueArray) {
        return this.addRecord(new Record(string, valueArray));
    }

    public Record addRecord(String string, List<Value> list) {
        return this.addRecord(new Record(string, list));
    }

    public Record addRecord(Record record) {
        this.checkRecords();
        this.records.add(record);
        return record;
    }

    public void removeRecord(Record record) {
        if (this.records != null) {
            this.records.remove(record);
        }
    }

    public void removeRecord(String string) {
        if (this.records != null) {
            for (int i = 0; i < this.records.size(); ++i) {
                if (!this.records.get(i).getKey().equals(string)) continue;
                this.records.remove(i);
                break;
            }
        }
    }

    public void removeLanguage(String string) {
        if (this.records != null) {
            for (int i = this.records.size() - 1; i >= 0; --i) {
                this.records.get(i).removeValue(string);
                if (this.records.get(i).size() != 0) continue;
                this.records.remove(i);
            }
        }
    }

    public void clear() {
        if (this.records != null) {
            this.records.clear();
        }
    }

    public int size() {
        return this.records != null ? this.records.size() : 0;
    }

    public List<Dictionary> getSubdictionaries() {
        return this.subdictionaries;
    }

    public void setSubdictionaries(List<Dictionary> list) {
        this.subdictionaries = list;
    }

    public void addSubdictionary(Dictionary dictionary) {
        this.checkSubdictionaries();
        this.subdictionaries.add(dictionary);
    }

    private void checkSubdictionaries() {
        if (this.subdictionaries == null) {
            this.subdictionaries = new ArrayList<Dictionary>();
        }
    }

    public void removeSubdictionary(Dictionary dictionary) {
        if (this.subdictionaries != null) {
            this.subdictionaries.remove(dictionary);
        }
    }

    public int subdictionaries() {
        return this.subdictionaries != null ? this.subdictionaries.size() : 0;
    }

    public String toString() {
        return (this.name != null ? this.name + " " : "") + (this.size() > 0 ? " (records: " + this.size() + ")" : "") + (this.subdictionaries() > 0 ? " (subdictionaries: " + this.subdictionaries() + ")" : "");
    }
}

