/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.extended.filefilter.DefaultFileFilter;
import com.alee.laf.GlobalConstants;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.proxy.ProxyManager;
import com.alee.utils.ImageUtils;
import com.alee.utils.WebUtils;
import com.alee.utils.file.FileDescription;
import com.alee.utils.file.FileDownloadListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileSystemView;

public class FileUtils {
    private static final FileSystemView fsv = FileSystemView.getFileSystemView();
    private static SimpleDateFormat sdf = new SimpleDateFormat("dd MMM yyyy HH:mm");
    private static final int MD5_BUFFER_LENGTH = 102400;
    private static final int TEXT_BUFFER_SIZE = 65536;
    public static final long KB = 1024L;
    public static final long MB = 0x100000L;
    public static final long GB = 0x40000000L;
    public static final long PB = 0x10000000000L;
    private static final char[] ILLEGAL_CHARACTERS = new char[]{'/', '\n', '\r', '\t', '\u0000', '\f', '\"', '`', '!', '?', '*', '\\', '<', '>', '|', ':', ';', '.', ',', '%', '$', '@', '#', '^', '{', '}', '[', ']', ']'};
    private static Map<String, Boolean> isDriveCache = new HashMap<String, Boolean>();
    private static Map<String, Boolean> isComputerCache = new HashMap<String, Boolean>();
    private static Map<String, Boolean> isCdDriveCache = new HashMap<String, Boolean>();
    private static Map<String, Boolean> isFileCache = new HashMap<String, Boolean>();
    private static Map<String, Boolean> isDirectoryCache = new HashMap<String, Boolean>();
    private static Map<String, Boolean> isHiddenCache = new HashMap<String, Boolean>();
    private static Map<String, String> displayFileNameCache = new HashMap<String, String>();
    private static Map<String, FileDescription> fileDescriptionCache = new HashMap<String, FileDescription>();
    private static Map<String, String> fileTypeDescriptionCache = new HashMap<String, String>();
    private static Map<String, String> displayFileModificationDateCache = new HashMap<String, String>();
    private static Map<String, ImageIcon> extensionIconsCache = new HashMap<String, ImageIcon>();
    private static Map<String, ImageIcon> resourceIconsCache = new HashMap<String, ImageIcon>();

    public static List<File> getFilePath(File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        while (file != null) {
            arrayList.add(0, file);
            file = file.getParentFile();
        }
        return arrayList;
    }

    public static File getSystemTemp() {
        return new File(FileUtils.getSystemTempPath());
    }

    public static String getSystemTempPath() {
        return System.getProperty("java.io.tmpdir");
    }

    public static boolean grantExecutePermissions(File file) {
        try {
            return file.setExecutable(true, false);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public static File normalize(File file) {
        try {
            return file != null ? file.getCanonicalFile() : file;
        }
        catch (IOException iOException) {
            return file;
        }
    }

    public static File getSystemRoot() {
        File[] fileArray = FileUtils.getSystemRoots();
        return fileArray.length > 0 ? fileArray[0] : null;
    }

    public static File[] getSystemRoots() {
        File[] fileArray = fsv.getRoots();
        if (fileArray != null && fileArray.length > 0) {
            return fileArray;
        }
        return FileUtils.getDiskRoots();
    }

    public static File[] getDiskRoots() {
        File[] fileArray = File.listRoots();
        int n = 0;
        for (File file : fileArray) {
            if (!file.isDirectory()) continue;
            ++n;
        }
        File[] fileArray2 = new File[n];
        int n2 = 0;
        for (File file : fileArray) {
            if (!file.isDirectory()) continue;
            fileArray2[n2] = file;
            ++n2;
        }
        return fileArray2;
    }

    public static String computeMD5(File file) {
        return FileUtils.computeMD5(file, 102400);
    }

    public static String computeMD5(File file, int n) {
        try {
            return FileUtils.computeMD5(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public static String computeMD5(InputStream inputStream) {
        return FileUtils.computeMD5(inputStream, 102400);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String computeMD5(InputStream inputStream, int n) {
        String string;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        try {
            int n2;
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray = new byte[n];
            while ((n2 = bufferedInputStream.read(byArray, 0, byArray.length)) > 0) {
                messageDigest.update(byArray, 0, n2);
            }
            byte[] byArray2 = messageDigest.digest();
            BigInteger bigInteger = new BigInteger(1, byArray2);
            string = bigInteger.toString(16);
        }
        catch (Throwable throwable) {
            try {
                String string2 = null;
                return string2;
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                try {
                    bufferedInputStream.close();
                }
                catch (Throwable throwable3) {}
            }
        }
        try {
            bufferedInputStream.close();
            return string;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string;
    }

    public static File getUserHome() {
        return new File(FileUtils.getUserHomePath());
    }

    public static String getUserHomePath() {
        String string = System.getProperty("user.home");
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        return string;
    }

    public static boolean equals(File file, File file2) {
        return file == null && file2 == null || file != null && file2 != null && file.getAbsolutePath().equals(file2.getAbsolutePath());
    }

    public static boolean equals(List<File> list, List<File> list2) {
        if (list.size() != list2.size()) {
            return false;
        }
        if (list.size() == list2.size() && list2.size() == 0) {
            return true;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).getAbsolutePath().equals(list2.get(i).getAbsolutePath())) continue;
            return false;
        }
        return true;
    }

    public static boolean containtsFile(List list, File file) {
        for (Object e : list) {
            if (!(e instanceof File ? ((File)e).getAbsolutePath().equals(file.getAbsolutePath()) : e instanceof String && e.equals(file.getAbsolutePath()))) continue;
            return true;
        }
        return false;
    }

    public static boolean isFileAccepted(File file, List<DefaultFileFilter> list) {
        if (list == null || list.size() == 0) {
            return true;
        }
        for (DefaultFileFilter defaultFileFilter : list) {
            if (!defaultFileFilter.accept(file)) continue;
            return true;
        }
        return false;
    }

    public static String getProperFileName(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            if (FileUtils.isIllegalFileNameChar(string.charAt(i))) continue;
            stringBuilder.append(string.charAt(i));
        }
        return stringBuilder.toString().replaceAll(" ", "_");
    }

    public static boolean isIllegalFileNameChar(char c) {
        boolean bl = false;
        for (char c2 : ILLEGAL_CHARACTERS) {
            if (c != c2) continue;
            bl = true;
        }
        return bl;
    }

    public static File getTopParent(File file) {
        File file2 = (file = file.getAbsoluteFile()).getParentFile();
        if (file2 == null) {
            return null;
        }
        while (file2.getParentFile() != null) {
            file2 = file2.getParentFile();
        }
        return file2;
    }

    public static boolean isParent(File file, File file2) {
        if (file2 == file) {
            return false;
        }
        if (file2 == null) {
            return false;
        }
        if (file == null) {
            return true;
        }
        if (file2.equals(file)) {
            return false;
        }
        file2 = file2.getAbsoluteFile();
        for (File file3 = file2.getParentFile(); file3 != null; file3 = file3.getParentFile()) {
            if (!file3.equals(file)) continue;
            return true;
        }
        return false;
    }

    public static String getFileNamePart(File file) {
        return FileUtils.getFileNamePart(file.getName());
    }

    public static String getFileNamePart(String string) {
        int n = string.lastIndexOf(".");
        return n == -1 ? string : string.substring(0, n);
    }

    public static String getFileExtPart(String string, boolean bl) {
        int n = string.lastIndexOf(".");
        return n == -1 ? "" : (bl ? string.substring(n) : string.substring(n + 1));
    }

    public static String getShortFileName(String string) {
        return FileUtils.getShortFileName(string, 30);
    }

    public static String getShortFileName(String string, int n) {
        if (n < 2) {
            return string;
        }
        String string2 = FileUtils.getFileNamePart(string);
        if (string2.length() > n) {
            return string2.substring(0, n - 2) + "..." + FileUtils.getFileExtPart(string, false);
        }
        return string;
    }

    public static List sortFiles(List<File> list) {
        if (list != null) {
            Collections.sort(list, GlobalConstants.FILE_COMPARATOR);
        }
        return list;
    }

    public static File[] sortFiles(File[] fileArray) {
        if (fileArray != null) {
            Arrays.sort(fileArray, GlobalConstants.FILE_COMPARATOR);
        }
        return fileArray;
    }

    public static String getAvailableName(String string, String string2) {
        return FileUtils.getAvailableName(new File(string), string2);
    }

    public static String getAvailableName(File file, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                arrayList.add(file2.getName());
            }
        }
        return FileUtils.getAvailableName(arrayList, string);
    }

    public static String getAvailableName(List<String> list, String string) {
        Integer n;
        int n2;
        if (!list.contains(string)) {
            return string;
        }
        int n3 = string.lastIndexOf(".");
        String string2 = n3 != -1 ? string.substring(0, n3).trim() : string;
        String string3 = n3 != -1 ? string.substring(string.lastIndexOf(".")) : null;
        String string4 = null;
        Integer n4 = null;
        int n5 = string2.lastIndexOf("(");
        if (n5 < (n2 = string2.lastIndexOf(")")) && n2 == string2.length() - 1) {
            try {
                string4 = string2.substring(0, n5);
                Integer n6 = n4 = Integer.valueOf(Integer.parseInt(string2.substring(n5 + 1, n2)));
                n = n4 = Integer.valueOf(n4 + 1);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        int n7 = 1;
        while (list.contains(string)) {
            if (string4 != null && n4 != null) {
                string = string4 + "(" + n4 + ")" + string3;
                n = n4;
                Integer n8 = n4 = Integer.valueOf(n4 + 1);
                continue;
            }
            string = string2 + " (" + n7 + ")" + (string3 != null ? string3 : "");
            ++n7;
        }
        return string;
    }

    public static List<File> toFilesList(Object ... objectArray) {
        ArrayList<File> arrayList = new ArrayList<File>(objectArray != null ? objectArray.length : 0);
        for (File file : arrayList) {
            if (!(file instanceof File)) continue;
            arrayList.add(file);
        }
        return arrayList;
    }

    public static void deleteFiles(Object ... objectArray) {
        for (Object object : objectArray) {
            if (!(object instanceof File)) continue;
            FileUtils.deleteFile((File)object);
        }
    }

    public static void deleteFile(File file) {
        if (file.exists()) {
            if (file.isFile()) {
                if (!file.delete()) {
                    file.deleteOnExit();
                }
            } else if (file.isDirectory()) {
                for (File file2 : file.listFiles()) {
                    FileUtils.deleteFile(file2);
                }
                if (!file.delete()) {
                    file.deleteOnExit();
                }
            }
        }
    }

    public static void clearDirectory(File file) {
        if (file.exists() && file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                FileUtils.deleteFile(file2);
            }
        }
    }

    public static FileDescription createFileDescription(File file, String string) {
        String string2 = FileUtils.getDisplayFileName(file);
        String string3 = file.isFile() ? FileUtils.getDisplayFileSize(file) + (string != null ? " (" + string + ")" : "") : null;
        String string4 = FileUtils.getFileTypeDescription(file);
        return new FileDescription(string2, string3, string4, null);
    }

    public static String getDisplayFileSize(File file) {
        return FileUtils.getFileSizeString(file.length());
    }

    public static String getDisplayFileSize(File file, int n) {
        return FileUtils.getFileSizeString(file.length(), n);
    }

    public static String getFileSizeString(long l) {
        return FileUtils.getFileSizeString(l, 2);
    }

    public static String getFileSizeString(long l, int n) {
        DecimalFormat decimalFormat = new DecimalFormat(n == 0 ? "#" : "#." + FileUtils.getDigits(n));
        if (l < 1024L) {
            return decimalFormat.format(l) + " " + LanguageManager.get("weblaf.file.size.b");
        }
        if (l >= 1024L && l < 0x100000L) {
            return decimalFormat.format((float)l / 1024.0f) + " " + LanguageManager.get("weblaf.file.size.kb");
        }
        if (l >= 0x100000L && l < 0x40000000L) {
            return decimalFormat.format((float)l / 1048576.0f) + " " + LanguageManager.get("weblaf.file.size.mb");
        }
        return decimalFormat.format((float)l / 1.0737418E9f) + " " + LanguageManager.get("weblaf.file.size.gb");
    }

    private static String getDigits(int n) {
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("#");
        }
        return stringBuilder.toString();
    }

    public static boolean copyDirectory(String string, String string2) {
        return FileUtils.copyDirectory(string, string2, false);
    }

    public static boolean copyDirectory(String string, String string2, boolean bl) {
        return FileUtils.copyDirectory(new File(string), new File(string2), bl);
    }

    public static boolean copyDirectory(File file, File file2) {
        return FileUtils.copyDirectory(file, file2, false);
    }

    public static boolean copyDirectory(File file, File file2, boolean bl) {
        if (file.exists() && file.isDirectory()) {
            if (FileUtils.ensureDirectoryExists(file2)) {
                boolean bl2 = true;
                for (File file3 : file.listFiles()) {
                    String string = file2.getAbsolutePath() + File.separator + file3.getName();
                    if (file3.isDirectory()) {
                        boolean bl3 = bl2 = FileUtils.copyDirectory(file3.getAbsolutePath(), string) && bl2;
                        if (bl2 || !bl) continue;
                        return false;
                    }
                    boolean bl4 = bl2 = FileUtils.copyFile(file3.getAbsolutePath(), string) && bl2;
                    if (bl2 || !bl) continue;
                    return false;
                }
                return bl2;
            }
            return false;
        }
        return false;
    }

    public static boolean copyFile(String string, String string2) {
        try {
            File file = new File(new File(string2).getParent());
            if (FileUtils.ensureDirectoryExists(file)) {
                FileChannel fileChannel = new FileInputStream(string).getChannel();
                FileChannel fileChannel2 = new FileOutputStream(string2).getChannel();
                return FileUtils.copyFile(fileChannel, fileChannel2);
            }
            return false;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
    }

    public static boolean copyFile(File file, File file2) {
        if (file.exists() && file.isFile()) {
            try {
                File file3 = new File(file2.getParent());
                if (FileUtils.ensureDirectoryExists(file3)) {
                    FileChannel fileChannel = new FileInputStream(file).getChannel();
                    FileChannel fileChannel2 = new FileOutputStream(file2).getChannel();
                    return FileUtils.copyFile(fileChannel, fileChannel2);
                }
                return false;
            }
            catch (FileNotFoundException fileNotFoundException) {
                return false;
            }
        }
        return false;
    }

    public static boolean copyFile(FileChannel fileChannel, FileChannel fileChannel2) {
        try {
            fileChannel2.transferFrom(fileChannel, 0L, fileChannel.size());
            fileChannel.close();
            fileChannel2.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static String readToString(Class clazz, String string) {
        try {
            return FileUtils.readToString(clazz.getResourceAsStream(string));
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static String readToString(URL uRL) {
        try {
            return FileUtils.readToString(uRL.openConnection().getInputStream());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String readToString(InputStream inputStream) {
        block14: {
            if (inputStream == null) break block14;
            String string = FileUtils.readToString(new InputStreamReader(inputStream, "UTF8"));
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return string;
        }
        String string = null;
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
        catch (Throwable throwable) {
            try {
                String string2 = null;
                return string2;
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String readToString(File file) {
        try {
            if (file != null && file.exists() && file.isFile()) {
                return FileUtils.readToString(new FileReader(file));
            }
            return null;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String readToString(Reader reader) {
        int n;
        block15: {
            if (reader != null) break block15;
            String string = "";
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return string;
        }
        char[] cArray = new char[65536];
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = reader.read(cArray, 0, 65536)) != -1) {
            stringBuilder.append(cArray, 0, n);
        }
        String string = stringBuilder.toString();
        try {
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
        catch (Throwable throwable) {
            try {
                String string2 = "";
                return string2;
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static List<String> getSubpaths(String string) {
        return FileUtils.getSubpaths(new File(string));
    }

    public static List<String> getSubpaths(File file) {
        return FileUtils.getSubpaths(file, "");
    }

    public static List<String> getSubpaths(File file, String string) {
        return FileUtils.getSubpaths(file, string, new ArrayList<String>());
    }

    public static List<String> getSubpaths(File file, String string, List<String> list) {
        for (File file2 : file.listFiles()) {
            if (file2.isFile()) {
                list.add(string + file2.getName());
                continue;
            }
            if (!file2.isDirectory()) continue;
            FileUtils.getSubpaths(file2, string + file2.getName() + File.separator, list);
        }
        return list;
    }

    public static File downloadFile(String string, File file) {
        return FileUtils.downloadFile(string, file, false, null, 3000, null);
    }

    public static File downloadFile(String string, File file, FileDownloadListener fileDownloadListener) {
        return FileUtils.downloadFile(string, file, false, null, 3000, fileDownloadListener);
    }

    public static File downloadFile(String string, String string2, boolean bl, String string3, int n) {
        return FileUtils.downloadFile(string, new File(string2), bl, string3, n, null);
    }

    public static File downloadFile(String string, String string2, boolean bl, String string3, int n, FileDownloadListener fileDownloadListener) {
        return FileUtils.downloadFile(string, new File(string2), bl, string3, n, fileDownloadListener);
    }

    public static File downloadFile(String string, File file, boolean bl, String string2, int n) {
        return FileUtils.downloadFile(string, file, bl, string2, n, null);
    }

    public static File downloadFile(String string, File file, boolean bl, String string2, int n, FileDownloadListener fileDownloadListener) {
        try {
            int n2;
            Object object;
            URL uRL = new URL(bl ? WebUtils.encodeUrl(string) : string);
            URLConnection uRLConnection = ProxyManager.getURLConnection(uRL);
            if (n != 0) {
                uRLConnection.setConnectTimeout(n);
                uRLConnection.setReadTimeout(n);
            }
            if (fileDownloadListener != null && fileDownloadListener.shouldStopDownload()) {
                FileUtils.deleteFile(file);
                return null;
            }
            if (string2 != null && !((String)(object = uRLConnection.getContentType())).contains(string2)) {
                FileUtils.deleteFile(file);
                return null;
            }
            if (fileDownloadListener != null) {
                fileDownloadListener.sizeDetermined(uRLConnection.getContentLength());
                if (fileDownloadListener.shouldStopDownload()) {
                    FileUtils.deleteFile(file);
                    return null;
                }
            }
            object = uRLConnection.getInputStream();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            if (fileDownloadListener != null && fileDownloadListener.shouldStopDownload()) {
                fileOutputStream.flush();
                fileOutputStream.close();
                ((InputStream)object).close();
                FileUtils.deleteFile(file);
                return null;
            }
            byte[] byArray = new byte[51200];
            int n3 = 0;
            while ((n2 = ((InputStream)object).read(byArray)) != -1) {
                if (fileDownloadListener != null) {
                    fileDownloadListener.partDownloaded(n3 += n2);
                    if (fileDownloadListener.shouldStopDownload()) {
                        fileOutputStream.flush();
                        fileOutputStream.close();
                        ((InputStream)object).close();
                        FileUtils.deleteFile(file);
                        return null;
                    }
                }
                fileOutputStream.write(byArray, 0, n2);
            }
            fileOutputStream.flush();
            fileOutputStream.close();
            ((InputStream)object).close();
            if (fileDownloadListener != null) {
                fileDownloadListener.fileDownloaded(file);
            }
            return file;
        }
        catch (Throwable throwable) {
            if (fileDownloadListener != null) {
                fileDownloadListener.fileDownloadFailed(throwable);
            }
            return null;
        }
    }

    public static int getFileSize(String string) {
        try {
            return FileUtils.getFileSize(new URL(string));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return -1;
        }
    }

    public static int getFileSize(URL uRL) {
        try {
            URLConnection uRLConnection = ProxyManager.getURLConnection(uRL);
            return uRLConnection.getContentLength();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return -1;
        }
    }

    public static List<File> findFilesRecursively(String string, List<String> list) {
        return FileUtils.findFilesRecursively(new File(string), list);
    }

    public static List<File> findFilesRecursively(File file, List<String> list) {
        return FileUtils.findFilesRecursively(file, list, true);
    }

    private static List<File> findFilesRecursively(String string, List<String> list, boolean bl) {
        return FileUtils.findFilesRecursively(new File(string), list, bl);
    }

    private static List<File> findFilesRecursively(File file, List<String> list, boolean bl) {
        return FileUtils.findFilesRecursively(file, list, bl, null);
    }

    private static List<File> findFilesRecursively(String string, List<String> list, boolean bl, List<File> list2) {
        return FileUtils.findFilesRecursively(new File(string), list, bl, list2);
    }

    private static List<File> findFilesRecursively(File file, List<String> list, boolean bl, List<File> list2) {
        if (list2 == null) {
            list2 = new ArrayList<File>();
        }
        if (file.exists() && file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                if (file2.isFile()) {
                    String string = FileUtils.getFileExtPart(file2.getName(), bl);
                    if (!list.contains(string)) continue;
                    list2.add(file2);
                    continue;
                }
                FileUtils.findFilesRecursively(file2.getAbsolutePath(), list, bl, list2);
            }
        }
        return list2;
    }

    public static boolean ensureDirectoryExists(String string) {
        return FileUtils.ensureDirectoryExists(new File(string));
    }

    public static boolean ensureDirectoryExists(File file) {
        if (file.exists()) {
            return true;
        }
        return file.mkdirs();
    }

    public static void clearIsDriveCache() {
        isDriveCache.clear();
    }

    public static boolean isDrive(File file) {
        String string = file.getAbsolutePath();
        if (isDriveCache.containsKey(string)) {
            return isDriveCache.get(string);
        }
        boolean bl = fsv.isDrive(file);
        isDriveCache.put(string, bl);
        return bl;
    }

    public static void clearIsComputerCache() {
        isComputerCache.clear();
    }

    public static boolean isComputer(File file) {
        String string = file.getAbsolutePath();
        if (isComputerCache.containsKey(string)) {
            return isComputerCache.get(string);
        }
        boolean bl = fsv.isComputerNode(file);
        isComputerCache.put(string, bl);
        return bl;
    }

    public static void clearIsCdDriveCache() {
        isCdDriveCache.clear();
    }

    public static boolean isCdDrive(File file) {
        boolean bl;
        String string = file.getAbsolutePath();
        if (isCdDriveCache.containsKey(string)) {
            return isCdDriveCache.get(string);
        }
        if (file.getParent() == null) {
            String string2 = FileUtils.getFileTypeDescription(file);
            String string3 = string2 != null ? string2.toLowerCase() : file.getName();
            bl = string3.contains("cd") || string3.contains("dvd") || string3.contains("blu-ray") || string3.contains("bluray");
        } else {
            bl = false;
        }
        isCdDriveCache.put(string, bl);
        return bl;
    }

    public static void clearIsFileCache() {
        isFileCache.clear();
    }

    public static boolean isFile(File file) {
        if (file == null) {
            return false;
        }
        if (isFileCache.containsKey(file.getAbsolutePath())) {
            return isFileCache.get(file.getAbsolutePath());
        }
        boolean bl = file.isFile();
        isFileCache.put(file.getAbsolutePath(), bl);
        return bl;
    }

    public static void clearIsDirectoryCache() {
        isDirectoryCache.clear();
    }

    public static boolean isDirectory(File file) {
        if (file == null) {
            return false;
        }
        if (isDirectoryCache.containsKey(file.getAbsolutePath())) {
            return isDirectoryCache.get(file.getAbsolutePath());
        }
        boolean bl = file.isDirectory();
        isDirectoryCache.put(file.getAbsolutePath(), bl);
        return bl;
    }

    public static void clearIsHiddenCache() {
        isHiddenCache.clear();
    }

    public static boolean isHidden(File file) {
        if (file == null) {
            return false;
        }
        if (isHiddenCache.containsKey(file.getAbsolutePath())) {
            return isHiddenCache.get(file.getAbsolutePath());
        }
        boolean bl = (file = file.getAbsoluteFile()).getParentFile() != null && file.isHidden();
        isHiddenCache.put(file.getAbsolutePath(), bl);
        return bl;
    }

    public static void clearFileDescriptionCache() {
        fileDescriptionCache.clear();
    }

    public static FileDescription getFileDescription(File file, String string) {
        if (fileDescriptionCache.containsKey(file.getAbsolutePath())) {
            return fileDescriptionCache.get(file.getAbsolutePath());
        }
        FileDescription fileDescription = FileUtils.createFileDescription(file, string);
        fileDescriptionCache.put(file.getAbsolutePath(), fileDescription);
        return fileDescription;
    }

    public static void clearDisplayFileNameCache() {
        displayFileNameCache.clear();
    }

    public static String getDisplayFileName(File file) {
        String string = file.getAbsolutePath();
        if (displayFileNameCache.containsKey(string)) {
            return displayFileNameCache.get(string);
        }
        String string2 = fsv.getSystemDisplayName(file);
        if (string2 == null || string2.trim().equals("")) {
            string2 = FileUtils.getFileTypeDescription(file);
        }
        displayFileNameCache.put(string, string2);
        return string2;
    }

    public static void clearDisplayFileModificationDateCache() {
        displayFileModificationDateCache.clear();
    }

    public static String getDisplayFileModificationDate(File file) {
        String string = file.getAbsolutePath();
        if (displayFileModificationDateCache.containsKey(string)) {
            return displayFileModificationDateCache.get(string);
        }
        String string2 = sdf.format(new Date(file.lastModified()));
        displayFileModificationDateCache.put(string, string2);
        return string2;
    }

    public static void clearFileTypeDescriptionCache() {
        fileTypeDescriptionCache.clear();
    }

    public static String getFileTypeDescription(File file) {
        if (file == null) {
            return "";
        }
        if (fileTypeDescriptionCache.containsKey(file.getAbsolutePath())) {
            return fileTypeDescriptionCache.get(file.getAbsolutePath());
        }
        String string = fsv.getSystemTypeDescription(file);
        fileTypeDescriptionCache.put(file.getAbsolutePath(), string);
        return string;
    }

    public static ImageIcon getFileIcon(File file) {
        return FileUtils.getFileIcon(file, false);
    }

    public static ImageIcon getFileIcon(File file, boolean bl) {
        return FileUtils.getStandartFileIcon(file, bl);
    }

    public static ImageIcon getStandartFileIcon(File file, boolean bl) {
        return FileUtils.getStandartFileIcon(file, bl, true);
    }

    public static ImageIcon getStandartFileIcon(File file, boolean bl, boolean bl2) {
        float f;
        String string;
        String string2;
        if (file == null) {
            return null;
        }
        if (!FileUtils.isDirectory(file)) {
            string2 = FileUtils.getFileExtPart(file.getName(), false).trim().toLowerCase();
            if (string2.trim().equals("")) {
                string2 = file.getAbsolutePath();
            }
        } else {
            string2 = FileUtils.isCdDrive(file) ? "cd_drive" : (FileUtils.isDrive(file) ? "drive" : (FileUtils.isComputer(file) ? "computer" : "folder"));
        }
        if (extensionIconsCache.containsKey(string = FileUtils.getStandartFileIconCacheKey(string2, bl, f = FileUtils.isHidden(file) ? 0.5f : 1.0f, bl2))) {
            return extensionIconsCache.get(string);
        }
        ImageIcon imageIcon = FileUtils.getStandartFileIcon(bl, string2, f);
        if (imageIcon == null) {
            imageIcon = FileUtils.getStandartFileIcon(bl, "file", f);
        }
        if (bl2) {
            extensionIconsCache.put(string, imageIcon);
        } else {
            extensionIconsCache.put(FileUtils.getStandartFileIconCacheKey(string2, bl, f, true), imageIcon);
            imageIcon = ImageUtils.createDisabledCopy(imageIcon);
            extensionIconsCache.put(string, imageIcon);
        }
        return imageIcon;
    }

    private static String getStandartFileIconCacheKey(String string, boolean bl, float f, boolean bl2) {
        return string + ";#&;" + bl + ";#&;" + f + ";#&;" + bl2;
    }

    public static ImageIcon getStandartFileIcon(boolean bl, String string, float f) {
        return FileUtils.getIconResource(FileUtils.class, "icons/extensions/" + (bl ? "32" : "16") + "/file_extension_" + string + ".png", f);
    }

    public static ImageIcon getIconResource(Class clazz, String string) {
        return FileUtils.getIconResource(clazz, string, 1.0f);
    }

    public static ImageIcon getIconResource(Class clazz, String string, float f) {
        ImageIcon imageIcon;
        String string2 = clazz.getCanonicalName() + ";#&;" + string + ";#&;" + f;
        if (resourceIconsCache.containsKey(string2)) {
            return resourceIconsCache.get(string2);
        }
        URL uRL = clazz.getResource(string);
        if (uRL != null) {
            imageIcon = new ImageIcon(uRL);
            if (f < 1.0f) {
                imageIcon = ImageUtils.createTransparentCopy(imageIcon, f);
            }
        } else {
            imageIcon = null;
        }
        resourceIconsCache.put(string2, imageIcon);
        return imageIcon;
    }
}

