/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.graphics.filters.ImageFilterUtils;
import com.alee.graphics.filters.ShadowFilter;
import com.alee.laf.GlobalConstants;
import com.alee.laf.StyleConstants;
import com.alee.utils.FileUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SystemUtils;
import com.mortennobel.imagescaling.ResampleOp;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ImageUtils {
    public static final String IMAGE_CACHE_SEPARATOR = ";#&;";
    private static Map<String, ImageIcon> mergedIconsCache = new HashMap<String, ImageIcon>();
    private static Map<String, BufferedImage> mergedImagesCache = new HashMap<String, BufferedImage>();
    public static final ImageIcon coloredChooserIcon = new ImageIcon(ImageUtils.class.getResource("icons/color/color.png"));
    public static final ImageIcon transarentChooserIcon = new ImageIcon(ImageUtils.class.getResource("icons/color/transparent.png"));
    private static Map<String, ImageIcon> iconsCache = new HashMap<String, ImageIcon>();
    private static final Map<String, ImageIcon> sizedPreviewCache = new HashMap<String, ImageIcon>();
    private static Map<String, ImageIcon> grayscaleCache = new HashMap<String, ImageIcon>();
    private static Map<String, ImageIcon> trasparentCache = new HashMap<String, ImageIcon>();

    public static boolean isImageContains(BufferedImage bufferedImage, int n, int n2) {
        return (bufferedImage.getRGB(n, n2) >> 24 & 0xFF) > 0;
    }

    public static BufferedImage createCompatibleImage(int n, int n2) {
        return SystemUtils.getGraphicsConfiguration().createCompatibleImage(n, n2);
    }

    public static BufferedImage createCompatibleImage(int n, int n2, int n3) {
        return SystemUtils.getGraphicsConfiguration().createCompatibleImage(n, n2, n3);
    }

    public static BufferedImage createCompatibleImage(BufferedImage bufferedImage) {
        return ImageUtils.createCompatibleImage(bufferedImage, bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    public static BufferedImage createCompatibleImage(BufferedImage bufferedImage, int n) {
        return ImageUtils.createCompatibleImage(bufferedImage.getWidth(), bufferedImage.getHeight(), n);
    }

    public static BufferedImage createCompatibleImage(BufferedImage bufferedImage, int n, int n2) {
        return ImageUtils.createCompatibleImage(n, n2, bufferedImage.getTransparency());
    }

    public static BufferedImage loadCompatibleImage(URL uRL) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(uRL);
        return ImageUtils.toCompatibleImage(bufferedImage);
    }

    public static BufferedImage toCompatibleImage(BufferedImage bufferedImage) {
        if (ImageUtils.isCompatibleImage(bufferedImage)) {
            return bufferedImage;
        }
        BufferedImage bufferedImage2 = SystemUtils.getGraphicsConfiguration().createCompatibleImage(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getTransparency());
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static boolean isCompatibleImage(BufferedImage bufferedImage) {
        return bufferedImage.getColorModel().equals(SystemUtils.getGraphicsConfiguration().getColorModel());
    }

    public static ImageIcon cutImage(Shape shape, ImageIcon imageIcon) {
        return new ImageIcon(ImageUtils.cutImage(shape, imageIcon.getImage()));
    }

    public static BufferedImage cutImage(Shape shape, Image image) {
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        BufferedImage bufferedImage = ImageUtils.createCompatibleImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        LafUtils.setupAntialias(graphics2D);
        graphics2D.setPaint(Color.WHITE);
        graphics2D.fill(shape);
        graphics2D.setComposite(AlphaComposite.getInstance(5));
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static List<Image> toImagesList(List<ImageIcon> list) {
        ArrayList<Image> arrayList = new ArrayList<Image>();
        for (ImageIcon imageIcon : list) {
            arrayList.add(imageIcon.getImage());
        }
        return arrayList;
    }

    public static ImageIcon combineIcons(List<ImageIcon> list) {
        return ImageUtils.combineIcons(0, list);
    }

    public static ImageIcon combineIcons(int n, List<ImageIcon> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        Image[] imageArray = new Image[list.size()];
        int n2 = 0;
        for (ImageIcon imageIcon : list) {
            imageArray[n2] = imageIcon != null ? imageIcon.getImage() : null;
            ++n2;
        }
        return new ImageIcon(ImageUtils.combineIcons(imageArray));
    }

    public static ImageIcon combineIcons(ImageIcon ... imageIconArray) {
        return ImageUtils.combineIcons(0, imageIconArray);
    }

    public static ImageIcon combineIcons(int n, ImageIcon ... imageIconArray) {
        if (imageIconArray == null || imageIconArray.length == 0) {
            return null;
        }
        Image[] imageArray = new Image[imageIconArray.length];
        int n2 = 0;
        for (ImageIcon imageIcon : imageIconArray) {
            imageArray[n2] = imageIcon != null ? imageIcon.getImage() : null;
            ++n2;
        }
        return new ImageIcon(ImageUtils.combineIcons(imageArray));
    }

    public static BufferedImage combineIcons(Image ... imageArray) {
        return ImageUtils.combineIcons(0, imageArray);
    }

    public static BufferedImage combineIcons(int n, Image ... imageArray) {
        if (imageArray == null || imageArray.length == 0) {
            return null;
        }
        Dimension dimension = new Dimension(0, 0);
        for (Image imageArray2 : imageArray) {
            if (imageArray2 == null) continue;
            dimension.width = dimension.width + imageArray2.getWidth(null) + n;
            dimension.height = Math.max(dimension.height, imageArray2.getHeight(null));
        }
        dimension.width -= n;
        if (dimension.width <= 0 || dimension.height <= 0) {
            return null;
        }
        BufferedImage bufferedImage = ImageUtils.createCompatibleImage(dimension.width, dimension.height, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        int n2 = 0;
        for (Image image : imageArray) {
            if (image == null) continue;
            graphics2D.drawImage(image, n2, 0, null);
            n2 += image.getWidth(null) + n;
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    public static void clearMergedIconsCache() {
        mergedIconsCache.clear();
    }

    public static ImageIcon mergeIcons(List<ImageIcon> list) {
        return ImageUtils.mergeIcons(null, list);
    }

    public static ImageIcon mergeIcons(String string, List<ImageIcon> list) {
        if (string != null && mergedIconsCache.containsKey(string)) {
            return mergedIconsCache.get(string);
        }
        if (list == null || list.size() == 0) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        Image[] imageArray = new Image[list.size()];
        int n = 0;
        for (ImageIcon imageIcon : list) {
            imageArray[n] = imageIcon != null ? imageIcon.getImage() : null;
            ++n;
        }
        ImageIcon imageIcon = new ImageIcon(ImageUtils.mergeImages(imageArray));
        if (string != null) {
            mergedIconsCache.put(string, imageIcon);
        }
        return imageIcon;
    }

    public static ImageIcon mergeIcons(ImageIcon ... imageIconArray) {
        return ImageUtils.mergeIcons(null, imageIconArray);
    }

    public static ImageIcon mergeIcons(String string, ImageIcon ... imageIconArray) {
        if (string != null && mergedIconsCache.containsKey(string)) {
            return mergedIconsCache.get(string);
        }
        if (imageIconArray == null || imageIconArray.length == 0) {
            return null;
        }
        if (imageIconArray.length == 1) {
            return imageIconArray[0];
        }
        Image[] imageArray = new Image[imageIconArray.length];
        int n = 0;
        for (ImageIcon imageIcon : imageIconArray) {
            imageArray[n] = imageIcon != null ? imageIcon.getImage() : null;
            ++n;
        }
        ImageIcon imageIcon = new ImageIcon(ImageUtils.mergeImages(imageArray));
        if (string != null) {
            mergedIconsCache.put(string, imageIcon);
        }
        return imageIcon;
    }

    public static void clearMergedImagesCache() {
        mergedImagesCache.clear();
    }

    public static BufferedImage mergeImages(Image ... imageArray) {
        return ImageUtils.mergeImages(null, imageArray);
    }

    public static BufferedImage mergeImages(String string, Image ... imageArray) {
        if (string != null && mergedImagesCache.containsKey(string)) {
            return mergedImagesCache.get(string);
        }
        if (imageArray == null || imageArray.length == 0) {
            return null;
        }
        if (imageArray.length == 1) {
            return ImageUtils.getBufferedImage(imageArray[0]);
        }
        Dimension dimension = new Dimension(0, 0);
        for (Image image : imageArray) {
            if (image == null) continue;
            dimension.width = Math.max(dimension.width, image.getWidth(null));
            dimension.height = Math.max(dimension.height, image.getHeight(null));
        }
        if (dimension.width <= 0 || dimension.height <= 0) {
            return null;
        }
        BufferedImage bufferedImage = ImageUtils.createCompatibleImage(dimension.width, dimension.height, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        for (Image image : imageArray) {
            if (image == null) continue;
            graphics2D.drawImage(image, 0, 0, null);
        }
        graphics2D.dispose();
        if (string != null) {
            mergedImagesCache.put(string, bufferedImage);
        }
        return bufferedImage;
    }

    public static BufferedImage loadImage(String string) {
        return ImageUtils.loadImage(new File(string));
    }

    public static BufferedImage loadImage(File file) {
        try {
            return ImageIO.read(file);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static ImageIcon loadImage(URL uRL) {
        try {
            return new ImageIcon(uRL);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static ImageIcon loadImage(Class clazz, String string) {
        try {
            return new ImageIcon(clazz.getResource(string));
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static ImageIcon loadImage(InputStream inputStream) {
        try {
            return new ImageIcon(ImageIO.read(inputStream));
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static ImageIcon addBackground(ImageIcon imageIcon, Color color) {
        return new ImageIcon(ImageUtils.addBackground(ImageUtils.getBufferedImage(imageIcon), color));
    }

    public static BufferedImage addBackground(BufferedImage bufferedImage, Color color) {
        BufferedImage bufferedImage2 = ImageUtils.createCompatibleImage(bufferedImage);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setPaint(color);
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static ImageIcon resizeCanvas(ImageIcon imageIcon, int n, int n2) {
        return new ImageIcon(ImageUtils.resizeCanvas(ImageUtils.getBufferedImage(imageIcon), n, n2));
    }

    public static BufferedImage resizeCanvas(BufferedImage bufferedImage, int n, int n2) {
        BufferedImage bufferedImage2 = ImageUtils.createCompatibleImage(bufferedImage, n, n2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage((Image)bufferedImage, n / 2 - bufferedImage.getWidth() / 2, n2 / 2 - bufferedImage.getHeight() / 2, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static ImageIcon rotateImage90CW(ImageIcon imageIcon) {
        return new ImageIcon(ImageUtils.rotateImage90CW(ImageUtils.getBufferedImage(imageIcon)));
    }

    public static BufferedImage rotateImage90CW(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = ImageUtils.createCompatibleImage(bufferedImage.getHeight(), bufferedImage.getWidth(), 3);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.translate(bufferedImage.getHeight(), 0);
        graphics2D.rotate(1.5707963267948966);
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static ImageIcon rotateImage90CCW(ImageIcon imageIcon) {
        return new ImageIcon(ImageUtils.rotateImage90CCW(ImageUtils.getBufferedImage(imageIcon)));
    }

    public static BufferedImage rotateImage90CCW(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = ImageUtils.createCompatibleImage(bufferedImage.getHeight(), bufferedImage.getWidth(), 3);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.translate(0, bufferedImage.getWidth());
        graphics2D.rotate(-1.5707963267948966);
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static ImageIcon rotateImage180(ImageIcon imageIcon) {
        return new ImageIcon(ImageUtils.rotateImage180(ImageUtils.getBufferedImage(imageIcon)));
    }

    public static BufferedImage rotateImage180(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = ImageUtils.createCompatibleImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 3);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.translate(bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.rotate(Math.PI);
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static ImageIcon createEmptyIcon(int n, int n2) {
        return new ImageIcon(ImageUtils.createEmptyImage(n, n2));
    }

    public static BufferedImage createEmptyImage(int n, int n2) {
        return ImageUtils.createCompatibleImage(n, n2, 3);
    }

    public static ImageIcon createColorIcon(Color color) {
        return ImageUtils.createColorIcon(color, 16, 16);
    }

    public static ImageIcon createColorIcon(Color color, int n, int n2) {
        return new ImageIcon(ImageUtils.createColorImage(color, n, n2));
    }

    public static BufferedImage createColorImage(Color color) {
        return ImageUtils.createColorImage(color, 16, 16);
    }

    public static BufferedImage createColorImage(Color color, int n, int n2) {
        BufferedImage bufferedImage = ImageUtils.createCompatibleImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        LafUtils.setupAntialias(graphics2D);
        graphics2D.setPaint(Color.GRAY);
        graphics2D.drawRoundRect(0, 0, n - 1, n2 - 1, StyleConstants.largeRound, StyleConstants.bigRound);
        graphics2D.setPaint(Color.WHITE);
        graphics2D.drawRoundRect(1, 1, n - 3, n2 - 3, StyleConstants.bigRound, StyleConstants.bigRound);
        graphics2D.setPaint(color);
        graphics2D.fillRoundRect(2, 2, n - 4, n2 - 4, StyleConstants.bigRound, StyleConstants.bigRound);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static ImageIcon createColorChooserIcon(Color color) {
        return new ImageIcon(ImageUtils.createColorChooserImage(color));
    }

    public static BufferedImage createColorChooserImage(Color color) {
        BufferedImage bufferedImage = ImageUtils.createCompatibleImage(16, 16, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (color == null || color.getAlpha() < 255) {
            graphics2D.drawImage(transarentChooserIcon.getImage(), 0, 0, null);
        }
        if (color != null) {
            graphics2D.setPaint(color);
            graphics2D.fillRect(2, 2, 13, 12);
        }
        graphics2D.drawImage(coloredChooserIcon.getImage(), 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static void darkenImage(BufferedImage bufferedImage, float f) {
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setComposite(AlphaComposite.getInstance(3, f));
        graphics2D.setPaint(Color.BLACK);
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.dispose();
    }

    public static Color getImageAverageColor(ImageIcon imageIcon) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        BufferedImage bufferedImage = ImageUtils.getBufferedImage(imageIcon.getImage());
        for (n = 0; n < imageIcon.getIconWidth(); ++n) {
            for (int i = 0; i < imageIcon.getIconHeight(); ++i) {
                int n5 = bufferedImage.getRGB(n, i);
                n2 += n5 >> 16 & 0xFF;
                n3 += n5 >> 8 & 0xFF;
                n4 += n5 & 0xFF;
            }
        }
        n = imageIcon.getIconWidth() * imageIcon.getIconHeight();
        return new Color(n2 / n, n3 / n, n4 / n);
    }

    public static boolean isImageLoadable(String string) {
        return GlobalConstants.IMAGE_FORMATS.contains(FileUtils.getFileExtPart(string, false).toLowerCase());
    }

    public static ImageIcon createThumbnailIcon(String string) {
        return ImageUtils.createThumbnailIcon(string, 50);
    }

    public static ImageIcon createThumbnailIcon(String string, int n) {
        ImageIcon imageIcon = ImageUtils.getImageIcon(string);
        if (imageIcon != null) {
            ImageIcon imageIcon2 = ImageUtils.createPreviewIcon(imageIcon.getImage(), n);
            if (imageIcon2 != null) {
                imageIcon2.setDescription(imageIcon.getIconWidth() + "x" + imageIcon.getIconHeight());
            }
            return imageIcon2;
        }
        return null;
    }

    public static ImageIcon createPreviewIcon(ImageIcon imageIcon, int n) {
        return ImageUtils.createPreviewIcon(imageIcon.getImage(), n);
    }

    public static ImageIcon createPreviewIcon(Image image, int n) {
        return ImageUtils.createPreviewIcon(ImageUtils.getBufferedImage(image), n);
    }

    public static ImageIcon createPreviewIcon(BufferedImage bufferedImage, int n) {
        BufferedImage bufferedImage2 = ImageUtils.createPreviewImage(bufferedImage, n);
        if (bufferedImage2 != null) {
            return new ImageIcon(bufferedImage2);
        }
        return new ImageIcon();
    }

    public static BufferedImage createPreviewImage(BufferedImage bufferedImage, Dimension dimension) {
        return ImageUtils.createPreviewImage(bufferedImage, dimension.width, dimension.height);
    }

    public static BufferedImage createPreviewImage(BufferedImage bufferedImage, int n, int n2) {
        if (bufferedImage.getWidth() > n || bufferedImage.getHeight() > n2) {
            if ((float)n2 * ((float)bufferedImage.getWidth() / (float)bufferedImage.getHeight()) <= (float)n) {
                return ImageUtils.createPreviewImage(bufferedImage, Math.max(n2, Math.round((float)n2 * ((float)bufferedImage.getWidth() / (float)bufferedImage.getHeight()))));
            }
            return ImageUtils.createPreviewImage(bufferedImage, Math.max(n, Math.round((float)n * ((float)bufferedImage.getHeight() / (float)bufferedImage.getWidth()))));
        }
        return bufferedImage;
    }

    public static BufferedImage createPreviewImage(BufferedImage bufferedImage, int n) {
        int n2;
        int n3;
        if (bufferedImage == null) {
            return null;
        }
        if (bufferedImage.getWidth() <= n && bufferedImage.getHeight() <= n) {
            return bufferedImage;
        }
        if (bufferedImage.getWidth() > bufferedImage.getHeight()) {
            n3 = n;
            n2 = Math.round((float)n * (float)bufferedImage.getHeight() / (float)bufferedImage.getWidth());
        } else if (bufferedImage.getWidth() < bufferedImage.getHeight()) {
            n2 = n;
            n3 = Math.round((float)n * (float)bufferedImage.getWidth() / (float)bufferedImage.getHeight());
        } else {
            n3 = n2 = n;
        }
        if (n3 >= 3 && n2 >= 3) {
            return new ResampleOp(n3, n2).filter(bufferedImage, ImageUtils.createCompatibleImage(bufferedImage));
        }
        int n4 = Math.max(1, n3);
        int n5 = Math.max(1, n2);
        BufferedImage bufferedImage2 = ImageUtils.createCompatibleImage(n4, n5, 3);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        LafUtils.setupImageQuality(graphics2D);
        graphics2D.drawImage(bufferedImage, 0, 0, n3, n2, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static boolean isImageCached(String string) {
        return iconsCache.containsKey(string) && iconsCache.get(string) != null;
    }

    public static void setImageCache(String string, ImageIcon imageIcon) {
        iconsCache.put(string, imageIcon);
    }

    public static void clearImagesCache() {
        iconsCache.clear();
    }

    public static void clearImageCache(String string) {
        if (iconsCache.size() > 0 && iconsCache.containsKey(string)) {
            if (iconsCache.get(string) != null && iconsCache.get(string).getImage() != null) {
                iconsCache.get(string).getImage().flush();
            }
            iconsCache.remove(string);
        }
    }

    public static ImageIcon getImageIcon(File file) {
        return ImageUtils.getImageIcon(file, true);
    }

    public static ImageIcon getImageIcon(File file, boolean bl) {
        return ImageUtils.getImageIcon(file.getAbsolutePath(), bl);
    }

    public static ImageIcon getImageIcon(String string) {
        return ImageUtils.getImageIcon(string, true);
    }

    public static ImageIcon getImageIcon(String string, boolean bl) {
        if (string != null && !string.trim().equals("")) {
            if (bl && iconsCache.containsKey(string)) {
                ImageIcon imageIcon = iconsCache.get(string);
                if (imageIcon != null) {
                    return imageIcon;
                }
                iconsCache.remove(string);
                return ImageUtils.getImageIcon(string, bl);
            }
            ImageIcon imageIcon = ImageUtils.createImageIcon(string);
            if (bl) {
                iconsCache.put(string, imageIcon);
            }
            return imageIcon;
        }
        return null;
    }

    private static ImageIcon createImageIcon(String string) {
        if (!new File(string).exists()) {
            return new ImageIcon();
        }
        try {
            return new ImageIcon(ImageIO.read(new File(string)));
        }
        catch (Throwable throwable) {
            return new ImageIcon();
        }
    }

    public static BufferedImage copy(Image image) {
        return ImageUtils.copy(ImageUtils.getBufferedImage(image));
    }

    public static BufferedImage copy(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = ImageUtils.createCompatibleImage(bufferedImage);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static BufferedImage getBufferedImage(URL uRL) {
        return ImageUtils.getBufferedImage(new ImageIcon(uRL));
    }

    public static BufferedImage getBufferedImage(String string) {
        return ImageUtils.getBufferedImage(new ImageIcon(string));
    }

    public static BufferedImage getBufferedImage(ImageIcon imageIcon) {
        return ImageUtils.getBufferedImage(imageIcon.getImage());
    }

    public static BufferedImage getBufferedImage(Image image) {
        if (image == null || image.getWidth(null) <= 0 || image.getHeight(null) <= 0) {
            return null;
        }
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        BufferedImage bufferedImage = ImageUtils.createCompatibleImage(image.getWidth(null), image.getHeight(null), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static BufferedImage getBufferedImage(Icon icon) {
        if (icon == null) {
            return null;
        }
        if (icon instanceof ImageIcon) {
            Image image = ((ImageIcon)icon).getImage();
            if (image != null) {
                return ImageUtils.getBufferedImage(image);
            }
            return ImageUtils.createBufferedImage(icon);
        }
        return ImageUtils.createBufferedImage(icon);
    }

    public static BufferedImage createBufferedImage(Icon icon) {
        BufferedImage bufferedImage = ImageUtils.createCompatibleImage(icon.getIconWidth(), icon.getIconHeight(), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        icon.paintIcon(null, graphics2D, 0, 0);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static ImageIcon getSizedImagePreview(String string, int n, boolean bl) {
        if (sizedPreviewCache.containsKey(n + IMAGE_CACHE_SEPARATOR + string)) {
            return sizedPreviewCache.get(n + IMAGE_CACHE_SEPARATOR + string);
        }
        ImageIcon imageIcon = ImageUtils.createThumbnailIcon(string, n);
        ImageIcon imageIcon2 = ImageUtils.createSizedImagePreview(imageIcon, n, bl);
        sizedPreviewCache.put(n + IMAGE_CACHE_SEPARATOR + string, imageIcon2);
        return imageIcon2;
    }

    public static ImageIcon getSizedImagePreview(String string, ImageIcon imageIcon, int n, boolean bl) {
        if (sizedPreviewCache.containsKey(string)) {
            return sizedPreviewCache.get(string);
        }
        ImageIcon imageIcon2 = ImageUtils.createSizedImagePreview(imageIcon, n, bl);
        sizedPreviewCache.put(string, imageIcon2);
        return imageIcon2;
    }

    public static ImageIcon createSizedImagePreview(ImageIcon imageIcon, int n, boolean bl) {
        BufferedImage bufferedImage = ImageUtils.createCompatibleImage(n += 4, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (imageIcon != null) {
            graphics2D.drawImage(imageIcon.getImage(), n / 2 - imageIcon.getIconWidth() / 2, n / 2 - imageIcon.getIconHeight() / 2, null);
        }
        if (bl) {
            graphics2D.setPaint(Color.LIGHT_GRAY);
            graphics2D.drawRect(0, 0, n - 1, n - 1);
        }
        graphics2D.dispose();
        ImageIcon imageIcon2 = new ImageIcon(bufferedImage);
        imageIcon2.setDescription(imageIcon != null ? imageIcon.getDescription() : null);
        return imageIcon2;
    }

    public static ImageIcon getDisabledCopy(String string, ImageIcon imageIcon) {
        if (grayscaleCache.containsKey(string)) {
            return grayscaleCache.get(string);
        }
        grayscaleCache.put(string, ImageUtils.createDisabledCopy(imageIcon));
        return grayscaleCache.get(string);
    }

    public static ImageIcon createDisabledCopy(ImageIcon imageIcon) {
        return new ImageIcon(ImageUtils.createDisabledCopy(imageIcon.getImage()));
    }

    public static BufferedImage createDisabledCopy(Image image) {
        BufferedImage bufferedImage = ImageUtils.createGrayscaleCopy(image);
        BufferedImage bufferedImage2 = ImageUtils.createCompatibleImage(bufferedImage);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        LafUtils.setupAlphaComposite(graphics2D, StyleConstants.disabledIconsTransparency);
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static ImageIcon createGrayscaleCopy(ImageIcon imageIcon) {
        return new ImageIcon(ImageUtils.createGrayscaleCopy(imageIcon.getImage()));
    }

    public static BufferedImage createGrayscaleCopy(Image image) {
        return ImageUtils.createGrayscaleCopy(ImageUtils.getBufferedImage(image));
    }

    public static BufferedImage createGrayscaleCopy(BufferedImage bufferedImage) {
        return ImageFilterUtils.applyGrayscaleFilter(bufferedImage, null);
    }

    public static ImageIcon getTransparentCopy(String string, ImageIcon imageIcon, float f) {
        if (trasparentCache.containsKey(string)) {
            return trasparentCache.get(string);
        }
        trasparentCache.put(string, ImageUtils.createTransparentCopy(imageIcon, f));
        return trasparentCache.get(string);
    }

    public static ImageIcon createTransparentCopy(ImageIcon imageIcon, float f) {
        BufferedImage bufferedImage = ImageUtils.createCompatibleImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        LafUtils.setupAlphaComposite(graphics2D, f);
        graphics2D.drawImage(imageIcon.getImage(), 0, 0, null);
        graphics2D.dispose();
        return new ImageIcon(bufferedImage);
    }

    public static BufferedImage createPrettyImage(Image image, int n, int n2) {
        return ImageUtils.createPrettyImage(ImageUtils.getBufferedImage(image), n, n2);
    }

    public static BufferedImage createPrettyImage(BufferedImage bufferedImage, int n, int n2) {
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = ImageUtils.createCompatibleImage(n3 + n * 2 + 1, n4 + n * 2 + 1, 3);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        LafUtils.setupAntialias(graphics2D);
        LafUtils.setupImageQuality(graphics2D);
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(n, n, n3, n4, n2, n2);
        Shape shape = graphics2D.getClip();
        graphics2D.setClip(double_);
        graphics2D.drawImage((Image)bufferedImage, n, n, null);
        graphics2D.setClip(shape);
        LafUtils.drawShade(graphics2D, double_, StyleConstants.shadeColor, n);
        graphics2D.setPaint(new LinearGradientPaint(0.0f, n, 0.0f, n4 - n, new float[]{0.0f, 0.5f, 1.0f}, new Color[]{new Color(125, 125, 125, 48), new Color(125, 125, 125, 0), new Color(125, 125, 125, 48)}));
        graphics2D.fill(double_);
        graphics2D.setColor(Color.GRAY);
        graphics2D.draw(double_);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static BufferedImage createImageShade(int n, int n2, Shape shape, int n3, float f) {
        return ImageUtils.createImageShade(n, n2, shape, n3, f, StyleConstants.transparent);
    }

    public static BufferedImage createImageShade(int n, int n2, Shape shape, int n3, float f, Color color) {
        int n4 = n3 * 2 + n;
        int n5 = n3 * 2 + n2;
        BufferedImage bufferedImage = ImageUtils.createCompatibleImage(n4, n4, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        LafUtils.setupAntialias(graphics2D);
        graphics2D.translate(n3, n3);
        graphics2D.setPaint(Color.BLACK);
        graphics2D.fill(shape);
        graphics2D.dispose();
        ShadowFilter shadowFilter = new ShadowFilter(n3, 0, 0, f);
        BufferedImage bufferedImage2 = shadowFilter.filter(bufferedImage, null);
        if (color != null) {
            Graphics2D graphics2D2 = bufferedImage2.createGraphics();
            LafUtils.setupAntialias(graphics2D2);
            graphics2D2.translate(n3, n3);
            graphics2D2.setComposite(AlphaComposite.getInstance(5));
            graphics2D2.setPaint(color);
            graphics2D2.fill(shape);
            graphics2D2.dispose();
        }
        return bufferedImage2;
    }

    public static ImageIcon createSimpleUpArrowIcon(int n) {
        return new ImageIcon(ImageUtils.createSimpleUpArrowImage(n));
    }

    public static BufferedImage createSimpleUpArrowImage(int n) {
        return ImageUtils.createImageShade(10, 10, ImageUtils.createUpArrowFill(), n, 1.0f, Color.WHITE);
    }

    public static ImageIcon createUpArrowIcon(int n) {
        return new ImageIcon(ImageUtils.createUpArrowImage(n));
    }

    public static BufferedImage createUpArrowImage(int n) {
        return ImageUtils.createArrowImage(ImageUtils.createUpArrowFill(), ImageUtils.createUpArrowBorder(), n);
    }

    private static GeneralPath createUpArrowFill() {
        GeneralPath generalPath = new GeneralPath(0);
        generalPath.moveTo(0.0f, 7.0f);
        generalPath.lineTo(5.0f, 1.0f);
        generalPath.lineTo(10.0f, 7.0f);
        generalPath.closePath();
        return generalPath;
    }

    private static GeneralPath createUpArrowBorder() {
        GeneralPath generalPath = new GeneralPath(0);
        generalPath.moveTo(0.0f, 6.0f);
        generalPath.lineTo(4.0f, 2.0f);
        generalPath.lineTo(8.0f, 6.0f);
        generalPath.closePath();
        return generalPath;
    }

    public static ImageIcon createSimpleLeftArrowIcon(int n) {
        return new ImageIcon(ImageUtils.createSimpleLeftArrowImage(n));
    }

    public static BufferedImage createSimpleLeftArrowImage(int n) {
        return ImageUtils.createImageShade(10, 10, ImageUtils.createLeftArrowFill(), n, 1.0f, Color.WHITE);
    }

    public static ImageIcon createLeftArrowIcon(int n) {
        return new ImageIcon(ImageUtils.createLeftArrowImage(n));
    }

    public static BufferedImage createLeftArrowImage(int n) {
        return ImageUtils.createArrowImage(ImageUtils.createLeftArrowFill(), ImageUtils.createLeftArrowBorder(), n);
    }

    private static GeneralPath createLeftArrowFill() {
        GeneralPath generalPath = new GeneralPath(0);
        generalPath.moveTo(7.0f, 0.0f);
        generalPath.lineTo(1.0f, 5.0f);
        generalPath.lineTo(7.0f, 10.0f);
        generalPath.closePath();
        return generalPath;
    }

    private static GeneralPath createLeftArrowBorder() {
        GeneralPath generalPath = new GeneralPath(0);
        generalPath.moveTo(6.0f, 0.0f);
        generalPath.lineTo(2.0f, 4.0f);
        generalPath.lineTo(6.0f, 8.0f);
        generalPath.closePath();
        return generalPath;
    }

    public static ImageIcon createSimpleDownArrowIcon(int n) {
        return new ImageIcon(ImageUtils.createSimpleDownArrowImage(n));
    }

    public static BufferedImage createSimpleDownArrowImage(int n) {
        return ImageUtils.createImageShade(10, 10, ImageUtils.createDownArrowFill(), n, 1.0f, Color.WHITE);
    }

    public static ImageIcon createDownArrowIcon(int n) {
        return new ImageIcon(ImageUtils.createDownArrowImage(n));
    }

    public static BufferedImage createDownArrowImage(int n) {
        return ImageUtils.createArrowImage(ImageUtils.createDownArrowFill(), ImageUtils.createDownArrowBorder(), n);
    }

    private static GeneralPath createDownArrowFill() {
        GeneralPath generalPath = new GeneralPath(0);
        generalPath.moveTo(0.0f, 3.0f);
        generalPath.lineTo(5.0f, 9.0f);
        generalPath.lineTo(10.0f, 3.0f);
        generalPath.closePath();
        return generalPath;
    }

    private static GeneralPath createDownArrowBorder() {
        GeneralPath generalPath = new GeneralPath(0);
        generalPath.moveTo(0.0f, 3.0f);
        generalPath.lineTo(4.0f, 7.0f);
        generalPath.lineTo(8.0f, 3.0f);
        generalPath.closePath();
        return generalPath;
    }

    public static ImageIcon createSimpleRightArrowIcon(int n) {
        return new ImageIcon(ImageUtils.createSimpleRightArrowImage(n));
    }

    public static BufferedImage createSimpleRightArrowImage(int n) {
        return ImageUtils.createImageShade(10, 10, ImageUtils.createRightArrowFill(), n, 1.0f, Color.WHITE);
    }

    public static ImageIcon createRightArrowIcon(int n) {
        return new ImageIcon(ImageUtils.createRightArrowImage(n));
    }

    public static BufferedImage createRightArrowImage(int n) {
        return ImageUtils.createArrowImage(ImageUtils.createRightArrowFill(), ImageUtils.createRightArrowBorder(), n);
    }

    private static GeneralPath createRightArrowFill() {
        GeneralPath generalPath = new GeneralPath(0);
        generalPath.moveTo(3.0f, 0.0f);
        generalPath.lineTo(9.0f, 5.0f);
        generalPath.lineTo(3.0f, 10.0f);
        generalPath.closePath();
        return generalPath;
    }

    private static GeneralPath createRightArrowBorder() {
        GeneralPath generalPath = new GeneralPath(0);
        generalPath.moveTo(3.0f, 0.0f);
        generalPath.lineTo(7.0f, 4.0f);
        generalPath.lineTo(3.0f, 8.0f);
        generalPath.closePath();
        return generalPath;
    }

    private static BufferedImage createArrowImage(GeneralPath generalPath, GeneralPath generalPath2, int n) {
        BufferedImage bufferedImage = ImageUtils.createImageShade(10, 10, generalPath, n, 1.0f, Color.BLACK);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        LafUtils.setupAntialias(graphics2D);
        graphics2D.setPaint(Color.WHITE);
        graphics2D.translate(n, n);
        graphics2D.draw(generalPath2);
        graphics2D.dispose();
        return bufferedImage;
    }
}

