/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.laf.StyleConstants;
import com.alee.utils.ColorUtils;
import com.alee.utils.GeometryUtils;
import com.alee.utils.laf.FocusType;
import com.alee.utils.laf.ShadeType;
import com.alee.utils.ninepatch.NinePatchIcon;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicButtonUI;

public class LafUtils {
    private static boolean systemTextHintsInitialized = false;
    private static Map systemTextHints = null;
    private static Map<String, GradientPaint> gradientCache = new HashMap<String, GradientPaint>();
    private static Map<String, Stroke> cachedStrokes = new HashMap<String, Stroke>();
    public static int halfButton = 4;
    public static int halfSelector = 2;
    public static int halfLine = 1;
    public static int shadeWidth = 3;
    private static final NinePatchIcon conn = new NinePatchIcon(LafUtils.class.getResource("icons/selection/conn.9.png"));
    private static final NinePatchIcon lr_conn = new NinePatchIcon(LafUtils.class.getResource("icons/selection/lr_conn.9.png"));
    private static final NinePatchIcon ud_conn = new NinePatchIcon(LafUtils.class.getResource("icons/selection/ud_conn.9.png"));
    private static final NinePatchIcon corners_conn = new NinePatchIcon(LafUtils.class.getResource("icons/selection/corners_conn.9.png"));
    private static final NinePatchIcon full_conn = new NinePatchIcon(LafUtils.class.getResource("icons/selection/full_conn.9.png"));
    private static final NinePatchIcon lr = new NinePatchIcon(LafUtils.class.getResource("icons/selection/lr.9.png"));
    private static final NinePatchIcon ud = new NinePatchIcon(LafUtils.class.getResource("icons/selection/ud.9.png"));
    private static final NinePatchIcon corners = new NinePatchIcon(LafUtils.class.getResource("icons/selection/corners.9.png"));
    private static final NinePatchIcon full = new NinePatchIcon(LafUtils.class.getResource("icons/selection/full.9.png"));
    private static Map<Integer, NinePatchIcon> selectorCache = new HashMap<Integer, NinePatchIcon>();
    private static final int TEXT_SHADOW_SIZE = 2;

    public static Border createWebBorder(Insets insets) {
        return new EmptyBorder(insets.top, insets.left, insets.bottom, insets.right);
    }

    public static Border createWebBorder(int n, int n2, int n3, int n4) {
        return new EmptyBorder(n, n2, n3, n4);
    }

    public static Border createWebBorder(int n) {
        return new EmptyBorder(n, n, n, n);
    }

    public static void fillVisibleBackground(Graphics graphics, JComponent jComponent) {
        if (jComponent.isOpaque()) {
            graphics.setColor(jComponent.getBackground());
            LafUtils.fillVisible(graphics, jComponent);
        }
    }

    public static void fillVisible(Graphics graphics, JComponent jComponent) {
        Shape shape = graphics.getClip();
        Rectangle rectangle = shape != null ? shape.getBounds() : jComponent.getVisibleRect();
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static void nullifyButtonUI(JButton jButton) {
        jButton.setUI(new BasicButtonUI());
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setBorder(null);
        jButton.setBorderPainted(false);
        jButton.setContentAreaFilled(false);
        jButton.setFocusable(false);
        jButton.setOpaque(false);
    }

    public static Shape createRoundedShape(int n, int ... nArray) {
        if (nArray == null || nArray.length % 2 != 0) {
            throw new RuntimeException("Incorrect x,y combinations amount");
        }
        Point[] pointArray = new Point[nArray.length / 2];
        for (int i = 0; i < nArray.length; i += 2) {
            pointArray[i / 2] = new Point(nArray[i], nArray[i + 1]);
        }
        return LafUtils.createRoundedShape(n, pointArray);
    }

    public static Shape createRoundedShape(int n, Point ... pointArray) {
        return LafUtils.createRoundedShape(n, pointArray, null);
    }

    public static Shape createRoundedShape(int n, Point[] pointArray, boolean[] blArray) {
        if (pointArray == null || pointArray.length < 3) {
            throw new RuntimeException("There should be atleast three points presented");
        }
        if (blArray != null && blArray.length != pointArray.length) {
            throw new RuntimeException("Rouned marks array size should fit points array size");
        }
        GeneralPath generalPath = new GeneralPath(0);
        for (int i = 0; i < pointArray.length; ++i) {
            Point point;
            Point point2;
            Point point3 = pointArray[i];
            if (i == 0) {
                point2 = pointArray[pointArray.length - 1];
                if (n == 0 || blArray != null && !blArray[pointArray.length - 1]) {
                    generalPath.moveTo(point2.x, point2.y);
                } else {
                    point = LafUtils.getRoundSidePoint(n, point2, point3);
                    generalPath.moveTo(point.x, point.y);
                }
                if (n == 0 || blArray != null && !blArray[i]) {
                    generalPath.lineTo(point3.x, point3.y);
                    continue;
                }
                point = LafUtils.getRoundSidePoint(n, point3, point2);
                Point point4 = LafUtils.getRoundSidePoint(n, point3, pointArray[i + 1]);
                generalPath.lineTo(point.x, point.y);
                generalPath.quadTo(point3.x, point3.y, point4.x, point4.y);
                continue;
            }
            if (n == 0 || blArray != null && !blArray[i]) {
                generalPath.lineTo(point3.x, point3.y);
                continue;
            }
            point2 = LafUtils.getRoundSidePoint(n, point3, pointArray[i - 1]);
            point = LafUtils.getRoundSidePoint(n, point3, pointArray[i < pointArray.length - 1 ? i + 1 : 0]);
            generalPath.lineTo(point2.x, point2.y);
            generalPath.quadTo(point3.x, point3.y, point.x, point.y);
        }
        return generalPath;
    }

    private static Point getRoundSidePoint(int n, Point point, Point point2) {
        if (point.y == point2.y) {
            if (point.x < point2.x) {
                return new Point(point.x + Math.min(n, (point2.x - point.x) / 2), point.y);
            }
            return new Point(point.x - Math.min(n, (point.x - point2.x) / 2), point.y);
        }
        if (point.x == point2.x) {
            if (point.y < point2.y) {
                return new Point(point.x, point.y + Math.min(n, (point2.y - point.y) / 2));
            }
            return new Point(point.x, point.y - Math.min(n, (point.y - point2.y) / 2));
        }
        return null;
    }

    public static void drawAlphaLayer(Graphics2D graphics2D, Rectangle rectangle) {
        LafUtils.drawAlphaLayer(graphics2D, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static void drawAlphaLayer(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        LafUtils.drawAlphaLayer(graphics2D, n, n2, n3, n4, StyleConstants.ALPHA_RECT_SIZE);
    }

    public static void drawAlphaLayer(Graphics2D graphics2D, Rectangle rectangle, int n) {
        LafUtils.drawAlphaLayer(graphics2D, rectangle.x, rectangle.y, rectangle.width, rectangle.height, n);
    }

    public static void drawAlphaLayer(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5) {
        LafUtils.drawAlphaLayer(graphics2D, n, n2, n3, n4, n5, StyleConstants.LIGHT_ALPHA, StyleConstants.DARK_ALPHA);
    }

    public static void drawAlphaLayer(Graphics2D graphics2D, Rectangle rectangle, int n, Color color, Color color2) {
        LafUtils.drawAlphaLayer(graphics2D, rectangle.x, rectangle.y, rectangle.width, rectangle.height, n, color, color2);
    }

    public static void drawAlphaLayer(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5, Color color, Color color2) {
        int n6 = n3 / n5 + 1;
        int n7 = n4 / n5 + 1;
        for (int i = 0; i < n6; ++i) {
            for (int j = 0; j < n7; ++j) {
                Color color3;
                boolean bl = (i + j) % 2 == 0;
                Color color4 = color3 = bl ? color : color2;
                if (color3 == null) continue;
                graphics2D.setPaint(color3);
                int n8 = n + i * n5 + n5 > n + n3 ? n3 - i * n5 : n5;
                int n9 = n2 + j * n5 + n5 > n2 + n4 ? n4 - j * n5 : n5;
                graphics2D.fillRect(n + i * n5, n2 + j * n5, n8, n9);
            }
        }
    }

    public static Shape intersectClip(Graphics2D graphics2D, Shape shape) {
        return LafUtils.intersectClip(graphics2D, shape, true);
    }

    public static Shape intersectClip(Graphics2D graphics2D, Shape shape, boolean bl) {
        if (bl && shape != null) {
            Shape shape2 = graphics2D.getClip();
            graphics2D.clip(shape);
            return shape2;
        }
        return null;
    }

    public static Shape subtractClip(Graphics graphics, Shape shape) {
        return LafUtils.subtractClip(graphics, shape, true);
    }

    public static Shape subtractClip(Graphics graphics, Shape shape, boolean bl) {
        if (bl && shape != null) {
            Shape shape2 = graphics.getClip();
            if (shape2 != null) {
                Area area = new Area(shape2);
                area.subtract(new Area(shape));
                graphics.setClip(area);
            }
            return shape2;
        }
        return null;
    }

    public static void restoreClip(Graphics graphics, Shape shape) {
        LafUtils.restoreClip(graphics, shape, true);
    }

    public static void restoreClip(Graphics graphics, Shape shape, boolean bl) {
        if (bl && shape != null) {
            graphics.setClip(shape);
        }
    }

    public static Stroke setupStroke(Graphics2D graphics2D, Stroke stroke) {
        return LafUtils.setupStroke(graphics2D, stroke, true);
    }

    public static Stroke setupStroke(Graphics2D graphics2D, Stroke stroke, boolean bl) {
        if (bl && stroke != null) {
            Stroke stroke2 = graphics2D.getStroke();
            graphics2D.setStroke(stroke);
            return stroke2;
        }
        return null;
    }

    public static void restoreStroke(Graphics2D graphics2D, Stroke stroke) {
        LafUtils.restoreStroke(graphics2D, stroke, true);
    }

    public static void restoreStroke(Graphics2D graphics2D, Stroke stroke, boolean bl) {
        if (bl && stroke != null) {
            graphics2D.setStroke(stroke);
        }
    }

    public static Object setupImageQuality(Graphics graphics) {
        return LafUtils.setupImageQuality((Graphics2D)graphics);
    }

    public static Object setupImageQuality(Graphics2D graphics2D) {
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        return object;
    }

    public static void restoreImageQuality(Graphics graphics, Object object) {
        LafUtils.restoreImageQuality((Graphics2D)graphics, object);
    }

    public static void restoreImageQuality(Graphics2D graphics2D, Object object) {
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object != null ? object : RenderingHints.VALUE_INTERPOLATION_BILINEAR);
    }

    public static Object setupAntialias(Graphics graphics) {
        return LafUtils.setupAntialias((Graphics2D)graphics, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    public static Object setupAntialias(Graphics2D graphics2D) {
        return LafUtils.setupAntialias(graphics2D, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    public static Object disableAntialias(Graphics graphics) {
        return LafUtils.setupAntialias((Graphics2D)graphics, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    public static Object disableAntialias(Graphics2D graphics2D) {
        return LafUtils.setupAntialias(graphics2D, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    private static Object setupAntialias(Graphics2D graphics2D, Object object) {
        Object object2 = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        return object2;
    }

    public static void restoreAntialias(Graphics graphics, Object object) {
        LafUtils.restoreAntialias((Graphics2D)graphics, object);
    }

    public static void restoreAntialias(Graphics2D graphics2D, Object object) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    public static Map getSystemTextHints() {
        if (!systemTextHintsInitialized) {
            systemTextHints = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
            systemTextHintsInitialized = true;
        }
        return systemTextHints;
    }

    public static void setupSystemTextHints(Graphics graphics) {
        LafUtils.setupSystemTextHints((Graphics2D)graphics);
    }

    public static void setupSystemTextHints(Graphics2D graphics2D) {
        Map map = LafUtils.getSystemTextHints();
        if (map != null) {
            graphics2D.addRenderingHints(map);
        }
    }

    public static Composite setupAlphaComposite(Graphics2D graphics2D, float f) {
        return LafUtils.setupAlphaComposite(graphics2D, f, true);
    }

    public static Composite setupAlphaComposite(Graphics2D graphics2D, float f, boolean bl) {
        return LafUtils.setupAlphaComposite(graphics2D, graphics2D.getComposite(), f, bl);
    }

    public static Composite setupAlphaComposite(Graphics2D graphics2D, Composite composite, float f) {
        return LafUtils.setupAlphaComposite(graphics2D, composite, f, true);
    }

    public static Composite setupAlphaComposite(Graphics2D graphics2D, Composite composite, float f, boolean bl) {
        Composite composite2 = graphics2D.getComposite();
        if (!bl) {
            return composite2;
        }
        float f2 = 1.0f;
        if (composite != null && composite instanceof AlphaComposite) {
            f2 = ((AlphaComposite)composite).getAlpha();
        }
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, f2 * f);
        graphics2D.setComposite(alphaComposite);
        return composite2;
    }

    public static void restoreComposite(Graphics2D graphics2D, Composite composite) {
        graphics2D.setComposite(composite);
    }

    public static void restoreComposite(Graphics2D graphics2D, Composite composite, boolean bl) {
        if (bl) {
            graphics2D.setComposite(composite);
        }
    }

    public static Rectangle getTextBounds(String string, Graphics graphics, Font font) {
        return LafUtils.getTextBounds(string, (Graphics2D)graphics, font);
    }

    public static Rectangle getTextBounds(String string, Graphics2D graphics2D, Font font) {
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        GlyphVector glyphVector = font.createGlyphVector(fontRenderContext, string);
        return glyphVector.getVisualBounds().getBounds();
    }

    public static Shape drawWebStyle(Graphics2D graphics2D, JComponent jComponent) {
        return LafUtils.drawWebStyle(graphics2D, jComponent, StyleConstants.shadeColor, StyleConstants.shadeWidth, StyleConstants.smallRound);
    }

    public static Shape drawWebStyle(Graphics2D graphics2D, JComponent jComponent, Color color, int n, int n2) {
        return LafUtils.drawWebStyle(graphics2D, jComponent, color, n, n2, true);
    }

    public static Shape drawWebStyle(Graphics2D graphics2D, JComponent jComponent, Color color, int n, int n2, boolean bl) {
        return LafUtils.drawWebStyle(graphics2D, jComponent, color, n, n2, bl, false);
    }

    public static Shape drawWebStyle(Graphics2D graphics2D, JComponent jComponent, Color color, int n, int n2, boolean bl, boolean bl2) {
        return LafUtils.drawWebStyle(graphics2D, jComponent, color, n, n2, bl, bl2, StyleConstants.darkBorderColor, StyleConstants.disabledBorderColor);
    }

    public static Shape drawWebStyle(Graphics2D graphics2D, JComponent jComponent, Color color, int n, int n2, boolean bl, boolean bl2, float f) {
        return LafUtils.drawWebStyle(graphics2D, jComponent, color, n, n2, bl, bl2, StyleConstants.darkBorderColor, StyleConstants.disabledBorderColor, f);
    }

    public static Shape drawWebStyle(Graphics2D graphics2D, JComponent jComponent, Color color, int n, int n2, boolean bl, boolean bl2, Color color2) {
        return LafUtils.drawWebStyle(graphics2D, jComponent, color, n, n2, bl, bl2, color2, color2);
    }

    public static Shape drawWebStyle(Graphics2D graphics2D, JComponent jComponent, Color color, int n, int n2, boolean bl, boolean bl2, Color color2, Color color3) {
        return LafUtils.drawWebStyle(graphics2D, jComponent, color, n, n2, bl, bl2, color2, color3, 1.0f);
    }

    public static Shape drawWebStyle(Graphics2D graphics2D, JComponent jComponent, Color color, int n, int n2, boolean bl, boolean bl2, Color color2, Color color3, float f) {
        if (f <= 0.0f || f > 1.0f) {
            return null;
        }
        Object object = LafUtils.setupAntialias(graphics2D);
        Composite composite = LafUtils.setupAlphaComposite(graphics2D, f, f < 1.0f);
        Shape shape = LafUtils.getWebBorderShape(jComponent, n, n2);
        if (jComponent.isEnabled() && color != null) {
            LafUtils.drawShade(graphics2D, shape, color, n);
        }
        if (bl) {
            graphics2D.setPaint(bl2 ? LafUtils.getWebGradientPaint(0, n, 0, jComponent.getHeight() - n) : jComponent.getBackground());
            if (n2 > 0) {
                graphics2D.fillRoundRect(n, n, jComponent.getWidth() - n * 2, jComponent.getHeight() - n * 2, n2 * 2 + 2, n2 * 2 + 2);
            } else {
                graphics2D.fillRect(n, n, jComponent.getWidth() - n * 2, jComponent.getHeight() - n * 2);
            }
        }
        if (color2 != null) {
            graphics2D.setPaint(jComponent.isEnabled() ? color2 : color3);
            graphics2D.draw(shape);
        }
        LafUtils.restoreComposite(graphics2D, composite, f < 1.0f);
        LafUtils.restoreAntialias(graphics2D, object);
        return shape;
    }

    public static GradientPaint getWebGradientPaint(Rectangle rectangle) {
        return LafUtils.getWebGradientPaint(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height);
    }

    public static GradientPaint getWebGradientPaint(int n, int n2, int n3, int n4) {
        String string = n + ";" + n2 + ";" + n3 + ";" + n4;
        if (gradientCache.containsKey(string)) {
            return gradientCache.get(string);
        }
        GradientPaint gradientPaint = new GradientPaint(n, n2, StyleConstants.topBgColor, n3, n4, StyleConstants.bottomBgColor);
        gradientCache.put(string, gradientPaint);
        return gradientPaint;
    }

    public static Shape getWebBorderShape(JComponent jComponent, int n, int n2) {
        if (n2 > 0) {
            return new RoundRectangle2D.Double(n, n, jComponent.getWidth() - n * 2 - 1, jComponent.getHeight() - n * 2 - 1, n2 * 2, n2 * 2);
        }
        return new Rectangle2D.Double(n, n, jComponent.getWidth() - n * 2 - 1, jComponent.getHeight() - n * 2 - 1);
    }

    public static void drawCustomWebBorder(Graphics2D graphics2D, JComponent jComponent, Shape shape, Color color, int n, boolean bl, boolean bl2) {
        LafUtils.drawCustomWebBorder(graphics2D, jComponent, shape, color, n, bl, bl2, Color.GRAY, Color.LIGHT_GRAY);
    }

    public static void drawCustomWebBorder(Graphics2D graphics2D, JComponent jComponent, Shape shape, Color color, int n, boolean bl, boolean bl2, Color color2, Color color3) {
        Object object = LafUtils.setupAntialias(graphics2D);
        if (jComponent.isEnabled()) {
            LafUtils.drawShade(graphics2D, shape, color, n);
        }
        if (bl) {
            if (bl2) {
                Rectangle rectangle = shape.getBounds();
                graphics2D.setPaint(new GradientPaint(0.0f, rectangle.y, StyleConstants.topBgColor, 0.0f, rectangle.y + rectangle.height, StyleConstants.bottomBgColor));
                graphics2D.fill(shape);
            } else {
                graphics2D.setPaint(jComponent.getBackground());
                graphics2D.fill(shape);
            }
        }
        if (color2 != null) {
            graphics2D.setPaint(jComponent.isEnabled() ? color2 : color3);
            graphics2D.draw(shape);
        }
        LafUtils.restoreAntialias(graphics2D, object);
    }

    public static boolean drawWebFocus(Graphics2D graphics2D, JComponent jComponent, FocusType focusType, int n, int n2) {
        return LafUtils.drawWebFocus(graphics2D, jComponent, focusType, n, n2, null);
    }

    public static boolean drawWebFocus(Graphics2D graphics2D, JComponent jComponent, FocusType focusType, int n, int n2, Boolean bl) {
        return LafUtils.drawWebFocus(graphics2D, jComponent, focusType, n, n2, bl, null);
    }

    public static boolean drawWebFocus(Graphics2D graphics2D, JComponent jComponent, FocusType focusType, int n, int n2, Boolean bl, Boolean bl2) {
        return LafUtils.drawWebFocus(graphics2D, jComponent, focusType, n, n2, bl, bl2, focusType.equals((Object)FocusType.componentFocus) ? StyleConstants.focusColor : StyleConstants.fieldFocusColor);
    }

    public static boolean drawWebFocus(Graphics2D graphics2D, JComponent jComponent, FocusType focusType, int n, int n2, Boolean bl, Boolean bl2, Color color) {
        return LafUtils.drawWebFocus(graphics2D, jComponent, focusType, n, n2, bl, bl2, color, focusType.equals((Object)FocusType.componentFocus) ? StyleConstants.focusStroke : StyleConstants.fieldFocusStroke);
    }

    public static boolean drawWebFocus(Graphics2D graphics2D, JComponent jComponent, FocusType focusType, int n, int n2, Boolean bl, Boolean bl2, Color color, Stroke stroke) {
        if ((bl2 = Boolean.valueOf(bl2 != null ? bl2 : jComponent.hasFocus() && jComponent.isEnabled())).booleanValue() && focusType.equals((Object)FocusType.componentFocus)) {
            Object object = LafUtils.setupAntialias(graphics2D);
            Stroke stroke2 = LafUtils.setupStroke(graphics2D, stroke);
            graphics2D.setPaint(color);
            graphics2D.draw(LafUtils.getWebFocusShape(jComponent, focusType, n, n2));
            LafUtils.restoreStroke(graphics2D, stroke2);
            LafUtils.restoreAntialias(graphics2D, object);
            return true;
        }
        if (focusType.equals((Object)FocusType.fieldFocus) && (bl2.booleanValue() || bl != null && bl.booleanValue())) {
            Object object = LafUtils.setupAntialias(graphics2D);
            Stroke stroke3 = LafUtils.setupStroke(graphics2D, stroke);
            graphics2D.setPaint(color);
            graphics2D.draw(LafUtils.getWebFocusShape(jComponent, focusType, n, n2));
            LafUtils.restoreStroke(graphics2D, stroke3);
            LafUtils.restoreAntialias(graphics2D, object);
            return true;
        }
        return false;
    }

    public static Shape getWebFocusShape(JComponent jComponent, FocusType focusType, int n, int n2) {
        int n3 = focusType.equals((Object)FocusType.componentFocus) ? 2 : 0;
        int n4 = n2 = focusType.equals((Object)FocusType.componentFocus) ? Math.max(0, n2 - 2) : n2;
        if (n2 > 0) {
            return new RoundRectangle2D.Double(n + n3, n + n3, jComponent.getWidth() - n * 2 - n3 * 2 - 1, jComponent.getHeight() - n * 2 - n3 * 2 - 1, n2 * 2, n2 * 2);
        }
        return new Rectangle2D.Double(n + n3, n + n3, jComponent.getWidth() - n * 2 - n3 * 2 - 1, jComponent.getHeight() - n * 2 - n3 * 2 - 1);
    }

    public static void drawCustomWebFocus(Graphics2D graphics2D, JComponent jComponent, FocusType focusType, Shape shape) {
        LafUtils.drawCustomWebFocus(graphics2D, jComponent, focusType, shape, null);
    }

    public static void drawCustomWebFocus(Graphics2D graphics2D, JComponent jComponent, FocusType focusType, Shape shape, Boolean bl) {
        LafUtils.drawCustomWebFocus(graphics2D, jComponent, focusType, shape, bl, null);
    }

    public static void drawCustomWebFocus(Graphics2D graphics2D, JComponent jComponent, FocusType focusType, Shape shape, Boolean bl, Boolean bl2) {
        if ((bl2 = Boolean.valueOf(bl2 != null ? bl2 : jComponent.hasFocus() && jComponent.isEnabled())).booleanValue() && focusType.equals((Object)FocusType.componentFocus)) {
            Object object = LafUtils.setupAntialias(graphics2D);
            Stroke stroke = LafUtils.setupStroke(graphics2D, StyleConstants.focusStroke);
            graphics2D.setPaint(StyleConstants.focusColor);
            graphics2D.draw(shape);
            LafUtils.restoreStroke(graphics2D, stroke);
            LafUtils.restoreAntialias(graphics2D, object);
        } else if (focusType.equals((Object)FocusType.fieldFocus) && (bl2.booleanValue() || bl != null && bl.booleanValue())) {
            Object object = LafUtils.setupAntialias(graphics2D);
            Stroke stroke = LafUtils.setupStroke(graphics2D, StyleConstants.fieldFocusStroke);
            graphics2D.setPaint(bl2 != false ? StyleConstants.fieldFocusColor : StyleConstants.transparentFieldFocusColor);
            graphics2D.draw(shape);
            LafUtils.restoreStroke(graphics2D, stroke);
            LafUtils.restoreAntialias(graphics2D, object);
        }
    }

    public static void drawShade(Graphics2D graphics2D, Shape shape, Color color, int n) {
        LafUtils.drawShade(graphics2D, shape, StyleConstants.shadeType, color, n);
    }

    public static void drawShade(Graphics2D graphics2D, Shape shape, ShadeType shadeType, Color color, int n) {
        LafUtils.drawShade(graphics2D, shape, shadeType, color, n, null, true);
    }

    public static void drawShade(Graphics2D graphics2D, Shape shape, Color color, int n, Shape shape2) {
        LafUtils.drawShade(graphics2D, shape, StyleConstants.shadeType, color, n, shape2, true);
    }

    public static void drawShade(Graphics2D graphics2D, Shape shape, ShadeType shadeType, Color color, int n, Shape shape2) {
        LafUtils.drawShade(graphics2D, shape, shadeType, color, n, shape2, true);
    }

    public static void drawShade(Graphics2D graphics2D, Shape shape, Color color, int n, boolean bl) {
        LafUtils.drawShade(graphics2D, shape, StyleConstants.shadeType, color, n, null, bl);
    }

    public static void drawShade(Graphics2D graphics2D, Shape shape, ShadeType shadeType, Color color, int n, boolean bl) {
        LafUtils.drawShade(graphics2D, shape, shadeType, color, n, null, bl);
    }

    public static void drawShade(Graphics2D graphics2D, Shape shape, Color color, int n, Shape shape2, boolean bl) {
        LafUtils.drawShade(graphics2D, shape, StyleConstants.shadeType, color, n, shape2, bl);
    }

    public static void drawShade(Graphics2D graphics2D, Shape shape, ShadeType shadeType, Color color, int n, Shape shape2, boolean bl) {
        if (n <= 1) {
            return;
        }
        Shape shape3 = shape2 != null ? LafUtils.intersectClip(graphics2D, shape2) : LafUtils.subtractClip(graphics2D, shape);
        Composite composite = graphics2D.getComposite();
        float f = 1.0f;
        if (composite instanceof AlphaComposite) {
            f = ((AlphaComposite)composite).getAlpha();
        }
        Stroke stroke = graphics2D.getStroke();
        if (color != null) {
            graphics2D.setPaint(color);
        }
        if (shadeType.equals((Object)ShadeType.simple)) {
            if (StyleConstants.simpleShadeTransparency < 1.0f) {
                graphics2D.setComposite(AlphaComposite.getInstance(3, StyleConstants.simpleShadeTransparency * f));
            }
            graphics2D.setStroke(LafUtils.getStroke(n * 2, bl ? 1 : 0));
            graphics2D.draw(shape);
        } else {
            for (int i = n *= 2; i >= 2; i -= 2) {
                float f2 = (float)(n - i) / (float)(n - 1);
                graphics2D.setComposite(AlphaComposite.getInstance(3, f2 * f));
                graphics2D.setStroke(LafUtils.getStroke(i, bl ? 1 : 0));
                graphics2D.draw(shape);
            }
        }
        LafUtils.restoreStroke(graphics2D, stroke);
        LafUtils.restoreComposite(graphics2D, composite);
        LafUtils.restoreClip(graphics2D, shape3);
    }

    public static Stroke getStroke(int n) {
        return LafUtils.getStroke(n, 1, 1);
    }

    public static Stroke getStroke(int n, int n2) {
        return LafUtils.getStroke(n, n2, 1);
    }

    public static Stroke getStroke(int n, int n2, int n3) {
        String string = n + "," + n2 + "," + n3;
        Stroke stroke = cachedStrokes.get(string);
        if (stroke == null) {
            stroke = new BasicStroke(n, n2, n3);
            cachedStrokes.put(string, stroke);
        }
        return stroke;
    }

    public static void drawWebSelection(Graphics2D graphics2D, Color color, int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
        LafUtils.drawWebSelection(graphics2D, color, new Rectangle(n, n2, n3, n4), bl, bl2, bl3);
    }

    public static void drawWebSelection(Graphics2D graphics2D, Color color, int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        LafUtils.drawWebSelection(graphics2D, color, new Rectangle(n, n2, n3, n4), bl, bl2, bl3, bl4);
    }

    public static void drawWebSelection(Graphics2D graphics2D, Color color, Rectangle rectangle, boolean bl, boolean bl2, boolean bl3) {
        LafUtils.drawWebSelection(graphics2D, color, rectangle, bl, bl2, bl3, true);
    }

    public static void drawWebSelection(Graphics2D graphics2D, Color color, Rectangle rectangle, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        rectangle = GeometryUtils.validateRect(rectangle);
        Object object = LafUtils.setupAntialias(graphics2D);
        Area area = new Area();
        if (bl2) {
            if (bl) {
                area.add(new Area(new Ellipse2D.Double(rectangle.x - halfButton, rectangle.y - halfButton, halfButton * 2, halfButton * 2)));
                area.add(new Area(new Ellipse2D.Double(rectangle.x + rectangle.width - halfButton, rectangle.y - halfButton, halfButton * 2, halfButton * 2)));
            }
            if (bl4) {
                area.add(new Area(new Ellipse2D.Double(rectangle.x + rectangle.width / 2 - halfButton, rectangle.y - halfButton, halfButton * 2, halfButton * 2)));
            }
        }
        if (bl && bl4) {
            area.add(new Area(new Ellipse2D.Double(rectangle.x - halfButton, rectangle.y + rectangle.height / 2 - halfButton, halfButton * 2, halfButton * 2)));
            area.add(new Area(new Ellipse2D.Double(rectangle.x + rectangle.width - halfButton, rectangle.y + rectangle.height / 2 - halfButton, halfButton * 2, halfButton * 2)));
        }
        if (bl2) {
            if (bl) {
                area.add(new Area(new Ellipse2D.Double(rectangle.x - halfButton, rectangle.y + rectangle.height - halfButton, halfButton * 2, halfButton * 2)));
                area.add(new Area(new Ellipse2D.Double(rectangle.x + rectangle.width - halfButton, rectangle.y + rectangle.height - halfButton, halfButton * 2, halfButton * 2)));
            }
            if (bl4) {
                area.add(new Area(new Ellipse2D.Double(rectangle.x + rectangle.width / 2 - halfButton, rectangle.y + rectangle.height - halfButton, halfButton * 2, halfButton * 2)));
            }
        }
        if (bl3) {
            Area area2 = new Area(new RoundRectangle2D.Double(rectangle.x - halfLine, rectangle.y - halfLine, rectangle.width + halfLine * 2, rectangle.height + halfLine * 2, 5.0, 5.0));
            area2.subtract(new Area(new RoundRectangle2D.Double(rectangle.x + halfLine, rectangle.y + halfLine, rectangle.width - halfLine * 2, rectangle.height - halfLine * 2, 3.0, 3.0)));
            area.add(area2);
        }
        LafUtils.drawShade(graphics2D, area, Color.GRAY, shadeWidth);
        graphics2D.setPaint(Color.GRAY);
        graphics2D.draw(area);
        graphics2D.setPaint(color);
        graphics2D.fill(area);
        LafUtils.restoreAntialias(graphics2D, object);
    }

    public static void drawWebSelector(Graphics2D graphics2D, Color color, Rectangle rectangle, int n) {
        rectangle = GeometryUtils.validateRect(rectangle);
        Object object = LafUtils.setupAntialias(graphics2D);
        Ellipse2D.Double double_ = n == 8 ? new Ellipse2D.Double(rectangle.x - halfSelector, rectangle.y - halfSelector, halfSelector * 2, halfSelector * 2) : (n == 1 ? new Ellipse2D.Double(rectangle.x + rectangle.width / 2 - halfSelector, rectangle.y - halfSelector, halfSelector * 2, halfSelector * 2) : (n == 2 ? new Ellipse2D.Double(rectangle.x + rectangle.width - halfSelector, rectangle.y - halfSelector, halfSelector * 2, halfSelector * 2) : (n == 7 ? new Ellipse2D.Double(rectangle.x - halfSelector, rectangle.y + rectangle.height / 2 - halfSelector, halfSelector * 2, halfSelector * 2) : (n == 3 ? new Ellipse2D.Double(rectangle.x + rectangle.width - halfSelector, rectangle.y + rectangle.height / 2 - halfSelector, halfSelector * 2, halfSelector * 2) : (n == 6 ? new Ellipse2D.Double(rectangle.x - halfSelector, rectangle.y + rectangle.height - halfSelector, halfSelector * 2, halfSelector * 2) : (n == 5 ? new Ellipse2D.Double(rectangle.x + rectangle.width / 2 - halfSelector, rectangle.y + rectangle.height - halfSelector, halfSelector * 2, halfSelector * 2) : (n == 4 ? new Ellipse2D.Double(rectangle.x + rectangle.width - halfSelector, rectangle.y + rectangle.height - halfSelector, halfSelector * 2, halfSelector * 2) : null)))))));
        graphics2D.setPaint(color);
        graphics2D.fill(double_);
        LafUtils.restoreAntialias(graphics2D, object);
    }

    public static void drawWebIconedSelection(Graphics2D graphics2D, Rectangle rectangle, boolean bl, boolean bl2, boolean bl3) {
        LafUtils.drawWebIconedSelection(graphics2D, rectangle, bl, bl2, bl3, 0);
    }

    public static void drawWebIconedSelection(Graphics2D graphics2D, Rectangle rectangle, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        LafUtils.drawWebIconedSelection(graphics2D, rectangle, bl, bl2, bl3, bl4, 0);
    }

    public static void drawWebIconedSelection(Graphics2D graphics2D, Rectangle rectangle, boolean bl, boolean bl2, boolean bl3, int n) {
        LafUtils.drawWebIconedSelection(graphics2D, rectangle, bl, bl2, bl3, true, n);
    }

    public static void drawWebIconedSelection(Graphics2D graphics2D, Rectangle rectangle, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n) {
        rectangle = GeometryUtils.validateRect(rectangle);
        Rectangle rectangle2 = LafUtils.calculateIconedRect(rectangle);
        if (bl3) {
            if (!bl && !bl2) {
                conn.paintIcon(graphics2D, rectangle2);
            } else if (bl && !bl2 && bl4) {
                lr_conn.paintIcon(graphics2D, rectangle2);
            } else if (!bl && bl2 && bl4) {
                ud_conn.paintIcon(graphics2D, rectangle2);
            } else if (bl && bl2) {
                if (bl4) {
                    full_conn.paintIcon(graphics2D, rectangle2);
                } else {
                    corners_conn.paintIcon(graphics2D, rectangle2);
                }
            }
        } else if (bl && !bl2 && bl4) {
            lr.paintIcon(graphics2D, rectangle2);
        } else if (!bl && bl2 && bl4) {
            ud.paintIcon(graphics2D, rectangle2);
        } else if (bl && bl2) {
            if (bl4) {
                full.paintIcon(graphics2D, rectangle2);
            } else {
                corners.paintIcon(graphics2D, rectangle2);
            }
        }
    }

    public static void drawWebIconedSelector(Graphics2D graphics2D, Rectangle rectangle, int n) {
        rectangle = GeometryUtils.validateRect(rectangle);
        Rectangle rectangle2 = LafUtils.calculateIconedRect(rectangle);
        LafUtils.getSelectorIcon(n).paintIcon(graphics2D, rectangle2);
    }

    private static Rectangle calculateIconedRect(Rectangle rectangle) {
        return new Rectangle(rectangle.x - halfButton - shadeWidth, rectangle.y - halfButton - shadeWidth, rectangle.width + halfButton * 2 + shadeWidth * 2, rectangle.height + halfButton * 2 + shadeWidth * 2);
    }

    private static NinePatchIcon getSelectorIcon(int n) {
        if (selectorCache.containsKey(n)) {
            return selectorCache.get(n);
        }
        NinePatchIcon ninePatchIcon = new NinePatchIcon(LafUtils.class.getResource("icons/selection/selector" + n + ".9.png"));
        selectorCache.put(n, ninePatchIcon);
        return ninePatchIcon;
    }

    public static void drawEtchedShape(Graphics2D graphics2D, BufferedImage bufferedImage, BufferedImage bufferedImage2, Shape shape, Shape shape2) {
        Object object = LafUtils.setupAntialias(graphics2D);
        Rectangle rectangle = shape.getBounds();
        graphics2D.setPaint(new TexturePaint(bufferedImage, new Rectangle(rectangle.getLocation(), new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight()))));
        graphics2D.fill(shape);
        Shape shape3 = graphics2D.getClip();
        Area area = new Area(shape3);
        area.intersect(new Area(shape2));
        graphics2D.setClip(area);
        graphics2D.setPaint(new TexturePaint(bufferedImage2, new Rectangle(rectangle.getLocation(), new Dimension(bufferedImage2.getWidth(), bufferedImage2.getHeight()))));
        graphics2D.fill(shape2);
        LafUtils.drawShade(graphics2D, shape2, Color.BLACK, 4);
        graphics2D.setClip(shape3);
        graphics2D.setPaint(Color.DARK_GRAY);
        graphics2D.draw(shape2);
        LafUtils.restoreAntialias(graphics2D, object);
    }

    public static void paintTextShadow(Graphics2D graphics2D, String string) {
        LafUtils.paintTextShadow(graphics2D, string, Color.LIGHT_GRAY);
    }

    public static void paintTextShadow(Graphics2D graphics2D, String string, Color color) {
        LafUtils.paintTextEffect(graphics2D, string, ColorUtils.removeAlpha(color), 2, -2.0, -1.0, true);
    }

    public static void paintTextGlow(Graphics2D graphics2D, String string, Color color) {
        LafUtils.paintTextEffect(graphics2D, string, ColorUtils.removeAlpha(color), 2, -2.0, -2.0, false);
    }

    public static void paintTextEffect(Graphics2D graphics2D, String string, Color color, int n, double d, double d2, boolean bl) {
        Composite composite = graphics2D.getComposite();
        Color color2 = graphics2D.getColor();
        float f = 0.4f;
        if (composite instanceof AlphaComposite && ((AlphaComposite)composite).getRule() == 3) {
            f = Math.min(((AlphaComposite)composite).getAlpha(), f);
        }
        graphics2D.setColor(color);
        graphics2D.translate(d, d2);
        int n2 = bl ? n - 1 : n;
        for (int i = -n; i <= n2; ++i) {
            for (int j = -n; j <= n2; ++j) {
                double d3 = i * i + j * j;
                float f2 = 0.8f;
                if (d3 > 0.0) {
                    f2 = (float)(1.0 / (d3 * (double)n * (double)0.8f));
                }
                if ((f2 *= f) > 1.0f) {
                    f2 = 1.0f;
                }
                graphics2D.setComposite(AlphaComposite.getInstance(3, f2));
                graphics2D.drawString(string, i + n, j + n);
            }
        }
        graphics2D.translate(-d, -d2);
        graphics2D.setComposite(composite);
        graphics2D.setColor(color2);
        graphics2D.drawString(string, 0, 0);
    }

    public static void drawDashedRect(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        LafUtils.drawDashedRect(graphics2D, n, n2, n3, n4, n5, n6, 0.0f);
    }

    public static void drawDashedRect(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5, int n6, float f) {
        if (n3 < n || n4 < n2) {
            return;
        }
        float[] fArray = new float[]{n5, n6};
        BasicStroke basicStroke = new BasicStroke(1.0f, 1, 1, 10.0f, fArray, f);
        Stroke stroke = LafUtils.setupStroke(graphics2D, basicStroke);
        graphics2D.drawRect(n, n2, n3 - n, n4 - n2);
        LafUtils.restoreStroke(graphics2D, stroke);
    }
}

