/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.utils.system.JavaVersion;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;

public class SystemUtils {
    public static final String WINDOWS = "win";
    public static final String MAC = "mac";
    public static final String UNIX = "unix";
    public static final String SOLARIS = "solaris";
    private static JavaVersion javaVersion;

    public static void copyToClipboard(String string) {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new StringSelection(string), null);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static String getJavaVersionString() {
        return System.getProperty("java.version");
    }

    public static JavaVersion getJavaVersion() {
        if (javaVersion == null) {
            javaVersion = new JavaVersion(SystemUtils.getJavaVersionString());
        }
        return javaVersion;
    }

    public static boolean isJavaVersion(double d, int n) {
        return SystemUtils.getJavaVersion().compareVersion(d, 0, n) >= 0;
    }

    public static boolean isJavaVersion(double d, int n, int n2) {
        return SystemUtils.getJavaVersion().compareVersion(d, n, n2) >= 0;
    }

    public static boolean isJava6orAbove() {
        return SystemUtils.getJavaVersion().compareVersion(1.6, 0, 0) >= 0;
    }

    public static boolean isJava7orAbove() {
        return SystemUtils.getJavaVersion().compareVersion(1.7, 0, 0) >= 0;
    }

    public static boolean isJava8orAbove() {
        return SystemUtils.getJavaVersion().compareVersion(1.8, 0, 0) >= 0;
    }

    public static String getJavaName() {
        return System.getProperty("java.vm.name");
    }

    public static String getJavaVendor() {
        return System.getProperty("java.vm.vendor");
    }

    public static String getShortOsName() {
        if (SystemUtils.isWindows()) {
            return WINDOWS;
        }
        if (SystemUtils.isMac()) {
            return MAC;
        }
        if (SystemUtils.isUnix()) {
            return UNIX;
        }
        if (SystemUtils.isSolaris()) {
            return SOLARIS;
        }
        return null;
    }

    public static ImageIcon getOsIcon() {
        return SystemUtils.getOsIcon(true);
    }

    public static ImageIcon getOsIcon(boolean bl) {
        return SystemUtils.getOsIcon(16, bl);
    }

    public static ImageIcon getOsIcon(int n) {
        return SystemUtils.getOsIcon(n, true);
    }

    public static ImageIcon getOsIcon(int n, boolean bl) {
        if (n != 16 && n != 32) {
            n = 16;
        }
        String string = SystemUtils.getShortOsName();
        String string2 = bl ? "_colored" : "";
        return string != null ? new ImageIcon(SystemUtils.class.getResource("icons/os/" + n + "/" + string + string2 + ".png")) : null;
    }

    public static boolean isWindows() {
        return SystemUtils.getOsName().toLowerCase().contains(WINDOWS);
    }

    public static boolean isMac() {
        String string = SystemUtils.getOsName().toLowerCase();
        return string.contains(MAC) || string.contains("darwin");
    }

    public static boolean isUnix() {
        String string = SystemUtils.getOsName().toLowerCase();
        return string.contains("nix") || string.contains("nux");
    }

    public static boolean isSolaris() {
        return SystemUtils.getOsName().toLowerCase().contains("sunos");
    }

    public static String getOsArch() {
        return ManagementFactory.getOperatingSystemMXBean().getArch();
    }

    public static String getOsName() {
        return ManagementFactory.getOperatingSystemMXBean().getName();
    }

    public static String getOsSite() {
        if (SystemUtils.isWindows()) {
            return "http://www.microsoft.com/";
        }
        if (SystemUtils.isMac()) {
            return "http://www.apple.com/";
        }
        if (SystemUtils.isUnix()) {
            return "http://www.unix.org/";
        }
        if (SystemUtils.isSolaris()) {
            return "http://www.oracle.com/";
        }
        return null;
    }

    public static String getOsVersion() {
        return ManagementFactory.getOperatingSystemMXBean().getVersion();
    }

    public static int getOsProcessors() {
        return ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors();
    }

    public static String getJreArch() {
        return SystemUtils.getJreArchName().contains("64") ? "64" : "32";
    }

    public static String getJreArchName() {
        return System.getProperty("sun.arch.data.model");
    }

    public static boolean isCapsLock() {
        return Toolkit.getDefaultToolkit().getLockingKeyState(20);
    }

    public static boolean isNumLock() {
        return Toolkit.getDefaultToolkit().getLockingKeyState(144);
    }

    public static boolean isScrollLock() {
        return Toolkit.getDefaultToolkit().getLockingKeyState(145);
    }

    public static GraphicsConfiguration getGraphicsConfiguration() {
        return SystemUtils.getGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    private static GraphicsEnvironment getGraphicsEnvironment() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment();
    }

    public static List<GraphicsDevice> getGraphicsDevices() {
        GraphicsEnvironment graphicsEnvironment = SystemUtils.getGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        ArrayList<GraphicsDevice> arrayList = new ArrayList<GraphicsDevice>();
        for (GraphicsDevice graphicsDevice2 : graphicsDeviceArray) {
            if (graphicsDevice2.getType() != 0) continue;
            if (graphicsDevice2 == graphicsDevice) {
                arrayList.add(0, graphicsDevice2);
                continue;
            }
            arrayList.add(graphicsDevice2);
        }
        return arrayList;
    }
}

