/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.utils.MathUtils;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;

public class TextUtils {
    private static final List<String> textSeparators = Arrays.asList(" ", ".", ",", ":", ";", "/", "\\", "\n", "\t", "|", "{", "}", "[", "]", "(", ")", "<", ">", "-", "+", "\"", "'", "*", "%", "$", "#", "@", "!", "~", "^", "&", "?");
    private static final int idPartLength = 5;
    private static final String defaultIdPrefix = "WebLaF";
    private static final String defaultIdSuffix = "ID";

    public static Integer findFirstNumber(String string) {
        int n = -1;
        StringBuilder stringBuilder = new StringBuilder("");
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isDigit(c)) {
                stringBuilder.append(c);
                continue;
            }
            if (stringBuilder.length() > 0) break;
        }
        return Integer.parseInt(stringBuilder.toString());
    }

    public static String getWord(String string, int n) {
        int n2;
        int n3 = n;
        for (n2 = n; n2 < string.length() - 1 && !textSeparators.contains(string.substring(n2, n2 + 1)); ++n2) {
        }
        while (n3 > 0 && !textSeparators.contains(string.substring(n3 - 1, n3))) {
            --n3;
        }
        return n3 == n2 ? null : string.substring(n3, n2);
    }

    public static String removeFirstLines(String string, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if ((n2 = string.indexOf("\n", n2)) != -1) {
                ++n2;
                continue;
            }
            return "";
        }
        return string.substring(n2);
    }

    public static List<String> split(String string, String string2) {
        return Arrays.asList(string.split(string2));
    }

    public static Point parsePoint(String string) {
        return TextUtils.parsePoint(string, ",");
    }

    public static Point parsePoint(String string, String string2) {
        String[] stringArray = string.split(string2);
        return stringArray.length == 2 ? new Point(Integer.parseInt(stringArray[0].trim()), Integer.parseInt(stringArray[1].trim())) : null;
    }

    public static String removeControlSymbols(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if (c < ' ') continue;
            cArray[n2] = c;
            ++n2;
        }
        return string;
    }

    public static String shortenText(String string, int n, boolean bl) {
        if (string.length() <= n) {
            return string;
        }
        return string.substring(0, n > 3 && bl ? n - 3 : n) + (bl ? "..." : "");
    }

    public static List<String> stringToList(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2, false);
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken().trim());
            }
        }
        return arrayList;
    }

    public static String listToString(List list, String string) {
        if (list.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            if (list != null) {
                int n = list.size() - 1;
                for (int i = 0; i <= n; ++i) {
                    stringBuilder.append(list.get(i).toString());
                    stringBuilder.append(i != n ? string : "");
                }
            }
            return stringBuilder.toString();
        }
        return null;
    }

    public static String generateId() {
        return TextUtils.generateId(null, null);
    }

    public static String generateId(String string) {
        return TextUtils.generateId(string, null);
    }

    public static String generateId(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string == null ? defaultIdPrefix : string);
        stringBuilder.append("-");
        stringBuilder.append(TextUtils.generateId(5));
        stringBuilder.append("-");
        stringBuilder.append(TextUtils.generateId(5));
        stringBuilder.append("-");
        stringBuilder.append(TextUtils.generateId(5));
        stringBuilder.append("-");
        stringBuilder.append(TextUtils.generateId(5));
        stringBuilder.append("-");
        stringBuilder.append(string2 == null ? defaultIdSuffix : string2);
        return stringBuilder.toString();
    }

    private static String generateId(int n) {
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            int n2 = 0;
            int n3 = 10;
            switch (MathUtils.random(3)) {
                case 0: {
                    n2 = 48;
                    n3 = 10;
                    break;
                }
                case 1: {
                    n2 = 97;
                    n3 = 26;
                    break;
                }
                case 2: {
                    n2 = 65;
                    n3 = 26;
                }
            }
            stringBuilder.append((char)(MathUtils.random(n3) + n2));
        }
        return stringBuilder.toString();
    }
}

