/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.collection;

import com.alee.utils.CollectionUtils;
import com.alee.utils.collection.ValuesTableConverter;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@XStreamAlias(value="ValuesTable")
@XStreamConverter(value=ValuesTableConverter.class)
public class ValuesTable<K, V>
implements Serializable {
    private List<K> keys;
    private List<V> values;

    public ValuesTable() {
        this(10);
    }

    public ValuesTable(int n) {
        this.keys = new ArrayList<K>(n);
        this.values = new ArrayList<V>(n);
    }

    public List<K> getKeys() {
        return CollectionUtils.copy(this.keys);
    }

    public List<V> getValues() {
        return CollectionUtils.copy(this.values);
    }

    public void addAll(Map<K, V> map) {
        this.putAll(map);
    }

    public void putAll(Map<K, V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void addAll(ValuesTable<K, V> valuesTable) {
        this.putAll(valuesTable);
    }

    public void putAll(ValuesTable<K, V> valuesTable) {
        for (int i = 0; i < valuesTable.size(); ++i) {
            this.put(valuesTable.getKey(i), valuesTable.getValue(i));
        }
    }

    public void add(K k, V v) {
        this.put(k, v);
    }

    public void put(K k, V v) {
        this.put(this.keys.size(), k, v);
    }

    public void add(int n, K k, V v) {
        this.put(n, k, v);
    }

    public void put(int n, K k, V v) {
        int n2 = -1;
        if (this.keys.contains(k)) {
            n2 = this.indexOfKey(k);
        }
        int n3 = -1;
        if (this.values.contains(v)) {
            n3 = this.indexOfValue(v);
        }
        if (n2 != -1 || n3 != -1) {
            if (n2 > n3) {
                if (n2 != -1) {
                    this.keys.remove(n2);
                    this.values.remove(n2);
                }
                if (n3 != -1) {
                    this.keys.remove(n3);
                    this.values.remove(n3);
                }
            } else {
                if (n3 != -1) {
                    this.keys.remove(n3);
                    this.values.remove(n3);
                }
                if (n2 != -1) {
                    this.keys.remove(n2);
                    this.values.remove(n2);
                }
            }
        }
        if (n2 != -1 && n2 < n && n3 != -1 && n3 < n) {
            n -= 2;
        } else if (n2 != -1 && n2 < n || n3 != -1 && n3 < n) {
            --n;
        }
        this.keys.add(n, k);
        this.values.add(n, v);
    }

    public void remove(K k) {
        this.removeByKey(k);
    }

    public void removeByKey(K k) {
        this.remove(this.indexOfKey(k));
    }

    public void removeByValue(V v) {
        this.remove(this.indexOfValue(v));
    }

    public void remove(int n) {
        if (n < 0 || n >= this.keys.size()) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(n));
        }
        this.keys.remove(n);
        this.values.remove(n);
    }

    public V get(int n) {
        return this.getValue((K)n);
    }

    public V getValue(int n) {
        return this.values.get(n);
    }

    public K getKey(int n) {
        return this.keys.get(n);
    }

    public V get(K k) {
        return this.getValue(k);
    }

    public V getValue(K k) {
        int n = this.indexOfKey(k);
        return n != -1 ? (V)this.values.get(n) : null;
    }

    public K getKey(V v) {
        int n = this.indexOfValue(v);
        return n != -1 ? (K)this.keys.get(n) : null;
    }

    public boolean contains(K k) {
        return this.keys.contains(k);
    }

    public boolean containsKey(K k) {
        return this.keys.contains(k);
    }

    public boolean containsValue(V v) {
        return this.values.contains(v);
    }

    public int indexOf(K k) {
        return this.indexOfKey(k);
    }

    public int indexOfKey(K k) {
        return this.keys.indexOf(k);
    }

    public int indexOfValue(V v) {
        return this.values.indexOf(v);
    }

    public int size() {
        return this.keys.size();
    }

    private String outOfBoundsMsg(int n) {
        return "Index: " + n + ", Size: " + this.size();
    }
}

