/*
 * Decompiled with CFR 0.152.
 */
package com.miui.home.launcher.upsidescene.data;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.FileUtils;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import com.android.internal.util.FastXmlSerializer;
import com.miui.home.launcher.upsidescene.data.FreeButtonInfo;
import com.miui.home.launcher.upsidescene.data.SceneData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import libcore.io.IoUtils;
import miui.os.Environment;
import miui.util.ErrorReportUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

public class DataSerializerV1 {
    private static final String LOG_TAG = "launcher.UpsideScene";
    private static final Boolean ENABLE_DEBUG = true;
    private static final String DATA_VERSION = "v5";
    private static final String BOOLEAN_TRUE_VAL = "true";
    private static final String BOOLEAN_FALSE_VAL = "false";
    private static final String BACKUP_SETTINGS_RELATIVE_PATH = "home/upside_scene/settings/";
    private static final String SETTINGS_TAG = "settings";
    private static final String CURRENT_ID_TAG = "current_id";
    private static final String SCENE_MTZ_GADGETS_TAG = "gadgets";
    private static final String GADGET_TAG = "gadget";
    private static final String GADGET_TITLE_ATTR = "title";
    private static final String GADGET_LOCATION_ATTR = "location";
    private static final String GADGET_SPANX_ATTR = "spanx";
    private static final String GADGET_SPANY_ATTR = "spanY";
    private static final String SCENE_FREE_BUTTONS_TAG = "free_buttons";
    private static final String FREE_BUTTON_TAG = "free_button";
    private static final String FREE_BUTTON_PREVIEW_IMAGE_ATTR = "preview_image";
    private static final String GADGET_DESCRIPTION_FILE_NAME = "description.xml";
    private static final String GADGET_DESCRIPTION_TITLE_TAG = "title";
    private static final String GADGET_PREVIEW_PNG_FILE_NAME = "preview/preview_cover_0.png";
    private static final String GADGET_PREVIEW_JPG_FILE_NAME = "preview/preview_cover_0.jpg";
    private static final String GADGET_PREVIEW_PNG_FILE_NAME_OLD_FORMAT = "preview/0.png";
    public static String DATA_LOCATION = "com.miui.home.upside";
    private static final String SCENE_DESCRIPTION_FILE = "scene.xml";
    private static final String SCENE_TAG = "scene";
    private static final String SCENE_SCREEN_TAG = "screen";
    private static final String SCENE_NAME_ATTR = "name";
    private static final String SCENE_VERSION_ATTR = "version";
    private static final String SCENE_WIDTH_ATTR = "width";
    private static final String SCENE_HEIGHT_ATTR = "height";
    private static final String SCENE_PERSIST_FILE_DIRECTORY = "upside_scene";
    private static final String SCENE_PERSIST_FILE_SETTINGS = "settings";
    private static final String SIZE_VAL_MATCH_PARENT = "match_parent";
    private static final String SCREEN_SPRITE_TAG = "sprite";
    private static final String SCREEN_TYPE_ATTR = "type";
    private static final String SCREEN_TYPE_DRIFT_VAL = "drift";
    private static final String SCREEN_TYPE_BACKGROUND_VAL = "background";
    private static final String SCREEN_TYPE_FOREGROUND_VAL = "foreground";
    private static final String SCREEN_TYPE_DOCK_VAL = "dock";
    private static final String SCREEN_HOME_ATTR = "home";
    private static final String SCREEN_INDEX_ATTR = "index";
    private static final String SCREEN_WIDTH_ATTR = "width";
    private static final String SCREEN_HEIGHT_ATTR = "height";
    private static final String SCREEN_INTERACTION_ATTR = "interaction";
    private static final String SPRITE_TYPE_ATTR = "type";
    private static final String SPRITE_TYPE_PICTURE_VAL = "picture";
    @Deprecated
    private static final String SPRITE_TYPE_SHORTCUT_VAL = "shortcut";
    private static final String SPRITE_TYPE_APPLICATION_VAL = "application";
    private static final String SPRITE_TYPE_FOLDER_VAL = "folder";
    private static final String SPRITE_TYPE_BUTTON_VAL = "button";
    private static final String SPRITE_TYPE_WIDGET_VAL = "widget";
    private static final String SPRITE_INDEX_ATTR = "index";
    private static final String SPRITE_LEFT_ATTR = "left";
    private static final String SPRITE_TOP_ATTR = "top";
    private static final String SPRITE_EDITNAME_ATTR = "_name";
    private static final String SPRITE_NORMAL_ATTR = "normal";
    private static final String SPRITE_PRESSED_ATTR = "pressed";
    private static final String SPRITE_SEND_BROADCAST_ATTR = "send_broadcast";
    private static final String SPRITE_FUNCTION_TYPE_ATTR = "function_type";
    private static final String SPRITE_COMPONENTS_ATTR = "components";
    private static final String SPRITE_FOLDER_TITLE_ATTR = "folder_title";
    private static final String RESOURCES_PACKAGE_ATTR = "resource_package";
    private static final String SPANX_ATTR = "spanx";
    private static final String SPANY_ATTR = "spany";
    private static final String ROTATION_ATTR = "rotation";
    private static final String SCALE_ATTR = "scale";
    private static final String SHOW_TITLE_ATTR = "show_title";
    private static final String SHOW_ICON_ATTR = "show_icon";
    private static final String TITLE_ATTR = "title";
    private static final String IS_FOLDER_ATTR = "is_folder";
    private static final String CURRENT_CONTENT_TYPE_ATTR = "content_type";
    private static final String ID_ATTR = "id";
    private static final String LOCATION_ATTR = "location";
    private static final String GADGET_TYPE_ATTR = "gadget_type";
    private boolean mSettingsAvailable = false;
    private Context mContext;

    public DataSerializerV1(Context context) {
        this.mContext = context.getApplicationContext();
    }

    public static boolean moveToNextStartTag(XmlPullParser parser) throws XmlPullParserException, IOException {
        return DataSerializerV1.moveToNextStartTagOrEnd(parser, null);
    }

    public static boolean moveToNextStartTagOrEnd(XmlPullParser parser, String endTag) throws XmlPullParserException, IOException {
        int eventType;
        while ((eventType = parser.next()) != 2 && eventType != 1) {
            if (endTag == null || eventType != 3 || !endTag.equals(parser.getName())) continue;
            return false;
        }
        return eventType != 1;
    }

    static int unpackComponentNames(List<ComponentName> array, String packedNames) {
        if (!TextUtils.isEmpty(packedNames)) {
            String[] names;
            String[] stringArray = names = packedNames.split(";");
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                array.add(ComponentName.unflattenFromString(name));
                ++n2;
            }
        }
        return array.size();
    }

    static String packComponentNames(List<ComponentName> components) {
        StringBuilder packedNames = new StringBuilder();
        for (ComponentName name : components) {
            packedNames.append(name.flattenToShortString()).append(';');
        }
        return packedNames.toString();
    }

    public static Bitmap decodeBitmapFromZip(HashMap<String, Bitmap> bitmapCache, float sceneScale, String entryName, ZipFile zip) throws IOException {
        return null;
    }

    private static Bitmap decodeBitmapFromZipInner(ZipEntry entry, ZipFile zip, BitmapFactory.Options opt) throws IOException {
        if (entry == null) {
            return null;
        }
        InputStream is = zip.getInputStream(entry);
        try {
            Bitmap bitmap = BitmapFactory.decodeStream(is, null, opt);
            return bitmap;
        }
        finally {
            is.close();
        }
    }

    static void LOG(String log) {
        if (ENABLE_DEBUG.booleanValue()) {
            Log.i(LOG_TAG, log);
        }
    }

    private int parseSizeValue(String value) {
        if (value.equals(SIZE_VAL_MATCH_PARENT)) {
            return -1;
        }
        return Integer.parseInt(value);
    }

    public boolean clearSettings(SceneData sceneData) {
        File file = new File(DataSerializerV1.getPersistSettingsPath(sceneData, this.mContext));
        if (file.exists()) {
            file.delete();
            return true;
        }
        return false;
    }

    private void backupSettings(SceneData sceneData) {
        try {
            File fileSrc = new File(DataSerializerV1.getPersistSettingsPath(sceneData, this.mContext));
            if (fileSrc.exists()) {
                File folderDst = new File(Environment.getMIUIStorageDirectory(), BACKUP_SETTINGS_RELATIVE_PATH);
                if (!folderDst.exists()) {
                    folderDst.mkdirs();
                }
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMdd-kkmmss");
                String fileName = dateFormat.format(new Date());
                File fileDst = new File(folderDst, "uss-" + fileName);
                FileUtils.copyFile(fileSrc, fileDst);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * Exception decompiling
     */
    private void loadMtzGadgetInfo(SceneData sceneData, String title, String location, int spanX, int spanY) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index 1 out of bounds for length 1
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalCondenser.collapseAssignmentsIntoConditional(ConditionalCondenser.java:121)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalCondenser.collapseAssignmentsIntoConditionals(ConditionalCondenser.java:228)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.collapseAssignmentsIntoConditionals(Op03Rewriters.java:44)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:576)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private XmlPullParser loadCurrentSceneDescription(SceneData sceneData, ZipFile data) {
        ZipEntry scene = data.getEntry(SCENE_DESCRIPTION_FILE);
        if (scene != null) {
            try {
                String tag;
                XmlPullParser parser = XmlPullParserFactory.newInstance().newPullParser();
                InputStream is = data.getInputStream(scene);
                parser.setInput(is, null);
                sceneData.mName = null;
                sceneData.mVersion = null;
                sceneData.mWidth = 0;
                sceneData.mHeight = 0;
                sceneData.mSceneScale = 0.0f;
                while (DataSerializerV1.moveToNextStartTag(parser) && (tag = parser.getName().trim()) != null) {
                    if (!SCENE_TAG.equals(tag)) continue;
                    int i = parser.getAttributeCount() - 1;
                    while (i >= 0) {
                        if (SCENE_NAME_ATTR.equals(parser.getAttributeName(i))) {
                            sceneData.mName = parser.getAttributeValue(i);
                        } else if (SCENE_VERSION_ATTR.equals(parser.getAttributeName(i))) {
                            sceneData.mVersion = parser.getAttributeValue(i);
                        } else if ("width".equals(parser.getAttributeName(i))) {
                            sceneData.mWidth = this.parseSizeValue(parser.getAttributeValue(i));
                        } else if ("height".equals(parser.getAttributeName(i))) {
                            sceneData.mHeight = this.parseSizeValue(parser.getAttributeValue(i));
                        }
                        --i;
                    }
                    sceneData.mRawWidth = sceneData.mWidth;
                    sceneData.mRawHeight = sceneData.mHeight;
                    if (sceneData.mName == null || sceneData.mVersion == null || sceneData.mWidth == 0 || sceneData.mHeight == 0) continue;
                    DisplayMetrics dm = this.mContext.getResources().getDisplayMetrics();
                    sceneData.mSceneScale = (float)dm.widthPixels / (float)sceneData.mWidth;
                    sceneData.mHeight = dm.heightPixels;
                    sceneData.mWidth = dm.widthPixels;
                    return parser;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public SceneData load() {
        ZipFile dataFile = null;
        try {
            File file = new File(DATA_LOCATION);
            dataFile = new ZipFile(file);
        }
        catch (ZipException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (dataFile == null) {
            DataSerializerV1.LOG("can not find data file.");
            return null;
        }
        SceneData sceneData = new SceneData();
        XmlPullParser parser = this.loadCurrentSceneDescription(sceneData, dataFile);
        if (parser == null) {
            DataSerializerV1.LOG("invalid data file.");
            return null;
        }
        String persistPath = DataSerializerV1.getPersistSettingsPath(sceneData, this.mContext);
        if (persistPath != null) {
            try {
                File persistFile = new File(persistPath);
                if (persistFile.length() == 0L) {
                    persistFile.delete();
                } else {
                    FileInputStream is = new FileInputStream(new File(persistPath));
                    parser.setInput((InputStream)is, null);
                    this.mSettingsAvailable = true;
                }
            }
            catch (FileNotFoundException persistFile) {
            }
            catch (XmlPullParserException persistFile) {
                // empty catch block
            }
        }
        try {
            sceneData.getBitmapCache().clear();
            sceneData.mDrift = null;
            sceneData.mDock = null;
            sceneData.mBackground = null;
            sceneData.mForeground = null;
            sceneData.mScreens = new LinkedList();
            boolean moveToNext = true;
            block16: while (!moveToNext || DataSerializerV1.moveToNextStartTag(parser)) {
                if (parser.getEventType() != 2) {
                    moveToNext = true;
                    continue;
                }
                String tag = parser.getName().trim();
                if (tag == null) break;
                if (SCENE_SCREEN_TAG.equals(tag)) {
                    SceneData.Screen screen = new SceneData.Screen(sceneData);
                    if (!this.loadScreen(sceneData, screen, parser, dataFile)) continue;
                    screen.calcSize(sceneData.mSceneScale);
                    if (ENABLE_DEBUG.booleanValue()) {
                        Log.i(LOG_TAG, "load successed " + screen.toString());
                    }
                    switch (screen.getType()) {
                        case 1: {
                            sceneData.mDrift = screen;
                            break;
                        }
                        case 2: {
                            sceneData.mBackground = screen;
                            break;
                        }
                        case 3: {
                            sceneData.mForeground = screen;
                            break;
                        }
                        case 4: {
                            sceneData.mDock = screen;
                        }
                    }
                    sceneData.mScreens.add(screen);
                    moveToNext = false;
                    continue;
                }
                if (SCENE_MTZ_GADGETS_TAG.equals(tag)) {
                    while (DataSerializerV1.moveToNextStartTag(parser)) {
                        tag = parser.getName().trim();
                        if (GADGET_TAG.equals(tag)) {
                            String title = null;
                            String location = null;
                            int spanX = -1;
                            int spanY = -1;
                            int i = parser.getAttributeCount() - 1;
                            while (i >= 0) {
                                String name = parser.getAttributeName(i);
                                if ("title".equals(name)) {
                                    title = parser.getAttributeValue(i);
                                } else if ("location".equals(name)) {
                                    location = parser.getAttributeValue(i);
                                } else if ("spanx".equals(name)) {
                                    spanX = Integer.parseInt(parser.getAttributeValue(i));
                                } else if (GADGET_SPANY_ATTR.equals(name)) {
                                    spanY = Integer.parseInt(parser.getAttributeValue(i));
                                }
                                --i;
                            }
                            this.loadMtzGadgetInfo(sceneData, title, location, spanX, spanY);
                            continue;
                        }
                        moveToNext = false;
                        continue block16;
                    }
                    continue;
                }
                if (!SCENE_FREE_BUTTONS_TAG.equals(tag)) continue;
                while (DataSerializerV1.moveToNextStartTagOrEnd(parser, SCENE_FREE_BUTTONS_TAG)) {
                    tag = parser.getName().trim();
                    FREE_BUTTON_TAG.equals(tag);
                }
                moveToNext = true;
            }
        }
        catch (Exception e) {
            if (this.isSettingsAvailable()) {
                this.backupSettings(sceneData);
                this.clearSettings(sceneData);
                throw new RuntimeException(e);
            }
            ErrorReportUtils.sendExceptionErrorReport(this.mContext, e);
            Log.e(LOG_TAG, "load scene data fail.", e);
        }
        try {
            dataFile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        dataFile = null;
        if (ENABLE_DEBUG.booleanValue()) {
            if (sceneData.mDrift != null) {
                Log.i(LOG_TAG, "load " + sceneData.mName + "_" + sceneData.mVersion + " succeeded.(width:" + sceneData.mWidth + ",height:" + sceneData.mHeight + ")");
            } else {
                Log.i(LOG_TAG, "load failed.");
            }
        }
        return sceneData;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private boolean loadScreen(SceneData sceneData, SceneData.Screen screen, XmlPullParser parser, ZipFile data) throws XmlPullParserException, IOException {
        i = parser.getAttributeCount() - 1;
        while (i >= 0) {
            name = parser.getAttributeName(i);
            if ("type".equals(name)) {
                type = parser.getAttributeValue(i);
                if (type.equals("drift")) {
                    screen.mType = 1;
                } else if (type.equals("background")) {
                    screen.mType = 2;
                } else if (type.equals("foreground")) {
                    screen.mType = 3;
                } else if (type.equals("dock")) {
                    screen.mType = 4;
                }
            } else if ("index".equals(name)) {
                screen.mIndex = Integer.parseInt(parser.getAttributeValue(i));
            }
            if ("home".equals(name)) {
                screen.mHome = Integer.parseInt(parser.getAttributeValue(i));
            } else if ("width".equals(name)) {
                screen.mWidth = this.parseSizeValue(parser.getAttributeValue(i));
            } else if ("height".equals(name)) {
                screen.mHeight = this.parseSizeValue(parser.getAttributeValue(i));
            } else if ("interaction".equals(name)) {
                screen.mInteraction = "true".equals(parser.getAttributeValue(i));
            }
            --i;
        }
        if (screen.checkValidate()) ** GOTO lbl83
        return false;
lbl-1000:
        // 1 sources

        {
            tag = parser.getName().trim();
            sprite /* !! */  = null;
            if (!"sprite".equals(tag)) break;
            type = parser.getAttributeValue(null, "type");
            if ("picture".equals(type)) {
                sprite /* !! */  = new SceneData.SpritePicture(sceneData);
            } else if ("shortcut".equals(type)) {
                v0 = sceneData;
                v0.getClass();
                sprite /* !! */  = new SceneData.SpriteCell(v0, 6);
            } else if ("picture".equals(type)) {
                sprite /* !! */  = new SceneData.SpritePicture(sceneData);
            } else if ("button".equals(type)) {
                sprite /* !! */  = new SceneData.SpriteButton(sceneData);
            } else if ("widget".equals(type)) {
                v1 = sceneData;
                v1.getClass();
                sprite /* !! */  = new SceneData.SpriteCell(v1, 4);
            } else if ("application".equals(type)) {
                v2 = sceneData;
                v2.getClass();
                sprite /* !! */  = new SceneData.SpriteCell(v2, 5);
            } else if ("folder".equals(type)) {
                v3 = sceneData;
                v3.getClass();
                sprite /* !! */  = new SceneData.SpriteCell(v3, 6);
            }
            if (sprite /* !! */  == null || !this.loadSprite(sceneData, sprite /* !! */ , parser, data)) continue;
            screen.mSprites.add(sprite /* !! */ );
lbl83:
            // 3 sources

            ** while (DataSerializerV1.moveToNextStartTag((XmlPullParser)parser))
        }
lbl84:
        // 2 sources

        screen.resortSprites();
        return true;
    }

    private String getScreenTypeDescription(int type) {
        switch (type) {
            case 1: {
                return SCREEN_TYPE_DRIFT_VAL;
            }
            case 2: {
                return SCREEN_TYPE_BACKGROUND_VAL;
            }
            case 3: {
                return SCREEN_TYPE_FOREGROUND_VAL;
            }
            case 4: {
                return SCREEN_TYPE_DOCK_VAL;
            }
        }
        return null;
    }

    public static boolean copyStreamToFileIfNotExist(InputStream is, String dstFileName) {
        byte[] buffer = new byte[1024];
        int size = 0;
        OutputStream os = null;
        try {
            try {
                File outFile = new File(dstFileName);
                if (!outFile.exists()) {
                    os = new FileOutputStream(outFile);
                    while ((size = is.read(buffer)) > 0) {
                        os.write(buffer, 0, size);
                    }
                }
            }
            catch (IOException e) {
                Log.w(LOG_TAG, "copyStreamToFile failed:" + dstFileName);
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return false;
            }
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    private static String fetchFileFromZipIfNotExist(ZipFile zip, String entryName, String targetDir) throws IOException {
        return null;
    }

    private boolean isSettingsAvailable() {
        return this.mSettingsAvailable;
    }

    public static String getPersistDirectory(SceneData sceneData, Context context) {
        return null;
    }

    private static String getPersistSettingsPath(SceneData sceneData, Context context) {
        String dir = DataSerializerV1.getPersistDirectory(sceneData, context);
        if (dir != null) {
            File file = new File(DataSerializerV1.getPersistDirectory(sceneData, context));
            if (!file.exists()) {
                file.mkdirs();
            }
            return String.valueOf(DataSerializerV1.getPersistDirectory(sceneData, context)) + "/" + "settings" + "_" + DATA_VERSION;
        }
        return null;
    }

    private boolean loadSprite(SceneData sceneData, SceneData.Sprite sprite, XmlPullParser parser, ZipFile data) throws XmlPullParserException, IOException {
        int i = parser.getAttributeCount() - 1;
        while (i >= 0) {
            String name = parser.getAttributeName(i);
            if ("index".equals(name)) {
                sprite.mIndex = Integer.parseInt(parser.getAttributeValue(i));
            } else if (SPRITE_LEFT_ATTR.equals(name)) {
                sprite.mLeft = Integer.parseInt(parser.getAttributeValue(i));
            }
            if (SPRITE_TOP_ATTR.equals(name)) {
                sprite.mTop = Integer.parseInt(parser.getAttributeValue(i));
            }
            if (SPRITE_EDITNAME_ATTR.equals(name)) {
                sprite.setEditName(parser.getAttributeValue(i));
            }
            --i;
        }
        switch (sprite.getType()) {
            case 1: {
                SceneData.SpritePicture spritePicture = (SceneData.SpritePicture)sprite;
                spritePicture.mPictureName = parser.nextText().trim();
                if (spritePicture.mPictureName != null) {
                    spritePicture.mPicture = DataSerializerV1.decodeBitmapFromZip(sceneData.getBitmapCache(), sceneData.mSceneScale, spritePicture.mPictureName, data);
                }
                return sprite.checkValidate();
            }
            case 2: {
                SceneData.SpriteButton spriteButton = (SceneData.SpriteButton)sprite;
                int i2 = parser.getAttributeCount() - 1;
                while (i2 >= 0) {
                    String name = parser.getAttributeName(i2);
                    if (SPRITE_NORMAL_ATTR.equals(name)) {
                        spriteButton.mNormalName = parser.getAttributeValue(i2);
                        spriteButton.mNormal = DataSerializerV1.decodeBitmapFromZip(sceneData.getBitmapCache(), sceneData.mSceneScale, spriteButton.mNormalName, data);
                    } else if (SPRITE_PRESSED_ATTR.equals(name)) {
                        spriteButton.mPressedName = parser.getAttributeValue(i2);
                        spriteButton.mPressed = DataSerializerV1.decodeBitmapFromZip(sceneData.getBitmapCache(), sceneData.mSceneScale, spriteButton.mPressedName, data);
                    } else if (SPRITE_SEND_BROADCAST_ATTR.equals(name)) {
                        spriteButton.mSendBroadcast = BOOLEAN_TRUE_VAL.equals(parser.getAttributeValue(i2));
                    } else if (RESOURCES_PACKAGE_ATTR.equals(name)) {
                        this.loadInnerResourcesPackage(sceneData, spriteButton, parser.getAttributeValue(i2), data);
                    } else if (SPRITE_FUNCTION_TYPE_ATTR.equals(name)) {
                        spriteButton.mFunctionType = Integer.parseInt(parser.getAttributeValue(i2));
                    } else if (SPRITE_COMPONENTS_ATTR.equals(name)) {
                        spriteButton.mComponents = new ArrayList<ComponentName>();
                        DataSerializerV1.unpackComponentNames(spriteButton.mComponents, parser.getAttributeValue(i2));
                    } else if (SPRITE_FOLDER_TITLE_ATTR.equals(name)) {
                        spriteButton.mFolderTitle = parser.getAttributeValue(i2);
                    }
                    --i2;
                }
                spriteButton.mIntent = null;
                String intent = parser.nextText().trim();
                if (intent != null) {
                    try {
                        spriteButton.mIntent = Intent.parseUri(intent, 0);
                    }
                    catch (URISyntaxException name) {
                        // empty catch block
                    }
                }
                return sprite.checkValidate();
            }
            case 3: {
                String name;
                SceneData.SpriteCell cell = (SceneData.SpriteCell)sprite;
                int i3 = parser.getAttributeCount() - 1;
                while (i3 >= 0) {
                    name = parser.getAttributeName(i3);
                    if ("spanx".equals(name)) {
                        cell.mSpanX = Integer.parseInt(parser.getAttributeValue(i3));
                    } else if (SPANY_ATTR.equals(name)) {
                        cell.mSpanY = Integer.parseInt(parser.getAttributeValue(i3));
                    } else if (ROTATION_ATTR.equals(name)) {
                        cell.mRotation = Float.parseFloat(parser.getAttributeValue(i3));
                    } else if (SCALE_ATTR.equals(name)) {
                        cell.mScale = Float.parseFloat(parser.getAttributeValue(i3));
                    } else if (SHOW_TITLE_ATTR.equals(name)) {
                        cell.mShowTitle = BOOLEAN_TRUE_VAL.equals(parser.getAttributeValue(i3));
                    } else if (SHOW_ICON_ATTR.equals(name)) {
                        cell.mShowIcon = BOOLEAN_TRUE_VAL.equals(parser.getAttributeValue(i3));
                    } else if (CURRENT_CONTENT_TYPE_ATTR.equals(name)) {
                        cell.mCurrentContentType = Integer.parseInt(parser.getAttributeValue(i3));
                    }
                    --i3;
                }
                if (cell.isAppOrFolder()) {
                    cell.mShortcuts = new SceneData.SpriteCell.Shortcuts(cell);
                    cell.mShortcuts.mFolderTitle = parser.getAttributeValue(null, "title");
                    String strIsFolder = parser.getAttributeValue(null, IS_FOLDER_ATTR);
                    DataSerializerV1.unpackComponentNames(cell.mShortcuts.mComponentNames, parser.nextText().trim());
                    cell.mShortcuts.mIsFolder = TextUtils.isEmpty(strIsFolder) ? cell.mShortcuts.mComponentNames.size() != 1 : Boolean.parseBoolean(strIsFolder);
                    if (cell.mShortcuts.checkValidate()) {
                        cell.mCurrentContentType = cell.mShortcuts.mIsFolder ? 6 : 5;
                        return true;
                    }
                } else if (cell.mCurrentContentType != 0) {
                    String widget;
                    cell.mWidget = new SceneData.SpriteCell.Widget(cell);
                    i3 = parser.getAttributeCount() - 1;
                    while (i3 >= 0) {
                        name = parser.getAttributeName(i3);
                        if (ID_ATTR.equals(name)) {
                            if (this.isSettingsAvailable()) {
                                cell.mWidget.mId = Integer.parseInt(parser.getAttributeValue(i3));
                            }
                        } else if ("location".equals(name)) {
                            cell.mWidget.mLocation = parser.getAttributeValue(i3);
                        } else if (GADGET_TYPE_ATTR.equals(name)) {
                            cell.mWidget.mGadgetType = Integer.parseInt(parser.getAttributeValue(i3));
                        }
                        --i3;
                    }
                    File wf = null;
                    if (cell.mWidget.mLocation != null) {
                        wf = new File(cell.mWidget.mLocation);
                        String string = cell.mWidget.mLocation = wf.exists() ? cell.mWidget.mLocation : null;
                    }
                    if ((widget = parser.nextText().trim()) != null) {
                        cell.mWidget.mDefaultLocation = widget;
                    } else {
                        DataSerializerV1.LOG("widget name can not be null.");
                    }
                    return cell.mWidget.checkValidate();
                }
                return true;
            }
        }
        return true;
    }

    private boolean loadInnerResourcesPackage(SceneData sceneData, SceneData.SpriteButton button, String packageName, ZipFile data) {
        ZipEntry entry;
        if (data != null && (entry = data.getEntry(packageName)) != null) {
            block4: {
                String absluteResPath = DataSerializerV1.fetchFileFromZipIfNotExist(data, packageName, DataSerializerV1.getPersistDirectory(sceneData, this.mContext));
                if (button.mResourcesPackageName == null) break block4;
                DataSerializerV1.LOG("recursive loading resources is prohibited!");
                return false;
            }
            try {
                button.mResourcesPackageName = packageName;
                button.mFreeButton = new FreeButtonInfo(null, packageName, sceneData.mSceneScale);
                sceneData.mFreeButtons.add(button.mFreeButton);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public void save(SceneData sceneData) {
        FileOutputStream os = null;
        try {
            try {
                os = new FileOutputStream(new File(DataSerializerV1.getPersistSettingsPath(sceneData, this.mContext)), false);
                FastXmlSerializer out = new FastXmlSerializer();
                out.setOutput(os, "utf-8");
                out.startDocument(null, true);
                out.startTag(null, "settings");
                out.attribute(null, SCENE_VERSION_ATTR, DATA_VERSION);
                out.attribute(null, CURRENT_ID_TAG, String.valueOf(sceneData.mCurrentItemId));
                for (SceneData.Screen screen : sceneData.mScreens) {
                    this.saveScreen(screen, out);
                }
                out.startTag(null, SCENE_MTZ_GADGETS_TAG);
                for (SceneData.MtzGadgetInfo info : sceneData.mMtzGadgets) {
                    out.startTag(null, GADGET_TAG);
                    out.attribute(null, "title", info.title);
                    out.attribute(null, "spanx", String.valueOf(info.spanX));
                    out.attribute(null, GADGET_SPANY_ATTR, String.valueOf(info.spanY));
                    out.attribute(null, "location", info.path);
                    out.endTag(null, GADGET_TAG);
                }
                out.endTag(null, SCENE_MTZ_GADGETS_TAG);
                out.startTag(null, SCENE_FREE_BUTTONS_TAG);
                for (FreeButtonInfo freeButton : sceneData.mFreeButtons) {
                    out.startTag(null, FREE_BUTTON_TAG);
                    out.attribute(null, SCENE_NAME_ATTR, freeButton.mName);
                    out.attribute(null, FREE_BUTTON_PREVIEW_IMAGE_ATTR, freeButton.getPreviewImageName());
                    out.attribute(null, RESOURCES_PACKAGE_ATTR, freeButton.mPackageName);
                    out.endTag(null, FREE_BUTTON_TAG);
                }
                out.endTag(null, SCENE_FREE_BUTTONS_TAG);
                out.endTag(null, "settings");
                out.endDocument();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            IoUtils.closeQuietly(os);
            throw throwable;
        }
        IoUtils.closeQuietly(os);
    }

    private void saveScreen(SceneData.Screen screen, XmlSerializer serializer) throws IOException {
        serializer.startTag(null, SCENE_SCREEN_TAG);
        serializer.attribute(null, "type", this.getScreenTypeDescription(screen.mType));
        serializer.attribute(null, "index", String.valueOf(screen.mIndex));
        serializer.attribute(null, SCREEN_HOME_ATTR, String.valueOf(screen.mHome));
        serializer.attribute(null, "width", String.valueOf(screen.mWidth));
        serializer.attribute(null, "height", String.valueOf(screen.mHeight));
        for (SceneData.Sprite sprite : screen.mSprites) {
            this.saveSprite(sprite, serializer);
        }
        serializer.endTag(null, SCENE_SCREEN_TAG);
    }

    private void saveSprite(SceneData.Sprite sprite, XmlSerializer serializer) throws IllegalArgumentException, IllegalStateException, IOException {
        serializer.startTag(null, SCREEN_SPRITE_TAG);
        serializer.attribute(null, "index", String.valueOf(sprite.getIndex()));
        serializer.attribute(null, SPRITE_LEFT_ATTR, String.valueOf(sprite.getLeft()));
        serializer.attribute(null, SPRITE_TOP_ATTR, String.valueOf(sprite.getTop()));
        switch (sprite.getType()) {
            case 1: {
                SceneData.SpritePicture spritePic = (SceneData.SpritePicture)sprite;
                serializer.attribute(null, "type", SPRITE_TYPE_PICTURE_VAL);
                serializer.text(spritePic.mPictureName);
                break;
            }
            case 2: {
                SceneData.SpriteButton spriteBtn = (SceneData.SpriteButton)sprite;
                serializer.attribute(null, "type", SPRITE_TYPE_BUTTON_VAL);
                if (spriteBtn.mNormalName != null) {
                    serializer.attribute(null, SPRITE_NORMAL_ATTR, spriteBtn.mNormalName);
                }
                if (spriteBtn.mPressedName != null) {
                    serializer.attribute(null, SPRITE_PRESSED_ATTR, spriteBtn.mPressedName);
                }
                if (spriteBtn.mResourcesPackageName != null) {
                    serializer.attribute(null, RESOURCES_PACKAGE_ATTR, spriteBtn.mResourcesPackageName);
                }
                if (spriteBtn.mFolderTitle != null) {
                    serializer.attribute(null, SPRITE_FOLDER_TITLE_ATTR, spriteBtn.mFolderTitle);
                }
                serializer.attribute(null, SPRITE_FUNCTION_TYPE_ATTR, Integer.toString(spriteBtn.mFunctionType));
                if (spriteBtn.mComponents != null) {
                    String packedComponents = DataSerializerV1.packComponentNames(spriteBtn.mComponents);
                    serializer.attribute(null, SPRITE_COMPONENTS_ATTR, packedComponents);
                }
                serializer.attribute(null, SPRITE_SEND_BROADCAST_ATTR, spriteBtn.mSendBroadcast ? BOOLEAN_TRUE_VAL : BOOLEAN_FALSE_VAL);
                if (spriteBtn.mIntent == null) break;
                serializer.text(spriteBtn.mIntent.toUri(0));
                break;
            }
            case 3: {
                SceneData.SpriteCell spriteCell = (SceneData.SpriteCell)sprite;
                serializer.attribute(null, CURRENT_CONTENT_TYPE_ATTR, String.valueOf(spriteCell.mCurrentContentType));
                serializer.attribute(null, "spanx", String.valueOf(spriteCell.mSpanX));
                serializer.attribute(null, SPANY_ATTR, String.valueOf(spriteCell.mSpanY));
                serializer.attribute(null, ROTATION_ATTR, String.valueOf(spriteCell.mRotation));
                serializer.attribute(null, SCALE_ATTR, String.valueOf(spriteCell.mScale));
                serializer.attribute(null, SHOW_TITLE_ATTR, spriteCell.mShowTitle ? BOOLEAN_TRUE_VAL : BOOLEAN_FALSE_VAL);
                serializer.attribute(null, SHOW_ICON_ATTR, spriteCell.mShowIcon ? BOOLEAN_TRUE_VAL : BOOLEAN_FALSE_VAL);
                if (spriteCell.isAppOrFolder()) {
                    serializer.attribute(null, "type", spriteCell.mShortcuts.isFolder() ? SPRITE_TYPE_FOLDER_VAL : SPRITE_TYPE_APPLICATION_VAL);
                    if (spriteCell.mShortcuts.mFolderTitle != null) {
                        serializer.attribute(null, "title", spriteCell.mShortcuts.mFolderTitle);
                    }
                    serializer.attribute(null, IS_FOLDER_ATTR, String.valueOf(spriteCell.mShortcuts.mIsFolder));
                    serializer.text(DataSerializerV1.packComponentNames(spriteCell.mShortcuts.mComponentNames));
                    break;
                }
                if (spriteCell.mCurrentContentType == 0) break;
                serializer.attribute(null, "type", SPRITE_TYPE_WIDGET_VAL);
                serializer.attribute(null, ID_ATTR, String.valueOf(spriteCell.mWidget.mId));
                if (spriteCell.mWidget.mLocation != null) {
                    serializer.attribute(null, "location", spriteCell.mWidget.mLocation);
                }
                serializer.attribute(null, GADGET_TYPE_ATTR, String.valueOf(spriteCell.mWidget.mGadgetType));
                if (spriteCell.mWidget.mDefaultLocation == null) break;
                serializer.text(spriteCell.mWidget.mDefaultLocation);
            }
        }
        serializer.endTag(null, SCREEN_SPRITE_TAG);
    }
}

