/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.module;

import com.miui.theme.tool.gui.MainFrame;
import com.miui.theme.tool.module.ColorRenderer;
import com.miui.theme.tool.module.EditModuleTableModel;
import com.miui.theme.tool.module.WikiImageManager;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.util.ThemeHelper;
import com.miui.theme.tool.util.Wiki;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultCellEditor;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class EditModuleTable
extends JTable {
    Timer mouseTimer;
    MouseListener mEditColorListener = new MouseAdapter(){

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getButton() != 1) {
                return;
            }
            final int row = EditModuleTable.this.getSelectedRow();
            final int column = EditModuleTable.this.getSelectedColumn();
            if (row < 0) {
                return;
            }
            if (e.getClickCount() == 1) {
                EditModuleTable.this.mouseTimer = new Timer(305, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        (this).EditModuleTable.this.mouseTimer.stop();
                        EditModuleTable.this.onOneClick(row, column);
                    }
                });
                EditModuleTable.this.mouseTimer.setRepeats(false);
                EditModuleTable.this.mouseTimer.start();
            } else if (e.getClickCount() == 2 && EditModuleTable.this.mouseTimer.isRunning()) {
                EditModuleTable.this.onDoubleClick(row, column);
                EditModuleTable.this.mouseTimer.stop();
            }
        }
    };
    public Thread mLoadNetCommentThread = null;

    public EditModuleTable(DefaultTableModel model) {
        super(model);
        this.bindMouseListener();
        this.bindKeyListener();
        this.bindSelectionListener();
    }

    public void adjustColumnsWidth() {
        this.getColumnModel().getColumn(0).setPreferredWidth(500);
        this.getColumnModel().getColumn(1).setPreferredWidth(50);
        this.getColumnModel().getColumn(2).setPreferredWidth(300);
        this.getColumnModel().getColumn(3).setPreferredWidth(150);
        this.getColumnModel().getColumn(4).setPreferredWidth(150);
        this.getColumnModel().getColumn(5).setPreferredWidth(100);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        if ((column == 4 || column == 3) && this.getModel().getValueAt(row, 1) != null && this.getModel().getValueAt(row, 1).equals("color")) {
            return new ColorRenderer(true);
        }
        if (column == 0) {
            return new EditModuleCommentCellRenderer();
        }
        return new EditModuleTableCellRenderer();
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        super.setValueAt(aValue, row, column);
        this.refreshUI();
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        if (column == 4 && this.getModel().getValueAt(row, 1) != null && this.getModel().getValueAt(row, 1).equals("bool")) {
            return new DefaultCellEditor(new JComboBox<String>(new String[]{"true", "false"}));
        }
        return super.getCellEditor(row, column);
    }

    private Vector<String> getImagePaths(String comment) {
        Vector<String> result = new Vector<String>();
        Pattern p = Pattern.compile("<img.*?src=\"(.*?)\".*?/>");
        Matcher m = p.matcher(comment);
        while (m.find()) {
            result.add(m.group(1));
        }
        return result;
    }

    public void resetSelected() {
        int[] rows = this.getSelectedRows();
        int i = 0;
        while (i < rows.length) {
            ((EditModuleTableModel)this.getModel()).resetRow(rows[i]);
            ++i;
        }
        this.refreshUI();
    }

    public void refreshUI() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditModuleTable.this.updateUI();
            }
        });
    }

    public void browseSelectedWiki() {
        int[] rows = this.getSelectedRows();
        int i = 0;
        while (i < rows.length) {
            URI uri = URI.create("http://wiki.dev.xiaomi.com/index.php?title=" + this.getWikiPath(rows[i]));
            try {
                Desktop.getDesktop().browse(uri);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    private String getPackageName() {
        return ((EditModuleTableModel)this.getModel()).mPackageName;
    }

    private void bindSelectionListener() {
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                final int[] rows = EditModuleTable.this.getSelectedRows();
                if (rows.length == 0) {
                    return;
                }
                new Thread(){

                    @Override
                    public void run() {
                        int i = 0;
                        while (i < rows.length) {
                            int index = rows[i];
                            EditModuleTable.this.loadNetComment(index);
                            ++i;
                        }
                    }
                }.start();
            }
        });
    }

    private void bindMouseListener() {
        this.addMouseListener(this.mEditColorListener);
    }

    private void setComment(int row, String comment) {
        if (comment != null && !comment.isEmpty()) {
            comment = "<html>" + comment + "</html>";
            this.setValueAt(comment, row, 0);
        }
    }

    private void loadNetComment(int index) {
        if (!ThemeHelper.isInnerUserMode()) {
            return;
        }
        String comment = null;
        String wikiPath = this.getWikiPath(index);
        Wiki wiki = new Wiki("wiki.dev.xiaomi.com", "");
        wiki.setUsingCompressedRequests(false);
        wiki.setThrottle(5000);
        try {
            comment = wiki.getRenderedText(wikiPath);
            if (comment.startsWith("<p><a href=\"/")) {
                return;
            }
            this.writeCommentCache(wikiPath, comment);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        if (comment.indexOf("<img") != -1) {
            Vector<String> paths = this.getImagePaths(comment);
            for (String imagePath : paths) {
                WikiImageManager.getInstance().addDownloadTask(imagePath);
            }
        }
        this.setComment(index, comment);
    }

    private String getWikiPath(int index) {
        if (this.getValueAt(index, 5).equals("android")) {
            return "theme_values/framework-res/" + this.getValueAt(index, 2);
        }
        if (this.getValueAt(index, 5).equals("miui")) {
            return "theme_values/framework-miui-res/" + this.getValueAt(index, 2);
        }
        String prefix = "";
        if (ResourceFactory.locale != null && !ResourceFactory.locale.toString().equals("zh_CN")) {
            prefix = "en/";
        }
        return "theme_values/" + prefix + this.getPackageName() + "/" + this.getValueAt(index, 2);
    }

    private void loadLocalComment(int index) {
        String path = this.getWikiPath(index);
        String comment = this.loadCommentCache(path);
        if (comment != null) {
            if (comment.isEmpty()) {
                String cachePath = ThemeHelper.getTmpFolder() + File.separator + path;
                new File(cachePath).delete();
            } else {
                this.setComment(index, comment);
            }
        }
    }

    private void writeCommentCache(String path, String comment) {
        String cachePath = ThemeHelper.getTmpFolder() + File.separator + path;
        File cacheFile = new File(cachePath);
        if (!cacheFile.getParentFile().exists()) {
            cacheFile.getParentFile().mkdirs();
        }
        ThemeHelper.writeToFile(cacheFile, comment);
    }

    private String loadCommentCache(String path) {
        path = ThemeHelper.assurePath(path);
        String cachePath = ThemeHelper.getTmpFolder() + File.separator + path;
        File cacheFile = new File(cachePath);
        if (cacheFile.exists()) {
            return ThemeHelper.readFromFile(cacheFile);
        }
        return null;
    }

    public void onOneClick(int row, int column) {
        if (column == 4) {
            this.onClickValue(row, column);
        }
    }

    private void onClickValue(int row, int column) {
        String type = (String)this.getValueAt(row, 1);
        String value = (String)this.getValueAt(row, 4);
        if (type != null && type.equals("color")) {
            String colorStr = "";
            if (value == null || value.equals("") || value.length() != "#ffffffff".length()) {
                colorStr = "0xffffff";
            } else if (value.startsWith("#") && value.length() == 9) {
                colorStr = "0x" + value.substring(3);
            } else if (value.startsWith("0x") && value.length() == 9) {
                colorStr = "0x" + value.substring(4);
            }
            Color color = JColorChooser.showDialog(MainFrame.getInstance(), "change color", Color.decode(colorStr));
            if (color != null) {
                StringBuffer sb = new StringBuffer();
                String A = Integer.toHexString(color.getAlpha());
                String R = Integer.toHexString(color.getRed());
                String G = Integer.toHexString(color.getGreen());
                String B = Integer.toHexString(color.getBlue());
                A = A.length() == 1 ? "0" + A : A;
                R = R.length() == 1 ? "0" + R : R;
                G = G.length() == 1 ? "0" + G : G;
                B = B.length() == 1 ? "0" + B : B;
                sb.append("#");
                sb.append(A);
                sb.append(R);
                sb.append(G);
                sb.append(B);
                this.setValueAt(sb.toString(), row, column);
            }
        }
    }

    public void onDoubleClick(int row, int column) {
        if (column == 0) {
            this.browseSelectedWiki();
        }
    }

    private void bindKeyListener() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                Transferable contents;
                Clipboard clipboard;
                if (e.getKeyCode() == 10) {
                    if (EditModuleTable.this.editCellAt(EditModuleTable.this.getSelectedRow(), 4)) {
                        EditModuleTable.this.getEditorComponent().requestFocus();
                    }
                    e.consume();
                }
                if (e.getKeyCode() == 67 && e.isControlDown()) {
                    clipboard = EditModuleTable.this.getToolkit().getSystemClipboard();
                    contents = new StringSelection(EditModuleTable.this.getValueAt(EditModuleTable.this.getSelectedRow(), 4).toString());
                    clipboard.setContents(contents, null);
                    e.consume();
                }
                if (e.getKeyCode() == 86 && e.isControlDown() && (contents = (clipboard = EditModuleTable.this.getToolkit().getSystemClipboard()).getContents(null)) != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    try {
                        String text = (String)contents.getTransferData(DataFlavor.stringFlavor);
                        int[] rows = EditModuleTable.this.getSelectedRows();
                        int i = 0;
                        while (i < rows.length) {
                            EditModuleTable.this.setValueAt(text, rows[i], 4);
                            ++i;
                        }
                    }
                    catch (UnsupportedFlavorException e1) {
                        e1.printStackTrace();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    e.consume();
                }
                if (e.isControlDown()) {
                    if (e.getKeyCode() == 65) {
                        return;
                    }
                    e.consume();
                }
            }
        });
    }

    public void fillComments() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < EditModuleTable.this.getRowCount()) {
                    EditModuleTable.this.loadLocalComment(i);
                    ++i;
                }
                if (!ThemeHelper.isInnerUserMode()) {
                    return;
                }
                EditModuleTable.this.mLoadNetCommentThread = new Thread(){

                    @Override
                    public void run() {
                        int i = 0;
                        while (i < EditModuleTable.this.getRowCount()) {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            EditModuleTable.this.loadNetComment(i);
                            ++i;
                        }
                    }
                };
                EditModuleTable.this.mLoadNetCommentThread.start();
            }
        });
    }

    class EditModuleCommentCellRenderer
    extends EditModuleTableCellRenderer {
        EditModuleCommentCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            String comment = EditModuleTable.this.getValueAt(row, 0).toString();
            this.setToolTipText(this.correctCommentImageUrl(comment));
            this.setValue(this.commentInTable(comment));
            return c;
        }

        private String correctCommentImageUrl(String comment) {
            if (comment.isEmpty()) {
                return comment;
            }
            if (comment.indexOf("<img") != -1) {
                Vector paths = EditModuleTable.this.getImagePaths(comment);
                for (String path : paths) {
                    String url = WikiImageManager.getInstance().getImageUrl(path);
                    if (url == null) {
                        comment = comment.replaceAll("<img.*?src=\"" + path + "\".*?/>", "<font color='blue'>" + ResourceFactory.getString("loading") + "</font>");
                        continue;
                    }
                    comment = comment.replaceAll("<a href.*?(<img.*?/>).*?/a>", "$1");
                    comment = comment.replace(path, url);
                }
            }
            return comment;
        }

        private String commentInTable(String comment) {
            if (comment.isEmpty()) {
                return comment;
            }
            if (comment.indexOf("<img") != -1) {
                comment = comment.replaceAll("<a href.*<img.*/a>", "<font color='blue'>" + ResourceFactory.getString("picture") + "</font>");
            }
            if (comment.indexOf("<br") != -1) {
                comment = comment.replaceAll("<br.*?/?>", "");
            }
            return comment;
        }
    }

    class EditModuleTableCellRenderer
    extends DefaultTableCellRenderer {
        EditModuleTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            if (!table.getValueAt(row, col).equals("")) {
                this.setToolTipText(table.getValueAt(row, col).toString());
            }
            Color backColor = table.getBackground();
            EditModuleTableModel ittm = (EditModuleTableModel)table.getModel();
            if (!ittm.isRowChanged(row)) {
                backColor = Color.GRAY;
            }
            if (isSelected) {
                backColor = table.getSelectionBackground();
            }
            c.setBackground(backColor);
            return c;
        }
    }
}

