/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.module;

import com.miui.theme.tool.os.OS;
import com.miui.theme.tool.util.DownloadProgressListener;
import com.miui.theme.tool.util.InternetDownloadTask;
import com.miui.theme.tool.util.ThemeHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashSet;

public class WikiImageManager {
    private HashSet<String> mDownlaodTask = new HashSet();
    private static volatile WikiImageManager single;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WikiImageManager getInstance() {
        if (single != null) return single;
        Class<WikiImageManager> clazz = WikiImageManager.class;
        synchronized (WikiImageManager.class) {
            if (single != null) return single;
            single = new WikiImageManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    public synchronized void addDownloadTask(String imagePath) {
        if (this.mDownlaodTask.contains(imagePath)) {
            return;
        }
        File imageFile = WikiImageManager.getImageFile(imagePath);
        try {
            InternetDownloadTask idt = new InternetDownloadTask(WikiImageManager.getImageWikiUrl(imagePath));
            if (!imageFile.exists() || imageFile.length() != (long)idt.getFileSize()) {
                this.mDownlaodTask.add(imagePath);
                imageFile.getParentFile().mkdirs();
                idt.setDestFileStream(new FileOutputStream(imageFile));
                idt.setDownloadProgressListener(new WikiDownloadListener(imagePath));
                idt.execute();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String getImageWikiUrl(String imagePath) {
        return "http://wiki.dev.xiaomi.com" + imagePath;
    }

    private static File getImageFile(String imagePath) {
        try {
            imagePath = new String(URLDecoder.decode(imagePath, ThemeHelper.CHARSET));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String path = ThemeHelper.getTmpFolder() + File.separator + "theme_values" + ThemeHelper.assurePath(imagePath);
        return new File(path);
    }

    public String getImageUrl(String imagePath) {
        File imageFile = WikiImageManager.getImageFile(imagePath);
        if (this.mDownlaodTask.contains(imagePath) || !imageFile.exists()) {
            return null;
        }
        if (OS.getOS() == 2) {
            return "file://" + imageFile.getAbsolutePath();
        }
        if (OS.getOS() == 1) {
            return "file:///" + imageFile.getAbsolutePath();
        }
        return "";
    }

    class WikiDownloadListener
    implements DownloadProgressListener {
        private String mPath;

        public WikiDownloadListener(String path) {
            this.mPath = path;
        }

        @Override
        public void progress(long current, long total) {
        }

        @Override
        public void cancelled() {
        }

        @Override
        public void done(Object o) {
            WikiImageManager.this.mDownlaodTask.remove(this.mPath);
        }
    }
}

