/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.resourceeditor;

import com.miui.theme.tool.resourceeditor.PointRectangle;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import javax.swing.JPanel;

public abstract class SelectableJPanel
extends JPanel {
    private static final long serialVersionUID = -7159915510292362753L;
    int x;
    int y;
    PointRectangle mSelection;
    PointRectangle mLastSelection;
    int mActiveHandle = -1;
    Rectangle[] mHandles = new Rectangle[9];
    private MouseAdapter ma = new MouseAdapter(){

        @Override
        public void mouseReleased(MouseEvent e) {
            if (SelectableJPanel.this.mActiveHandle >= 0) {
                SelectableJPanel.this.wipeSelection();
                SelectableJPanel.this.drawSelection(SelectableJPanel.this.mSelection);
                SelectableJPanel.this.confirmSelection(SelectableJPanel.this.mSelection);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            SelectableJPanel.this.x = e.getX();
            SelectableJPanel.this.y = e.getY();
            SelectableJPanel.this.mLastSelection = SelectableJPanel.this.mSelection;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int i = 0;
            while (i < SelectableJPanel.this.mHandles.length) {
                if (SelectableJPanel.this.mHandles[i] != null && SelectableJPanel.this.mHandles[i].contains(e.getX(), e.getY())) {
                    SelectableJPanel.this.mActiveHandle = i;
                    switch (i) {
                        case 0: 
                        case 4: {
                            SelectableJPanel.this.setCursor(Cursor.getPredefinedCursor(5));
                            break;
                        }
                        case 1: 
                        case 5: {
                            SelectableJPanel.this.setCursor(Cursor.getPredefinedCursor(9));
                            break;
                        }
                        case 2: 
                        case 6: {
                            SelectableJPanel.this.setCursor(Cursor.getPredefinedCursor(4));
                            break;
                        }
                        case 3: 
                        case 7: {
                            SelectableJPanel.this.setCursor(Cursor.getPredefinedCursor(11));
                            break;
                        }
                        case 8: {
                            SelectableJPanel.this.setCursor(Cursor.getPredefinedCursor(13));
                        }
                    }
                    return;
                }
                ++i;
            }
            SelectableJPanel.this.mActiveHandle = -1;
            SelectableJPanel.this.setCursor(Cursor.getPredefinedCursor(12));
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (SelectableJPanel.this.mActiveHandle >= 0) {
                if (SelectableJPanel.this.mSelection != null) {
                    SelectableJPanel.this.wipeSelection();
                }
                switch (SelectableJPanel.this.mActiveHandle) {
                    case 0: {
                        SelectableJPanel.this.mSelection = new PointRectangle(e.getX(), e.getY(), SelectableJPanel.this.mSelection.x2, SelectableJPanel.this.mSelection.y2);
                        break;
                    }
                    case 1: {
                        SelectableJPanel.this.mSelection = new PointRectangle(SelectableJPanel.this.mSelection.x1, e.getY(), SelectableJPanel.this.mSelection.x2, SelectableJPanel.this.mSelection.y2);
                        break;
                    }
                    case 2: {
                        SelectableJPanel.this.mSelection = new PointRectangle(SelectableJPanel.this.mSelection.x1, e.getY(), e.getX(), SelectableJPanel.this.mSelection.y2);
                        break;
                    }
                    case 3: {
                        SelectableJPanel.this.mSelection = new PointRectangle(SelectableJPanel.this.mSelection.x1, SelectableJPanel.this.mSelection.y1, e.getX(), SelectableJPanel.this.mSelection.y2);
                        break;
                    }
                    case 4: {
                        SelectableJPanel.this.mSelection = new PointRectangle(SelectableJPanel.this.mSelection.x1, SelectableJPanel.this.mSelection.y1, e.getX(), e.getY());
                        break;
                    }
                    case 5: {
                        SelectableJPanel.this.mSelection = new PointRectangle(SelectableJPanel.this.mSelection.x1, SelectableJPanel.this.mSelection.y1, SelectableJPanel.this.mSelection.x2, e.getY());
                        break;
                    }
                    case 6: {
                        SelectableJPanel.this.mSelection = new PointRectangle(e.getX(), SelectableJPanel.this.mSelection.y1, SelectableJPanel.this.mSelection.x2, e.getY());
                        break;
                    }
                    case 7: {
                        SelectableJPanel.this.mSelection = new PointRectangle(e.getX(), SelectableJPanel.this.mSelection.y1, SelectableJPanel.this.mSelection.x2, SelectableJPanel.this.mSelection.y2);
                        break;
                    }
                    case 8: {
                        int xMove = e.getX() - SelectableJPanel.this.x;
                        int yMove = e.getY() - SelectableJPanel.this.y;
                        SelectableJPanel.this.mSelection = new PointRectangle(SelectableJPanel.this.mLastSelection.x1 + xMove, SelectableJPanel.this.mLastSelection.y1 + yMove, SelectableJPanel.this.mLastSelection.x2 + xMove, SelectableJPanel.this.mLastSelection.y2 + yMove);
                    }
                }
            } else {
                return;
            }
            SelectableJPanel.this.drawSelection(SelectableJPanel.this.mSelection);
        }
    };
    protected Color selection_color = Color.RED;

    protected void bindSelection() {
        this.addMouseListener(this.ma);
        this.addMouseMotionListener(this.ma);
    }

    protected void unbindSelection() {
        this.removeMouseListener(this.ma);
        this.removeMouseMotionListener(this.ma);
        this.wipeSelection();
    }

    public void clearSelection() {
        this.mSelection = null;
        this.mActiveHandle = -1;
        int i = 0;
        while (i < this.mHandles.length) {
            this.mHandles[i] = null;
            ++i;
        }
    }

    protected void wipeSelection() {
        Graphics2D graphics = (Graphics2D)this.getGraphics().create();
        Area area = new Area(new Rectangle(this.mSelection.x, this.mSelection.y, this.mSelection.width + 1, this.mSelection.height + 1));
        area.subtract(new Area(new Rectangle(this.mSelection.x + 1, this.mSelection.y + 1, this.mSelection.width - 1, this.mSelection.height - 1)));
        area.add(new Area(new Rectangle(this.mSelection.x - 2, this.mSelection.y - 2, 5, 5)));
        area.add(new Area(new Rectangle(this.mSelection.x + this.mSelection.width / 2 - 2, this.mSelection.y - 2, 5, 5)));
        area.add(new Area(new Rectangle(this.mSelection.x + this.mSelection.width - 2, this.mSelection.y - 2, 5, 5)));
        area.add(new Area(new Rectangle(this.mSelection.x + this.mSelection.width - 2, this.mSelection.y + this.mSelection.height / 2 - 2, 5, 5)));
        area.add(new Area(new Rectangle(this.mSelection.x + this.mSelection.width - 2, this.mSelection.y + this.mSelection.height - 2, 5, 5)));
        area.add(new Area(new Rectangle(this.mSelection.x + this.mSelection.width / 2 - 2, this.mSelection.y + this.mSelection.height - 2, 5, 5)));
        area.add(new Area(new Rectangle(this.mSelection.x - 2, this.mSelection.y + this.mSelection.height - 2, 5, 5)));
        area.add(new Area(new Rectangle(this.mSelection.x - 2, this.mSelection.y + this.mSelection.height / 2 - 2, 5, 5)));
        graphics.setClip(area);
        this.paintSelectImage(graphics);
    }

    public abstract void paintSelectImage(Graphics var1);

    protected void drawSelection(PointRectangle selection) {
        Graphics2D graphics = (Graphics2D)this.getGraphics().create();
        graphics.setPaint(this.selection_color);
        graphics.setStroke(new BasicStroke(1.0f, 0, 1, 1.0f, new float[]{5.0f}, 0.0f));
        graphics.draw(selection);
    }

    protected void confirmSelection(Rectangle selection) {
        this.mSelection = new PointRectangle(selection);
        Graphics2D graphics = (Graphics2D)this.getGraphics();
        if (selection.isEmpty()) {
            this.clearSelection();
            return;
        }
        graphics.setStroke(new BasicStroke(1.0f));
        graphics.setPaint(Color.BLUE);
        graphics.draw(selection);
        graphics.setPaint(Color.WHITE);
        graphics.setStroke(new BasicStroke(1.0f, 0, 1, 1.0f, new float[]{5.0f}, 0.0f));
        graphics.draw(selection);
        this.mHandles[0] = new Rectangle(selection.x - 2, selection.y - 2, 4, 4);
        this.mHandles[1] = new Rectangle(selection.x + selection.width / 2 - 2, selection.y - 2, 4, 4);
        this.mHandles[2] = new Rectangle(selection.x + selection.width - 2, selection.y - 2, 4, 4);
        this.mHandles[3] = new Rectangle(selection.x + selection.width - 2, selection.y + selection.height / 2 - 2, 4, 4);
        this.mHandles[4] = new Rectangle(selection.x + selection.width - 2, selection.y + selection.height - 2, 4, 4);
        this.mHandles[5] = new Rectangle(selection.x + selection.width / 2 - 2, selection.y + selection.height - 2, 4, 4);
        this.mHandles[6] = new Rectangle(selection.x - 2, selection.y + selection.height - 2, 4, 4);
        this.mHandles[7] = new Rectangle(selection.x - 2, selection.y + selection.height / 2 - 2, 4, 4);
        this.mHandles[8] = new Rectangle(selection.x, selection.y, selection.width, selection.height);
        graphics.setComposite(AlphaComposite.getInstance(3, 1.0f));
        graphics.setPaint(Color.WHITE);
        int i = 0;
        while (i < this.mHandles.length - 1) {
            graphics.fill(this.mHandles[i]);
            ++i;
        }
        graphics.setPaint(Color.BLACK);
        graphics.setStroke(new BasicStroke(1.0f));
        i = 0;
        while (i < this.mHandles.length - 1) {
            graphics.draw(this.mHandles[i]);
            ++i;
        }
    }

    public Rectangle getSelection() {
        return this.mSelection;
    }
}

