/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.upsidescene;

import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.schema.Attribute;
import com.miui.theme.tool.upsidescene.Manager;
import com.miui.theme.tool.xmlparser.Attributes;
import java.util.ArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

class AttributesModel
extends AbstractTableModel
implements TableModelListener {
    Attributes attributes = new Attributes();
    ArrayList<Attribute> attrSchema;
    ArrayList<String> mDescriptions;
    String[] mColName = new String[]{ResourceFactory.getString("properties"), ResourceFactory.getString("values"), ResourceFactory.getString("description")};
    Manager mManager;

    public Attribute getAttributes(int i) {
        return this.attrSchema.get(i);
    }

    public void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    public AttributesModel(ArrayList<Attribute> attrSchema, Attributes attrs, Manager mManager, ArrayList<String> descriptions) {
        this.attrSchema = attrSchema;
        if (attrSchema == null) {
            return;
        }
        for (Attribute attr : attrSchema) {
            this.attributes.addAttribute(attr.getName(), null);
            if (attrs.getValue(attr.getName()) != null) {
                this.attributes.setValue(attr.getName(), attrs.getValue(attr.getName()));
                continue;
            }
            this.attributes.setValue(attr.getName(), "");
        }
        this.addTableModelListener(this);
        this.mManager = mManager;
        this.mDescriptions = descriptions;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.attributes.getLength();
    }

    @Override
    public String getColumnName(int col) {
        return this.mColName[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (col == 0) {
            return this.attributes.getName(row);
        }
        if (col == 1) {
            return this.attributes.getValue(row);
        }
        return ResourceFactory.getString(this.mDescriptions.get(row));
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (column == 1) {
            if (this.attrSchema.get(row).getRely_on_type() != null) {
                String[] rely = this.attrSchema.get(row).getRely_on_type();
                int i = 0;
                while (i < rely.length) {
                    if (rely[i].equals(this.attributes.getValue("type"))) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col != 1 || row > this.getRowCount()) {
            return;
        }
        this.attributes.setValue(row, (String)value);
        this.fireTableCellUpdated(row, col);
    }

    @Override
    public void tableChanged(TableModelEvent arg0) {
        this.mManager.mSendNotify(this.attributes);
    }
}

