/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.upsidescene;

import com.miui.theme.tool.errorManager.Error;
import com.miui.theme.tool.errorManager.ErrorManager;
import com.miui.theme.tool.schema.Schema;
import com.miui.theme.tool.tagTreeBuilder.BaseElement;
import com.miui.theme.tool.util.ThemeHelper;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class TreeHelper {
    private MutableTreeNode mRootTreeNode = null;
    private MutableTreeNode mCurrentTreeNode = null;
    Schema mSchema = null;

    public TreeHelper(BaseElement ele) {
        this.load(ele);
    }

    public TreeHelper(BaseElement ele, Schema mSchema) {
        this.mSchema = mSchema;
        this.load(ele);
    }

    private void load(BaseElement ele) {
        MutableTreeNode temp = null;
        if (ele == null) {
            return;
        }
        if (this.mRootTreeNode == null) {
            this.mCurrentTreeNode = this.mRootTreeNode = this.defaultMutableTreeNodeFactory(ele);
        } else {
            MutableTreeNode node = this.defaultMutableTreeNodeFactory(ele);
            this.mCurrentTreeNode.add(node);
            temp = this.mCurrentTreeNode;
            this.mCurrentTreeNode = node;
        }
        if (ele.getChildTags().size() != 0) {
            for (BaseElement childs : ele.getChildTags()) {
                this.load(childs);
            }
        }
        this.mCurrentTreeNode = temp;
    }

    private MutableTreeNode defaultMutableTreeNodeFactory(BaseElement ele) {
        String name;
        if (!this.mSchema.inSchema(ele.getTAG_NAME())) {
            ErrorManager.getInstance().addError(Error.ErrorKind.SYTAX_ERROR, ele.getStartRow());
            ele.setWrong(true);
        }
        if (ThemeHelper.isNullOrEmpty(name = ele.getAttributes().getValue("_name"))) {
            name = ele.getAttributes().getValue("_content");
        }
        if (ThemeHelper.isNullOrEmpty(name)) {
            name = ele.getAttributes().getValue("type");
        }
        if (ThemeHelper.isNullOrEmpty(name)) {
            name = ele.getTAG_NAME();
        }
        MutableTreeNode node = new MutableTreeNode(name, ele.getStartPos(), ele.getEndPos(), ele.isWrong());
        if (ele.isWrong()) {
            node.setUserObject("(wrong) " + ele.getTAG_NAME());
        }
        return node;
    }

    public MutableTreeNode getRootTreeNode() {
        return this.mRootTreeNode;
    }

    public void setRootTreeNode(MutableTreeNode mRootTreeNode) {
        this.mRootTreeNode = mRootTreeNode;
    }

    public static class MutableTreeNode
    extends DefaultMutableTreeNode {
        private int startPos = 0;
        private int endPos = 0;
        private boolean isWrong = false;
        TreePath mPath;
        private Object MutableTreeNode;

        public MutableTreeNode() {
            this.mPath = new TreePath(this);
        }

        public MutableTreeNode(String name) {
            super(name);
            this.mPath = new TreePath(this);
        }

        public MutableTreeNode(String name, int startRow, int endRow, boolean isWrong) {
            super(name);
            this.setStartPos(startRow);
            this.setEndPos(endRow);
            this.setWrong(isWrong);
            this.mPath = new TreePath(this);
        }

        public int getStartPos() {
            return this.startPos;
        }

        public void setStartPos(int startPos) {
            this.startPos = startPos;
        }

        public int getEndPos() {
            return this.endPos;
        }

        public void setEndPos(int endPos) {
            this.endPos = endPos;
        }

        public boolean isWrong() {
            return this.isWrong;
        }

        public void setWrong(boolean isWrong) {
            this.isWrong = isWrong;
        }

        public MutableTreeNode fetch(int pos) {
            MutableTreeNode ele = null;
            if (pos >= this.getStartPos() && pos <= this.getEndPos()) {
                int i = 0;
                while (i < this.getChildCount() && ele == null) {
                    ele = ((MutableTreeNode)this.getChildAt(i)).fetch(pos);
                    ++i;
                }
                if (ele == null) {
                    return this;
                }
                return ele;
            }
            return null;
        }

        public void resetTree() {
            this.getUserObject();
            this.setUserObject(this.resetString((String)this.getUserObject()));
            int count = this.getChildCount();
            if (count > 0) {
                int i = 0;
                while (i < count) {
                    MutableTreeNode node = (MutableTreeNode)this.getChildAt(i);
                    node.resetTree();
                    ++i;
                }
            }
        }

        private String resetString(String name) {
            if (name.startsWith(">")) {
                return name.substring(1);
            }
            return name;
        }
    }
}

