/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.upsidescene;

import com.miui.theme.tool.upsidescene.Manager;
import com.miui.theme.tool.upsidescene.TreeHelper;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeView
extends JScrollPane
implements Observer {
    private static DefaultMutableTreeNode mRoot = new DefaultMutableTreeNode("   ");
    private static JTree mTree = new JTree(mRoot);
    private DefaultTreeModel mModel;
    private Manager mManager;
    private TreePath lastTreePath = null;
    private int lastRow = -1;
    boolean shouldRefresh = true;

    public TreeView(Manager manager) {
        super(mTree);
        mTree.getSelectionModel().setSelectionMode(1);
        this.mManager = manager;
        mTree.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                JTree mTree = (JTree)arg0.getSource();
                TreePath path = mTree.getPathForLocation(arg0.getX(), arg0.getY());
                mTree.requestFocus();
                mTree.setSelectionPath(path);
                TreeView.this.onSelect(mTree);
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        });
        mTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent arg0) {
                JTree mTree = (JTree)arg0.getSource();
                TreeView.this.onSelect(mTree);
            }
        });
        this.mModel = (DefaultTreeModel)mTree.getModel();
    }

    private void onSelect(JTree mTree) {
        if (this.lastTreePath == null) {
            this.refreshSelection(mTree);
            this.lastTreePath = mTree.getSelectionPath();
            mTree.setSelectionPath(this.lastTreePath);
        } else if (this.shouldRefresh) {
            this.refreshSelection(mTree);
            this.lastTreePath = mTree.getSelectionPath();
            mTree.setSelectionPath(this.lastTreePath);
        } else {
            this.shouldRefresh = true;
        }
    }

    private void refreshSelection(JTree mTree) {
        TreeHelper.MutableTreeNode selNode = (TreeHelper.MutableTreeNode)mTree.getLastSelectedPathComponent();
        if (selNode != null) {
            this.mManager.mSendNotify(selNode);
        }
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        if (arg1 == null) {
            DefaultMutableTreeNode mRoot = ((Manager)arg0).getDefaultTreeNode();
            this.mModel.setRoot(mRoot);
            if (this.lastTreePath != null) {
                TreeHelper.MutableTreeNode lastNode = (TreeHelper.MutableTreeNode)this.lastTreePath.getLastPathComponent();
                this.shouldRefresh = false;
                this.selectNode(lastNode.getStartPos(), (String)lastNode.getUserObject());
            }
        } else if (arg1.getClass() != Integer.class) {
            arg1.getClass();
        }
        this.expansionAll();
    }

    public void selectNode(int pos, String name) {
        TreeHelper.MutableTreeNode node = ((TreeHelper.MutableTreeNode)mTree.getModel().getRoot()).fetch(pos);
        if (node == null) {
            return;
        }
        TreePath path = new TreePath(node.getPath());
        if (name != null && !name.equals(node.getUserObject().toString())) {
            return;
        }
        TreeView.getmTree().setSelectionPath(path);
    }

    public void expansionNode(int pos) {
        TreeHelper.MutableTreeNode node = ((TreeHelper.MutableTreeNode)mTree.getModel().getRoot()).fetch(pos);
        if (node == null) {
            return;
        }
        TreePath path = new TreePath(node.getPath());
        TreeView.getmTree().makeVisible(path);
    }

    public void expansionAll() {
        TreeNode root = (TreeNode)TreeView.getmTree().getModel().getRoot();
        if (root != null) {
            this.expansionAll(TreeView.getmTree(), new TreePath(root), true);
        }
    }

    private void expansionAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expansionAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    public static JTree getmTree() {
        return mTree;
    }

    public static void setmTree(JTree mTree) {
        TreeView.mTree = mTree;
    }
}

