/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.dock;

import com.alee.extended.dock.DockingPaneInfo;
import com.alee.extended.dock.DockingPaneLayout;
import com.alee.extended.dock.FrameType;
import com.alee.extended.dock.WebDockableFrame;
import com.alee.extended.window.TestFrame;
import com.alee.laf.StyleConstants;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.button.WebButtonStyle;
import com.alee.laf.button.WebToggleButton;
import com.alee.laf.label.WebLabel;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.tabbedpane.TabbedPaneStyle;
import com.alee.laf.tabbedpane.WebTabbedPane;
import com.alee.laf.text.WebTextArea;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class WebDockingPane
extends WebPanel {
    private static final Color buttonsPaneBackground = new Color(233, 236, 240);
    private static ImageIcon top = new ImageIcon(WebDockingPane.class.getResource("icons/dock_top_.png"));
    private static ImageIcon left = new ImageIcon(WebDockingPane.class.getResource("icons/dock_left_.png"));
    private static ImageIcon right = new ImageIcon(WebDockingPane.class.getResource("icons/dock_right_.png"));
    private static ImageIcon bottom = new ImageIcon(WebDockingPane.class.getResource("icons/dock_bottom_.png"));

    public WebDockingPane() {
        super(new DockingPaneLayout());
    }

    public DockingPaneLayout getActualLayout() {
        return (DockingPaneLayout)this.getLayout();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        int n;
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        DockingPaneLayout dockingPaneLayout = this.getActualLayout();
        DockingPaneInfo dockingPaneInfo = dockingPaneLayout.getDockingPaneInfo();
        int n2 = dockingPaneInfo.hasLeftButtons ? dockingPaneInfo.leftButtonsPaneBounds.x + dockingPaneInfo.leftButtonsPaneBounds.width : dockingPaneInfo.rect.x;
        int n3 = dockingPaneInfo.hasTopButtons ? dockingPaneInfo.topButtonsPaneBounds.y + dockingPaneInfo.topButtonsPaneBounds.height : dockingPaneInfo.rect.y;
        int n4 = dockingPaneInfo.hasRightButtons ? dockingPaneInfo.rightButtonsPaneBounds.x - 1 : dockingPaneInfo.rect.x + dockingPaneInfo.rect.width - 1;
        int n5 = n = dockingPaneInfo.hasBottomButtons ? dockingPaneInfo.bottomButtonsPaneBounds.y - 1 : dockingPaneInfo.rect.y + dockingPaneInfo.rect.height - 1;
        if (dockingPaneInfo.hasTopButtons) {
            graphics2D.setPaint(buttonsPaneBackground);
            graphics2D.fill(dockingPaneInfo.topButtonsPaneBounds);
            graphics2D.setPaint(StyleConstants.darkBorderColor);
            graphics2D.drawLine(n2, n3, n4, n3);
        }
        if (dockingPaneInfo.hasLeftButtons) {
            graphics2D.setPaint(buttonsPaneBackground);
            graphics2D.fill(dockingPaneInfo.leftButtonsPaneBounds);
            graphics2D.setPaint(StyleConstants.darkBorderColor);
            graphics2D.drawLine(n2, n3, n2, n);
        }
        if (dockingPaneInfo.hasRightButtons) {
            graphics2D.setPaint(buttonsPaneBackground);
            graphics2D.fill(dockingPaneInfo.rightButtonsPaneBounds);
            graphics2D.setPaint(StyleConstants.darkBorderColor);
            graphics2D.drawLine(n4, n3, n4, n);
        }
        if (dockingPaneInfo.hasBottomButtons) {
            graphics2D.setPaint(buttonsPaneBackground);
            graphics2D.fill(dockingPaneInfo.bottomButtonsPaneBounds);
            graphics2D.setPaint(StyleConstants.darkBorderColor);
            graphics2D.drawLine(n2, n, n4, n);
        }
    }

    public static void main(String[] stringArray) {
        WebButtonStyle.round = 0;
        WebButtonStyle.drawFocus = false;
        WebButtonStyle.rolloverDecoratedOnly = true;
        WebLookAndFeel.install();
        final WebDockingPane webDockingPane = new WebDockingPane();
        webDockingPane.add((Component)new WebToggleButton("Top frame", top){
            {
                this.setSelected(true);
            }
        }, (Object)"TOP_LEFT");
        webDockingPane.add((Component)new WebToggleButton("Test 2", top), (Object)"TOP_LEFT");
        webDockingPane.add((Component)new WebToggleButton("Test 3", top), (Object)"TOP_RIGHT");
        webDockingPane.add((Component)new WebToggleButton(left){
            {
                this.setSelected(true);
            }
        }, (Object)"LEFT_TOP");
        webDockingPane.add((Component)new WebToggleButton(left), (Object)"LEFT_BOTTOM");
        webDockingPane.add((Component)new WebToggleButton(left), (Object)"LEFT_BOTTOM");
        webDockingPane.add((Component)new WebToggleButton(right), (Object)"RIGHT_TOP");
        webDockingPane.add((Component)new WebToggleButton(right), (Object)"RIGHT_TOP");
        webDockingPane.add((Component)new WebToggleButton(right), (Object)"RIGHT_TOP");
        webDockingPane.add((Component)new WebToggleButton(right), (Object)"RIGHT_TOP");
        webDockingPane.add((Component)new WebToggleButton(right), (Object)"RIGHT_BOTTOM");
        webDockingPane.add((Component)new WebToggleButton(right), (Object)"RIGHT_BOTTOM");
        webDockingPane.add((Component)new WebToggleButton("Test 4", bottom), (Object)"BOTTOM_LEFT");
        webDockingPane.add((Component)new WebToggleButton("Test 5", bottom), (Object)"BOTTOM_RIGHT");
        webDockingPane.add((Component)new WebToggleButton("Test 6", bottom), (Object)"BOTTOM_RIGHT");
        webDockingPane.add(WebDockingPane.createTopFrame(), (Object)"TOP_FRAME");
        webDockingPane.add(WebDockingPane.createLeftFrame(), (Object)"LEFT_FRAME");
        webDockingPane.add(WebDockingPane.createContent(), (Object)"CONTENT");
        for (final Component component : webDockingPane.getComponents()) {
            if (!(component instanceof AbstractButton)) continue;
            component.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                        webDockingPane.remove(component);
                        webDockingPane.revalidate();
                        webDockingPane.repaint();
                    }
                }
            });
        }
        TestFrame testFrame = new TestFrame(webDockingPane);
        testFrame.center(600, 500);
    }

    private static Component createLeftFrame() {
        WebDockableFrame webDockableFrame = new WebDockableFrame(left, "Left frame");
        webDockableFrame.setFrameType(FrameType.left);
        webDockableFrame.add((Component)new WebTextArea("123"));
        return webDockableFrame;
    }

    private static Component createTopFrame() {
        WebDockableFrame webDockableFrame = new WebDockableFrame(top, "Top frame");
        webDockableFrame.setFrameType(FrameType.top);
        webDockableFrame.add((Component)new WebTextArea("123", 3, 0));
        return webDockableFrame;
    }

    private static Component createContent() {
        WebTabbedPane webTabbedPane = new WebTabbedPane(1);
        webTabbedPane.setTabbedPaneStyle(TabbedPaneStyle.attached);
        for (int i = 0; i < 20; ++i) {
            webTabbedPane.addTab("Tab " + i, new WebLabel());
        }
        return webTabbedPane;
    }
}

