/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.drag;

import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;

public class TextDragHandler
extends TransferHandler {
    private String text;
    private boolean defaultBehavior = true;

    public TextDragHandler(JComponent jComponent) {
        this(jComponent, null);
    }

    public TextDragHandler(JComponent jComponent, String string) {
        this(jComponent, string, true);
    }

    public TextDragHandler(final JComponent jComponent, String string, boolean bl) {
        this.setText(string);
        this.setDefaultBehavior(bl);
        jComponent.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (TextDragHandler.this.isDefaultBehavior() && SwingUtilities.isLeftMouseButton(mouseEvent) && jComponent.isEnabled()) {
                    TextDragHandler.this.exportAsDrag(jComponent, mouseEvent, TextDragHandler.this.getSourceActions(jComponent));
                }
            }
        });
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public boolean isDefaultBehavior() {
        return this.defaultBehavior;
    }

    public void setDefaultBehavior(boolean bl) {
        this.defaultBehavior = bl;
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        return 1;
    }

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        return new StringSelection(this.getText());
    }
}

