/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.image;

import com.alee.extended.drag.ImageDropHandler;
import com.alee.utils.ImageUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class WebImageDrop
extends JComponent {
    private int round;
    private int width;
    private int height;
    private BufferedImage actualImage;
    private BufferedImage image;

    public WebImageDrop() {
        this(64, 64);
    }

    public WebImageDrop(int n, int n2) {
        this(n, n2, null);
    }

    public WebImageDrop(int n, int n2, BufferedImage bufferedImage) {
        this.width = n;
        this.height = n2;
        this.round = Math.max(Math.max(n, n2) / 10, 3);
        this.actualImage = bufferedImage;
        this.image = bufferedImage;
        this.updatePreview();
        SwingUtils.setOrientation(this);
        this.setTransferHandler(new ImageDropHandler(){

            @Override
            protected boolean imagesImported(List<ImageIcon> list) {
                for (ImageIcon imageIcon : list) {
                    try {
                        WebImageDrop.this.setImage(ImageUtils.getBufferedImage(list.get(0)));
                        return true;
                    }
                    catch (Throwable throwable) {
                    }
                }
                return false;
            }
        });
    }

    public BufferedImage getImage() {
        return this.actualImage;
    }

    public BufferedImage getThumbnail() {
        return this.image;
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int n) {
        this.round = n;
        this.updatePreview();
    }

    public int getImageWidth() {
        return this.width;
    }

    public void setImageWidth(int n) {
        this.width = n;
        this.updatePreview();
    }

    public int getImageHeight() {
        return this.height;
    }

    public void setImageHeight(int n) {
        this.height = n;
        this.updatePreview();
    }

    public void setImage(BufferedImage bufferedImage) {
        this.actualImage = bufferedImage;
        this.image = bufferedImage;
        this.updatePreview();
        this.repaint();
    }

    private void updatePreview() {
        if (this.image != null) {
            this.image = ImageUtils.createPreviewImage(this.actualImage, this.width, this.height);
            BufferedImage bufferedImage = ImageUtils.createCompatibleImage(this.image, 3);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            LafUtils.setupAntialias(graphics2D);
            graphics2D.setPaint(Color.WHITE);
            graphics2D.fillRoundRect(0, 0, this.image.getWidth(), this.image.getHeight(), this.round * 2, this.round * 2);
            graphics2D.setComposite(AlphaComposite.getInstance(5));
            graphics2D.drawImage((Image)this.image, 0, 0, null);
            graphics2D.dispose();
            this.image.flush();
            this.image = bufferedImage;
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        LafUtils.setupAntialias(graphics2D);
        if (this.image != null) {
            graphics2D.drawImage((Image)this.image, this.getWidth() / 2 - this.image.getWidth() / 2 + 1, this.getHeight() / 2 - this.image.getHeight() / 2 + 1, null);
        }
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(this.getWidth() / 2 - this.width / 2 + 1, this.getHeight() / 2 - this.height / 2 + 1, this.width - (this.image == null ? 3 : 1), this.height - (this.image == null ? 3 : 1), this.round * 2, this.round * 2);
        if (this.image == null) {
            graphics2D.setPaint(new Color(242, 242, 242));
            graphics2D.fill(double_);
            graphics2D.setStroke(new BasicStroke(2.0f, 1, 1, 1.0f, new float[]{Math.max(5.0f, Math.min((float)(Math.max(this.width, this.height) / 6), 10.0f)), 8.0f}, 4.0f));
            graphics2D.setPaint(Color.LIGHT_GRAY);
            graphics2D.draw(double_);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.width + 2, this.height + 2);
    }
}

