/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingConstants;

public class GroupLayout
implements LayoutManager,
SwingConstants {
    public static final String PREFERRED = "PREFERRED";
    public static final String FILL = "FILL";
    private int orientation;
    private int gap;
    private Map<Component, String> constraints = new HashMap<Component, String>();

    public GroupLayout() {
        this(0);
    }

    public GroupLayout(int n) {
        this(n, 0);
    }

    public GroupLayout(int n, int n2) {
        this.setOrientation(n);
        this.setGap(n2);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        this.orientation = n;
    }

    public int getGap() {
        return this.gap;
    }

    public void setGap(int n) {
        this.gap = n;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        this.constraints.put(component, string);
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.constraints.remove(component);
    }

    @Override
    public void layoutContainer(Container container) {
        int n;
        int n2 = 0;
        int n3 = 0;
        for (Component component : container.getComponents()) {
            n = this.isFill(component);
            if (n != 0) {
                ++n2;
            }
            if (this.orientation == 0) {
                n3 += n != 0 ? 0 : component.getPreferredSize().width;
                continue;
            }
            n3 += n != 0 ? 0 : component.getPreferredSize().height;
        }
        if (container.getComponentCount() > 0) {
            n3 += this.gap * (container.getComponentCount() - 1);
        }
        boolean bl = container.getComponentOrientation().isLeftToRight();
        Insets insets = container.getInsets();
        Dimension dimension = container.getSize();
        int n4 = dimension.width - insets.left - insets.right;
        n = dimension.height - insets.top - insets.bottom;
        int n5 = this.orientation == 0 ? (n2 > 0 && n4 > n3 ? (n4 - n3) / n2 : 0) : (n2 > 0 && n > n3 ? (n - n3) / n2 : 0);
        int n6 = bl || this.orientation == 1 ? insets.left : dimension.width - insets.right;
        int n7 = insets.top;
        for (Component component : container.getComponents()) {
            int n8;
            Dimension dimension2 = component.getPreferredSize();
            boolean bl2 = this.isFill(component);
            if (this.orientation == 0) {
                n8 = bl2 ? n5 : dimension2.width;
                component.setBounds(n6 - (bl ? 0 : n8), n7, n8, n);
                n6 += (bl ? 1 : -1) * (n8 + this.gap);
                continue;
            }
            n8 = bl2 ? n5 : dimension2.height;
            component.setBounds(n6, n7, n4, n8);
            n7 += n8 + this.gap;
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        return this.calculateSize(container, false);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.calculateSize(container, true);
    }

    private Dimension calculateSize(Container container, boolean bl) {
        Insets insets = container.getInsets();
        Dimension dimension = new Dimension();
        for (Component component : container.getComponents()) {
            boolean bl2;
            Dimension dimension2 = bl ? component.getMinimumSize() : component.getPreferredSize();
            boolean bl3 = bl2 = bl && this.isFill(component);
            if (this.orientation == 0) {
                dimension.width = dimension.width + (bl2 ? 1 : dimension2.width);
                dimension.height = Math.max(dimension.height, dimension2.height);
                continue;
            }
            dimension.width = Math.max(dimension.width, dimension2.width);
            dimension.height = dimension.height + (bl2 ? 1 : dimension2.height);
        }
        if (container.getComponentCount() > 0) {
            if (this.orientation == 0) {
                dimension.width += this.gap * (container.getComponentCount() - 1);
            } else {
                dimension.height += this.gap * (container.getComponentCount() - 1);
            }
        }
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    private boolean isFill(Component component) {
        if (this.constraints.containsKey(component)) {
            String string = this.constraints.get(component);
            return string != null && string.equals(FILL);
        }
        return false;
    }
}

