/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.layout;

import com.alee.laf.StyleConstants;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.Timer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;

public class SlidingLayout
implements LayoutManager {
    private int slideY = 0;
    private Timer animator = null;
    private int height = 0;
    private int slideSpeed = 5;
    private JComponent container;

    public SlidingLayout(JComponent jComponent) {
        this.container = jComponent;
    }

    public void slideIn() {
        if (this.animator != null && this.animator.isRunning()) {
            this.animator.stop();
        }
        this.slideY = 0;
        this.animator = new Timer("SlidingLayout.slideInTimer", (long)StyleConstants.avgAnimationDelay, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SlidingLayout.this.slideY < SlidingLayout.this.height) {
                    SlidingLayout.this.slideY += SlidingLayout.this.slideSpeed;
                    SlidingLayout.this.container.revalidate();
                } else {
                    SlidingLayout.this.slideY = SlidingLayout.this.height;
                    SlidingLayout.this.animator.stop();
                }
            }
        });
        this.animator.start();
    }

    public int getSlideSpeed() {
        return this.slideSpeed;
    }

    public void setSlideSpeed(int n) {
        this.slideSpeed = n;
    }

    public void slideOut() {
        if (this.animator != null && this.animator.isRunning()) {
            this.animator.stop();
        }
        this.slideY = this.height;
        this.animator = new Timer("SlidingLayout.slideOutTimer", (long)StyleConstants.avgAnimationDelay, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SlidingLayout.this.slideY > 0) {
                    SlidingLayout.this.slideY -= SlidingLayout.this.slideSpeed;
                    SlidingLayout.this.container.revalidate();
                } else {
                    SlidingLayout.this.slideY = 0;
                    SlidingLayout.this.animator.stop();
                }
            }
        });
        this.animator.start();
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        for (Component component : container.getComponents()) {
            dimension = SwingUtils.max(dimension, component.getPreferredSize());
        }
        dimension.height = this.slideY < dimension.height ? this.slideY : dimension.height;
        return dimension;
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public void layoutContainer(Container container) {
        for (Component component : container.getComponents()) {
            Dimension dimension = component.getPreferredSize();
            component.setBounds(0, this.slideY < dimension.height ? this.slideY - dimension.height : 0, container.getWidth(), dimension.height);
            this.height = Math.max(this.height, dimension.height);
        }
    }
}

