/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.ninepatch;

import com.alee.extended.drag.FileDropHandler;
import com.alee.extended.filechooser.SelectionMode;
import com.alee.extended.filechooser.WebFileChooser;
import com.alee.extended.ninepatch.NinePatchEditor;
import com.alee.extended.ninepatch.NinePatchInfo;
import com.alee.extended.ninepatch.ZoomChangeListener;
import com.alee.extended.painter.AlphaLayerPainter;
import com.alee.extended.painter.ColorPainter;
import com.alee.extended.painter.NinePatchIconPainter;
import com.alee.extended.panel.ResizablePanel;
import com.alee.extended.panel.WebButtonGroup;
import com.alee.extended.statusbar.WebStatusBar;
import com.alee.extended.tree.WebFileTree;
import com.alee.laf.GlobalConstants;
import com.alee.laf.button.WebButton;
import com.alee.laf.button.WebToggleButton;
import com.alee.laf.colorchooser.WebColorChooserDialog;
import com.alee.laf.label.WebLabel;
import com.alee.laf.optionpane.WebOptionPane;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.scroll.WebScrollPane;
import com.alee.laf.slider.WebSlider;
import com.alee.laf.splitpane.WebSplitPane;
import com.alee.laf.text.WebTextField;
import com.alee.laf.toolbar.ToolbarStyle;
import com.alee.laf.toolbar.WebToolBar;
import com.alee.laf.toolbar.WebToolbarStyle;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.settings.SettingsManager;
import com.alee.utils.CollectionUtils;
import com.alee.utils.ImageUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.XmlUtils;
import com.alee.utils.ninepatch.NinePatchInterval;
import com.alee.utils.ninepatch.NinePatchIntervalType;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class NinePatchEditorPanel
extends WebPanel {
    public static final ImageIcon OPEN_ICON = new ImageIcon(NinePatchEditorPanel.class.getResource("icons/open.png"));
    public static final ImageIcon SAVE_ICON = new ImageIcon(NinePatchEditorPanel.class.getResource("icons/save.png"));
    public static final ImageIcon SAVE_AS_ICON = new ImageIcon(NinePatchEditorPanel.class.getResource("icons/saveas.png"));
    public static final ImageIcon COPY_ICON = new ImageIcon(NinePatchEditorPanel.class.getResource("icons/copy.png"));
    public static final ImageIcon PASTE_ICON = new ImageIcon(NinePatchEditorPanel.class.getResource("icons/paste.png"));
    public static final ImageIcon UNDO_ICON = new ImageIcon(NinePatchEditorPanel.class.getResource("icons/undo.png"));
    public static final ImageIcon REDO_ICON = new ImageIcon(NinePatchEditorPanel.class.getResource("icons/redo.png"));
    public static final ImageIcon GUIDES_ICON = new ImageIcon(NinePatchEditorPanel.class.getResource("icons/guides.png"));
    public static final ImageIcon RULER_ICON = new ImageIcon(NinePatchEditorPanel.class.getResource("icons/ruler.png"));
    public static final ImageIcon STRETCH_ICON = new ImageIcon(NinePatchEditorPanel.class.getResource("icons/stretch.png"));
    public static final ImageIcon CONTENT_ICON = new ImageIcon(NinePatchEditorPanel.class.getResource("icons/content.png"));
    public static final ImageIcon RULER_CURSOR_ICON = new ImageIcon(NinePatchEditorPanel.class.getResource("icons/ruler_cursor.png"));
    public static final ImageIcon AREA_CURSOR_ICON = new ImageIcon(NinePatchEditorPanel.class.getResource("icons/area_cursor.png"));
    public static final ImageIcon MIN_ICON = new ImageIcon(NinePatchEditorPanel.class.getResource("icons/min.png"));
    public static final ImageIcon MAX_ICON = new ImageIcon(NinePatchEditorPanel.class.getResource("icons/max.png"));
    public static final ImageIcon ICON = new ImageIcon(NinePatchEditorPanel.class.getResource("icons/icon.png"));
    public static final ImageIcon SHOW_ICON_ICON = new ImageIcon(NinePatchEditorPanel.class.getResource("icons/show_icon.png"));
    public static final ImageIcon SHOW_TEXT_ICON = new ImageIcon(NinePatchEditorPanel.class.getResource("icons/show_text.png"));
    public static final ImageIcon FOREGROUND_COLOR_ICON = new ImageIcon(NinePatchEditorPanel.class.getResource("icons/foreground_color.png"));
    public static final ImageIcon TRANSPARENT_ICON = new ImageIcon(NinePatchEditorPanel.class.getResource("icons/transparent.png"));
    public static final ImageIcon BACKGROUND_COLOR_ICON = new ImageIcon(NinePatchEditorPanel.class.getResource("icons/background_color.png"));
    private List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();
    private String imageSrc = null;
    private WebFileTree fileTree;
    private NinePatchEditor ninePatchEditor;
    private WebToolBar toolBar;
    private WebButton save;
    private WebButton saveAs;
    private ChangeListener changeListener;
    private ZoomChangeListener zoomChangeListener;
    private AlphaLayerPainter abp;
    private ColorPainter cbp;
    private WebPanel previewPanel;
    private WebLabel preview;
    private boolean openFromTreeEnabled = true;
    private static boolean aliasesInitialized = false;

    public NinePatchEditorPanel() {
        NinePatchEditorPanel.initializeAliases();
        this.setLayout(new BorderLayout());
        this.ninePatchEditor = new NinePatchEditor();
        this.ninePatchEditor.setTransferHandler(new FileDropHandler(){

            @Override
            protected boolean filesImported(List<File> list) {
                if (list != null) {
                    for (File file : list) {
                        if (!ImageUtils.isImageLoadable(file.getName())) continue;
                        NinePatchEditorPanel.this.openImage(file);
                        return true;
                    }
                }
                return false;
            }
        });
        this.fileTree = new WebFileTree();
        this.fileTree.setSelectionMode(1);
        this.fileTree.setFileFilter(GlobalConstants.IMAGES_AND_FOLDERS_FILTER);
        this.fileTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                if (NinePatchEditorPanel.this.openFromTreeEnabled && NinePatchEditorPanel.this.fileTree.getSelectionCount() > 0) {
                    NinePatchEditorPanel.this.openImage(NinePatchEditorPanel.this.fileTree.getSelectedFile());
                }
            }
        });
        this.fileTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && NinePatchEditorPanel.this.openFromTreeEnabled && NinePatchEditorPanel.this.fileTree.getSelectionCount() > 0) {
                    NinePatchEditorPanel.this.openImage(NinePatchEditorPanel.this.fileTree.getSelectedFile());
                }
            }
        });
        this.fileTree.setTransferHandler(new TransferHandler(){

            @Override
            public int getSourceActions(JComponent jComponent) {
                return 1;
            }

            @Override
            protected Transferable createTransferable(JComponent jComponent) {
                return NinePatchEditorPanel.this.fileTree.getSelectionCount() > 0 ? new StringSelection(NinePatchEditorPanel.this.fileTree.getSelectedFile().getAbsolutePath()) : null;
            }
        });
        WebScrollPane webScrollPane = new WebScrollPane(this.fileTree, false);
        webScrollPane.setMinimumWidth(200);
        webScrollPane.setPreferredHeight(0);
        webScrollPane.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, WebToolbarStyle.borderColor));
        WebScrollPane webScrollPane2 = this.ninePatchEditor.getView();
        webScrollPane2.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 1, WebToolbarStyle.borderColor));
        WebPanel webPanel = this.createPreviewPanel();
        webPanel.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, WebToolbarStyle.borderColor));
        final WebSplitPane webSplitPane = new WebSplitPane(1);
        webSplitPane.setLeftComponent(webScrollPane2);
        webSplitPane.setRightComponent(webPanel);
        webSplitPane.setOneTouchExpandable(true);
        webSplitPane.setContinuousLayout(true);
        webSplitPane.setResizeWeight(1.0);
        final WebSplitPane webSplitPane2 = new WebSplitPane(1);
        webSplitPane2.setLeftComponent(webScrollPane);
        webSplitPane2.setRightComponent(webSplitPane);
        webSplitPane2.setOneTouchExpandable(true);
        webSplitPane2.setContinuousLayout(true);
        webSplitPane2.setResizeWeight(0.0);
        this.add((Component)webSplitPane2, (Object)"Center");
        Integer n = SettingsManager.get("NinePatchEditor", (Object)"filesSplitLocation", (Integer)null);
        if (n != null) {
            webSplitPane2.setDividerLocation(n);
        } else {
            webSplitPane2.setDividerLocation(230);
        }
        webSplitPane2.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SettingsManager.set("NinePatchEditor", "filesSplitLocation", webSplitPane2.getDividerLocation());
            }
        });
        Integer n2 = SettingsManager.get("NinePatchEditor", (Object)"splitLocation", (Integer)null);
        if (n2 != null) {
            webSplitPane.setDividerLocation(n2);
        }
        webSplitPane.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SettingsManager.set("NinePatchEditor", "splitLocation", webSplitPane.getDividerLocation());
            }
        });
        this.toolBar = new WebToolBar(0);
        this.toolBar.setToolbarStyle(ToolbarStyle.attached);
        this.toolBar.setFloatable(false);
        this.add((Component)this.toolBar, (Object)"North");
        WebButton webButton = new WebButton(OPEN_ICON);
        webButton.setLanguage("weblaf.ex.npeditor.openImage", new Object[0]);
        webButton.addHotkey(this, Hotkey.CTRL_O);
        webButton.setRolloverDecoratedOnly(true);
        webButton.addActionListener(new ActionListener(){
            private WebFileChooser wfc = null;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                if (this.wfc == null) {
                    this.wfc = new WebFileChooser(SwingUtils.getWindowAncestor(NinePatchEditorPanel.this), "");
                    this.wfc.setLanguage("weblaf.ex.npeditor.openImage.title", new Object[0]);
                    this.wfc.setSelectionMode(SelectionMode.SINGLE_SELECTION);
                }
                if (NinePatchEditorPanel.this.imageSrc != null) {
                    this.wfc.setCurrentDirectory(NinePatchEditorPanel.this.imageSrc);
                }
                if ((n = this.wfc.showDialog()) == 0) {
                    File file = this.wfc.getSelectedFile();
                    NinePatchEditorPanel.this.openImage(file);
                }
            }
        });
        this.toolBar.add((Component)webButton);
        this.toolBar.addSeparator();
        this.save = new WebButton(SAVE_ICON);
        this.save.setLanguage("weblaf.ex.npeditor.saveImage", new Object[0]);
        this.save.addHotkey(this, Hotkey.CTRL_S);
        this.save.setRolloverDecoratedOnly(true);
        this.save.setEnabled(false);
        this.save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (NinePatchEditorPanel.this.imageSrc != null) {
                    try {
                        NinePatchEditorPanel.this.saveImage(new File(NinePatchEditorPanel.this.imageSrc));
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        });
        this.toolBar.add((Component)this.save);
        this.saveAs = new WebButton(SAVE_AS_ICON);
        this.saveAs.setLanguage("weblaf.ex.npeditor.saveImageAs", new Object[0]);
        this.saveAs.addHotkey(this, Hotkey.CTRL_SHIFT_S);
        this.saveAs.setRolloverDecoratedOnly(true);
        this.saveAs.addActionListener(new ActionListener(){
            private WebFileChooser wfc = null;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                if (this.wfc == null) {
                    this.wfc = new WebFileChooser(SwingUtils.getWindowAncestor(NinePatchEditorPanel.this), "");
                    this.wfc.setLanguage("weblaf.ex.npeditor.saveImageAs.title", new Object[0]);
                    this.wfc.setSelectionMode(SelectionMode.SINGLE_SELECTION);
                }
                if (NinePatchEditorPanel.this.imageSrc != null) {
                    this.wfc.setCurrentDirectory(NinePatchEditorPanel.this.imageSrc);
                }
                if ((n = this.wfc.showDialog()) == 0) {
                    try {
                        NinePatchEditorPanel.this.saveImage(this.wfc.getSelectedFile());
                        NinePatchEditorPanel.this.save.setEnabled(true);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        });
        this.toolBar.add((Component)this.saveAs);
        this.toolBar.addSeparator();
        WebButton webButton2 = new WebButton(COPY_ICON);
        webButton2.setLanguage("weblaf.ex.npeditor.copyInfo", new Object[0]);
        webButton2.addHotkey(this, Hotkey.CTRL_C);
        webButton2.setRolloverDecoratedOnly(true);
        webButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!NinePatchEditorPanel.this.ninePatchEditor.isSomeDragged()) {
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(XmlUtils.toXML(NinePatchEditorPanel.this.ninePatchEditor.getNinePatchInfo())), null);
                }
            }
        });
        this.toolBar.add((Component)webButton2);
        WebButton webButton3 = new WebButton(PASTE_ICON);
        webButton3.setLanguage("weblaf.ex.npeditor.pasteInfo", new Object[0]);
        webButton3.addHotkey(this, Hotkey.CTRL_V);
        webButton3.setRolloverDecoratedOnly(true);
        webButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!NinePatchEditorPanel.this.ninePatchEditor.isSomeDragged()) {
                    try {
                        Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
                        if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                            String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                            NinePatchInfo ninePatchInfo = (NinePatchInfo)XmlUtils.fromXML(string);
                            NinePatchEditorPanel.this.ninePatchEditor.setNinePatchInfo(ninePatchInfo);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        });
        this.toolBar.add((Component)webButton3);
        this.toolBar.addSeparator();
        WebButton webButton4 = new WebButton(UNDO_ICON);
        webButton4.setLanguage("weblaf.ex.npeditor.undo", new Object[0]);
        webButton4.addHotkey(this, Hotkey.CTRL_Z);
        webButton4.setRolloverDecoratedOnly(true);
        webButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NinePatchEditorPanel.this.ninePatchEditor.undo();
            }
        });
        this.toolBar.add((Component)webButton4);
        WebButton webButton5 = new WebButton(REDO_ICON);
        webButton5.setLanguage("weblaf.ex.npeditor.redo", new Object[0]);
        webButton5.addHotkey(this, Hotkey.CTRL_R);
        webButton5.addHotkey(this, Hotkey.CTRL_SHIFT_Z);
        webButton5.setRolloverDecoratedOnly(true);
        webButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NinePatchEditorPanel.this.ninePatchEditor.redo();
            }
        });
        this.toolBar.add((Component)webButton5);
        boolean bl = SettingsManager.get("NinePatchEditor", (Object)"preview.showIcon", false);
        this.preview.setIcon(bl ? ICON : null);
        final WebToggleButton webToggleButton = new WebToggleButton(SHOW_ICON_ICON);
        webToggleButton.setLanguage("weblaf.ex.npeditor.preview.showIcon", new Object[0]);
        webToggleButton.setRolloverDecoratedOnly(true);
        webToggleButton.setSelected(bl);
        webToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = webToggleButton.isSelected();
                SettingsManager.set("NinePatchEditor", "preview.showIcon", bl);
                NinePatchEditorPanel.this.preview.setIcon(bl ? ICON : null);
            }
        });
        this.toolBar.addToEnd(webToggleButton);
        boolean bl2 = SettingsManager.get("NinePatchEditor", (Object)"preview.showText", true);
        final WebToggleButton webToggleButton2 = new WebToggleButton(SHOW_TEXT_ICON);
        webToggleButton2.setLanguage("weblaf.ex.npeditor.preview.showText", new Object[0]);
        webToggleButton2.setCursor(Cursor.getDefaultCursor());
        webToggleButton2.setDrawFocus(false);
        webToggleButton2.setRolloverDecoratedOnly(true);
        webToggleButton2.setRolloverDarkBorderOnly(false);
        webToggleButton2.setDrawRight(false);
        webToggleButton2.setDrawRightLine(true);
        webToggleButton2.setShadeWidth(0);
        webToggleButton2.setSelected(bl2);
        String string = SettingsManager.get("NinePatchEditor", (Object)"preview.text", LanguageManager.get("weblaf.ex.npeditor.preview.text"));
        this.preview.setText(bl2 ? this.parseToMultilineHtml(string) : "");
        final WebTextField webTextField = new WebTextField(8);
        webTextField.setText(string);
        webTextField.setHorizontalAlignment(0);
        webTextField.setDrawFocus(false);
        webTextField.setEditable(bl2);
        webTextField.setMargin(-1);
        webTextField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                SettingsManager.set("NinePatchEditor", "preview.text", webTextField.getText());
                NinePatchEditorPanel.this.preview.setText(webToggleButton2.isSelected() ? NinePatchEditorPanel.this.parseToMultilineHtml(webTextField.getText()) : "");
            }
        });
        webToggleButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = webToggleButton2.isSelected();
                SettingsManager.set("NinePatchEditor", "preview.showText", bl);
                webTextField.setEditable(bl);
                NinePatchEditorPanel.this.preview.setText(bl ? NinePatchEditorPanel.this.parseToMultilineHtml(webTextField.getText()) : "");
            }
        });
        webTextField.setLeadingComponent(webToggleButton2);
        this.toolBar.addToEnd(webTextField);
        WebButton webButton6 = new WebButton(FOREGROUND_COLOR_ICON);
        webButton6.setLanguage("weblaf.ex.npeditor.preview.foregroundColor", new Object[0]);
        this.preview.setForeground(SettingsManager.get("NinePatchEditor", (Object)"preview.foregroundColor", Color.WHITE));
        webButton6.setCursor(Cursor.getDefaultCursor());
        webButton6.setDrawFocus(false);
        webButton6.setRolloverDecoratedOnly(true);
        webButton6.setRolloverDarkBorderOnly(false);
        webButton6.setDrawLeft(false);
        webButton6.setDrawLeftLine(true);
        webButton6.setShadeWidth(0);
        webButton6.addActionListener(new ActionListener(){
            private WebColorChooserDialog webColorChooser = null;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (this.webColorChooser == null) {
                    this.webColorChooser = new WebColorChooserDialog((Component)SwingUtils.getWindowAncestor(NinePatchEditorPanel.this.previewPanel));
                    this.webColorChooser.setColor(NinePatchEditorPanel.this.preview.getForeground());
                }
                if (this.webColorChooser.showDialog() == 0) {
                    Color color = this.webColorChooser.getColor();
                    SettingsManager.set("NinePatchEditor", "preview.foregroundColor", color);
                    NinePatchEditorPanel.this.preview.setForeground(color);
                }
            }
        });
        webTextField.setTrailingComponent(webButton6);
        this.abp = new AlphaLayerPainter();
        boolean bl3 = SettingsManager.get("NinePatchEditor", (Object)"preview.transparentBackground", true);
        WebToggleButton webToggleButton3 = new WebToggleButton(TRANSPARENT_ICON);
        webToggleButton3.setLanguage("weblaf.ex.npeditor.preview.transparentBackground", new Object[0]);
        webToggleButton3.setSelected(bl3);
        webToggleButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsManager.set("NinePatchEditor", "preview.transparentBackground", true);
                NinePatchEditorPanel.this.previewPanel.setPainter(NinePatchEditorPanel.this.abp);
            }
        });
        this.cbp = new ColorPainter(SettingsManager.get("NinePatchEditor", (Object)"preview.backgroundColor", Color.WHITE));
        final WebToggleButton webToggleButton4 = new WebToggleButton(ImageUtils.createColorIcon(this.cbp.getColor()));
        webToggleButton4.setLanguage("weblaf.ex.npeditor.preview.coloredBackground", new Object[0]);
        webToggleButton4.setSelected(!bl3);
        webToggleButton4.addActionListener(new ActionListener(){
            private WebColorChooserDialog wcc = null;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsManager.set("NinePatchEditor", "preview.transparentBackground", false);
                if (this.wcc == null) {
                    this.wcc = new WebColorChooserDialog((Component)SwingUtils.getWindowAncestor(NinePatchEditorPanel.this.previewPanel), "");
                    this.wcc.setLanguage("preview.backgroundColor.title", new Object[0]);
                    this.wcc.setColor(NinePatchEditorPanel.this.cbp.getColor());
                }
                this.wcc.setVisible(true);
                if (this.wcc.getResult() == 0) {
                    Color color = this.wcc.getColor();
                    SettingsManager.set("NinePatchEditor", "preview.backgroundColor", color);
                    webToggleButton4.setIcon(ImageUtils.createColorIcon(color));
                    NinePatchEditorPanel.this.cbp.setColor(color);
                }
                NinePatchEditorPanel.this.previewPanel.setPainter(NinePatchEditorPanel.this.cbp);
            }
        });
        this.previewPanel.setPainter(bl3 ? this.abp : this.cbp);
        WebButtonGroup webButtonGroup = new WebButtonGroup(true, webToggleButton3, webToggleButton4);
        this.toolBar.addToEnd(webButtonGroup);
        WebStatusBar webStatusBar = new WebStatusBar();
        this.add((Component)webStatusBar, (Object)"South");
        boolean bl4 = SettingsManager.get("NinePatchEditor", (Object)"showSpacing", true);
        final WebToggleButton webToggleButton5 = new WebToggleButton(GUIDES_ICON);
        webToggleButton5.setLanguage("weblaf.ex.npeditor.showSpacing", new Object[0]);
        webToggleButton5.setRolloverDecoratedOnly(true);
        webToggleButton5.setSelected(bl4);
        this.ninePatchEditor.setShowGuideSpacing(bl4);
        webToggleButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = webToggleButton5.isSelected();
                SettingsManager.set("NinePatchEditor", "showSpacing", bl);
                NinePatchEditorPanel.this.ninePatchEditor.setShowGuideSpacing(bl);
            }
        });
        boolean bl5 = SettingsManager.get("NinePatchEditor", (Object)"showRuler", true);
        final WebToggleButton webToggleButton6 = new WebToggleButton(RULER_ICON);
        webToggleButton6.setLanguage("weblaf.ex.npeditor.showRuler", new Object[0]);
        webToggleButton6.setRolloverDecoratedOnly(true);
        webToggleButton6.setSelected(bl5);
        this.ninePatchEditor.setShowRuler(bl5);
        webToggleButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = webToggleButton6.isSelected();
                SettingsManager.set("NinePatchEditor", "showRuler", bl);
                NinePatchEditorPanel.this.ninePatchEditor.setShowRuler(bl);
            }
        });
        boolean bl6 = SettingsManager.get("NinePatchEditor", (Object)"fillContent", true);
        final WebToggleButton webToggleButton7 = new WebToggleButton(CONTENT_ICON);
        webToggleButton7.setLanguage("weblaf.ex.npeditor.fillContent", new Object[0]);
        webToggleButton7.setRolloverDecoratedOnly(true);
        webToggleButton7.setSelected(bl6);
        this.ninePatchEditor.setFillContentArea(bl6);
        webToggleButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = webToggleButton7.isSelected();
                SettingsManager.set("NinePatchEditor", "fillContent", bl);
                NinePatchEditorPanel.this.ninePatchEditor.setFillContentArea(bl);
            }
        });
        boolean bl7 = SettingsManager.get("NinePatchEditor", (Object)"fillStretch", true);
        final WebToggleButton webToggleButton8 = new WebToggleButton(STRETCH_ICON);
        webToggleButton8.setLanguage("weblaf.ex.npeditor.fillStretch", new Object[0]);
        webToggleButton8.setRolloverDecoratedOnly(true);
        webToggleButton8.setSelected(bl7);
        this.ninePatchEditor.setFillStretchAreas(bl7);
        webToggleButton8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = webToggleButton8.isSelected();
                SettingsManager.set("NinePatchEditor", "fillStretch", bl);
                NinePatchEditorPanel.this.ninePatchEditor.setFillStretchAreas(bl);
            }
        });
        boolean bl8 = SettingsManager.get("NinePatchEditor", (Object)"rulerCursor", true);
        final WebToggleButton webToggleButton9 = new WebToggleButton(RULER_CURSOR_ICON);
        webToggleButton9.setLanguage("weblaf.ex.npeditor.rulerCursor", new Object[0]);
        webToggleButton9.setRolloverDecoratedOnly(true);
        webToggleButton9.setSelected(bl8);
        this.ninePatchEditor.setShowRulerCursorPosition(bl8);
        webToggleButton9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = webToggleButton9.isSelected();
                SettingsManager.set("NinePatchEditor", "rulerCursor", bl);
                NinePatchEditorPanel.this.ninePatchEditor.setShowRulerCursorPosition(bl);
            }
        });
        boolean bl9 = SettingsManager.get("NinePatchEditor", (Object)"areaCursor", false);
        final WebToggleButton webToggleButton10 = new WebToggleButton(AREA_CURSOR_ICON);
        webToggleButton10.setLanguage("weblaf.ex.npeditor.areaCursor", new Object[0]);
        webToggleButton10.setRolloverDecoratedOnly(true);
        webToggleButton10.setSelected(bl9);
        this.ninePatchEditor.setShowAreaCursorPosition(bl9);
        webToggleButton10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = webToggleButton10.isSelected();
                SettingsManager.set("NinePatchEditor", "areaCursor", bl);
                NinePatchEditorPanel.this.ninePatchEditor.setShowAreaCursorPosition(bl);
            }
        });
        webStatusBar.add(webToggleButton5);
        webStatusBar.add(webToggleButton6);
        webStatusBar.addSeparator();
        webStatusBar.add(webToggleButton7);
        webStatusBar.add(webToggleButton8);
        webStatusBar.addSeparator();
        webStatusBar.add(webToggleButton9);
        webStatusBar.add(webToggleButton10);
        final WebSlider webSlider = new WebSlider(1, 32, this.ninePatchEditor.getZoom()){

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = 170;
                return dimension;
            }
        };
        webSlider.setAngledThumb(false);
        webSlider.setPaintTicks(false);
        webSlider.setPaintLabels(false);
        this.changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                NinePatchEditorPanel.this.ninePatchEditor.removeZoomChangeListener(NinePatchEditorPanel.this.zoomChangeListener);
                NinePatchEditorPanel.this.ninePatchEditor.setZoom(webSlider.getValue());
                NinePatchEditorPanel.this.ninePatchEditor.addZoomChangeListener(NinePatchEditorPanel.this.zoomChangeListener);
            }
        };
        webSlider.addChangeListener(this.changeListener);
        this.zoomChangeListener = new ZoomChangeListener(){

            @Override
            public void zoomChanged() {
                webSlider.removeChangeListener(NinePatchEditorPanel.this.changeListener);
                webSlider.setValue(NinePatchEditorPanel.this.ninePatchEditor.getZoom());
                webSlider.addChangeListener(NinePatchEditorPanel.this.changeListener);
            }
        };
        this.ninePatchEditor.addZoomChangeListener(this.zoomChangeListener);
        WebButton webButton7 = new WebButton(MIN_ICON);
        webButton7.setRolloverDecoratedOnly(true);
        webButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                webSlider.setValue(1);
            }
        });
        WebButton webButton8 = new WebButton(MAX_ICON);
        webButton8.setRolloverDecoratedOnly(true);
        webButton8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                webSlider.setValue(32);
            }
        });
        webStatusBar.addToEnd(webButton7);
        webStatusBar.addToEnd(webSlider);
        webStatusBar.addToEnd(webButton8);
    }

    private static void initializeAliases() {
        if (!aliasesInitialized) {
            aliasesInitialized = true;
            XmlUtils.processAnnotations(NinePatchInfo.class);
            XmlUtils.processAnnotations(NinePatchInterval.class);
            XmlUtils.processAnnotations(NinePatchIntervalType.class);
        }
    }

    public void openImage(File file) {
        try {
            if (this.imageSrc != null && file.getAbsolutePath().equals(this.imageSrc)) {
                return;
            }
            if (file.isDirectory() || !ImageUtils.isImageLoadable(file.getName())) {
                return;
            }
            Image image = Toolkit.getDefaultToolkit().createImage(file.getAbsolutePath());
            if (image == null) {
                return;
            }
            if (!this.continueAfterSave()) {
                return;
            }
            BufferedImage bufferedImage = ImageUtils.getBufferedImage(new ImageIcon(image));
            this.ninePatchEditor.setNinePatchImage(bufferedImage);
            this.imageSrc = file.getAbsolutePath();
            this.save.setEnabled(true);
            this.openFromTreeEnabled = false;
            this.fileTree.setSelectedFile(file);
            this.openFromTreeEnabled = true;
            this.fireStateChanged();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean continueAfterSave() {
        if (this.ninePatchEditor.isChanged()) {
            String string;
            String string2 = LanguageManager.get("weblaf.ex.npeditor.saveChanges.text");
            int n = WebOptionPane.showConfirmDialog(this, string2, string = LanguageManager.get("weblaf.ex.npeditor.saveChanges.title"), 1, 3);
            if (n == 0) {
                if (this.save.isEnabled()) {
                    this.save.doClick();
                } else {
                    this.saveAs.doClick();
                }
                if (this.ninePatchEditor.isChanged()) {
                    return false;
                }
            } else if (n == 2) {
                return false;
            }
        }
        return true;
    }

    private WebPanel createPreviewPanel() {
        this.previewPanel = new WebPanel(){

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = Math.max(230, dimension.width);
                dimension.height = 400;
                return dimension;
            }
        };
        this.previewPanel.setLayout(new TableLayout(new double[][]{{-1.0, -2.0, -1.0}, {-1.0, -2.0, -1.0}}));
        this.previewPanel.setPainter(this.abp);
        this.preview = new WebLabel("", 0);
        ResizablePanel resizablePanel = new ResizablePanel(this.preview);
        this.previewPanel.add((Component)resizablePanel, (Object)"1,1");
        this.updatePreviews();
        this.getNinePatchEditor().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                NinePatchEditorPanel.this.updatePreviews();
            }
        });
        return new WebPanel(this.previewPanel);
    }

    private String parseToMultilineHtml(String string) {
        return "<html><center>" + string.replaceAll(";", "<br>").replaceAll("\\\\n", "<br>") + "</center></html>";
    }

    private void updatePreviews() {
        NinePatchIconPainter ninePatchIconPainter = new NinePatchIconPainter(this.getNinePatchEditor().getNinePatchIcon());
        this.preview.setPainter(ninePatchIconPainter);
        this.previewPanel.revalidate();
    }

    private void saveImage(File file) throws IOException {
        String string = this.getSaveFileName(file);
        file = new File(file.getParent(), string);
        this.imageSrc = file.getAbsolutePath();
        BufferedImage bufferedImage = this.ninePatchEditor.getNinePatchImage();
        ImageIO.write((RenderedImage)bufferedImage, "png", file);
        this.ninePatchEditor.setChanged(false);
        this.fireStateChanged();
    }

    private String getSaveFileName(File file) {
        String string = ".png";
        String string2 = ".9";
        String string3 = file.getName();
        if (string3.endsWith(string)) {
            String string4 = string3.substring(0, string3.lastIndexOf(string));
            if (!string4.endsWith(string2)) {
                string3 = string4 + string2 + string;
            }
        } else if (string3.endsWith(string2)) {
            string3 = string3 + string;
        } else {
            int n = string3.lastIndexOf(".");
            if (n != -1) {
                string3 = string3.substring(0, n);
            }
            string3 = string3 + string2 + string;
        }
        return string3;
    }

    public NinePatchEditor getNinePatchEditor() {
        return this.ninePatchEditor;
    }

    public String getImageSrc() {
        return this.imageSrc;
    }

    public void setNinePatchImage(ImageIcon imageIcon) {
        this.setNinePatchImage(imageIcon.getImage());
    }

    public void setNinePatchImage(Image image) {
        this.setNinePatchImage(ImageUtils.getBufferedImage(image));
    }

    public void setNinePatchImage(BufferedImage bufferedImage) {
        if (!this.continueAfterSave()) {
            return;
        }
        this.ninePatchEditor.setNinePatchImage(bufferedImage);
        this.imageSrc = null;
        this.save.setEnabled(true);
        this.fireStateChanged();
    }

    public BufferedImage getNinePatchImage() {
        return this.ninePatchEditor.getNinePatchImage();
    }

    public List<ChangeListener> getChangeListeners() {
        return this.changeListeners;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    private void fireStateChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : CollectionUtils.copy(this.changeListeners)) {
            changeListener.stateChanged(changeEvent);
        }
    }
}

