/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.optionpane;

import com.alee.extended.image.WebImage;
import com.alee.extended.layout.HorizontalFlowLayout;
import com.alee.extended.optionpane.DialogType;
import com.alee.extended.panel.CenterPanel;
import com.alee.laf.button.WebButton;
import com.alee.laf.label.WebLabel;
import com.alee.laf.optionpane.WebOptionPaneUI;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.rootpane.WebDialog;
import com.alee.managers.language.LanguageManager;
import com.alee.utils.CollectionUtils;
import com.alee.utils.SwingUtils;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ImageIcon;

public class WebExtendedOptionPane
extends WebDialog {
    public static final ImageIcon INFORMATION_ICON = new ImageIcon(WebExtendedOptionPane.class.getResource("icons/information.png"));
    public static final ImageIcon WARNING_ICON = new ImageIcon(WebExtendedOptionPane.class.getResource("icons/warning.png"));
    public static final ImageIcon ERROR_ICON = new ImageIcon(WebExtendedOptionPane.class.getResource("icons/error.png"));
    public static final ImageIcon QUESTION_ICON = new ImageIcon(WebExtendedOptionPane.class.getResource("icons/question.png"));
    public static final int YES_NO_OPTION = 0;
    public static final int YES_NO_CANCEL_OPTION = 1;
    public static final int OK_CANCEL_OPTION = 2;
    public static final int YES_OPTION = 0;
    public static final int NO_OPTION = 1;
    public static final int CANCEL_OPTION = 2;
    public static final int OK_OPTION = 0;
    public static final int CLOSED_OPTION = -1;
    public static final int ERROR_MESSAGE = 64;
    public static final int INFORMATION_MESSAGE = 1;
    public static final int WARNING_MESSAGE = 2;
    public static final int QUESTION_MESSAGE = 3;
    public static final int PLAIN_MESSAGE = -1;
    private Component parentComponent;
    private int result;
    private WebPanel container;
    private WebPanel controls;
    private WebPanel centerer;
    private WebPanel buttons;
    private WebButton yes;
    private WebButton no;
    private WebButton ok;
    private WebButton cancel;
    private Component specialComponent = null;

    public WebExtendedOptionPane(DialogType dialogType, Component component, Object object, Object object2, String string, int n, int n2) {
        super(SwingUtils.getWindowAncestor(component), string);
        this.setIconImages(this.getDialogIcons(n2));
        this.setLayout(new BorderLayout());
        this.parentComponent = component;
        this.container = new WebPanel(new BorderLayout(15, 15));
        this.container.setMargin(15, 15, 8, 15);
        this.add((Component)this.container, "Center");
        ImageIcon imageIcon = this.getLargeIcon(n2);
        if (imageIcon != null) {
            WebImage webImage = new WebImage(imageIcon);
            webImage.setVerticalAlignment(1);
            this.container.add((Component)new CenterPanel(webImage, false, true), (Object)"West");
        }
        this.setContent(object, false);
        this.controls = new WebPanel(new BorderLayout(15, 15));
        this.container.add((Component)this.controls, (Object)"South");
        this.centerer = new WebPanel();
        this.controls.add((Component)this.centerer, (Object)"Center");
        this.buttons = new WebPanel(new HorizontalFlowLayout(5, false));
        this.setSpecialComponent(object2);
        if (n == 0 || n == 1) {
            this.yes = this.createControlButton("weblaf.optionpane.yes");
            this.yes.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    WebExtendedOptionPane.this.closeDialog(0);
                }
            });
            this.buttons.add((Component)this.yes);
        }
        if (n == 0 || n == 1) {
            this.no = this.createControlButton("weblaf.optionpane.no");
            this.no.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    WebExtendedOptionPane.this.closeDialog(1);
                }
            });
            this.buttons.add((Component)this.no);
        }
        if (n == 2) {
            this.ok = this.createControlButton("weblaf.optionpane.ok");
            this.ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    WebExtendedOptionPane.this.closeDialog(0);
                }
            });
            this.buttons.add((Component)this.ok);
        }
        if (n == 1 || n == 2) {
            this.cancel = this.createControlButton("weblaf.optionpane.cancel");
            this.cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    WebExtendedOptionPane.this.closeDialog(2);
                }
            });
            this.buttons.add((Component)this.cancel);
        }
        SwingUtils.equalizeComponentsWidths(this.buttons.getComponents());
        this.setModal(true);
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(SwingUtils.getWindowAncestor(component));
    }

    protected ImageIcon getLargeIcon(int n) {
        return WebOptionPaneUI.getTypeIcon(n);
    }

    public void clickYes() {
        this.yes.doClick();
    }

    public void clickNo() {
        this.no.doClick();
    }

    public void clickOk() {
        this.ok.doClick();
    }

    public void clickCancel() {
        this.cancel.doClick();
    }

    public void setContent(Object object) {
        this.setContent(object, true);
    }

    public void setSpecialComponent(Object object) {
        if (this.specialComponent != null) {
            this.controls.remove(this.specialComponent);
            this.specialComponent = null;
        }
        if (object != null) {
            this.specialComponent = object instanceof Component ? (Component)object : new WebLabel(object.toString());
            this.controls.add(this.specialComponent, (Object)"West");
        }
        this.updateCenterer();
    }

    private void updateCenterer() {
        this.centerer.removeAll();
        if (this.specialComponent == null) {
            this.centerer.setLayout(new TableLayout(new double[][]{{-1.0, -2.0, -1.0}, {-2.0}}));
        } else {
            this.centerer.setLayout(new TableLayout(new double[][]{{-1.0, -2.0}, {-2.0}}));
        }
        this.centerer.add((Component)this.buttons, (Object)"1,0");
    }

    private void setContent(Object object, boolean bl) {
        if (object != null) {
            if (object instanceof Component) {
                this.container.add((Component)object, (Object)"Center");
            } else {
                this.container.add((Component)new WebLabel(object.toString()), (Object)"Center");
            }
        }
        if (bl) {
            this.pack();
            this.setLocationRelativeTo(SwingUtils.getWindowAncestor(this.parentComponent));
        }
    }

    private List<Image> getDialogIcons(int n) {
        Image image = null;
        switch (n) {
            case 64: {
                image = ERROR_ICON.getImage();
                break;
            }
            case 1: {
                image = INFORMATION_ICON.getImage();
                break;
            }
            case 2: {
                image = WARNING_ICON.getImage();
                break;
            }
            case 3: {
                image = QUESTION_ICON.getImage();
            }
        }
        ImageIcon imageIcon = WebOptionPaneUI.getTypeIcon(n);
        Image image2 = imageIcon != null ? imageIcon.getImage() : null;
        return CollectionUtils.copy(image, image2);
    }

    private void closeDialog(int n) {
        this.result = n;
        this.dispose();
    }

    private WebButton createControlButton(String string) {
        WebButton webButton = new WebButton();
        webButton.setLanguage(string, new Object[0]);
        webButton.setLeftRightSpacing(10);
        webButton.setMinimumSize(new Dimension(70, 0));
        return webButton;
    }

    public int getResult() {
        return this.result;
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.result = -1;
            this.buttons.getComponents()[0].requestFocusInWindow();
        }
        super.setVisible(bl);
    }

    public static WebExtendedOptionPane showConfirmDialog(Component component, Object object) {
        return WebExtendedOptionPane.showConfirmDialog(component, object, null);
    }

    public static WebExtendedOptionPane showConfirmDialog(Component component, Object object, Object object2) {
        return WebExtendedOptionPane.showConfirmDialog(component, object, object2, LanguageManager.get("weblaf.optionpane.title"));
    }

    public static WebExtendedOptionPane showConfirmDialog(Component component, Object object, Object object2, String string) {
        return WebExtendedOptionPane.showConfirmDialog(component, object, object2, string, 0);
    }

    public static WebExtendedOptionPane showConfirmDialog(Component component, Object object, Object object2, String string, int n) {
        return WebExtendedOptionPane.showConfirmDialog(component, object, object2, string, n, 3);
    }

    public static WebExtendedOptionPane showConfirmDialog(Component component, Object object, Object object2, String string, int n, int n2) {
        WebExtendedOptionPane webExtendedOptionPane = new WebExtendedOptionPane(DialogType.confirm, component, object, object2, string, n, n2);
        webExtendedOptionPane.setVisible(true);
        return webExtendedOptionPane;
    }
}

