/*
 * Decompiled with CFR 0.152.
 */
package com.alee.graphics.filters;

import com.alee.graphics.filters.AbstractBufferedImageOp;
import com.alee.graphics.filters.ImageMath;
import java.awt.image.BufferedImage;

public class BoxBlurFilter
extends AbstractBufferedImageOp {
    private int hRadius;
    private int vRadius;
    private int iterations = 1;

    public BoxBlurFilter() {
    }

    public BoxBlurFilter(int n, int n2, int n3) {
        this.setHRadius(n);
        this.setVRadius(n2);
        this.setIterations(n3);
    }

    public void setHRadius(int n) {
        this.hRadius = n;
    }

    public int getHRadius() {
        return this.hRadius;
    }

    public void setVRadius(int n) {
        this.vRadius = n;
    }

    public int getVRadius() {
        return this.vRadius;
    }

    public void setRadius(int n) {
        this.hRadius = this.vRadius = n;
    }

    public int getRadius() {
        return this.hRadius;
    }

    public void setIterations(int n) {
        this.iterations = n;
    }

    public int getIterations() {
        return this.iterations;
    }

    @Override
    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
        }
        int[] nArray = new int[n * n2];
        int[] nArray2 = new int[n * n2];
        this.getRGB(bufferedImage, 0, 0, n, n2, nArray);
        for (int i = 0; i < this.iterations; ++i) {
            BoxBlurFilter.blur(nArray, nArray2, n, n2, this.hRadius);
            BoxBlurFilter.blur(nArray2, nArray, n2, n, this.vRadius);
        }
        this.setRGB(bufferedImage2, 0, 0, n, n2, nArray);
        return bufferedImage2;
    }

    public static void blur(int[] nArray, int[] nArray2, int n, int n2, int n3) {
        int n4;
        int n5 = n - 1;
        int n6 = 2 * n3 + 1;
        int[] nArray3 = new int[256 * n6];
        for (n4 = 0; n4 < 256 * n6; ++n4) {
            nArray3[n4] = n4 / n6;
        }
        n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n7;
            int n8;
            int n9 = i;
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            int n13 = 0;
            for (n8 = -n3; n8 <= n3; ++n8) {
                n7 = nArray[n4 + ImageMath.clamp(n8, 0, n - 1)];
                n10 += n7 >> 24 & 0xFF;
                n11 += n7 >> 16 & 0xFF;
                n12 += n7 >> 8 & 0xFF;
                n13 += n7 & 0xFF;
            }
            for (n8 = 0; n8 < n; ++n8) {
                int n14;
                nArray2[n9] = nArray3[n10] << 24 | nArray3[n11] << 16 | nArray3[n12] << 8 | nArray3[n13];
                n7 = n8 + n3 + 1;
                if (n7 > n5) {
                    n7 = n5;
                }
                if ((n14 = n8 - n3) < 0) {
                    n14 = 0;
                }
                int n15 = nArray[n4 + n7];
                int n16 = nArray[n4 + n14];
                n10 += (n15 >> 24 & 0xFF) - (n16 >> 24 & 0xFF);
                n11 += (n15 & 0xFF0000) - (n16 & 0xFF0000) >> 16;
                n12 += (n15 & 0xFF00) - (n16 & 0xFF00) >> 8;
                n13 += (n15 & 0xFF) - (n16 & 0xFF);
                n9 += n2;
            }
            n4 += n;
        }
    }
}

