/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf;

import com.alee.extended.label.WebMultiLineLabelUI;
import com.alee.extended.label.WebVerticalLabelUI;
import com.alee.laf.AltProcessor;
import com.alee.laf.StyleConstants;
import com.alee.laf.WebLayoutStyle;
import com.alee.laf.button.WebButtonUI;
import com.alee.laf.button.WebToggleButtonUI;
import com.alee.laf.checkbox.WebCheckBoxUI;
import com.alee.laf.colorchooser.WebColorChooserUI;
import com.alee.laf.combobox.WebComboBoxUI;
import com.alee.laf.desktoppane.WebDesktopIconUI;
import com.alee.laf.desktoppane.WebDesktopPaneUI;
import com.alee.laf.desktoppane.WebInternalFrameUI;
import com.alee.laf.filechooser.WebFileChooserUI;
import com.alee.laf.label.WebLabelUI;
import com.alee.laf.list.WebListCellRenderer;
import com.alee.laf.list.WebListStyle;
import com.alee.laf.list.WebListUI;
import com.alee.laf.menu.WebCheckBoxMenuItemUI;
import com.alee.laf.menu.WebMenuBarUI;
import com.alee.laf.menu.WebMenuItemUI;
import com.alee.laf.menu.WebMenuUI;
import com.alee.laf.menu.WebPopupMenuSeparatorUI;
import com.alee.laf.menu.WebPopupMenuUI;
import com.alee.laf.menu.WebRadioButtonMenuItemUI;
import com.alee.laf.optionpane.WebOptionPaneUI;
import com.alee.laf.panel.WebPanelUI;
import com.alee.laf.progressbar.WebProgressBarUI;
import com.alee.laf.radiobutton.WebRadioButtonUI;
import com.alee.laf.rootpane.WebRootPaneUI;
import com.alee.laf.scroll.WebScrollBarStyle;
import com.alee.laf.scroll.WebScrollBarUI;
import com.alee.laf.scroll.WebScrollPaneUI;
import com.alee.laf.separator.WebSeparatorUI;
import com.alee.laf.slider.WebSliderUI;
import com.alee.laf.spinner.WebSpinnerUI;
import com.alee.laf.splitpane.WebSplitPaneUI;
import com.alee.laf.tabbedpane.WebTabbedPaneUI;
import com.alee.laf.table.WebTableHeaderUI;
import com.alee.laf.table.WebTableStyle;
import com.alee.laf.table.WebTableUI;
import com.alee.laf.text.WebEditorPaneUI;
import com.alee.laf.text.WebFormattedTextFieldUI;
import com.alee.laf.text.WebPasswordFieldUI;
import com.alee.laf.text.WebTextAreaUI;
import com.alee.laf.text.WebTextFieldUI;
import com.alee.laf.text.WebTextPaneUI;
import com.alee.laf.toolbar.WebToolBarSeparatorUI;
import com.alee.laf.toolbar.WebToolBarUI;
import com.alee.laf.tooltip.WebToolTipUI;
import com.alee.laf.tree.WebTreeUI;
import com.alee.laf.viewport.WebViewportUI;
import com.alee.managers.focus.FocusManager;
import com.alee.managers.hotkey.HotkeyManager;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.proxy.ProxyManager;
import com.alee.managers.settings.SettingsManager;
import com.alee.managers.tooltip.TooltipManager;
import com.alee.managers.version.VersionManager;
import com.alee.utils.CollectionUtils;
import com.alee.utils.ImageUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.SystemUtils;
import com.alee.utils.XmlUtils;
import com.alee.utils.swing.SwingLazyValue;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicLookAndFeel;

public class WebLookAndFeel
extends BasicLookAndFeel {
    public static final String COMPONENT_ORIENTATION_PROPERTY = "componentOrientation";
    public static final String COMPONENT_MARGIN_PROPERTY = "margin";
    public static final String COMPONENT_ENABLED_PROPERTY = "enabled";
    public static final String TOOLBAR_FLOATABLE_PROPERTY = "floatable";
    public static final String WINDOW_DECORATION_STYLE_PROPERTY = "windowDecorationStyle";
    private static List<ImageIcon> icons = null;
    public static final AltProcessor altProcessor = new AltProcessor();
    private static boolean isMnemonicHidden = true;
    private static boolean decorateFrames = false;
    private static boolean decorateDialogs = false;
    public static String labelUI = WebLabelUI.class.getCanonicalName();
    public static String toolTipUI = WebToolTipUI.class.getCanonicalName();
    public static String buttonUI = WebButtonUI.class.getCanonicalName();
    public static String toggleButtonUI = WebToggleButtonUI.class.getCanonicalName();
    public static String checkBoxUI = WebCheckBoxUI.class.getCanonicalName();
    public static String radioButtonUI = WebRadioButtonUI.class.getCanonicalName();
    public static String menuBarUI = WebMenuBarUI.class.getCanonicalName();
    public static String menuUI = WebMenuUI.class.getCanonicalName();
    public static String popupMenuUI = WebPopupMenuUI.class.getCanonicalName();
    public static String menuItemUI = WebMenuItemUI.class.getCanonicalName();
    public static String checkBoxMenuItemUI = WebCheckBoxMenuItemUI.class.getCanonicalName();
    public static String radioButtonMenuItemUI = WebRadioButtonMenuItemUI.class.getCanonicalName();
    public static String popupMenuSeparatorUI = WebPopupMenuSeparatorUI.class.getCanonicalName();
    public static String separatorUI = WebSeparatorUI.class.getCanonicalName();
    public static String scrollBarUI = WebScrollBarUI.class.getCanonicalName();
    public static String scrollPaneUI = WebScrollPaneUI.class.getCanonicalName();
    public static String textFieldUI = WebTextFieldUI.class.getCanonicalName();
    public static String passwordFieldUI = WebPasswordFieldUI.class.getCanonicalName();
    public static String formattedTextFieldUI = WebFormattedTextFieldUI.class.getCanonicalName();
    public static String textAreaUI = WebTextAreaUI.class.getCanonicalName();
    public static String editorPaneUI = WebEditorPaneUI.class.getCanonicalName();
    public static String textPaneUI = WebTextPaneUI.class.getCanonicalName();
    public static String toolBarUI = WebToolBarUI.class.getCanonicalName();
    public static String toolBarSeparatorUI = WebToolBarSeparatorUI.class.getCanonicalName();
    public static String tableUI = WebTableUI.class.getCanonicalName();
    public static String tableHeaderUI = WebTableHeaderUI.class.getCanonicalName();
    public static String colorChooserUI = WebColorChooserUI.class.getCanonicalName();
    public static String fileChooserUI = WebFileChooserUI.class.getCanonicalName();
    public static String panelUI = WebPanelUI.class.getCanonicalName();
    public static String viewportUI = WebViewportUI.class.getCanonicalName();
    public static String rootPaneUI = WebRootPaneUI.class.getCanonicalName();
    public static String tabbedPaneUI = WebTabbedPaneUI.class.getCanonicalName();
    public static String splitPaneUI = WebSplitPaneUI.class.getCanonicalName();
    public static String progressBarUI = WebProgressBarUI.class.getCanonicalName();
    public static String sliderUI = WebSliderUI.class.getCanonicalName();
    public static String spinnerUI = WebSpinnerUI.class.getCanonicalName();
    public static String treeUI = WebTreeUI.class.getCanonicalName();
    public static String listUI = WebListUI.class.getCanonicalName();
    public static String comboBoxUI = WebComboBoxUI.class.getCanonicalName();
    public static String desktopPaneUI = WebDesktopPaneUI.class.getCanonicalName();
    public static String descktopIconUI = WebDesktopIconUI.class.getCanonicalName();
    public static String internalFrameUI = WebInternalFrameUI.class.getCanonicalName();
    public static String optionPaneUI = WebOptionPaneUI.class.getCanonicalName();
    public static String verticalLabelUI = WebVerticalLabelUI.class.getCanonicalName();
    public static String multiLineLabelUI = WebMultiLineLabelUI.class.getCanonicalName();
    public static Font globalTextFont = new Font("Dialog", 0, 12);
    public static Font buttonFont;
    public static Font toggleButtonFont;
    public static Font radioButtonFont;
    public static Font checkBoxFont;
    public static Font colorChooserFont;
    public static Font labelFont;
    public static Font listFont;
    public static Font menuBarFont;
    public static Font menuItemFont;
    public static Font radioButtonMenuItemFont;
    public static Font checkBoxMenuItemFont;
    public static Font menuFont;
    public static Font popupMenuFont;
    public static Font optionPaneFont;
    public static Font panelFont;
    public static Font progressBarFont;
    public static Font scrollPaneFont;
    public static Font viewportFont;
    public static Font sliderFont;
    public static Font tabbedPaneFont;
    public static Font tableFont;
    public static Font tableHeaderFont;
    public static Font titledBorderFont;
    public static Font toolBarFont;
    public static Font toolTipFont;
    public static Font treeFont;
    public static Font globalAcceleratorFont;
    public static Font menuItemAcceleratorFont;
    public static Font radioButtonMenuItemAcceleratorFont;
    public static Font checkBoxMenuItemAcceleratorFont;
    public static Font menuAcceleratorFont;
    public static Font globalTitleFont;
    public static Font internalFrameFont;
    public static Font globalEditorsFont;
    public static Font comboBoxFont;
    public static Font spinnerFont;
    public static Font textFieldFont;
    public static Font formattedTextFieldFont;
    public static Font passwordFieldFont;
    public static Font textAreaFont;
    public static Font textPaneFont;
    public static Font editorPaneFont;

    @Override
    public String getName() {
        return "WebLookAndFeel";
    }

    @Override
    public String getID() {
        return "WebLookAndFeel";
    }

    @Override
    public String getDescription() {
        return "Cross-platform stylish Look and Feel";
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return false;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    public boolean getSupportsWindowDecorations() {
        return SystemUtils.isWindows() || SystemUtils.isMac();
    }

    @Override
    protected void initClassDefaults(UIDefaults uIDefaults) {
        uIDefaults.put("LabelUI", labelUI);
        uIDefaults.put("ToolTipUI", toolTipUI);
        uIDefaults.put("ButtonUI", buttonUI);
        uIDefaults.put("ToggleButtonUI", toggleButtonUI);
        uIDefaults.put("CheckBoxUI", checkBoxUI);
        uIDefaults.put("RadioButtonUI", radioButtonUI);
        uIDefaults.put("MenuBarUI", menuBarUI);
        uIDefaults.put("MenuUI", menuUI);
        uIDefaults.put("PopupMenuUI", popupMenuUI);
        uIDefaults.put("MenuItemUI", menuItemUI);
        uIDefaults.put("CheckBoxMenuItemUI", checkBoxMenuItemUI);
        uIDefaults.put("RadioButtonMenuItemUI", radioButtonMenuItemUI);
        uIDefaults.put("PopupMenuSeparatorUI", popupMenuSeparatorUI);
        uIDefaults.put("SeparatorUI", separatorUI);
        uIDefaults.put("ScrollBarUI", scrollBarUI);
        uIDefaults.put("ScrollPaneUI", scrollPaneUI);
        uIDefaults.put("TextFieldUI", textFieldUI);
        uIDefaults.put("PasswordFieldUI", passwordFieldUI);
        uIDefaults.put("FormattedTextFieldUI", formattedTextFieldUI);
        uIDefaults.put("TextAreaUI", textAreaUI);
        uIDefaults.put("EditorPaneUI", editorPaneUI);
        uIDefaults.put("TextPaneUI", textPaneUI);
        uIDefaults.put("ToolBarUI", toolBarUI);
        uIDefaults.put("ToolBarSeparatorUI", toolBarSeparatorUI);
        uIDefaults.put("TableUI", tableUI);
        uIDefaults.put("TableHeaderUI", tableHeaderUI);
        uIDefaults.put("ColorChooserUI", colorChooserUI);
        uIDefaults.put("FileChooserUI", fileChooserUI);
        uIDefaults.put("PanelUI", panelUI);
        uIDefaults.put("ViewportUI", viewportUI);
        uIDefaults.put("RootPaneUI", rootPaneUI);
        uIDefaults.put("TabbedPaneUI", tabbedPaneUI);
        uIDefaults.put("SplitPaneUI", splitPaneUI);
        uIDefaults.put("ProgressBarUI", progressBarUI);
        uIDefaults.put("SliderUI", sliderUI);
        uIDefaults.put("SpinnerUI", spinnerUI);
        uIDefaults.put("TreeUI", treeUI);
        uIDefaults.put("ListUI", listUI);
        uIDefaults.put("ComboBoxUI", comboBoxUI);
        uIDefaults.put("DesktopPaneUI", desktopPaneUI);
        uIDefaults.put("DesktopIconUI", descktopIconUI);
        uIDefaults.put("InternalFrameUI", internalFrameUI);
        uIDefaults.put("OptionPaneUI", optionPaneUI);
    }

    @Override
    protected void initComponentDefaults(UIDefaults uIDefaults) {
        super.initComponentDefaults(uIDefaults);
        WebLookAndFeel.initializeFonts(uIDefaults);
        uIDefaults.put("OptionPane.messageAreaBorder", new SwingLazyValue("javax.swing.plaf.BorderUIResource$EmptyBorderUIResource", new Object[]{0, 0, 5, 0}));
        uIDefaults.put("html.pendingImage", StyleConstants.htmlPendingIcon);
        uIDefaults.put("html.missingImage", StyleConstants.htmlMissingIcon);
        uIDefaults.put("ScrollBar.minimumThumbSize", new Dimension(WebScrollBarStyle.minThumbWidth, WebScrollBarStyle.minThumbHeight));
        uIDefaults.put("Tree.openIcon", WebTreeUI.OPEN_ICON);
        uIDefaults.put("Tree.closedIcon", WebTreeUI.CLOSED_ICON);
        uIDefaults.put("Tree.leafIcon", WebTreeUI.LEAF_ICON);
        uIDefaults.put("Tree.collapsedIcon", WebTreeUI.EXPAND_ICON);
        uIDefaults.put("Tree.expandedIcon", WebTreeUI.COLLAPSE_ICON);
        uIDefaults.put("Tree.textForeground", Color.BLACK);
        uIDefaults.put("Tree.textBackground", StyleConstants.transparent);
        uIDefaults.put("Tree.selectionForeground", Color.BLACK);
        uIDefaults.put("Tree.selectionBackground", StyleConstants.transparent);
        uIDefaults.put("Tree.selectionBorderColor", StyleConstants.transparent);
        uIDefaults.put("Tree.rendererMargins", new InsetsUIResource(4, 4, 4, 6));
        uIDefaults.put("Tree.rendererFillBackground", Boolean.FALSE);
        uIDefaults.put("Tree.drawsFocusBorderAroundIcon", Boolean.FALSE);
        uIDefaults.put("Tree.drawDashedFocusIndicator", Boolean.FALSE);
        uIDefaults.put("MenuItem.disabledForeground", StyleConstants.disabledTextColor);
        uIDefaults.put("MenuItem.evenHeight", Boolean.TRUE);
        uIDefaults.put("Menu.menuPopupOffsetX", (Object)StyleConstants.shadeWidth);
        uIDefaults.put("Menu.menuPopupOffsetY", (Object)(-StyleConstants.shadeWidth / 2));
        uIDefaults.put("Menu.submenuPopupOffsetX", (Object)(StyleConstants.shadeWidth / 2));
        uIDefaults.put("Menu.submenuPopupOffsetY", (Object)0);
        uIDefaults.put("Table.cellNoFocusBorder", LafUtils.createWebBorder(1, 1, 1, 1));
        uIDefaults.put("Table.focusSelectedCellHighlightBorder", LafUtils.createWebBorder(1, 1, 1, 1));
        uIDefaults.put("Table.focusCellHighlightBorder", LafUtils.createWebBorder(1, 1, 1, 1));
        uIDefaults.put("Table.foreground", WebTableStyle.foreground);
        uIDefaults.put("Table.background", WebTableStyle.background);
        uIDefaults.put("Table.selectionForeground", WebTableStyle.selectionForeground);
        uIDefaults.put("Table.selectionBackground", WebTableStyle.selectionBackground);
        uIDefaults.put("TableHeader.cellBorder", LafUtils.createWebBorder(WebTableStyle.headerMargin));
        uIDefaults.put("TableHeader.focusCellBorder", LafUtils.createWebBorder(WebTableStyle.headerMargin));
        uIDefaults.put("List.cellRenderer", new UIDefaults.ActiveValue(){

            @Override
            public Object createValue(UIDefaults uIDefaults) {
                return new WebListCellRenderer.UIResource();
            }
        });
        uIDefaults.put("List.selectionForeground", WebListStyle.foreground);
        uIDefaults.put("ComboBox.selectionForeground", Color.BLACK);
        uIDefaults.put("ComboBox.squareButton", (Object)false);
        uIDefaults.put("ProgressBar.border", new SwingLazyValue("com.alee.laf.WebBorders", "getProgressBarBorder"));
        uIDefaults.put("Button.border", new SwingLazyValue("com.alee.laf.WebBorders", "getButtonBorder"));
        uIDefaults.put("TextField.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"control C", "copy-to-clipboard", "control V", "paste-from-clipboard", "control X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "control INSERT", "copy-to-clipboard", "shift INSERT", "paste-from-clipboard", "shift DELETE", "cut-to-clipboard", "control A", "select-all", "control BACK_SLASH", "unselect", "shift LEFT", "selection-backward", "shift RIGHT", "selection-forward", "control LEFT", "caret-previous-word", "control RIGHT", "caret-next-word", "control shift LEFT", "selection-previous-word", "control shift RIGHT", "selection-next-word", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "BACK_SPACE", "delete-previous", "shift BACK_SPACE", "delete-previous", "ctrl H", "delete-previous", "DELETE", "delete-next", "ctrl DELETE", "delete-next-word", "ctrl BACK_SPACE", "delete-previous-word", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "control shift O", "toggle-componentOrientation"}));
        uIDefaults.put("PasswordField.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"control C", "copy-to-clipboard", "control V", "paste-from-clipboard", "control X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "control INSERT", "copy-to-clipboard", "shift INSERT", "paste-from-clipboard", "shift DELETE", "cut-to-clipboard", "control A", "select-all", "control BACK_SLASH", "unselect", "shift LEFT", "selection-backward", "shift RIGHT", "selection-forward", "control LEFT", "caret-begin-line", "control RIGHT", "caret-end-line", "control shift LEFT", "selection-begin-line", "control shift RIGHT", "selection-end-line", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "BACK_SPACE", "delete-previous", "shift BACK_SPACE", "delete-previous", "ctrl H", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "control shift O", "toggle-componentOrientation"}));
        uIDefaults.put("FormattedTextField.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "control INSERT", "copy-to-clipboard", "shift INSERT", "paste-from-clipboard", "shift DELETE", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "BACK_SPACE", "delete-previous", "shift BACK_SPACE", "delete-previous", "ctrl H", "delete-previous", "DELETE", "delete-next", "ctrl DELETE", "delete-next-word", "ctrl BACK_SPACE", "delete-previous-word", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "ctrl BACK_SLASH", "unselect", "control shift O", "toggle-componentOrientation", "ESCAPE", "reset-field-edit", "UP", "increment", "KP_UP", "increment", "DOWN", "decrement", "KP_DOWN", "decrement"}));
        UIDefaults.LazyInputMap lazyInputMap = new UIDefaults.LazyInputMap(new Object[]{"control C", "copy-to-clipboard", "control V", "paste-from-clipboard", "control X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "control INSERT", "copy-to-clipboard", "shift INSERT", "paste-from-clipboard", "shift DELETE", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift RIGHT", "selection-forward", "control LEFT", "caret-previous-word", "control RIGHT", "caret-next-word", "control shift LEFT", "selection-previous-word", "control shift RIGHT", "selection-next-word", "control A", "select-all", "control BACK_SLASH", "unselect", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "control HOME", "caret-begin", "control END", "caret-end", "control shift HOME", "selection-begin", "control shift END", "selection-end", "UP", "caret-up", "DOWN", "caret-down", "BACK_SPACE", "delete-previous", "shift BACK_SPACE", "delete-previous", "ctrl H", "delete-previous", "DELETE", "delete-next", "ctrl DELETE", "delete-next-word", "ctrl BACK_SPACE", "delete-previous-word", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "PAGE_UP", "page-up", "PAGE_DOWN", "page-down", "shift PAGE_UP", "selection-page-up", "shift PAGE_DOWN", "selection-page-down", "ctrl shift PAGE_UP", "selection-page-left", "ctrl shift PAGE_DOWN", "selection-page-right", "shift UP", "selection-up", "shift DOWN", "selection-down", "ENTER", "insert-break", "TAB", "insert-tab", "control T", "next-link-action", "control shift T", "previous-link-action", "control SPACE", "activate-link-action", "control shift O", "toggle-componentOrientation"});
        uIDefaults.put("TextArea.focusInputMap", lazyInputMap);
        uIDefaults.put("TextPane.focusInputMap", lazyInputMap);
        uIDefaults.put("EditorPane.focusInputMap", lazyInputMap);
        uIDefaults.put("ComboBox.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "hidePopup", "PAGE_UP", "pageUpPassThrough", "PAGE_DOWN", "pageDownPassThrough", "HOME", "homePassThrough", "END", "endPassThrough", "DOWN", "selectNext", "KP_DOWN", "selectNext", "alt DOWN", "togglePopup", "alt KP_DOWN", "togglePopup", "alt UP", "togglePopup", "alt KP_UP", "togglePopup", "SPACE", "spacePopup", "ENTER", "enterPressed", "UP", "selectPrevious", "KP_UP", "selectPrevious"}));
        uIDefaults.put("FileChooser.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "cancelSelection", "F2", "editFileName", "F5", "refresh", "BACK_SPACE", "Go Up", "ENTER", "approveSelection", "ctrl ENTER", "approveSelection"}));
    }

    private static void initializeFonts(UIDefaults uIDefaults) {
        WebLookAndFeel.initializeFont(uIDefaults, "Button.font", buttonFont, globalTextFont);
        WebLookAndFeel.initializeFont(uIDefaults, "ToggleButton.font", toggleButtonFont, globalTextFont);
        WebLookAndFeel.initializeFont(uIDefaults, "RadioButton.font", radioButtonFont, globalTextFont);
        WebLookAndFeel.initializeFont(uIDefaults, "CheckBox.font", checkBoxFont, globalTextFont);
        WebLookAndFeel.initializeFont(uIDefaults, "ColorChooser.font", colorChooserFont, globalTextFont);
        WebLookAndFeel.initializeFont(uIDefaults, "ComboBox.font", comboBoxFont, globalEditorsFont);
        WebLookAndFeel.initializeFont(uIDefaults, "InternalFrame.titleFont", internalFrameFont, globalTitleFont);
        WebLookAndFeel.initializeFont(uIDefaults, "Label.font", labelFont, globalTextFont);
        WebLookAndFeel.initializeFont(uIDefaults, "List.font", listFont, globalTextFont);
        WebLookAndFeel.initializeFont(uIDefaults, "MenuBar.font", menuBarFont, globalTextFont);
        WebLookAndFeel.initializeFont(uIDefaults, "MenuItem.font", menuItemFont, globalTextFont);
        WebLookAndFeel.initializeFont(uIDefaults, "MenuItem.acceleratorFont", menuItemAcceleratorFont, globalAcceleratorFont);
        WebLookAndFeel.initializeFont(uIDefaults, "RadioButtonMenuItem.font", radioButtonMenuItemFont, globalTextFont);
        WebLookAndFeel.initializeFont(uIDefaults, "RadioButtonMenuItem.acceleratorFont", radioButtonMenuItemAcceleratorFont, globalAcceleratorFont);
        WebLookAndFeel.initializeFont(uIDefaults, "CheckBoxMenuItem.font", checkBoxMenuItemFont, globalTextFont);
        WebLookAndFeel.initializeFont(uIDefaults, "CheckBoxMenuItem.acceleratorFont", checkBoxMenuItemAcceleratorFont, globalAcceleratorFont);
        WebLookAndFeel.initializeFont(uIDefaults, "Menu.font", menuFont, globalTextFont);
        WebLookAndFeel.initializeFont(uIDefaults, "Menu.acceleratorFont", menuAcceleratorFont, globalAcceleratorFont);
        WebLookAndFeel.initializeFont(uIDefaults, "PopupMenu.font", popupMenuFont, globalTextFont);
        WebLookAndFeel.initializeFont(uIDefaults, "OptionPane.font", optionPaneFont, globalTextFont);
        WebLookAndFeel.initializeFont(uIDefaults, "Panel.font", panelFont, globalTextFont);
        WebLookAndFeel.initializeFont(uIDefaults, "ProgressBar.font", progressBarFont, globalTextFont);
        WebLookAndFeel.initializeFont(uIDefaults, "ScrollPane.font", scrollPaneFont, globalTextFont);
        WebLookAndFeel.initializeFont(uIDefaults, "Viewport.font", viewportFont, globalTextFont);
        WebLookAndFeel.initializeFont(uIDefaults, "Slider.font", sliderFont, globalTextFont);
        WebLookAndFeel.initializeFont(uIDefaults, "Spinner.font", spinnerFont, globalEditorsFont);
        WebLookAndFeel.initializeFont(uIDefaults, "TabbedPane.font", tabbedPaneFont, globalTextFont);
        WebLookAndFeel.initializeFont(uIDefaults, "Table.font", tableFont, globalTextFont);
        WebLookAndFeel.initializeFont(uIDefaults, "TableHeader.font", tableHeaderFont, globalTextFont);
        WebLookAndFeel.initializeFont(uIDefaults, "TextField.font", textFieldFont, globalEditorsFont);
        WebLookAndFeel.initializeFont(uIDefaults, "FormattedTextField.font", formattedTextFieldFont, globalEditorsFont);
        WebLookAndFeel.initializeFont(uIDefaults, "PasswordField.font", passwordFieldFont, globalEditorsFont);
        WebLookAndFeel.initializeFont(uIDefaults, "TextArea.font", textAreaFont, globalEditorsFont);
        WebLookAndFeel.initializeFont(uIDefaults, "TextPane.font", textPaneFont, globalEditorsFont);
        WebLookAndFeel.initializeFont(uIDefaults, "EditorPane.font", editorPaneFont, globalEditorsFont);
        WebLookAndFeel.initializeFont(uIDefaults, "TitledBorder.font", titledBorderFont, globalTextFont);
        WebLookAndFeel.initializeFont(uIDefaults, "ToolBar.font", toolBarFont, globalTextFont);
        WebLookAndFeel.initializeFont(uIDefaults, "ToolTip.font", toolTipFont, globalTextFont);
        WebLookAndFeel.initializeFont(uIDefaults, "Tree.font", treeFont, globalTextFont);
    }

    private static void initializeFont(UIDefaults uIDefaults, String string, Font font, Font font2) {
        uIDefaults.put(string, WebLookAndFeel.createLazyFont(font != null ? font : font2));
    }

    private static SwingLazyValue createLazyFont(Font font) {
        return new SwingLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{font.getName(), font.getStyle(), font.getSize()});
    }

    @Override
    public void initialize() {
        super.initialize();
        SwingUtils.invokeAndWaitSafely(new Runnable(){

            @Override
            public void run() {
                Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread thread, Throwable throwable) {
                        throwable.printStackTrace();
                    }
                });
            }
        });
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(altProcessor);
        UIManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("lookAndFeel")) {
                    JFrame.setDefaultLookAndFeelDecorated(decorateFrames);
                    JDialog.setDefaultLookAndFeelDecorated(decorateDialogs);
                    if (propertyChangeEvent.getNewValue() instanceof WebLookAndFeel) {
                        WebLookAndFeel.initializeManagers();
                    }
                    UIManager.removePropertyChangeListener(this);
                }
            }
        });
    }

    @Override
    public void uninitialize() {
        super.uninitialize();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventPostProcessor(altProcessor);
    }

    public static void setMnemonicHidden(boolean bl) {
        isMnemonicHidden = !UIManager.getBoolean("Button.showMnemonics") && bl;
    }

    public static boolean isMnemonicHidden() {
        if (UIManager.getBoolean("Button.showMnemonics")) {
            isMnemonicHidden = false;
        }
        return isMnemonicHidden;
    }

    public static boolean install() {
        return WebLookAndFeel.install(false);
    }

    public static boolean install(boolean bl) {
        try {
            UIManager.setLookAndFeel(new WebLookAndFeel());
            if (bl) {
                WebLookAndFeel.updateAllComponentUIs();
            }
            return true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public static boolean isInstalled() {
        return UIManager.getLookAndFeel().getClass().getCanonicalName().equals(WebLookAndFeel.class.getCanonicalName());
    }

    public static void initializeManagers() {
        VersionManager.initialize();
        LanguageManager.initialize();
        SettingsManager.initialize();
        HotkeyManager.initialize();
        FocusManager.initialize();
        TooltipManager.initialize();
        ProxyManager.initialize();
    }

    public static List<Image> getImages() {
        WebLookAndFeel.loadIcons();
        return ImageUtils.toImagesList(icons);
    }

    public static List<ImageIcon> getIcons() {
        WebLookAndFeel.loadIcons();
        return CollectionUtils.copy(icons);
    }

    public static Image getImage(int n) {
        return WebLookAndFeel.getIcon(n).getImage();
    }

    public static ImageIcon getIcon(int n) {
        WebLookAndFeel.loadIcons();
        for (ImageIcon imageIcon : icons) {
            if (imageIcon.getIconWidth() != n) continue;
            return imageIcon;
        }
        return null;
    }

    private static void loadIcons() {
        if (icons == null) {
            icons = XmlUtils.loadImagesList(WebLookAndFeel.class.getResource("resources/icons.xml"));
        }
    }

    @Override
    public Icon getDisabledIcon(JComponent jComponent, Icon icon) {
        if (icon instanceof ImageIcon) {
            return ImageUtils.createDisabledCopy((ImageIcon)icon);
        }
        return null;
    }

    public static void updateAllComponentUIs() {
        for (Window window : Window.getWindows()) {
            SwingUtilities.updateComponentTreeUI(window);
        }
    }

    @Override
    public LayoutStyle getLayoutStyle() {
        return WebLayoutStyle.INSTANCE;
    }

    public static boolean isDecorateFrames() {
        return decorateFrames;
    }

    public static void setDecorateFrames(boolean bl) {
        decorateFrames = bl;
        JFrame.setDefaultLookAndFeelDecorated(bl);
    }

    public static boolean isDecorateDialogs() {
        return decorateDialogs;
    }

    public static void setDecorateDialogs(boolean bl) {
        decorateDialogs = bl;
        JDialog.setDefaultLookAndFeelDecorated(bl);
    }

    public static void setDecorateAllWindows(boolean bl) {
        WebLookAndFeel.setDecorateFrames(bl);
        WebLookAndFeel.setDecorateDialogs(bl);
    }

    public static boolean isLeftToRight() {
        return LanguageManager.isLeftToRight();
    }

    public static ComponentOrientation getOrientation() {
        return LanguageManager.getOrientation();
    }

    public static void setOrientation(ComponentOrientation componentOrientation) {
        LanguageManager.setOrientation(componentOrientation);
    }

    public static void changeOrientation() {
        LanguageManager.changeOrientation();
    }

    static {
        globalAcceleratorFont = new Font("Dialog", 0, 11);
        globalTitleFont = new Font("Dialog", 1, 12);
        globalEditorsFont = new Font("Dialog", 0, 12);
    }
}

