/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.colorchooser;

import com.alee.extended.colorchooser.DoubleColorField;
import com.alee.extended.layout.ToolbarLayout;
import com.alee.laf.StyleConstants;
import com.alee.laf.button.WebButton;
import com.alee.laf.checkbox.WebCheckBox;
import com.alee.laf.colorchooser.ColorChooserListener;
import com.alee.laf.colorchooser.HSBColor;
import com.alee.laf.colorchooser.LineColorChooser;
import com.alee.laf.colorchooser.PaletteColorChooser;
import com.alee.laf.label.WebLabel;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.separator.WebSeparator;
import com.alee.laf.text.WebTextField;
import com.alee.managers.hotkey.Hotkey;
import com.alee.utils.CollectionUtils;
import com.alee.utils.ColorUtils;
import com.alee.utils.SwingUtils;
import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WebColorChooserPanel
extends WebPanel {
    private List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();
    private List<ColorChooserListener> colorChooserListeners = new ArrayList<ColorChooserListener>();
    private boolean showButtonsPanel = false;
    private Boolean webOnlyColors = false;
    private Color oldColor = Color.WHITE;
    private Color color = Color.WHITE;
    private int result = -2;
    private boolean adjustingText = false;
    private PaletteColorChooser palette;
    private LineColorChooser lineColorChooser;
    private DoubleColorField doubleColorField;
    private WebTextField hueField;
    private WebTextField saturationField;
    private WebTextField brightnessField;
    private WebTextField redField;
    private WebTextField greenField;
    private WebTextField blueField;
    private WebTextField hexColor;
    private WebPanel buttonsPanel;

    public WebColorChooserPanel() {
        this(false);
    }

    public WebColorChooserPanel(boolean bl) {
        this.showButtonsPanel = bl;
        this.setOpaque(false);
        this.setWebColored(false);
        this.setMargin(2, 5, 2, 5);
        this.setLayout(new TableLayout(new double[][]{{-1.0, 4.0, -2.0, 4.0, -2.0}, {-2.0, -2.0}}));
        this.palette = new PaletteColorChooser();
        this.palette.setOpaque(false);
        this.palette.setWebOnlyColors(this.isWebOnlyColors());
        final ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                WebColorChooserPanel.this.color = WebColorChooserPanel.this.palette.getColor();
                WebColorChooserPanel.this.updateColors(WebColorChooserPanel.this.color, UpdateSource.palette);
            }
        };
        this.palette.addChangeListener(changeListener);
        this.add((Component)this.palette, (Object)"0,0");
        this.lineColorChooser = new LineColorChooser();
        this.lineColorChooser.setOpaque(false);
        this.lineColorChooser.setWebOnlyColors(this.isWebOnlyColors());
        this.lineColorChooser.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                WebColorChooserPanel.this.palette.setSideColor(WebColorChooserPanel.this.lineColorChooser.getColor());
            }
        });
        this.add((Component)this.lineColorChooser, (Object)"2,0");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new TableLayout(new double[][]{{-2.0, 4.0, -1.0}, {3.0, -1.0, 5.0, -2.0, 4.0, -2.0, 1.0, -2.0, 1.0, -2.0, 1.0, -2.0, 3.0}}));
        jPanel.setOpaque(false);
        this.add((Component)jPanel, (Object)"4,0");
        this.doubleColorField = new DoubleColorField(){

            @Override
            protected void oldColorPressed() {
                WebColorChooserPanel.this.setColor(WebColorChooserPanel.this.doubleColorField.getOldColor());
            }
        };
        this.updateDoubleColorField(this.color);
        this.doubleColorField.setOldColor(this.oldColor);
        jPanel.add((Component)this.doubleColorField, "0,1,2,3");
        jPanel.add((Component)new WebSeparator(0), "0,5,2,5");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new TableLayout(new double[][]{{-1.0, 5.0, -2.0, 4.0, -2.0}, {-2.0, 0.0, -2.0, 0.0, -2.0, 1.0, -2.0, 1.0, -2.0, 0.0, -2.0, 0.0, -2.0}}));
        jPanel2.setOpaque(false);
        jPanel.add((Component)jPanel2, "0,7,2,7");
        WebLabel webLabel = new WebLabel("H:");
        webLabel.setDrawShade(true);
        jPanel2.add((Component)webLabel, "0,0");
        this.hueField = new WebTextField();
        jPanel2.add((Component)this.hueField, "2,0");
        WebLabel webLabel2 = new WebLabel("\u00b0");
        webLabel2.setDrawShade(true);
        jPanel2.add((Component)webLabel2, "4,0");
        WebLabel webLabel3 = new WebLabel("S:");
        webLabel3.setDrawShade(true);
        jPanel2.add((Component)webLabel3, "0,2");
        this.saturationField = new WebTextField();
        jPanel2.add((Component)this.saturationField, "2,2");
        WebLabel webLabel4 = new WebLabel("%");
        webLabel4.setDrawShade(true);
        jPanel2.add((Component)webLabel4, "4,2");
        WebLabel webLabel5 = new WebLabel("B:");
        webLabel5.setDrawShade(true);
        jPanel2.add((Component)webLabel5, "0,4");
        this.brightnessField = new WebTextField();
        jPanel2.add((Component)this.brightnessField, "2,4");
        WebLabel webLabel6 = new WebLabel("%");
        webLabel6.setDrawShade(true);
        jPanel2.add((Component)webLabel6, "4,4");
        CaretListener caretListener = new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                if (!WebColorChooserPanel.this.adjustingText) {
                    WebColorChooserPanel.this.palette.removeChangeListener(changeListener);
                    try {
                        float f = (float)Integer.parseInt(WebColorChooserPanel.this.hueField.getText()) / 360.0f;
                        float f2 = (float)Integer.parseInt(WebColorChooserPanel.this.saturationField.getText()) / 100.0f;
                        float f3 = (float)Integer.parseInt(WebColorChooserPanel.this.brightnessField.getText()) / 100.0f;
                        WebColorChooserPanel.this.color = new HSBColor(f, f2, f3).getColor();
                        WebColorChooserPanel.this.updateColors(WebColorChooserPanel.this.color, UpdateSource.hsbField);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    WebColorChooserPanel.this.palette.addChangeListener(changeListener);
                }
            }
        };
        this.hueField.addCaretListener(caretListener);
        this.saturationField.addCaretListener(caretListener);
        this.brightnessField.addCaretListener(caretListener);
        jPanel2.add((Component)new WebSeparator(0), "0,6,4,6");
        WebLabel webLabel7 = new WebLabel("R:");
        webLabel7.setDrawShade(true);
        jPanel2.add((Component)webLabel7, "0,8");
        this.redField = new WebTextField();
        this.redField.setColumns(3);
        jPanel2.add((Component)this.redField, "2,8");
        WebLabel webLabel8 = new WebLabel("G:");
        webLabel8.setDrawShade(true);
        jPanel2.add((Component)webLabel8, "0,10");
        this.greenField = new WebTextField();
        this.greenField.setColumns(3);
        jPanel2.add((Component)this.greenField, "2,10");
        WebLabel webLabel9 = new WebLabel("B:");
        webLabel9.setDrawShade(true);
        jPanel2.add((Component)webLabel9, "0,12");
        this.blueField = new WebTextField();
        this.blueField.setColumns(3);
        jPanel2.add((Component)this.blueField, "2,12");
        CaretListener caretListener2 = new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                if (!WebColorChooserPanel.this.adjustingText) {
                    WebColorChooserPanel.this.palette.removeChangeListener(changeListener);
                    try {
                        int n = Integer.parseInt(WebColorChooserPanel.this.redField.getText());
                        int n2 = Integer.parseInt(WebColorChooserPanel.this.greenField.getText());
                        int n3 = Integer.parseInt(WebColorChooserPanel.this.blueField.getText());
                        WebColorChooserPanel.this.color = new Color(n, n2, n3);
                        WebColorChooserPanel.this.updateColors(WebColorChooserPanel.this.color, UpdateSource.rgbField);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    WebColorChooserPanel.this.palette.addChangeListener(changeListener);
                }
            }
        };
        this.redField.addCaretListener(caretListener2);
        this.greenField.addCaretListener(caretListener2);
        this.blueField.addCaretListener(caretListener2);
        jPanel.add((Component)new WebSeparator(0), "0,9,2,9");
        WebLabel webLabel10 = new WebLabel("#");
        webLabel10.setDrawShade(true);
        jPanel.add((Component)webLabel10, "0,11");
        this.hexColor = new WebTextField();
        this.updateHexField(this.color);
        CaretListener caretListener3 = new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                if (!WebColorChooserPanel.this.adjustingText) {
                    WebColorChooserPanel.this.palette.removeChangeListener(changeListener);
                    try {
                        WebColorChooserPanel.this.color = ColorUtils.parseHexColor(WebColorChooserPanel.this.hexColor.getText());
                        WebColorChooserPanel.this.updateColors(WebColorChooserPanel.this.color, UpdateSource.hexField);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    WebColorChooserPanel.this.palette.addChangeListener(changeListener);
                }
            }
        };
        this.hexColor.addCaretListener(caretListener3);
        jPanel.add((Component)this.hexColor, "2,11");
        if (bl) {
            this.add((Component)this.getButtonsPanel(), (Object)"0,1,4,1");
        }
        this.setOldColor(this.oldColor);
        this.setColor(this.color);
    }

    private WebPanel getButtonsPanel() {
        if (this.buttonsPanel == null) {
            this.buttonsPanel = this.createButtonsPanel();
        }
        return this.buttonsPanel;
    }

    private WebPanel createButtonsPanel() {
        WebPanel webPanel = new WebPanel(new ToolbarLayout(2, 0));
        webPanel.setOpaque(false);
        webPanel.setMargin(5, 0, 3, 0);
        final WebCheckBox webCheckBox = new WebCheckBox();
        webCheckBox.setLanguage("weblaf.colorchooser.webonly", new Object[0]);
        webCheckBox.setSelected(this.isWebOnlyColors());
        webCheckBox.setMargin(0, 5, 0, 5);
        webCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebColorChooserPanel.this.setWebOnlyColors(webCheckBox.isSelected());
            }
        });
        webPanel.add((Component)webCheckBox);
        final WebButton webButton = new WebButton();
        webButton.setLanguage("weblaf.colorchooser.choose", new Object[0]);
        webButton.addHotkey(this, Hotkey.ENTER);
        if (StyleConstants.highlightControlButtons) {
            webButton.setShineColor(StyleConstants.greenHighlight);
        }
        webButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebColorChooserPanel.this.result = 0;
                WebColorChooserPanel.this.fireOkPressed(actionEvent);
            }
        });
        this.palette.getColorChooser().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    webButton.doClick(0);
                }
            }
        });
        webPanel.add((Component)webButton, (Object)"END");
        WebButton webButton2 = new WebButton();
        webButton2.setLanguage("weblaf.colorchooser.reset", new Object[0]);
        webButton2.addHotkey(this, Hotkey.ALT_R);
        if (StyleConstants.highlightControlButtons) {
            webButton2.setShineColor(StyleConstants.blueHighlight);
        }
        webButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebColorChooserPanel.this.setColor(WebColorChooserPanel.this.getOldColor());
                WebColorChooserPanel.this.fireResetPressed(actionEvent);
            }
        });
        webPanel.add((Component)webButton2, (Object)"END");
        WebButton webButton3 = new WebButton();
        webButton3.setLanguage("weblaf.colorchooser.cancel", new Object[0]);
        webButton3.addHotkey(this, Hotkey.ESCAPE);
        if (StyleConstants.highlightControlButtons) {
            webButton3.setShineColor(StyleConstants.redHighlight);
        }
        webButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebColorChooserPanel.this.result = 1;
                WebColorChooserPanel.this.setColor(WebColorChooserPanel.this.getOldColor());
                WebColorChooserPanel.this.fireCancelPressed(actionEvent);
            }
        });
        webPanel.add((Component)webButton3, (Object)"END");
        SwingUtils.equalizeComponentsSize(webButton, webButton2, webButton3);
        return webPanel;
    }

    public boolean isShowButtonsPanel() {
        return this.showButtonsPanel;
    }

    public void setShowButtonsPanel(boolean bl) {
        if (this.showButtonsPanel != bl) {
            this.showButtonsPanel = bl;
            if (bl) {
                this.add((Component)this.getButtonsPanel(), (Object)"0,1,4,1");
            } else {
                this.remove(this.getButtonsPanel());
            }
            this.revalidate();
        }
    }

    public boolean isWebOnlyColors() {
        return this.webOnlyColors;
    }

    public void setWebOnlyColors(boolean bl) {
        this.webOnlyColors = bl;
        this.palette.setWebOnlyColors(bl);
        this.lineColorChooser.setWebOnlyColors(bl);
    }

    private void updateColors(Color color, UpdateSource updateSource) {
        this.adjustingText = true;
        if (!updateSource.equals((Object)UpdateSource.palette)) {
            this.updateView(color);
        }
        if (!updateSource.equals((Object)UpdateSource.doubleField)) {
            this.updateDoubleColorField(color);
        }
        if (!updateSource.equals((Object)UpdateSource.hsbField)) {
            this.updateHSBFields(color);
        }
        if (!updateSource.equals((Object)UpdateSource.rgbField)) {
            this.updateRGBFields(color);
        }
        if (!updateSource.equals((Object)UpdateSource.hexField)) {
            this.updateHexField(color);
        }
        this.adjustingText = false;
        this.fireStateChanged();
    }

    private void updateView(Color color) {
        this.lineColorChooser.setColor(color);
        this.palette.setColor(color);
    }

    private void updateDoubleColorField(Color color) {
        this.doubleColorField.setNewColor(color);
    }

    private void updateHexField(Color color) {
        this.hexColor.setText(ColorUtils.getHexColor(color));
    }

    private void updateRGBFields(Color color) {
        this.redField.setText("" + color.getRed());
        this.greenField.setText("" + color.getGreen());
        this.blueField.setText("" + color.getBlue());
    }

    private void updateHSBFields(Color color) {
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        this.hueField.setText("" + this.lineColorChooser.getHue());
        this.saturationField.setText("" + Math.round(100.0f * fArray[1]));
        this.brightnessField.setText("" + Math.round(100.0f * fArray[2]));
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        this.setOldColor(color);
        this.updateColors(color, UpdateSource.outer);
    }

    public Color getOldColor() {
        return this.oldColor;
    }

    public void setOldColor(Color color) {
        this.oldColor = color;
        this.doubleColorField.setOldColor(color);
    }

    public void resetResult() {
        this.setResult(-2);
    }

    public void setResult(int n) {
        this.result = n;
    }

    public int getResult() {
        return this.result;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    private void fireStateChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : CollectionUtils.copy(this.changeListeners)) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public void addColorChooserListener(ColorChooserListener colorChooserListener) {
        this.colorChooserListeners.add(colorChooserListener);
    }

    public void removeColorChooserListener(ColorChooserListener colorChooserListener) {
        this.colorChooserListeners.remove(colorChooserListener);
    }

    private void fireOkPressed(ActionEvent actionEvent) {
        for (ColorChooserListener colorChooserListener : CollectionUtils.copy(this.colorChooserListeners)) {
            colorChooserListener.okPressed(actionEvent);
        }
    }

    private void fireResetPressed(ActionEvent actionEvent) {
        for (ColorChooserListener colorChooserListener : CollectionUtils.copy(this.colorChooserListeners)) {
            colorChooserListener.resetPressed(actionEvent);
        }
    }

    private void fireCancelPressed(ActionEvent actionEvent) {
        for (ColorChooserListener colorChooserListener : CollectionUtils.copy(this.colorChooserListeners)) {
            colorChooserListener.cancelPressed(actionEvent);
        }
    }

    private static enum UpdateSource {
        outer,
        palette,
        doubleField,
        hsbField,
        rgbField,
        hexField;

    }
}

