/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.desktoppane;

import com.alee.laf.StyleConstants;
import com.alee.laf.desktoppane.WebInternalFrameTitlePane;
import com.alee.managers.focus.FocusManager;
import com.alee.managers.focus.FocusTracker;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.RoundRectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public class WebInternalFrameUI
extends BasicInternalFrameUI
implements FocusTracker {
    private int sideSpacing = 1;
    private boolean focused = false;

    public WebInternalFrameUI(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new WebInternalFrameUI((JInternalFrame)jComponent);
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        SwingUtils.setOrientation(jComponent);
        jComponent.setOpaque(false);
        jComponent.setBackground(new Color(90, 90, 90, 220));
        jComponent.setBorder(BorderFactory.createEmptyBorder());
        FocusManager.registerFocusTracker(this);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        FocusManager.unregisterFocusTracker(this);
        super.uninstallUI(jComponent);
    }

    @Override
    public boolean isTrackingEnabled() {
        return this.frame.isShowing();
    }

    @Override
    public Component getTrackedComponent() {
        return this.frame;
    }

    @Override
    public boolean isUniteWithChilds() {
        return true;
    }

    @Override
    public boolean isListenGlobalChange() {
        return false;
    }

    @Override
    public void focusChanged(boolean bl) {
        this.focused = bl;
        this.frame.repaint();
    }

    @Override
    protected JComponent createNorthPane(JInternalFrame jInternalFrame) {
        this.titlePane = new WebInternalFrameTitlePane(jInternalFrame);
        return this.titlePane;
    }

    @Override
    protected JComponent createWestPane(JInternalFrame jInternalFrame) {
        return new JComponent(){
            {
                this.setOpaque(false);
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(4 + WebInternalFrameUI.this.sideSpacing, 0);
            }
        };
    }

    @Override
    protected JComponent createEastPane(JInternalFrame jInternalFrame) {
        return new JComponent(){
            {
                this.setOpaque(false);
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(4 + WebInternalFrameUI.this.sideSpacing, 0);
            }
        };
    }

    @Override
    protected JComponent createSouthPane(JInternalFrame jInternalFrame) {
        return new JComponent(){
            {
                this.setOpaque(false);
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(0, 4 + WebInternalFrameUI.this.sideSpacing);
            }
        };
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = LafUtils.setupAntialias(graphics2D);
        Insets insets = jComponent.getInsets();
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(insets.left + 3 + this.sideSpacing, insets.top + this.titlePane.getHeight() - 1, jComponent.getWidth() - 1 - insets.left - 3 - this.sideSpacing - insets.right - 3 - this.sideSpacing, jComponent.getHeight() - 1 - insets.top - this.titlePane.getHeight() + 1 - insets.bottom - 3 - this.sideSpacing, (StyleConstants.bigRound - 1) * 2, (StyleConstants.bigRound - 1) * 2);
        LafUtils.drawWebStyle(graphics2D, jComponent, jComponent.isEnabled() && this.focused ? StyleConstants.fieldFocusColor : StyleConstants.shadeColor, StyleConstants.shadeWidth, StyleConstants.bigRound, true, false);
        graphics2D.setPaint(Color.GRAY);
        graphics2D.draw(double_);
        LafUtils.restoreAntialias(graphics2D, object);
    }
}

