/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.list;

import com.alee.laf.WebLookAndFeel;
import com.alee.laf.list.WebListCellRenderer;
import com.alee.laf.list.WebListUI;
import com.alee.laf.list.editor.DefaultListCellEditor;
import com.alee.laf.list.editor.ListCellEditor;
import com.alee.laf.list.editor.ListEditListener;
import com.alee.utils.CollectionUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.swing.ListRolloverSelectionAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;

public class WebList
extends JList {
    private List<ListEditListener> editListeners = new ArrayList<ListEditListener>();
    private boolean editable = false;
    private ListCellEditor listCellEditor = null;
    private int editedCell = -1;

    public WebList() {
    }

    public WebList(Vector vector) {
        super(vector);
    }

    public WebList(Object[] objectArray) {
        super(objectArray);
    }

    public WebList(ListModel listModel) {
        super(listModel);
    }

    public WebListCellRenderer getWebListCellRenderer() {
        ListCellRenderer listCellRenderer = this.getCellRenderer();
        return listCellRenderer instanceof WebListCellRenderer ? (WebListCellRenderer)listCellRenderer : null;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
        if (bl && this.listCellEditor == null) {
            this.setCellEditor(this.createDefaultCellEditor());
        }
    }

    public boolean isRolloverSelectionEnabled() {
        return ListRolloverSelectionAdapter.isInstalled(this);
    }

    public void setRolloverSelectionEnabled(boolean bl) {
        if (bl) {
            if (!this.isRolloverSelectionEnabled()) {
                this.setHighlightRolloverCell(false);
                ListRolloverSelectionAdapter.install(this);
            }
        } else if (this.isRolloverSelectionEnabled()) {
            ListRolloverSelectionAdapter.uninstall(this);
        }
    }

    public void setCellEditor(ListCellEditor listCellEditor) {
        this.removeCellEditor();
        this.listCellEditor = listCellEditor;
        listCellEditor.install(this);
    }

    protected ListCellEditor createDefaultCellEditor() {
        return new DefaultListCellEditor();
    }

    public ListCellEditor getCellEditor() {
        return this.listCellEditor;
    }

    public void removeCellEditor() {
        if (this.listCellEditor != null) {
            this.listCellEditor.uninstall(this);
            this.listCellEditor = null;
        }
    }

    public void editSelectedCell() {
        this.editCell(this.getSelectedIndex());
    }

    public void editCell(int n) {
        if (n != -1 && this.getCellEditor() != null) {
            this.setSelectedIndex(n);
            this.getCellEditor().startEdit(this, n);
        }
    }

    public int getModelSize() {
        return this.getModel().getSize();
    }

    public boolean isHighlightRolloverCell() {
        return this.getWebUI().isHighlightRolloverCell();
    }

    public void setHighlightRolloverCell(boolean bl) {
        this.getWebUI().setHighlightRolloverCell(bl);
    }

    public int getSelectionRound() {
        return this.getWebUI().getSelectionRound();
    }

    public void setSelectionRound(int n) {
        this.getWebUI().setSelectionRound(n);
    }

    public int getSelectionShadeWidth() {
        return this.getWebUI().getSelectionShadeWidth();
    }

    public void setSelectionShadeWidth(int n) {
        this.getWebUI().setSelectionShadeWidth(n);
    }

    public boolean isAutoScrollToSelection() {
        return this.getWebUI().isAutoScrollToSelection();
    }

    public void setAutoScrollToSelection(boolean bl) {
        this.getWebUI().setAutoScrollToSelection(bl);
    }

    public WebListUI getWebUI() {
        return (WebListUI)this.getUI();
    }

    @Override
    public void updateUI() {
        if (this.getUI() == null || !(this.getUI() instanceof WebListUI)) {
            try {
                this.setUI((WebListUI)ReflectUtils.createInstance(WebLookAndFeel.listUI, new Object[0]));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                this.setUI(new WebListUI());
            }
        } else {
            this.setUI(this.getUI());
        }
    }

    public void repaint(int n) {
        this.repaint(this.getCellBounds(n, n));
    }

    public void repaint(int n, int n2) {
        this.repaint(this.getCellBounds(n, n2));
    }

    public int getEditedCell() {
        return this.editedCell;
    }

    public void addListEditListener(ListEditListener listEditListener) {
        this.editListeners.add(listEditListener);
    }

    public void removeListEditListener(ListEditListener listEditListener) {
        this.editListeners.remove(listEditListener);
    }

    public void fireEditStarted(int n) {
        this.editedCell = n;
        for (ListEditListener listEditListener : CollectionUtils.copy(this.editListeners)) {
            listEditListener.editStarted(n);
        }
    }

    public void fireEditFinished(int n, Object object, Object object2) {
        this.editedCell = -1;
        for (ListEditListener listEditListener : CollectionUtils.copy(this.editListeners)) {
            listEditListener.editFinished(n, object, object2);
        }
    }

    public void fireEditCancelled(int n) {
        this.editedCell = -1;
        for (ListEditListener listEditListener : CollectionUtils.copy(this.editListeners)) {
            listEditListener.editCancelled(n);
        }
    }
}

