/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.scroll;

import com.alee.laf.StyleConstants;
import com.alee.laf.scroll.WebScrollPaneCorner;
import com.alee.laf.scroll.WebScrollPaneStyle;
import com.alee.managers.focus.FocusManager;
import com.alee.managers.focus.FocusTracker;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.ShapeProvider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollPaneUI;

public class WebScrollPaneUI
extends BasicScrollPaneUI
implements ShapeProvider,
FocusTracker {
    private boolean drawBorder = WebScrollPaneStyle.drawBorder;
    private Color borderColor = WebScrollPaneStyle.borderColor;
    private Color darkBorder = WebScrollPaneStyle.darkBorder;
    private int round = WebScrollPaneStyle.round;
    private int shadeWidth = WebScrollPaneStyle.shadeWidth;
    private Insets margin = WebScrollPaneStyle.margin;
    private boolean drawFocus = WebScrollPaneStyle.drawFocus;
    private boolean drawBackground = WebScrollPaneStyle.drawBackground;
    private boolean focusOwner = false;
    private WebScrollPaneCorner corner;
    private PropertyChangeListener propertyChangeListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WebScrollPaneUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        SwingUtils.setOrientation(this.scrollpane);
        this.scrollpane.setOpaque(false);
        this.scrollpane.setBackground(StyleConstants.backgroundColor);
        this.updateBorder(this.scrollpane);
        this.scrollpane.setCorner("LOWER_TRAILING_CORNER", this.getCornerComponent());
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WebScrollPaneUI.this.scrollpane.setCorner("LOWER_TRAILING_CORNER", WebScrollPaneUI.this.getCornerComponent());
            }
        };
        this.scrollpane.addPropertyChangeListener("componentOrientation", this.propertyChangeListener);
        FocusManager.registerFocusTracker(this);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.scrollpane.removePropertyChangeListener("componentOrientation", this.propertyChangeListener);
        this.scrollpane.remove(this.getCornerComponent());
        FocusManager.unregisterFocusTracker(this);
        super.uninstallUI(jComponent);
    }

    private WebScrollPaneCorner getCornerComponent() {
        if (this.corner == null) {
            this.corner = new WebScrollPaneCorner();
        }
        return this.corner;
    }

    @Override
    public Shape provideShape() {
        return LafUtils.getWebBorderShape(this.scrollpane, this.getShadeWidth(), this.getRound());
    }

    private void updateBorder(JComponent jComponent) {
        if (jComponent != null) {
            if (this.drawBorder) {
                jComponent.setBorder(BorderFactory.createEmptyBorder(this.shadeWidth + 1 + this.margin.top, this.shadeWidth + 1 + this.margin.left, this.shadeWidth + 1 + this.margin.bottom, this.shadeWidth + 1 + this.margin.right));
            } else {
                jComponent.setBorder(BorderFactory.createEmptyBorder(this.margin.top, this.margin.left, this.margin.bottom, this.margin.right));
            }
        }
    }

    @Override
    public boolean isTrackingEnabled() {
        return this.drawBorder && this.drawFocus;
    }

    @Override
    public Component getTrackedComponent() {
        return this.scrollpane;
    }

    @Override
    public boolean isUniteWithChilds() {
        return true;
    }

    @Override
    public boolean isListenGlobalChange() {
        return false;
    }

    @Override
    public void focusChanged(boolean bl) {
        this.focusOwner = bl;
        if (this.scrollpane != null) {
            this.scrollpane.repaint();
        }
    }

    public boolean isDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean bl) {
        this.drawBorder = bl;
        this.updateBorder(this.scrollpane);
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int n) {
        this.round = n;
    }

    public int getShadeWidth() {
        return this.shadeWidth;
    }

    public void setShadeWidth(int n) {
        this.shadeWidth = n;
        this.updateBorder(this.scrollpane);
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets insets) {
        this.margin = insets;
        this.updateBorder(this.scrollpane);
    }

    public boolean isDrawFocus() {
        return this.drawFocus;
    }

    public void setDrawFocus(boolean bl) {
        this.drawFocus = bl;
    }

    public boolean isDrawBackground() {
        return this.drawBackground;
    }

    public void setDrawBackground(boolean bl) {
        this.drawBackground = bl;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public Color getDarkBorder() {
        return this.darkBorder;
    }

    public void setDarkBorder(Color color) {
        this.darkBorder = color;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        if (this.drawBorder) {
            LafUtils.drawWebStyle((Graphics2D)graphics, jComponent, this.drawFocus && this.focusOwner ? StyleConstants.fieldFocusColor : StyleConstants.shadeColor, this.shadeWidth, this.round, this.drawBackground, false);
        }
        super.paint(graphics, jComponent);
    }
}

