/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.text;

import com.alee.laf.StyleConstants;
import com.alee.utils.LafUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.View;

public class WebHighlighter
extends LayeredHighlighter {
    private static final Highlighter.Highlight[] noHighlights = new Highlighter.Highlight[0];
    private Vector highlights = new Vector();
    private JTextComponent component;
    private boolean drawsLayeredHighlights = true;
    private SafeDamager safeDamager = new SafeDamager();

    @Override
    public void paint(Graphics graphics) {
        int n = this.highlights.size();
        for (int i = 0; i < n; ++i) {
            HighlightInfo highlightInfo = (HighlightInfo)this.highlights.elementAt(i);
            if (highlightInfo instanceof LayeredHighlightInfo) continue;
            Rectangle rectangle = this.component.getBounds();
            Insets insets = this.component.getInsets();
            rectangle.x = insets.left;
            rectangle.y = insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
            while (i < n) {
                highlightInfo = (HighlightInfo)this.highlights.elementAt(i);
                if (!(highlightInfo instanceof LayeredHighlightInfo)) {
                    Highlighter.HighlightPainter highlightPainter = highlightInfo.getPainter();
                    highlightPainter.paint(graphics, highlightInfo.getStartOffset(), highlightInfo.getEndOffset(), rectangle, this.component);
                }
                ++i;
            }
        }
    }

    @Override
    public void install(JTextComponent jTextComponent) {
        this.component = jTextComponent;
        this.removeAllHighlights();
    }

    @Override
    public void deinstall(JTextComponent jTextComponent) {
        this.component = null;
    }

    @Override
    public Object addHighlight(int n, int n2, Highlighter.HighlightPainter highlightPainter) throws BadLocationException {
        Document document = this.component.getDocument();
        HighlightInfo highlightInfo = this.getDrawsLayeredHighlights() && highlightPainter instanceof LayeredHighlighter.LayerPainter ? new LayeredHighlightInfo() : new HighlightInfo();
        highlightInfo.painter = highlightPainter;
        highlightInfo.p0 = document.createPosition(n);
        highlightInfo.p1 = document.createPosition(n2);
        this.highlights.addElement(highlightInfo);
        this.safeDamageRange(n, n2);
        return highlightInfo;
    }

    @Override
    public void removeHighlight(Object object) {
        if (object instanceof LayeredHighlightInfo) {
            LayeredHighlightInfo layeredHighlightInfo = (LayeredHighlightInfo)object;
            if (layeredHighlightInfo.width > 0 && layeredHighlightInfo.height > 0) {
                this.component.repaint(layeredHighlightInfo.x, layeredHighlightInfo.y, layeredHighlightInfo.width, layeredHighlightInfo.height);
            }
        } else {
            HighlightInfo highlightInfo = (HighlightInfo)object;
            this.safeDamageRange(highlightInfo.p0, highlightInfo.p1);
        }
        this.highlights.removeElement(object);
    }

    @Override
    public void removeAllHighlights() {
        int n;
        TextUI textUI = this.component.getUI();
        if (this.getDrawsLayeredHighlights()) {
            int n2 = this.highlights.size();
            if (n2 != 0) {
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                int n7 = -1;
                int n8 = -1;
                for (int i = 0; i < n2; ++i) {
                    HighlightInfo highlightInfo = (HighlightInfo)this.highlights.elementAt(i);
                    if (highlightInfo instanceof LayeredHighlightInfo) {
                        LayeredHighlightInfo layeredHighlightInfo = (LayeredHighlightInfo)highlightInfo;
                        n3 = Math.min(n3, layeredHighlightInfo.x);
                        n4 = Math.min(n4, layeredHighlightInfo.y);
                        n5 = Math.max(n5, layeredHighlightInfo.x + layeredHighlightInfo.width);
                        n6 = Math.max(n6, layeredHighlightInfo.y + layeredHighlightInfo.height);
                        continue;
                    }
                    if (n7 == -1) {
                        n7 = highlightInfo.p0.getOffset();
                        n8 = highlightInfo.p1.getOffset();
                        continue;
                    }
                    n7 = Math.min(n7, highlightInfo.p0.getOffset());
                    n8 = Math.max(n8, highlightInfo.p1.getOffset());
                }
                if (n3 != n5 && n4 != n6) {
                    this.component.repaint(n3, n4, n5 - n3, n6 - n4);
                }
                if (n7 != -1) {
                    try {
                        this.safeDamageRange(n7, n8);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                this.highlights.removeAllElements();
            }
        } else if (textUI != null && (n = this.highlights.size()) != 0) {
            int n9 = Integer.MAX_VALUE;
            int n10 = 0;
            for (int i = 0; i < n; ++i) {
                HighlightInfo highlightInfo = (HighlightInfo)this.highlights.elementAt(i);
                n9 = Math.min(n9, highlightInfo.p0.getOffset());
                n10 = Math.max(n10, highlightInfo.p1.getOffset());
            }
            try {
                this.safeDamageRange(n9, n10);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            this.highlights.removeAllElements();
        }
    }

    @Override
    public void changeHighlight(Object object, int n, int n2) throws BadLocationException {
        Document document = this.component.getDocument();
        if (object instanceof LayeredHighlightInfo) {
            LayeredHighlightInfo layeredHighlightInfo = (LayeredHighlightInfo)object;
            if (layeredHighlightInfo.width > 0 && layeredHighlightInfo.height > 0) {
                this.component.repaint(layeredHighlightInfo.x, layeredHighlightInfo.y, layeredHighlightInfo.width, layeredHighlightInfo.height);
            }
            layeredHighlightInfo.height = 0;
            layeredHighlightInfo.width = 0;
            layeredHighlightInfo.p0 = document.createPosition(n);
            layeredHighlightInfo.p1 = document.createPosition(n2);
            this.safeDamageRange(Math.min(n, n2), Math.max(n, n2));
        } else {
            HighlightInfo highlightInfo = (HighlightInfo)object;
            int n3 = highlightInfo.p0.getOffset();
            int n4 = highlightInfo.p1.getOffset();
            if (n == n3) {
                this.safeDamageRange(Math.min(n4, n2), Math.max(n4, n2));
            } else if (n2 == n4) {
                this.safeDamageRange(Math.min(n, n3), Math.max(n, n3));
            } else {
                this.safeDamageRange(n3, n4);
                this.safeDamageRange(n, n2);
            }
            highlightInfo.p0 = document.createPosition(n);
            highlightInfo.p1 = document.createPosition(n2);
        }
    }

    @Override
    public Highlighter.Highlight[] getHighlights() {
        int n = this.highlights.size();
        if (n == 0) {
            return noHighlights;
        }
        Object[] objectArray = new Highlighter.Highlight[n];
        this.highlights.copyInto(objectArray);
        return objectArray;
    }

    @Override
    public void paintLayeredHighlights(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view) {
        for (int i = this.highlights.size() - 1; i >= 0; --i) {
            Object e = this.highlights.elementAt(i);
            if (!(e instanceof LayeredHighlightInfo)) continue;
            LayeredHighlightInfo layeredHighlightInfo = (LayeredHighlightInfo)e;
            int n3 = layeredHighlightInfo.getStartOffset();
            int n4 = layeredHighlightInfo.getEndOffset();
            if ((n >= n3 || n2 <= n3) && (n < n3 || n >= n4)) continue;
            layeredHighlightInfo.paintLayeredHighlights(graphics, n, n2, shape, jTextComponent, view);
        }
    }

    private void safeDamageRange(Position position, Position position2) {
        this.safeDamager.damageRange(position, position2);
    }

    private void safeDamageRange(int n, int n2) throws BadLocationException {
        Document document = this.component.getDocument();
        this.safeDamageRange(document.createPosition(n), document.createPosition(n2));
    }

    public void setDrawsLayeredHighlights(boolean bl) {
        this.drawsLayeredHighlights = bl;
    }

    public boolean getDrawsLayeredHighlights() {
        return this.drawsLayeredHighlights;
    }

    class SafeDamager
    implements Runnable {
        private Vector p0 = new Vector(10);
        private Vector p1 = new Vector(10);
        private Document lastDoc = null;

        SafeDamager() {
        }

        @Override
        public synchronized void run() {
            TextUI textUI;
            if (WebHighlighter.this.component != null && (textUI = WebHighlighter.this.component.getUI()) != null && this.lastDoc == WebHighlighter.this.component.getDocument()) {
                int n = this.p0.size();
                for (int i = 0; i < n; ++i) {
                    textUI.damageRange(WebHighlighter.this.component, ((Position)this.p0.get(i)).getOffset(), ((Position)this.p1.get(i)).getOffset());
                }
            }
            this.p0.clear();
            this.p1.clear();
            this.lastDoc = null;
        }

        public synchronized void damageRange(Position position, Position position2) {
            if (WebHighlighter.this.component == null) {
                this.p0.clear();
                this.lastDoc = null;
                return;
            }
            boolean bl = this.p0.isEmpty();
            Document document = WebHighlighter.this.component.getDocument();
            if (document != this.lastDoc) {
                if (!this.p0.isEmpty()) {
                    this.p0.clear();
                    this.p1.clear();
                }
                this.lastDoc = document;
            }
            this.p0.add(position);
            this.p1.add(position2);
            if (bl) {
                SwingUtilities.invokeLater(this);
            }
        }
    }

    class LayeredHighlightInfo
    extends HighlightInfo {
        int x;
        int y;
        int width;
        int height;

        LayeredHighlightInfo() {
        }

        void union(Shape shape) {
            if (shape == null) {
                return;
            }
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            if (this.width == 0 || this.height == 0) {
                this.x = rectangle.x;
                this.y = rectangle.y;
                this.width = rectangle.width;
                this.height = rectangle.height;
            } else {
                this.width = Math.max(this.x + this.width, rectangle.x + rectangle.width);
                this.height = Math.max(this.y + this.height, rectangle.y + rectangle.height);
                this.x = Math.min(this.x, rectangle.x);
                this.width -= this.x;
                this.y = Math.min(this.y, rectangle.y);
                this.height -= this.y;
            }
        }

        void paintLayeredHighlights(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view) {
            int n3 = this.getStartOffset();
            int n4 = this.getEndOffset();
            n = Math.max(n3, n);
            n2 = Math.min(n4, n2);
            Graphics2D graphics2D = (Graphics2D)graphics;
            Object object = LafUtils.setupAntialias(graphics2D);
            Shape shape2 = graphics2D.getClip();
            try {
                Insets insets = jTextComponent.getInsets();
                Area area = new Area(new Rectangle(insets.left - 2, insets.top - 2, jTextComponent.getWidth() - insets.left - insets.right + 4, jTextComponent.getHeight() - insets.top - insets.bottom + 4));
                area.intersect(new Area(jTextComponent.getVisibleRect()));
                graphics2D.setClip(area);
                Rectangle rectangle = (Rectangle)view.modelToView(n, Position.Bias.Forward, n2, Position.Bias.Backward, shape);
                --rectangle.x;
                --rectangle.y;
                ++rectangle.height;
                rectangle.width = rectangle.width + (n4 == jTextComponent.getText().length() ? 1 : 0);
                RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 0.0, 0.0);
                LafUtils.drawShade(graphics2D, double_, StyleConstants.shadeColor, 2);
                graphics2D.setPaint(new Color(128, 128, 128, 64));
                graphics2D.fill(double_);
                graphics2D.setPaint(Color.LIGHT_GRAY);
                graphics2D.draw(double_);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            graphics2D.setClip(shape2);
            LafUtils.restoreAntialias(graphics2D, object);
        }
    }

    class HighlightInfo
    implements Highlighter.Highlight {
        Position p0;
        Position p1;
        Highlighter.HighlightPainter painter;

        HighlightInfo() {
        }

        @Override
        public int getStartOffset() {
            return this.p0.getOffset();
        }

        @Override
        public int getEndOffset() {
            return this.p1.getOffset();
        }

        @Override
        public Highlighter.HighlightPainter getPainter() {
            return this.painter;
        }
    }
}

