/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.text;

import com.alee.extended.painter.Painter;
import com.alee.laf.StyleConstants;
import com.alee.laf.text.WebTextAreaStyle;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.JTextComponent;

public class WebTextAreaUI
extends BasicTextAreaUI {
    private Painter painter = WebTextAreaStyle.painter;
    private FocusListener focusListener;
    private PropertyChangeListener marginChangeListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WebTextAreaUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        final JTextComponent jTextComponent = this.getComponent();
        SwingUtils.setOrientation(jTextComponent);
        jTextComponent.setOpaque(true);
        jTextComponent.setBackground(Color.WHITE);
        jTextComponent.setSelectionColor(StyleConstants.textSelectionColor);
        jTextComponent.setForeground(Color.BLACK);
        jTextComponent.setSelectedTextColor(Color.BLACK);
        jTextComponent.setCaretColor(Color.GRAY);
        jTextComponent.setMargin(WebTextAreaStyle.margin);
        this.updateBorder();
        this.focusListener = new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                jTextComponent.repaint();
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                jTextComponent.repaint();
            }
        };
        jTextComponent.addFocusListener(this.focusListener);
        this.marginChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WebTextAreaUI.this.updateBorder();
            }
        };
        jTextComponent.addPropertyChangeListener("margin", this.marginChangeListener);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        JTextComponent jTextComponent = this.getComponent();
        jTextComponent.removeFocusListener(this.focusListener);
        jTextComponent.removePropertyChangeListener("margin", this.marginChangeListener);
        super.uninstallUI(jComponent);
    }

    public Painter getPainter() {
        return this.painter;
    }

    public void setPainter(Painter painter) {
        this.painter = painter;
        this.getComponent().setOpaque(painter == null || painter.isOpaque(this.getComponent()));
        this.updateBorder();
    }

    private void updateBorder() {
        JTextComponent jTextComponent = this.getComponent();
        if (jTextComponent != null) {
            Insets insets;
            Insets insets2 = jTextComponent.getMargin();
            boolean bl = jTextComponent.getComponentOrientation().isLeftToRight();
            Insets insets3 = insets2 == null ? new Insets(0, 0, 0, 0) : (insets = new Insets(insets2.top, bl ? insets2.left : insets2.right, insets2.bottom, bl ? insets2.right : insets2.left));
            if (this.painter != null) {
                Insets insets4 = this.painter.getMargin(jTextComponent);
                insets.top += insets4.top;
                insets.bottom += insets4.bottom;
                insets.left = insets.left + (bl ? insets4.left : insets4.right);
                insets.right = insets.right + (bl ? insets4.right : insets4.left);
            }
            jTextComponent.setBorder(LafUtils.createWebBorder(insets));
        }
    }

    @Override
    protected void paintBackground(Graphics graphics) {
    }

    @Override
    protected void paintSafely(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        JTextComponent jTextComponent = this.getComponent();
        if (jTextComponent.isOpaque() && (this.painter == null || !this.painter.isOpaque(jTextComponent))) {
            graphics2D.setPaint(jTextComponent.getBackground());
            graphics2D.fillRect(0, 0, jTextComponent.getWidth(), jTextComponent.getHeight());
        }
        if (this.painter != null) {
            this.painter.paint(graphics2D, SwingUtils.size(jTextComponent), jTextComponent);
        }
        Map map = SwingUtils.setupTextAntialias(graphics2D, (Component)jTextComponent);
        super.paintSafely(graphics);
        SwingUtils.restoreTextAntialias(graphics2D, map);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        if (this.painter != null) {
            if (jComponent.getLayout() != null) {
                dimension = SwingUtils.max(dimension, jComponent.getLayout().preferredLayoutSize(jComponent));
            }
            dimension = SwingUtils.max(dimension, this.painter.getPreferredSize(jComponent));
        }
        return dimension;
    }
}

