/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.popup;

import com.alee.laf.panel.WebPanel;
import com.alee.managers.popup.WebPopup;
import com.alee.utils.laf.ShapeProvider;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;

public class PopupLayer
extends WebPanel {
    public PopupLayer() {
        super((LayoutManager)null);
        this.setOpaque(false);
    }

    public void hideAllPopups() {
        this.removeAll();
        this.setVisible(false);
    }

    public void showPopup(WebPopup webPopup) {
        webPopup.firePopupWillBeOpened();
        this.add((Component)webPopup, 0);
        this.setBounds(new Rectangle(0, 0, this.getParent().getWidth(), this.getParent().getHeight()));
        this.setVisible(true);
        this.revalidate();
        this.repaint();
    }

    public void hidePopup(WebPopup webPopup) {
        if (!webPopup.isShowing() || webPopup.getParent() != this) {
            return;
        }
        webPopup.firePopupWillBeClosed();
        Rectangle rectangle = webPopup.getBounds();
        this.remove(webPopup);
        this.revalidate();
        this.repaint(rectangle);
        if (this.getComponentCount() == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public boolean contains(int n, int n2) {
        for (Component component : this.getComponents()) {
            Shape shape;
            Point point = component.getLocation();
            if (!(component instanceof ShapeProvider ? (shape = ((ShapeProvider)((Object)component)).provideShape()) != null && shape.contains(n - point.x, n2 - point.y) : component.getBounds().contains(n, n2))) continue;
            return true;
        }
        return false;
    }

    public boolean normalContains(int n, int n2) {
        return super.contains(n, n2);
    }
}

