/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.settings.processors;

import com.alee.managers.settings.SettingsProcessor;
import com.alee.managers.settings.SettingsProcessorData;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;

public class JComboBoxSettingsProcessor
extends SettingsProcessor<JComboBox, Integer> {
    private ActionListener actionListener;

    public JComboBoxSettingsProcessor(SettingsProcessorData settingsProcessorData) {
        super(settingsProcessorData);
    }

    @Override
    public Integer getDefaultValue() {
        Integer n = (Integer)super.getDefaultValue();
        if (n == null) {
            n = -1;
        }
        return n;
    }

    @Override
    protected void doInit(JComboBox jComboBox) {
        this.actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBoxSettingsProcessor.this.save();
            }
        };
        jComboBox.addActionListener(this.actionListener);
    }

    @Override
    protected void doLoad(JComboBox jComboBox) {
        Integer n = (Integer)this.loadValue();
        if (jComboBox.getSelectedIndex() != n.intValue()) {
            jComboBox.setSelectedIndex(n);
        }
    }

    @Override
    protected void doSave(JComboBox jComboBox) {
        this.saveValue(jComboBox.getSelectedIndex());
    }

    @Override
    protected void doDestroy(JComboBox jComboBox) {
        jComboBox.removeActionListener(this.actionListener);
        this.actionListener = null;
    }
}

