/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.settings.processors;

import com.alee.managers.settings.SettingsManager;
import com.alee.managers.settings.SettingsProcessor;
import com.alee.managers.settings.SettingsProcessorData;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JSliderSettingsProcessor
extends SettingsProcessor<JSlider, Integer> {
    private ChangeListener changeListener;

    public JSliderSettingsProcessor(SettingsProcessorData settingsProcessorData) {
        super(settingsProcessorData);
    }

    @Override
    public Integer getDefaultValue() {
        Integer n = (Integer)super.getDefaultValue();
        if (n == null) {
            n = ((JSlider)this.getComponent()).getMinimum();
        }
        return n;
    }

    @Override
    protected void doInit(JSlider jSlider) {
        this.changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JSliderSettingsProcessor.this.save();
            }
        };
        jSlider.addChangeListener(this.changeListener);
    }

    @Override
    protected void doLoad(JSlider jSlider) {
        jSlider.setValue((Integer)this.loadValue());
    }

    @Override
    protected void doSave(JSlider jSlider) {
        SettingsManager.set(this.getGroup(), this.getKey(), jSlider.getValue());
    }

    @Override
    protected void doDestroy(JSlider jSlider) {
        jSlider.removeChangeListener(this.changeListener);
        this.changeListener = null;
    }
}

