/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing;

import com.alee.utils.CollectionUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.TimeUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class Timer {
    public static String threadName = "Timer";
    private List<ActionListener> listeners = new ArrayList<ActionListener>();
    private int id = 0;
    private int lastId;
    private Map<Integer, Boolean> running = new Hashtable<Integer, Boolean>();
    private long sleepStart = 0L;
    private long sleepTime = 0L;
    private Thread exec = null;
    private long delay;
    private long initialDelay;
    private boolean repeats = true;
    private boolean coalesce = true;
    private boolean useEventDispatchThread = true;
    private String actionCommand = "";
    private String name = null;
    private int cyclesLimit = 0;

    public Timer(long l) {
        this(threadName, l);
    }

    public Timer(String string, long l) {
        this(string, l, null);
    }

    public Timer(long l, long l2) {
        this(threadName, l, l2);
    }

    public Timer(String string, long l, long l2) {
        this(string, l, l2, null);
    }

    public Timer(long l, ActionListener actionListener) {
        this(threadName, l, actionListener);
    }

    public Timer(String string, long l, ActionListener actionListener) {
        this(string, l, -1L, actionListener);
    }

    public Timer(long l, long l2, ActionListener actionListener) {
        this(threadName, l, l2, actionListener);
    }

    public Timer(String string, long l, long l2, ActionListener actionListener) {
        this.setName(string);
        this.setDelay(l);
        this.setInitialDelay(l2);
        this.addActionListener(actionListener);
    }

    public long getInitialDelay() {
        return this.initialDelay;
    }

    public void setInitialDelay(long l) {
        if (l != -1L && l < 0L) {
            throw new IllegalArgumentException("Invalid initial delay: " + l);
        }
        this.initialDelay = l;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Invalid delay: " + l);
        }
        this.delay = l;
    }

    public boolean isRepeats() {
        return this.repeats;
    }

    public void setRepeats(boolean bl) {
        this.repeats = bl;
    }

    public boolean isCoalesce() {
        return this.coalesce;
    }

    public void setCoalesce(boolean bl) {
        this.coalesce = bl;
    }

    public boolean isUseEventDispatchThread() {
        return this.useEventDispatchThread;
    }

    public void setUseEventDispatchThread(boolean bl) {
        this.useEventDispatchThread = bl;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public int getCyclesLimit() {
        return this.cyclesLimit;
    }

    public void setCyclesLimit(int n) {
        this.cyclesLimit = n;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public long getCycleTimePassed() {
        return System.currentTimeMillis() - this.sleepStart;
    }

    public long getCycleTimeLeft() {
        return this.sleepTime - this.getCycleTimePassed();
    }

    public void start() {
        this.startExec();
    }

    public void stop() {
        this.stopExec();
    }

    public void restart() {
        this.stopExec();
        this.startExec();
    }

    public synchronized boolean isRunning() {
        return this.exec != null && this.exec.isAlive();
    }

    private synchronized void startExec() {
        if (this.isRunning()) {
            return;
        }
        final int n = this.lastId = this.id++;
        this.exec = new Thread(new Runnable(){

            @Override
            public void run() {
                block6: {
                    Timer.this.setAlive(n, true);
                    try {
                        long l;
                        long l2 = l = Timer.this.getInitialDelay() < 0L ? Timer.this.getDelay() : Timer.this.getInitialDelay();
                        if (l > 0L) {
                            Timer.this.sleepStart = System.currentTimeMillis();
                            Timer.this.sleepTime = l;
                            Thread.sleep(l);
                        }
                        if (!Timer.this.shouldContinue(-1, n)) break block6;
                        if (Timer.this.repeats) {
                            int n2 = 0;
                            while (Timer.this.shouldContinue(n2, n)) {
                                Timer.this.fireEvent();
                                if (Timer.this.shouldContinue(++n2, n)) {
                                    if (Timer.this.getDelay() <= 0L) continue;
                                    long l3 = Timer.this.getDelay();
                                    Timer.this.sleepStart = System.currentTimeMillis();
                                    Timer.this.sleepTime = l3;
                                    Thread.sleep(l3);
                                    continue;
                                }
                                break block6;
                            }
                            break block6;
                        }
                        Timer.this.fireEvent();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                Timer.this.cleanUp(n);
            }
        }, this.name);
        this.exec.start();
    }

    private boolean shouldContinue(int n, int n2) {
        return this.running.get(n2) != false && !Thread.currentThread().isInterrupted() && (this.cyclesLimit <= 0 || this.cyclesLimit > n);
    }

    private void setAlive(int n, boolean bl) {
        this.running.put(n, bl);
    }

    private void cleanUp(int n) {
        this.running.remove(n);
    }

    private synchronized void stopExec() {
        if (this.exec != null) {
            this.exec.interrupt();
            this.setAlive(this.lastId, false);
            try {
                this.exec.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public void addActionListener(ActionListener actionListener) {
        if (actionListener != null) {
            this.listeners.add(actionListener);
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        if (actionListener != null) {
            this.listeners.remove(actionListener);
        }
    }

    public List<ActionListener> getListeners() {
        return this.listeners;
    }

    private void fireEvent() {
        block6: {
            if (this.listeners.size() <= 0) break block6;
            final ActionEvent actionEvent = this.createActionEvent();
            final List<ActionListener> list = CollectionUtils.copy(this.listeners);
            if (this.useEventDispatchThread) {
                if (this.coalesce) {
                    SwingUtils.invokeAndWaitSafely(new Runnable(){

                        @Override
                        public void run() {
                            for (ActionListener actionListener : list) {
                                actionListener.actionPerformed(actionEvent);
                            }
                        }
                    });
                } else {
                    for (final ActionListener actionListener : list) {
                        SwingUtils.invokeAndWaitSafely(new Runnable(){

                            @Override
                            public void run() {
                                actionListener.actionPerformed(actionEvent);
                            }
                        });
                    }
                }
            } else {
                for (ActionListener actionListener : list) {
                    actionListener.actionPerformed(actionEvent);
                }
            }
        }
    }

    private ActionEvent createActionEvent() {
        return new ActionEvent(this, 0, this.actionCommand, TimeUtils.currentTime(), 0);
    }

    public static Timer delay(long l, ActionListener actionListener) {
        return Timer.delay(l, true, actionListener);
    }

    public static Timer delay(long l, boolean bl, ActionListener actionListener) {
        Timer timer = new Timer(l, actionListener);
        timer.setRepeats(false);
        timer.start();
        return timer;
    }

    public static Timer repeat(long l, ActionListener actionListener) {
        return Timer.repeat(l, l, true, actionListener);
    }

    public static Timer repeat(long l, boolean bl, ActionListener actionListener) {
        return Timer.repeat(l, l, bl, actionListener);
    }

    public static Timer repeat(long l, long l2, ActionListener actionListener) {
        return Timer.repeat(l, l2, true, actionListener);
    }

    public static Timer repeat(long l, long l2, boolean bl, ActionListener actionListener) {
        Timer timer = new Timer(l, l2, actionListener);
        timer.setRepeats(true);
        timer.start();
        return timer;
    }
}

