/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import java.io.UnsupportedEncodingException;

public class Base64 {
    public static final int DEFAULT = 0;
    public static final int NO_PADDING = 1;
    public static final int NO_WRAP = 2;
    public static final int CRLF = 4;
    public static final int URL_SAFE = 8;
    public static final int NO_CLOSE = 16;

    public static byte[] decode(String str, int flags) {
        return Base64.decode(str.getBytes(), flags);
    }

    public static byte[] decode(byte[] input, int flags) {
        return Base64.decode(input, 0, input.length, flags);
    }

    public static byte[] decode(byte[] input, int offset, int len, int flags) {
        Decoder decoder = new Decoder(flags, new byte[len * 3 / 4]);
        if (!decoder.process(input, offset, len, true)) {
            throw new IllegalArgumentException("bad base-64");
        }
        if (decoder.op == decoder.output.length) {
            return decoder.output;
        }
        byte[] temp = new byte[decoder.op];
        System.arraycopy(decoder.output, 0, temp, 0, decoder.op);
        return temp;
    }

    public static String encodeToString(byte[] input, int flags) {
        try {
            return new String(Base64.encode(input, flags), "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static String encodeToString(byte[] input, int offset, int len, int flags) {
        try {
            return new String(Base64.encode(input, offset, len, flags), "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static byte[] encode(byte[] input, int flags) {
        return Base64.encode(input, 0, input.length, flags);
    }

    public static byte[] encode(byte[] input, int offset, int len, int flags) {
        Encoder encoder = new Encoder(flags, null);
        int output_len = len / 3 * 4;
        if (encoder.do_padding) {
            if (len % 3 > 0) {
                output_len += 4;
            }
        } else {
            switch (len % 3) {
                case 0: {
                    break;
                }
                case 1: {
                    output_len += 2;
                    break;
                }
                case 2: {
                    output_len += 3;
                }
            }
        }
        if (encoder.do_newline && len > 0) {
            output_len += ((len - 1) / 57 + 1) * (encoder.do_cr ? 2 : 1);
        }
        encoder.output = new byte[output_len];
        encoder.process(input, offset, len, true);
        assert (encoder.op == output_len);
        return encoder.output;
    }

    private Base64() {
    }

    static abstract class Coder {
        public byte[] output;
        public int op;

        Coder() {
        }

        public abstract boolean process(byte[] var1, int var2, int var3, boolean var4);

        public abstract int maxOutputSize(int var1);
    }

    static class Decoder
    extends Coder {
        private static final int[] DECODE;
        private static final int[] DECODE_WEBSAFE;
        private static final int SKIP = -1;
        private static final int EQUALS = -2;
        private int state;
        private int value;
        private final int[] alphabet;

        static {
            int[] nArray = new int[256];
            nArray[0] = -1;
            nArray[1] = -1;
            nArray[2] = -1;
            nArray[3] = -1;
            nArray[4] = -1;
            nArray[5] = -1;
            nArray[6] = -1;
            nArray[7] = -1;
            nArray[8] = -1;
            nArray[9] = -1;
            nArray[10] = -1;
            nArray[11] = -1;
            nArray[12] = -1;
            nArray[13] = -1;
            nArray[14] = -1;
            nArray[15] = -1;
            nArray[16] = -1;
            nArray[17] = -1;
            nArray[18] = -1;
            nArray[19] = -1;
            nArray[20] = -1;
            nArray[21] = -1;
            nArray[22] = -1;
            nArray[23] = -1;
            nArray[24] = -1;
            nArray[25] = -1;
            nArray[26] = -1;
            nArray[27] = -1;
            nArray[28] = -1;
            nArray[29] = -1;
            nArray[30] = -1;
            nArray[31] = -1;
            nArray[32] = -1;
            nArray[33] = -1;
            nArray[34] = -1;
            nArray[35] = -1;
            nArray[36] = -1;
            nArray[37] = -1;
            nArray[38] = -1;
            nArray[39] = -1;
            nArray[40] = -1;
            nArray[41] = -1;
            nArray[42] = -1;
            nArray[43] = 62;
            nArray[44] = -1;
            nArray[45] = -1;
            nArray[46] = -1;
            nArray[47] = 63;
            nArray[48] = 52;
            nArray[49] = 53;
            nArray[50] = 54;
            nArray[51] = 55;
            nArray[52] = 56;
            nArray[53] = 57;
            nArray[54] = 58;
            nArray[55] = 59;
            nArray[56] = 60;
            nArray[57] = 61;
            nArray[58] = -1;
            nArray[59] = -1;
            nArray[60] = -1;
            nArray[61] = -2;
            nArray[62] = -1;
            nArray[63] = -1;
            nArray[64] = -1;
            nArray[66] = 1;
            nArray[67] = 2;
            nArray[68] = 3;
            nArray[69] = 4;
            nArray[70] = 5;
            nArray[71] = 6;
            nArray[72] = 7;
            nArray[73] = 8;
            nArray[74] = 9;
            nArray[75] = 10;
            nArray[76] = 11;
            nArray[77] = 12;
            nArray[78] = 13;
            nArray[79] = 14;
            nArray[80] = 15;
            nArray[81] = 16;
            nArray[82] = 17;
            nArray[83] = 18;
            nArray[84] = 19;
            nArray[85] = 20;
            nArray[86] = 21;
            nArray[87] = 22;
            nArray[88] = 23;
            nArray[89] = 24;
            nArray[90] = 25;
            nArray[91] = -1;
            nArray[92] = -1;
            nArray[93] = -1;
            nArray[94] = -1;
            nArray[95] = -1;
            nArray[96] = -1;
            nArray[97] = 26;
            nArray[98] = 27;
            nArray[99] = 28;
            nArray[100] = 29;
            nArray[101] = 30;
            nArray[102] = 31;
            nArray[103] = 32;
            nArray[104] = 33;
            nArray[105] = 34;
            nArray[106] = 35;
            nArray[107] = 36;
            nArray[108] = 37;
            nArray[109] = 38;
            nArray[110] = 39;
            nArray[111] = 40;
            nArray[112] = 41;
            nArray[113] = 42;
            nArray[114] = 43;
            nArray[115] = 44;
            nArray[116] = 45;
            nArray[117] = 46;
            nArray[118] = 47;
            nArray[119] = 48;
            nArray[120] = 49;
            nArray[121] = 50;
            nArray[122] = 51;
            nArray[123] = -1;
            nArray[124] = -1;
            nArray[125] = -1;
            nArray[126] = -1;
            nArray[127] = -1;
            nArray[128] = -1;
            nArray[129] = -1;
            nArray[130] = -1;
            nArray[131] = -1;
            nArray[132] = -1;
            nArray[133] = -1;
            nArray[134] = -1;
            nArray[135] = -1;
            nArray[136] = -1;
            nArray[137] = -1;
            nArray[138] = -1;
            nArray[139] = -1;
            nArray[140] = -1;
            nArray[141] = -1;
            nArray[142] = -1;
            nArray[143] = -1;
            nArray[144] = -1;
            nArray[145] = -1;
            nArray[146] = -1;
            nArray[147] = -1;
            nArray[148] = -1;
            nArray[149] = -1;
            nArray[150] = -1;
            nArray[151] = -1;
            nArray[152] = -1;
            nArray[153] = -1;
            nArray[154] = -1;
            nArray[155] = -1;
            nArray[156] = -1;
            nArray[157] = -1;
            nArray[158] = -1;
            nArray[159] = -1;
            nArray[160] = -1;
            nArray[161] = -1;
            nArray[162] = -1;
            nArray[163] = -1;
            nArray[164] = -1;
            nArray[165] = -1;
            nArray[166] = -1;
            nArray[167] = -1;
            nArray[168] = -1;
            nArray[169] = -1;
            nArray[170] = -1;
            nArray[171] = -1;
            nArray[172] = -1;
            nArray[173] = -1;
            nArray[174] = -1;
            nArray[175] = -1;
            nArray[176] = -1;
            nArray[177] = -1;
            nArray[178] = -1;
            nArray[179] = -1;
            nArray[180] = -1;
            nArray[181] = -1;
            nArray[182] = -1;
            nArray[183] = -1;
            nArray[184] = -1;
            nArray[185] = -1;
            nArray[186] = -1;
            nArray[187] = -1;
            nArray[188] = -1;
            nArray[189] = -1;
            nArray[190] = -1;
            nArray[191] = -1;
            nArray[192] = -1;
            nArray[193] = -1;
            nArray[194] = -1;
            nArray[195] = -1;
            nArray[196] = -1;
            nArray[197] = -1;
            nArray[198] = -1;
            nArray[199] = -1;
            nArray[200] = -1;
            nArray[201] = -1;
            nArray[202] = -1;
            nArray[203] = -1;
            nArray[204] = -1;
            nArray[205] = -1;
            nArray[206] = -1;
            nArray[207] = -1;
            nArray[208] = -1;
            nArray[209] = -1;
            nArray[210] = -1;
            nArray[211] = -1;
            nArray[212] = -1;
            nArray[213] = -1;
            nArray[214] = -1;
            nArray[215] = -1;
            nArray[216] = -1;
            nArray[217] = -1;
            nArray[218] = -1;
            nArray[219] = -1;
            nArray[220] = -1;
            nArray[221] = -1;
            nArray[222] = -1;
            nArray[223] = -1;
            nArray[224] = -1;
            nArray[225] = -1;
            nArray[226] = -1;
            nArray[227] = -1;
            nArray[228] = -1;
            nArray[229] = -1;
            nArray[230] = -1;
            nArray[231] = -1;
            nArray[232] = -1;
            nArray[233] = -1;
            nArray[234] = -1;
            nArray[235] = -1;
            nArray[236] = -1;
            nArray[237] = -1;
            nArray[238] = -1;
            nArray[239] = -1;
            nArray[240] = -1;
            nArray[241] = -1;
            nArray[242] = -1;
            nArray[243] = -1;
            nArray[244] = -1;
            nArray[245] = -1;
            nArray[246] = -1;
            nArray[247] = -1;
            nArray[248] = -1;
            nArray[249] = -1;
            nArray[250] = -1;
            nArray[251] = -1;
            nArray[252] = -1;
            nArray[253] = -1;
            nArray[254] = -1;
            nArray[255] = -1;
            DECODE = nArray;
            int[] nArray2 = new int[256];
            nArray2[0] = -1;
            nArray2[1] = -1;
            nArray2[2] = -1;
            nArray2[3] = -1;
            nArray2[4] = -1;
            nArray2[5] = -1;
            nArray2[6] = -1;
            nArray2[7] = -1;
            nArray2[8] = -1;
            nArray2[9] = -1;
            nArray2[10] = -1;
            nArray2[11] = -1;
            nArray2[12] = -1;
            nArray2[13] = -1;
            nArray2[14] = -1;
            nArray2[15] = -1;
            nArray2[16] = -1;
            nArray2[17] = -1;
            nArray2[18] = -1;
            nArray2[19] = -1;
            nArray2[20] = -1;
            nArray2[21] = -1;
            nArray2[22] = -1;
            nArray2[23] = -1;
            nArray2[24] = -1;
            nArray2[25] = -1;
            nArray2[26] = -1;
            nArray2[27] = -1;
            nArray2[28] = -1;
            nArray2[29] = -1;
            nArray2[30] = -1;
            nArray2[31] = -1;
            nArray2[32] = -1;
            nArray2[33] = -1;
            nArray2[34] = -1;
            nArray2[35] = -1;
            nArray2[36] = -1;
            nArray2[37] = -1;
            nArray2[38] = -1;
            nArray2[39] = -1;
            nArray2[40] = -1;
            nArray2[41] = -1;
            nArray2[42] = -1;
            nArray2[43] = -1;
            nArray2[44] = -1;
            nArray2[45] = 62;
            nArray2[46] = -1;
            nArray2[47] = -1;
            nArray2[48] = 52;
            nArray2[49] = 53;
            nArray2[50] = 54;
            nArray2[51] = 55;
            nArray2[52] = 56;
            nArray2[53] = 57;
            nArray2[54] = 58;
            nArray2[55] = 59;
            nArray2[56] = 60;
            nArray2[57] = 61;
            nArray2[58] = -1;
            nArray2[59] = -1;
            nArray2[60] = -1;
            nArray2[61] = -2;
            nArray2[62] = -1;
            nArray2[63] = -1;
            nArray2[64] = -1;
            nArray2[66] = 1;
            nArray2[67] = 2;
            nArray2[68] = 3;
            nArray2[69] = 4;
            nArray2[70] = 5;
            nArray2[71] = 6;
            nArray2[72] = 7;
            nArray2[73] = 8;
            nArray2[74] = 9;
            nArray2[75] = 10;
            nArray2[76] = 11;
            nArray2[77] = 12;
            nArray2[78] = 13;
            nArray2[79] = 14;
            nArray2[80] = 15;
            nArray2[81] = 16;
            nArray2[82] = 17;
            nArray2[83] = 18;
            nArray2[84] = 19;
            nArray2[85] = 20;
            nArray2[86] = 21;
            nArray2[87] = 22;
            nArray2[88] = 23;
            nArray2[89] = 24;
            nArray2[90] = 25;
            nArray2[91] = -1;
            nArray2[92] = -1;
            nArray2[93] = -1;
            nArray2[94] = -1;
            nArray2[95] = 63;
            nArray2[96] = -1;
            nArray2[97] = 26;
            nArray2[98] = 27;
            nArray2[99] = 28;
            nArray2[100] = 29;
            nArray2[101] = 30;
            nArray2[102] = 31;
            nArray2[103] = 32;
            nArray2[104] = 33;
            nArray2[105] = 34;
            nArray2[106] = 35;
            nArray2[107] = 36;
            nArray2[108] = 37;
            nArray2[109] = 38;
            nArray2[110] = 39;
            nArray2[111] = 40;
            nArray2[112] = 41;
            nArray2[113] = 42;
            nArray2[114] = 43;
            nArray2[115] = 44;
            nArray2[116] = 45;
            nArray2[117] = 46;
            nArray2[118] = 47;
            nArray2[119] = 48;
            nArray2[120] = 49;
            nArray2[121] = 50;
            nArray2[122] = 51;
            nArray2[123] = -1;
            nArray2[124] = -1;
            nArray2[125] = -1;
            nArray2[126] = -1;
            nArray2[127] = -1;
            nArray2[128] = -1;
            nArray2[129] = -1;
            nArray2[130] = -1;
            nArray2[131] = -1;
            nArray2[132] = -1;
            nArray2[133] = -1;
            nArray2[134] = -1;
            nArray2[135] = -1;
            nArray2[136] = -1;
            nArray2[137] = -1;
            nArray2[138] = -1;
            nArray2[139] = -1;
            nArray2[140] = -1;
            nArray2[141] = -1;
            nArray2[142] = -1;
            nArray2[143] = -1;
            nArray2[144] = -1;
            nArray2[145] = -1;
            nArray2[146] = -1;
            nArray2[147] = -1;
            nArray2[148] = -1;
            nArray2[149] = -1;
            nArray2[150] = -1;
            nArray2[151] = -1;
            nArray2[152] = -1;
            nArray2[153] = -1;
            nArray2[154] = -1;
            nArray2[155] = -1;
            nArray2[156] = -1;
            nArray2[157] = -1;
            nArray2[158] = -1;
            nArray2[159] = -1;
            nArray2[160] = -1;
            nArray2[161] = -1;
            nArray2[162] = -1;
            nArray2[163] = -1;
            nArray2[164] = -1;
            nArray2[165] = -1;
            nArray2[166] = -1;
            nArray2[167] = -1;
            nArray2[168] = -1;
            nArray2[169] = -1;
            nArray2[170] = -1;
            nArray2[171] = -1;
            nArray2[172] = -1;
            nArray2[173] = -1;
            nArray2[174] = -1;
            nArray2[175] = -1;
            nArray2[176] = -1;
            nArray2[177] = -1;
            nArray2[178] = -1;
            nArray2[179] = -1;
            nArray2[180] = -1;
            nArray2[181] = -1;
            nArray2[182] = -1;
            nArray2[183] = -1;
            nArray2[184] = -1;
            nArray2[185] = -1;
            nArray2[186] = -1;
            nArray2[187] = -1;
            nArray2[188] = -1;
            nArray2[189] = -1;
            nArray2[190] = -1;
            nArray2[191] = -1;
            nArray2[192] = -1;
            nArray2[193] = -1;
            nArray2[194] = -1;
            nArray2[195] = -1;
            nArray2[196] = -1;
            nArray2[197] = -1;
            nArray2[198] = -1;
            nArray2[199] = -1;
            nArray2[200] = -1;
            nArray2[201] = -1;
            nArray2[202] = -1;
            nArray2[203] = -1;
            nArray2[204] = -1;
            nArray2[205] = -1;
            nArray2[206] = -1;
            nArray2[207] = -1;
            nArray2[208] = -1;
            nArray2[209] = -1;
            nArray2[210] = -1;
            nArray2[211] = -1;
            nArray2[212] = -1;
            nArray2[213] = -1;
            nArray2[214] = -1;
            nArray2[215] = -1;
            nArray2[216] = -1;
            nArray2[217] = -1;
            nArray2[218] = -1;
            nArray2[219] = -1;
            nArray2[220] = -1;
            nArray2[221] = -1;
            nArray2[222] = -1;
            nArray2[223] = -1;
            nArray2[224] = -1;
            nArray2[225] = -1;
            nArray2[226] = -1;
            nArray2[227] = -1;
            nArray2[228] = -1;
            nArray2[229] = -1;
            nArray2[230] = -1;
            nArray2[231] = -1;
            nArray2[232] = -1;
            nArray2[233] = -1;
            nArray2[234] = -1;
            nArray2[235] = -1;
            nArray2[236] = -1;
            nArray2[237] = -1;
            nArray2[238] = -1;
            nArray2[239] = -1;
            nArray2[240] = -1;
            nArray2[241] = -1;
            nArray2[242] = -1;
            nArray2[243] = -1;
            nArray2[244] = -1;
            nArray2[245] = -1;
            nArray2[246] = -1;
            nArray2[247] = -1;
            nArray2[248] = -1;
            nArray2[249] = -1;
            nArray2[250] = -1;
            nArray2[251] = -1;
            nArray2[252] = -1;
            nArray2[253] = -1;
            nArray2[254] = -1;
            nArray2[255] = -1;
            DECODE_WEBSAFE = nArray2;
        }

        public Decoder(int flags, byte[] output) {
            this.output = output;
            this.alphabet = (flags & 8) == 0 ? DECODE : DECODE_WEBSAFE;
            this.state = 0;
            this.value = 0;
        }

        @Override
        public int maxOutputSize(int len) {
            return len * 3 / 4 + 10;
        }

        @Override
        public boolean process(byte[] input, int offset, int len, boolean finish) {
            if (this.state == 6) {
                return false;
            }
            int p = offset;
            len += offset;
            int state = this.state;
            int value = this.value;
            int op = 0;
            byte[] output = this.output;
            int[] alphabet = this.alphabet;
            while (p < len) {
                if (state == 0) {
                    while (p + 4 <= len && (value = alphabet[input[p] & 0xFF] << 18 | alphabet[input[p + 1] & 0xFF] << 12 | alphabet[input[p + 2] & 0xFF] << 6 | alphabet[input[p + 3] & 0xFF]) >= 0) {
                        output[op + 2] = (byte)value;
                        output[op + 1] = (byte)(value >> 8);
                        output[op] = (byte)(value >> 16);
                        op += 3;
                        p += 4;
                    }
                    if (p >= len) break;
                }
                int d = alphabet[input[p++] & 0xFF];
                switch (state) {
                    case 0: {
                        if (d >= 0) {
                            value = d;
                            ++state;
                            break;
                        }
                        if (d == -1) break;
                        this.state = 6;
                        return false;
                    }
                    case 1: {
                        if (d >= 0) {
                            value = value << 6 | d;
                            ++state;
                            break;
                        }
                        if (d == -1) break;
                        this.state = 6;
                        return false;
                    }
                    case 2: {
                        if (d >= 0) {
                            value = value << 6 | d;
                            ++state;
                            break;
                        }
                        if (d == -2) {
                            output[op++] = (byte)(value >> 4);
                            state = 4;
                            break;
                        }
                        if (d == -1) break;
                        this.state = 6;
                        return false;
                    }
                    case 3: {
                        if (d >= 0) {
                            value = value << 6 | d;
                            output[op + 2] = (byte)value;
                            output[op + 1] = (byte)(value >> 8);
                            output[op] = (byte)(value >> 16);
                            op += 3;
                            state = 0;
                            break;
                        }
                        if (d == -2) {
                            output[op + 1] = (byte)(value >> 2);
                            output[op] = (byte)(value >> 10);
                            op += 2;
                            state = 5;
                            break;
                        }
                        if (d == -1) break;
                        this.state = 6;
                        return false;
                    }
                    case 4: {
                        if (d == -2) {
                            ++state;
                            break;
                        }
                        if (d == -1) break;
                        this.state = 6;
                        return false;
                    }
                    case 5: {
                        if (d == -1) break;
                        this.state = 6;
                        return false;
                    }
                }
            }
            if (!finish) {
                this.state = state;
                this.value = value;
                this.op = op;
                return true;
            }
            switch (state) {
                case 0: {
                    break;
                }
                case 1: {
                    this.state = 6;
                    return false;
                }
                case 2: {
                    output[op++] = (byte)(value >> 4);
                    break;
                }
                case 3: {
                    output[op++] = (byte)(value >> 10);
                    output[op++] = (byte)(value >> 2);
                    break;
                }
                case 4: {
                    this.state = 6;
                    return false;
                }
            }
            this.state = state;
            this.op = op;
            return true;
        }
    }

    static class Encoder
    extends Coder {
        public static final int LINE_GROUPS = 19;
        private static final byte[] ENCODE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        private static final byte[] ENCODE_WEBSAFE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 95};
        private final byte[] tail;
        int tailLen;
        private int count;
        public final boolean do_padding;
        public final boolean do_newline;
        public final boolean do_cr;
        private final byte[] alphabet;

        public Encoder(int flags, byte[] output) {
            this.output = output;
            this.do_padding = (flags & 1) == 0;
            this.do_newline = (flags & 2) == 0;
            this.do_cr = (flags & 4) != 0;
            this.alphabet = (flags & 8) == 0 ? ENCODE : ENCODE_WEBSAFE;
            this.tail = new byte[2];
            this.tailLen = 0;
            this.count = this.do_newline ? 19 : -1;
        }

        @Override
        public int maxOutputSize(int len) {
            return len * 8 / 5 + 10;
        }

        @Override
        public boolean process(byte[] input, int offset, int len, boolean finish) {
            byte[] alphabet = this.alphabet;
            byte[] output = this.output;
            int op = 0;
            int count = this.count;
            int p = offset;
            len += offset;
            int v = -1;
            switch (this.tailLen) {
                case 0: {
                    break;
                }
                case 1: {
                    if (p + 2 > len) break;
                    v = (this.tail[0] & 0xFF) << 16 | (input[p++] & 0xFF) << 8 | input[p++] & 0xFF;
                    this.tailLen = 0;
                    break;
                }
                case 2: {
                    if (p + 1 > len) break;
                    v = (this.tail[0] & 0xFF) << 16 | (this.tail[1] & 0xFF) << 8 | input[p++] & 0xFF;
                    this.tailLen = 0;
                }
            }
            if (v != -1) {
                output[op++] = alphabet[v >> 18 & 0x3F];
                output[op++] = alphabet[v >> 12 & 0x3F];
                output[op++] = alphabet[v >> 6 & 0x3F];
                output[op++] = alphabet[v & 0x3F];
                if (--count == 0) {
                    if (this.do_cr) {
                        output[op++] = 13;
                    }
                    output[op++] = 10;
                    count = 19;
                }
            }
            while (p + 3 <= len) {
                v = (input[p] & 0xFF) << 16 | (input[p + 1] & 0xFF) << 8 | input[p + 2] & 0xFF;
                output[op] = alphabet[v >> 18 & 0x3F];
                output[op + 1] = alphabet[v >> 12 & 0x3F];
                output[op + 2] = alphabet[v >> 6 & 0x3F];
                output[op + 3] = alphabet[v & 0x3F];
                p += 3;
                op += 4;
                if (--count != 0) continue;
                if (this.do_cr) {
                    output[op++] = 13;
                }
                output[op++] = 10;
                count = 19;
            }
            if (finish) {
                if (p - this.tailLen == len - 1) {
                    int t = 0;
                    v = ((this.tailLen > 0 ? this.tail[t++] : input[p++]) & 0xFF) << 4;
                    this.tailLen -= t;
                    output[op++] = alphabet[v >> 6 & 0x3F];
                    output[op++] = alphabet[v & 0x3F];
                    if (this.do_padding) {
                        output[op++] = 61;
                        output[op++] = 61;
                    }
                    if (this.do_newline) {
                        if (this.do_cr) {
                            output[op++] = 13;
                        }
                        output[op++] = 10;
                    }
                } else if (p - this.tailLen == len - 2) {
                    int t = 0;
                    v = ((this.tailLen > 1 ? this.tail[t++] : input[p++]) & 0xFF) << 10 | ((this.tailLen > 0 ? this.tail[t++] : input[p++]) & 0xFF) << 2;
                    this.tailLen -= t;
                    output[op++] = alphabet[v >> 12 & 0x3F];
                    output[op++] = alphabet[v >> 6 & 0x3F];
                    output[op++] = alphabet[v & 0x3F];
                    if (this.do_padding) {
                        output[op++] = 61;
                    }
                    if (this.do_newline) {
                        if (this.do_cr) {
                            output[op++] = 13;
                        }
                        output[op++] = 10;
                    }
                } else if (this.do_newline && op > 0 && count != 19) {
                    if (this.do_cr) {
                        output[op++] = 13;
                    }
                    output[op++] = 10;
                }
                assert (this.tailLen == 0);
                assert (p == len);
            } else if (p == len - 1) {
                this.tail[this.tailLen++] = input[p];
            } else if (p == len - 2) {
                this.tail[this.tailLen++] = input[p];
                this.tail[this.tailLen++] = input[p + 1];
            }
            this.op = op;
            this.count = count;
            return true;
        }
    }
}

