/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.freestyle;

import com.miui.home.launcher.upsidescene.data.Appearance;
import com.miui.home.launcher.upsidescene.data.Function;
import com.miui.home.launcher.upsidescene.data.Sprite;
import com.miui.theme.tool.freestyle.SelectFunction;
import com.miui.theme.tool.freestyle.SelectionCell;
import com.miui.theme.tool.gui.MainFrame;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.util.GridBagHelper;
import com.miui.theme.tool.util.ThemeHelper;
import java.awt.Cursor;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class SelectAppearance
extends JDialog
implements ActionListener {
    public Appearance mAppearanceResult;
    public Function mFunctionResult;
    private JButton mRefreshButton;
    private JButton mOpenFolderButton;
    private JTabbedPane mTab;
    private String mFreeStylePath;
    private StageImageSelectPanel mStageImagesSelectPanel;
    private SkinImageSelectPanel mSkinsImageSelectPanel;
    private ToolsSelectPanel mToolsSelectPanel;
    private JButton mNoAppearanceButton;
    private JButton mKeepAppearanceButton;
    public static final int DIALOG_WIDTH = 900;
    public static final int DIALOG_HEIGHT = 700;
    public static int icons_per_line = 5;

    public SelectAppearance(String freeStylePath) {
        this.mFreeStylePath = freeStylePath;
        this.setModal(true);
        MainFrame mainFrame = MainFrame.getInstance();
        this.setTitle(ResourceFactory.getString("select_appearance"));
        this.setBounds(mainFrame.getX() + (mainFrame.getWidth() - 900) / 2, mainFrame.getY() + (mainFrame.getHeight() - 700) / 2, 900, 700);
        this.mNoAppearanceButton = new JButton(ResourceFactory.getString("no_appearance"));
        this.mNoAppearanceButton.addActionListener(this);
        this.mKeepAppearanceButton = new JButton(ResourceFactory.getString("keep_appearance"));
        this.mKeepAppearanceButton.addActionListener(this);
        this.mRefreshButton = new JButton(ResourceFactory.getString("refresh"));
        this.mRefreshButton.addActionListener(this);
        this.mOpenFolderButton = new JButton(ResourceFactory.getString("open_folder"));
        this.mOpenFolderButton.addActionListener(this);
        this.mTab = new JTabbedPane(1);
        this.mStageImagesSelectPanel = new StageImageSelectPanel();
        this.mSkinsImageSelectPanel = new SkinImageSelectPanel();
        this.mToolsSelectPanel = new ToolsSelectPanel();
        this.mTab.addTab(ResourceFactory.getString("freestyle.stage_image"), null, new JScrollPane(this.mStageImagesSelectPanel), null);
        this.mTab.addTab(ResourceFactory.getString("freestyle.skins"), null, new JScrollPane(this.mSkinsImageSelectPanel), null);
        this.mTab.addTab(ResourceFactory.getString("freestyle.tools"), null, new JScrollPane(this.mToolsSelectPanel), null);
        this.setLayout(new GridBagLayout());
        int x = 0;
        int y = 0;
        int gap = 5;
        GridBagHelper.addComponent(this.getContentPane(), this.mTab, x, y, 2, 1, 0, 0, gap, gap, 1.0, 1.0, 1, 10);
        GridBagHelper.addComponent(this.getContentPane(), this.mNoAppearanceButton, x, ++y, 1, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 10);
        GridBagHelper.addComponent(this.getContentPane(), this.mKeepAppearanceButton, ++x, y, 1, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 10);
        x = 0;
        GridBagHelper.addComponent(this.getContentPane(), this.mOpenFolderButton, x, ++y, 1, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 10);
        GridBagHelper.addComponent(this.getContentPane(), this.mRefreshButton, ++x, y, 1, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 10);
        this.refresh();
    }

    public void refresh() {
        new Thread(){

            @Override
            public void run() {
                SelectAppearance.this.setCursor(Cursor.getPredefinedCursor(3));
                SelectAppearance.this.mStageImagesSelectPanel.refresh();
                SelectAppearance.this.mSkinsImageSelectPanel.refresh();
                SelectAppearance.this.mToolsSelectPanel.refresh();
                SelectAppearance.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }.start();
    }

    protected boolean selectFunction() {
        SelectFunction sf = new SelectFunction();
        sf.setVisible(true);
        if (sf.mFunctionResult == null) {
            return false;
        }
        this.mFunctionResult = sf.mFunctionResult;
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.mRefreshButton)) {
            this.refresh();
        }
        if (e.getSource().equals(this.mOpenFolderButton)) {
            ThemeHelper.openInExplorer(new File(this.mFreeStylePath));
        }
        if (e.getSource().equals(this.mNoAppearanceButton)) {
            this.mAppearanceResult = new Appearance.NoneAppearance();
            if (this.selectFunction()) {
                this.dispose();
            }
        }
        if (e.getSource().equals(this.mKeepAppearanceButton) && this.selectFunction()) {
            this.dispose();
        }
    }

    abstract class ImageSelectPanel
    extends SelectPanel {
        ImageSelectPanel() {
        }

        @Override
        protected void addCell(File file) {
            try {
                Appearance appearance = Appearance.load(file.getAbsolutePath().substring(SelectAppearance.this.mFreeStylePath.length() + 1), 1.0f);
                if (appearance == null || appearance instanceof Appearance.NoneAppearance) {
                    return;
                }
                Function function = Function.parse(null);
                Sprite sprite = new Sprite();
                sprite.setAppearance(appearance);
                sprite.setFunction(function);
                SelectionCell cell = new SelectionCell(sprite);
                cell.mLabel.setText(file.getName());
                this.bindMouseListener(cell);
                this.add(cell);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    abstract class SelectPanel
    extends JPanel {
        public String mPath;
        public MouseListener ml = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                SelectionCell sc = (SelectionCell)e.getSource();
                ((SelectPanel)SelectPanel.this).SelectAppearance.this.mAppearanceResult = sc.mSprite.getAppearance();
                ((SelectPanel)SelectPanel.this).SelectAppearance.this.mFunctionResult = sc.mSprite.getFunction();
                SelectAppearance.this.dispose();
            }
        };

        SelectPanel() {
        }

        protected abstract void addCell(File var1);

        public void refresh() {
            this.removeAll();
            File f = new File(this.mPath);
            File[] files = f.listFiles();
            if (files != null) {
                int line = files.length / icons_per_line + 1;
                this.setLayout(new GridLayout(line, icons_per_line, 0, 0));
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    this.addCell(file);
                    ++n2;
                }
            }
            this.validate();
        }

        protected void bindMouseListener(SelectionCell cell) {
            cell.addMouseListener(this.ml);
        }
    }

    class SkinImageSelectPanel
    extends ImageSelectPanel {
        public MouseListener ml = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                SelectionCell sc = (SelectionCell)e.getSource();
                ((SkinImageSelectPanel)SkinImageSelectPanel.this).SelectAppearance.this.mAppearanceResult = sc.mSprite.getAppearance();
                if (SelectAppearance.this.selectFunction()) {
                    SelectAppearance.this.dispose();
                }
            }
        };

        public SkinImageSelectPanel() {
            this.mPath = String.valueOf(SelectAppearance.this.mFreeStylePath) + File.separator + "skins";
        }

        @Override
        protected void bindMouseListener(SelectionCell cell) {
            cell.addMouseListener(this.ml);
        }
    }

    class StageImageSelectPanel
    extends ImageSelectPanel {
        public StageImageSelectPanel() {
            this.mPath = String.valueOf(SelectAppearance.this.mFreeStylePath) + File.separator + "stage_images";
        }
    }

    class ToolsSelectPanel
    extends SelectPanel {
        public MouseListener ml = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                SelectionCell sc = (SelectionCell)e.getSource();
                ((ToolsSelectPanel)ToolsSelectPanel.this).SelectAppearance.this.mAppearanceResult = sc.mSprite.getAppearance();
                ((ToolsSelectPanel)ToolsSelectPanel.this).SelectAppearance.this.mFunctionResult = sc.mSprite.getFunction();
                SelectAppearance.this.dispose();
            }
        };

        public ToolsSelectPanel() {
            this.mPath = String.valueOf(SelectAppearance.this.mFreeStylePath) + File.separator + "tools";
        }

        @Override
        protected void addCell(File file) {
            Appearance.NoneAppearance appearance = new Appearance.NoneAppearance();
            Function function = Function.parse("mtz_gadget:" + file.getAbsolutePath().substring(SelectAppearance.this.mFreeStylePath.length() + 1));
            Sprite sprite = new Sprite();
            sprite.setAppearance(appearance);
            sprite.setFunction(function);
            SelectionCell cell = new SelectionCell(sprite);
            cell.mLabel.setText(file.getName());
            this.bindMouseListener(cell);
            this.add(cell);
        }

        @Override
        protected void bindMouseListener(SelectionCell cell) {
            cell.addMouseListener(this.ml);
        }
    }
}

