/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.gui;

import com.miui.theme.tool.apk.Member;
import com.miui.theme.tool.apk.ThemeValue;
import com.miui.theme.tool.compress.MtzCompressor;
import com.miui.theme.tool.extract.Extractor;
import com.miui.theme.tool.freestyle.FreeStyleConverter;
import com.miui.theme.tool.freestyle.FreeStylePanel;
import com.miui.theme.tool.gui.AnimationPlayPanel;
import com.miui.theme.tool.gui.ApkSelectDialog;
import com.miui.theme.tool.gui.ImageLabel;
import com.miui.theme.tool.gui.MainFrame;
import com.miui.theme.tool.gui.StateBar;
import com.miui.theme.tool.icons.IconReplacePanel;
import com.miui.theme.tool.module.EditModuleTable;
import com.miui.theme.tool.module.EditModuleTableModel;
import com.miui.theme.tool.module.MIUIThemeValues;
import com.miui.theme.tool.ninepatch.NinePatchUtils;
import com.miui.theme.tool.os.CmdUtils;
import com.miui.theme.tool.os.OS;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.resourceeditor.ResourceMainPanel;
import com.miui.theme.tool.upsidescene.TextEditorView;
import com.miui.theme.tool.upsidescene.screen.SceneData;
import com.miui.theme.tool.util.GridBagHelper;
import com.miui.theme.tool.util.ThemeConf;
import com.miui.theme.tool.util.ThemeHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ThemeEditPanel
extends Observable
implements ActionListener,
ItemListener,
Observer {
    static Logger logger = Logger.getLogger("EditThemePanel");
    private JTabbedPane mEditThemePane;
    private EditModuleTableModel mModuleTableModel;
    private JFileChooser jfc;
    private HashMap<String, Member> mHashMapApp = null;
    private String userDir = ThemeHelper.getUserDir();
    private Object selectedItem;
    private JPanel mIconsPanel;
    private JPanel paneEditModule = new JPanel();
    private JPanel paneGetRes;
    private JButton mOpenThemeButton;
    private JButton mCreateModuleButton;
    public JLabel mModuleState;
    private JScrollPane scrollPaneThemeValue;
    private EditModuleTable mModuleTable;
    private JComboBox boxItem;
    private JPanel descPanel;
    private JLabel themeCoverLabel;
    private JTextField textTitle;
    private JTextField textAuthor;
    private JTextField textDesigner;
    private JTextField textVersion;
    private JComboBox textUIVersion;
    private JLabel stateLabel;
    private ImageLabel coverLabel;
    private JPanel paneBoots;
    private JPanel bootsPane;
    private AnimationPlayPanel preview;
    private DefaultTableModel bootsAnimationModel;
    private JPopupMenu bootsPopupMenu;
    private JMenuItem itemDel;
    private JMenuItem itemAdd;
    private JTextField textWidth;
    private JTextField textHeight;
    private JTextField textFrameNumPerSec;
    private JLabel labelHit;
    private int folderNum;
    private MyKeyListener myKeyFolderLetter;
    private JTable table;
    private String[][] data;
    private JScrollPane bootsEditPanel;
    private String[] colums_name = new String[]{ResourceFactory.getString("boot_animation_folder"), ResourceFactory.getString("boot_play_num"), ResourceFactory.getString("boot_pause_frames_after_finish_play")};
    private JLabel bootsSaveState;
    private boolean bootsExist;
    private JButton nextFrameBtn;
    private JButton preFrameBtn;
    private boolean mIsLoadingFlag = true;
    JPanel mScenePane;
    String[] iconsDirs = new String[]{"icons" + File.separator + "res" + File.separator + "drawable-hdpi", "icons" + File.separator + "res" + File.separator + "drawable-xhdpi", "icons"};
    int iconsTabIndex = 0;
    private JPanel mScenePaneWrapper;
    private JButton mChangeModeButton;
    private ResourceMainPanel mResourceEditorPanel;
    private JPanel mThemeValuePanel;
    private GridBagLayout mModulePanelLayout;
    private JButton mDeleteModuleButton;
    private JButton mOpenInExplorerButton;
    private JButton mResetThemeValuesButton;
    private JButton mRefreshCatalogButton;
    private JComboBox mTypeComboBox;
    private JComboBox mPackageComboBox;
    boolean firstAdjustFlag = true;
    private Vector<Vector<String>> mThemeValues;
    private Vector<Vector<String>> mCatalogThemeValues;
    private Vector<Vector<String>> mFrameworkThemeValues;
    private Vector<Vector<String>> mFrameworkMiuiThemeValues;
    public static final int DESCRIPTION_PANEL = 0;
    public static final int ICONS_PANEL = 1;
    public static final int MODULES_PANEL = 2;
    public static final int BOOT_PANEL = 3;
    public static final int SCENE_PANEL = 4;
    private HashMap<String, Vector<String>> mThemeHashMap;
    private Vector<Vector<String>> mCatalogThemeData;
    private HashMap<String, Vector<String>> mCatalogHashMap;
    private String mCurrentItemPackageName;
    private ActionListener mFilterChangeListener;

    public ThemeEditPanel() {
        this.mEditThemePane = new JTabbedPane(1);
        this.initDescriptionPanel();
        this.readDescription();
        this.initIconsPanel2();
        this.initModulePanel();
        this.initBootsPanel();
        this.mEditThemePane.addTab(ResourceFactory.getString("tab_description"), null, this.descPanel, null);
        this.mEditThemePane.addTab(ResourceFactory.getString("tab_icon"), null, this.mIconsPanel, null);
        this.mEditThemePane.addTab(ResourceFactory.getString("tab_module"), null, this.paneEditModule, null);
        this.mEditThemePane.addTab(ResourceFactory.getString("tab_boot"), null, this.paneBoots, null);
        if (this.initScenePanelWrapper()) {
            this.mEditThemePane.addTab(ResourceFactory.getString("tab_scene"), null, this.mScenePaneWrapper, null);
        }
        this.mEditThemePane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (ThemeEditPanel.this.mEditThemePane.getSelectedIndex() == 0) {
                    ThemeEditPanel.this.setChanged();
                    ThemeEditPanel.this.notifyObservers("");
                } else if (ThemeEditPanel.this.mEditThemePane.getSelectedIndex() == 1) {
                    ThemeEditPanel.this.setChanged();
                    ThemeEditPanel.this.notifyObservers("icons");
                } else if (ThemeEditPanel.this.mEditThemePane.getSelectedIndex() == 2) {
                    ThemeEditPanel.this.setChanged();
                    ThemeEditPanel.this.notifyObservers("");
                } else if (ThemeEditPanel.this.mEditThemePane.getSelectedIndex() == 3) {
                    ThemeEditPanel.this.setChanged();
                    ThemeEditPanel.this.notifyObservers("boots");
                } else if (ThemeEditPanel.this.mEditThemePane.getSelectedIndex() == 4) {
                    ThemeEditPanel.this.setChanged();
                    if (ThemeEditPanel.this.mScenePane instanceof TextEditorView) {
                        ThemeEditPanel.this.notifyObservers(SceneData.getSceneFolderName());
                    } else if (ThemeEditPanel.this.mScenePane instanceof FreeStylePanel) {
                        ThemeEditPanel.this.notifyObservers("com.miui.home.freestyle");
                    }
                }
            }
        });
        this.mIsLoadingFlag = false;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!MainFrame.auto) {
                    return;
                }
                ThemeEditPanel.this.mEditThemePane.setSelectedIndex(2);
                ThemeEditPanel.this.boxItem.setSelectedIndex(1);
                System.out.println("do click");
            }
        });
    }

    public JTabbedPane getPanel() {
        return this.mEditThemePane;
    }

    private void initIconsPanel2() {
        this.mIconsPanel = new IconReplacePanel();
    }

    private void initModulePanel() {
        this.paneEditModule.removeAll();
        this.mModulePanelLayout = new GridBagLayout();
        GridBagConstraints gc = new GridBagConstraints();
        this.paneEditModule.setLayout(this.mModulePanelLayout);
        gc.fill = 1;
        gc.anchor = 17;
        gc.insets = new Insets(10, 10, 10, 10);
        JLabel label = new JLabel(ResourceFactory.getString("item_item"));
        label.setBounds(20, 24, 76, 20);
        gc.gridx = 0;
        gc.gridy = 0;
        this.mModulePanelLayout.setConstraints(label, gc);
        this.paneEditModule.add(label);
        this.boxItem = new JComboBox();
        gc.gridx = 1;
        gc.gridy = 0;
        gc.gridwidth = 1;
        this.mModulePanelLayout.setConstraints(this.boxItem, gc);
        this.initBoxItem();
        this.paneEditModule.add(this.boxItem);
        this.boxItem.addItemListener(this);
        this.paneGetRes = new JPanel();
        gc.gridx = 2;
        gc.gridy = 0;
        gc.gridwidth = 2;
        gc.gridheight = 1;
        this.mModulePanelLayout.setConstraints(this.paneGetRes, gc);
        this.paneEditModule.add(this.paneGetRes);
        this.mOpenThemeButton = new JButton(ResourceFactory.getString("item_chooseapkfromcomputer"));
        this.paneGetRes.add(this.mOpenThemeButton);
        this.mOpenThemeButton.addActionListener(this);
        this.mOpenThemeButton.setVisible(false);
        this.mRefreshCatalogButton = new JButton(ResourceFactory.getString("item_refreshcatalog"));
        this.mRefreshCatalogButton.addActionListener(this);
        this.paneGetRes.add(this.mRefreshCatalogButton);
        this.mCreateModuleButton = new JButton(ResourceFactory.getString("item_createmodule"));
        this.paneGetRes.add(this.mCreateModuleButton);
        this.mCreateModuleButton.addActionListener(this);
        this.mDeleteModuleButton = new JButton(ResourceFactory.getString("item_delete"));
        this.paneGetRes.add(this.mDeleteModuleButton);
        this.mDeleteModuleButton.addActionListener(this);
        this.mChangeModeButton = new JButton(ResourceFactory.getString("item_changeMode"));
        this.paneGetRes.add(this.mChangeModeButton);
        this.mChangeModeButton.addActionListener(this);
        this.mOpenInExplorerButton = new JButton(ResourceFactory.getString("catalog_openinexplorer"));
        this.paneGetRes.add(this.mOpenInExplorerButton);
        this.mOpenInExplorerButton.addActionListener(this);
        this.mModuleState = new JLabel();
        this.mModuleState.setText("");
        this.mModuleState.setForeground(Color.red);
        this.paneGetRes.add(this.mModuleState);
        this.mThemeValuePanel = new JPanel();
        this.mThemeValuePanel.setBorder(new TitledBorder(null, ResourceFactory.getString("item_edit_themevalues"), 4, 2, null, null));
        GridBagHelper.addComponent(this.paneEditModule, this.mThemeValuePanel, 0, 2, 5, 1, 1, 1, 10, 10, 1.0, 0.5, 1, 10);
        this.initModuleTable();
        this.scrollPaneThemeValue = new JScrollPane();
        this.scrollPaneThemeValue.setViewportView(this.mModuleTable);
        this.mThemeValuePanel.setLayout(new GridBagLayout());
        this.mTypeComboBox = new JComboBox<String>(new String[]{"bool", "color", "dimen", "drawable", "fraction", "integer", "string"});
        this.mPackageComboBox = new JComboBox<String>(new String[]{"", "android", "miui"});
        this.mTypeComboBox.setSelectedItem("color");
        this.mPackageComboBox.setSelectedItem("");
        this.mTypeComboBox.setEnabled(false);
        this.mPackageComboBox.setEnabled(false);
        this.mFilterChangeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThemeEditPanel.this.mModuleTableModel.setFilter(ThemeEditPanel.this.mTypeComboBox.getSelectedItem().toString(), ThemeEditPanel.this.mPackageComboBox.getSelectedItem().toString());
                ThemeEditPanel.this.mModuleTable.refreshUI();
                ThemeEditPanel.this.mModuleTable.fillComments();
            }
        };
        this.mResetThemeValuesButton = new JButton(ResourceFactory.getString("item_edit_themevalues_context_reset"));
        this.mResetThemeValuesButton.addActionListener(this);
        this.mResetThemeValuesButton.setEnabled(false);
        int x = 0;
        int y = 0;
        int dx = 5;
        GridBagHelper.addComponent(this.mThemeValuePanel, this.mPackageComboBox, x, y, 1, 1, 1, 1, dx, dx, 0.0, 0.0, 0, 17);
        GridBagHelper.addComponent(this.mThemeValuePanel, this.mTypeComboBox, ++x, y, 1, 1, 1, 1, dx, dx, 0.0, 0.0, 0, 17);
        x = 0;
        GridBagHelper.addComponent(this.mThemeValuePanel, this.scrollPaneThemeValue, x, ++y, 2, 1, 1, 1, 1.0, 1.0, 1, 10);
        x = 0;
        GridBagHelper.addComponent(this.mThemeValuePanel, this.mResetThemeValuesButton, x, ++y, 2, 1, 1, 1, 1.0, 0.0, 0, 10);
        this.mModuleTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int[] rows = ThemeEditPanel.this.mModuleTable.getSelectedRows();
                int i = 0;
                while (i < rows.length) {
                    if (ThemeEditPanel.this.mModuleTableModel.isRowChanged(rows[i])) {
                        ThemeEditPanel.this.mResetThemeValuesButton.setEnabled(true);
                        return;
                    }
                    ++i;
                }
                ThemeEditPanel.this.mResetThemeValuesButton.setEnabled(false);
            }
        });
        this.paneEditModule.validate();
        this.paneEditModule.repaint();
    }

    private void initDescriptionPanel() {
        this.descPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints gc = new GridBagConstraints();
        this.descPanel.setLayout(layout);
        gc.fill = 1;
        gc.anchor = 17;
        gc.insets = new Insets(10, 10, 10, 10);
        JLabel label = new JLabel(ResourceFactory.getString("desc_name"));
        gc.gridx = 0;
        gc.gridy = 4;
        gc.weighty = 0.0;
        gc.weightx = 0.0;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        layout.setConstraints(label, gc);
        this.descPanel.add(label);
        this.textTitle = new JTextField(ThemeHelper.sThemeName);
        gc.gridx = 1;
        gc.gridy = 4;
        gc.gridwidth = 2;
        gc.weightx = 0.2;
        layout.setConstraints(this.textTitle, gc);
        this.descPanel.add(this.textTitle);
        this.textTitle.setColumns(20);
        JLabel label_2 = new JLabel(ResourceFactory.getString("desc_author"));
        gc.gridx = 0;
        gc.gridy = 5;
        gc.weightx = 0.0;
        gc.gridwidth = 1;
        layout.setConstraints(label_2, gc);
        this.descPanel.add(label_2);
        this.textAuthor = new JTextField(ResourceFactory.getString("default"));
        gc.gridx = 1;
        gc.gridy = 5;
        gc.weightx = 0.2;
        gc.gridwidth = 2;
        layout.setConstraints(this.textAuthor, gc);
        this.descPanel.add(this.textAuthor);
        this.textAuthor.setColumns(20);
        JLabel label_1 = new JLabel(ResourceFactory.getString("desc_designer"));
        gc.gridx = 0;
        gc.gridy = 6;
        gc.weightx = 0.0;
        gc.gridwidth = 1;
        layout.setConstraints(label_1, gc);
        this.descPanel.add(label_1);
        this.textDesigner = new JTextField(ResourceFactory.getString("default"));
        gc.gridx = 1;
        gc.gridy = 6;
        gc.weightx = 0.2;
        gc.gridwidth = 2;
        layout.setConstraints(this.textDesigner, gc);
        this.descPanel.add(this.textDesigner);
        this.textDesigner.setColumns(20);
        JLabel label_3 = new JLabel(ResourceFactory.getString("desc_version"));
        gc.gridx = 0;
        gc.gridy = 7;
        gc.weightx = 0.0;
        gc.gridwidth = 1;
        layout.setConstraints(label_3, gc);
        this.descPanel.add(label_3);
        this.textVersion = new JTextField("1.0");
        gc.gridx = 1;
        gc.gridy = 7;
        gc.gridwidth = 2;
        gc.weightx = 0.2;
        layout.setConstraints(this.textVersion, gc);
        this.descPanel.add(this.textVersion);
        this.textVersion.setColumns(20);
        JLabel lblUi = new JLabel(ResourceFactory.getString("desc_uiversion"));
        gc.gridx = 0;
        gc.gridy = 8;
        gc.weightx = 0.0;
        gc.gridwidth = 1;
        layout.setConstraints(lblUi, gc);
        this.descPanel.add(lblUi);
        this.textUIVersion = new JComboBox<String>(ThemeHelper.UI_VERSION_LABEL);
        this.textUIVersion.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                int version = Integer.parseInt(ThemeHelper.UI_VERSION_VALUE[ThemeEditPanel.this.textUIVersion.getSelectedIndex()]);
                if (ThemeEditPanel.this.mIsLoadingFlag) {
                    ThemeHelper.sThemeVersion = version;
                } else if (ThemeHelper.sThemeVersion != version && MainFrame.getInstance().checkAndSave(true)) {
                    MainFrame.getInstance().reloadEditor();
                    StateBar.getInstance().setText(ResourceFactory.getString("reloaded"));
                }
            }
        });
        gc.gridx = 1;
        gc.gridy = 8;
        gc.weightx = 0.2;
        gc.gridwidth = 2;
        layout.setConstraints(this.textUIVersion, gc);
        this.descPanel.add(this.textUIVersion);
        this.textUIVersion.setSelectedIndex(2);
        this.stateLabel = new JLabel("           ");
        this.stateLabel.setForeground(Color.red);
        gc.gridx = 2;
        gc.gridy = 13;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        layout.setConstraints(this.stateLabel, gc);
        this.descPanel.add(this.stateLabel);
        this.coverLabel = new ImageLabel();
        this.themeCoverLabel = this.coverLabel.showLabel();
        this.coverLabel.setImgPath(String.valueOf(ThemeHelper.sThemeFolderPath) + File.separator + "preview" + File.separator + "preview_cover_0.jpg");
        gc.gridx = 3;
        gc.gridy = 0;
        gc.gridwidth = 4;
        gc.gridheight = 13;
        gc.weightx = 1.0;
        gc.weighty = 0.5;
        this.themeCoverLabel.setBorder(new TitledBorder(new LineBorder(new Color(184, 207, 229)), ResourceFactory.getString("desc_cover"), 4, 2, null, new Color(51, 51, 51)));
        layout.setConstraints(this.themeCoverLabel, gc);
        this.descPanel.add(this.themeCoverLabel);
    }

    private boolean initScenePanelWrapper() {
        this.mScenePaneWrapper = new JPanel();
        if (this.initScenePanel()) {
            return true;
        }
        JButton createSceneButton = new JButton(ResourceFactory.getString("scene_create_sample"));
        Font font = createSceneButton.getFont();
        createSceneButton.setFont(font.deriveFont(1, 24.0f));
        GridBagLayout gbl = new GridBagLayout();
        this.mScenePaneWrapper.setLayout(gbl);
        GridBagHelper.addComponent(this.mScenePaneWrapper, createSceneButton, 0, 1, 1, 1, 1, 0, 0.0, 0.0, 2, 10);
        createSceneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        return false;
    }

    private boolean initScenePanel() {
        String sceneXmlPath = String.valueOf(SceneData.getSceneLocation()) + File.separator + "scene.xml";
        File sceneFile = new File(sceneXmlPath);
        if (ThemeHelper.sThemeVersion == 2) {
            if (sceneFile.exists()) {
                this.mScenePane = new TextEditorView();
                this.mScenePaneWrapper.removeAll();
                this.mScenePaneWrapper.setLayout(new BorderLayout());
                this.mScenePaneWrapper.add((Component)this.mScenePane, "Center");
                ((TextEditorView)this.mScenePane).onFileSelected(sceneFile);
                return true;
            }
        } else if (ThemeHelper.sThemeVersion == 3) {
            String freeStylePath = FreeStylePanel.getFreeStylePath();
            File freeStyleFile = new File(freeStylePath);
            if (sceneFile.exists() && !freeStyleFile.exists()) {
                Object[] options = new Object[]{ResourceFactory.getString("global_yes"), ResourceFactory.getString("global_no")};
                int response = JOptionPane.showOptionDialog(null, ResourceFactory.getString("check_convert_freestyle"), "", 0, 1, null, options, options[0]);
                if (response == 0) {
                    FreeStyleConverter.convert(SceneData.getSceneLocation(), freeStylePath);
                } else {
                    return false;
                }
            }
            if (freeStyleFile.exists()) {
                this.mScenePane = new FreeStylePanel();
                this.mScenePaneWrapper.removeAll();
                this.mScenePaneWrapper.setLayout(new BorderLayout());
                this.mScenePaneWrapper.add((Component)this.mScenePane, "Center");
                ((FreeStylePanel)this.mScenePane).onFileSelected(freeStyleFile);
                return true;
            }
        }
        return false;
    }

    private boolean deleteFile(File file) {
        if (file.exists()) {
            if (file.isFile()) {
                file.delete();
            } else if (file.isDirectory()) {
                File[] files = file.listFiles();
                int i = 0;
                while (i < files.length) {
                    this.deleteFile(files[i]);
                    ++i;
                }
            }
        } else {
            return false;
        }
        file.delete();
        return true;
    }

    private void initBootsPanel() {
        if (this.paneBoots == null) {
            this.paneBoots = new JPanel();
        } else {
            this.paneBoots.removeAll();
        }
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints gc = new GridBagConstraints();
        this.paneBoots.setLayout(layout);
        gc.fill = 1;
        gc.anchor = 17;
        gc.insets = new Insets(10, 10, 10, 10);
        this.bootsPane = new JPanel();
        gc.gridx = 0;
        gc.gridy = 2;
        gc.gridwidth = 3;
        gc.weightx = 1.0;
        gc.weighty = 0.5;
        layout.setConstraints(this.bootsPane, gc);
        this.bootsExist = false;
        final String boot_dir = String.valueOf(ThemeHelper.sThemeFolderPath) + File.separator + "boots";
        String str = String.valueOf(boot_dir) + File.separator + "bootanimation";
        if (new File(str).exists()) {
            this.bootsExist = true;
            this.bootsPane.setLayout(layout);
            JLabel l1 = new JLabel(ResourceFactory.getString("boot_screen_width"));
            gc.gridwidth = 1;
            gc.weightx = 0.1;
            gc.weighty = 0.0;
            gc.gridx = 0;
            gc.gridy = 0;
            layout.setConstraints(l1, gc);
            this.bootsPane.add(l1);
            this.textWidth = new JTextField(10);
            this.textWidth.setText("          ");
            gc.gridx = 1;
            gc.gridy = 0;
            gc.weightx = 0.2;
            layout.setConstraints(this.textWidth, gc);
            this.bootsPane.add(this.textWidth);
            JLabel l2 = new JLabel(ResourceFactory.getString("boot_screen_height"));
            gc.gridx = 2;
            gc.gridy = 0;
            gc.weightx = 0.1;
            gc.gridwidth = 1;
            layout.setConstraints(l2, gc);
            this.bootsPane.add(l2);
            this.textHeight = new JTextField(10);
            this.textHeight.setText("          ");
            gc.gridx = 3;
            gc.gridy = 0;
            gc.weightx = 0.2;
            layout.setConstraints(this.textHeight, gc);
            this.bootsPane.add(this.textHeight);
            JLabel l3 = new JLabel(ResourceFactory.getString("boot_frame_per_second"));
            gc.gridx = 0;
            gc.gridy = 1;
            gc.gridwidth = 1;
            gc.weightx = 0.1;
            layout.setConstraints(l3, gc);
            this.bootsPane.add(l3);
            this.textFrameNumPerSec = new JTextField(10);
            this.textFrameNumPerSec.setText("          ");
            gc.gridx = 1;
            gc.gridy = 1;
            gc.weightx = 0.2;
            layout.setConstraints(this.textFrameNumPerSec, gc);
            this.bootsPane.add(this.textFrameNumPerSec);
            JLabel labelInfo = new JLabel();
            gc.gridx = 0;
            gc.gridy = 2;
            gc.gridwidth = 4;
            gc.weightx = 0.0;
            layout.setConstraints(labelInfo, gc);
            this.bootsPane.add(labelInfo);
            this.initBootsEditPane();
            gc.gridx = 0;
            gc.gridy = 3;
            gc.gridwidth = 6;
            gc.weighty = 0.5;
            layout.setConstraints(this.bootsEditPanel, gc);
            this.bootsPane.add(this.bootsEditPanel);
            labelInfo.setText(String.valueOf(ResourceFactory.getString("boot_config_table_lbl_1")) + " " + this.folderNum + " " + ResourceFactory.getString("boot_config_table_lbl_2"));
            this.labelHit = new JLabel(ResourceFactory.getString("boot_config_tip"));
            gc.gridx = 0;
            gc.gridy = 4;
            gc.gridwidth = 4;
            gc.weightx = 0.0;
            gc.weighty = 0.0;
            layout.setConstraints(this.labelHit, gc);
            this.bootsPane.add(this.labelHit);
            JButton deleteBoots = new JButton();
            deleteBoots.setText(ResourceFactory.getString("boot_delete"));
            gc.gridx = 0;
            gc.gridy = 0;
            gc.gridwidth = 2;
            gc.weightx = 0.0;
            gc.weighty = 0.0;
            layout.setConstraints(deleteBoots, gc);
            this.paneBoots.add(deleteBoots);
            deleteBoots.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ThemeEditPanel.this.deleteFile(new File(boot_dir))) {
                        StateBar.getInstance().setText(ResourceFactory.getString("boots_deleted"));
                    }
                    ThemeEditPanel.this.initBootsPanel();
                }
            });
        } else {
            JButton createSample = new JButton();
            createSample.setText(ResourceFactory.getString("boot_create_sample"));
            gc.gridx = 0;
            gc.gridy = 0;
            gc.gridwidth = 2;
            gc.weightx = 0.0;
            gc.weighty = 0.0;
            layout.setConstraints(createSample, gc);
            this.paneBoots.add(createSample);
            createSample.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    logger.info("extracting boot animation");
                    String src = "tools" + File.separator + "boots.zip";
                    String des = String.valueOf(ThemeHelper.sThemeFolderPath) + File.separator;
                    logger.info(src);
                    logger.info(des);
                    new Extractor(src, des).unzipTheme();
                    ThemeEditPanel.this.initBootsPanel();
                }
            });
        }
        this.bootsPane.setBorder(new TitledBorder(new LineBorder(new Color(184, 207, 229)), ResourceFactory.getString("boot_config_title"), 4, 2, null, new Color(51, 51, 51)));
        this.paneBoots.add(this.bootsPane);
        this.bootsSaveState = new JLabel("");
        this.bootsSaveState.setForeground(Color.red);
        gc.gridx = 1;
        gc.gridy = 3;
        gc.gridwidth = 1;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        layout.setConstraints(this.bootsSaveState, gc);
        this.paneBoots.add(this.bootsSaveState);
        this.preview = new AnimationPlayPanel();
        this.preview.setBorder(new TitledBorder(new LineBorder(new Color(184, 207, 229)), ResourceFactory.getString("boot_preview"), 4, 2, null, new Color(51, 51, 51)));
        gc.gridx = 3;
        gc.gridy = 2;
        gc.gridwidth = 5;
        gc.weightx = 2.0;
        gc.weighty = 0.5;
        layout.setConstraints(this.preview, gc);
        this.paneBoots.add(this.preview);
        final JButton playBtn = new JButton(ResourceFactory.getString("boot_preview_play"));
        final JButton pauseBtn = new JButton(ResourceFactory.getString("boot_preview_pause"));
        final JButton stopBtn = new JButton(ResourceFactory.getString("boot_preview_stop"));
        gc.gridx = 7;
        gc.gridy = 3;
        gc.gridwidth = 1;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        layout.setConstraints(stopBtn, gc);
        stopBtn.setEnabled(false);
        this.paneBoots.add(stopBtn);
        stopBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ThemeEditPanel.this.bootsExist) {
                    ThemeEditPanel.this.preview.stop();
                    playBtn.setEnabled(true);
                    stopBtn.setEnabled(false);
                    pauseBtn.setEnabled(false);
                }
            }
        });
        this.nextFrameBtn = new JButton(ResourceFactory.getString("boot_preview_nextframe"));
        gc.gridx = 3;
        gc.gridy = 3;
        gc.gridwidth = 1;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        layout.setConstraints(playBtn, gc);
        playBtn.setEnabled(this.bootsExist);
        this.paneBoots.add(playBtn);
        playBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (ThemeEditPanel.this.bootsExist) {
                    int fps;
                    int height;
                    int width;
                    try {
                        width = Integer.parseInt(ThemeEditPanel.this.textWidth.getText().trim());
                        height = Integer.parseInt(ThemeEditPanel.this.textHeight.getText().trim());
                        fps = Integer.parseInt(ThemeEditPanel.this.textFrameNumPerSec.getText().trim());
                    }
                    catch (NumberFormatException e) {
                        JOptionPane.showMessageDialog(null, ResourceFactory.getString("boot_config_save_tip_illegal_whf"));
                        return;
                    }
                    String[][] data = ThemeEditPanel.this.getBootsCellData();
                    if (data == null) {
                        JOptionPane.showMessageDialog(null, ResourceFactory.getString("boot_config_save_tip_illegal_table"));
                        return;
                    }
                    ThemeEditPanel.this.preview.play(String.valueOf(ThemeHelper.sThemeFolderPath) + File.separator + "boots" + File.separator + "bootanimation", width, height, fps, data);
                    playBtn.setEnabled(false);
                    pauseBtn.setEnabled(true);
                    stopBtn.setEnabled(true);
                }
            }
        });
        gc.gridx = 4;
        gc.gridy = 3;
        gc.gridwidth = 1;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        layout.setConstraints(pauseBtn, gc);
        pauseBtn.setEnabled(false);
        this.paneBoots.add(pauseBtn);
        pauseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThemeEditPanel.this.preview.pause();
                pauseBtn.setEnabled(false);
                playBtn.setEnabled(true);
            }
        });
        this.preFrameBtn = new JButton(ResourceFactory.getString("boot_preview_preframe"));
        gc.gridx = 5;
        gc.gridy = 3;
        gc.gridwidth = 1;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        layout.setConstraints(this.preFrameBtn, gc);
        this.preFrameBtn.setEnabled(this.bootsExist);
        this.paneBoots.add(this.preFrameBtn);
        this.preFrameBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (ThemeEditPanel.this.bootsExist) {
                    int fps;
                    int height;
                    int width;
                    try {
                        width = Integer.parseInt(ThemeEditPanel.this.textWidth.getText().trim());
                        height = Integer.parseInt(ThemeEditPanel.this.textWidth.getText().trim());
                        fps = Integer.parseInt(ThemeEditPanel.this.textWidth.getText().trim());
                    }
                    catch (NumberFormatException e) {
                        JOptionPane.showMessageDialog(null, ResourceFactory.getString("boot_config_save_tip_illegal_whf"));
                        return;
                    }
                    String[][] data = ThemeEditPanel.this.getBootsCellData();
                    if (data == null) {
                        JOptionPane.showMessageDialog(null, ResourceFactory.getString("boot_config_save_tip_illegal_table"));
                        return;
                    }
                    ThemeEditPanel.this.preview.preFrame(String.valueOf(ThemeHelper.sThemeFolderPath) + File.separator + "boots" + File.separator + "bootanimation", width, height, fps, data);
                }
            }
        });
        gc.gridx = 6;
        gc.gridy = 3;
        gc.gridwidth = 1;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        layout.setConstraints(this.nextFrameBtn, gc);
        this.nextFrameBtn.setEnabled(this.bootsExist);
        this.nextFrameBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (ThemeEditPanel.this.bootsExist) {
                    int fps;
                    int height;
                    int width;
                    try {
                        width = Integer.parseInt(ThemeEditPanel.this.textWidth.getText().trim());
                        height = Integer.parseInt(ThemeEditPanel.this.textWidth.getText().trim());
                        fps = Integer.parseInt(ThemeEditPanel.this.textWidth.getText().trim());
                    }
                    catch (NumberFormatException e) {
                        JOptionPane.showMessageDialog(null, ResourceFactory.getString("boot_config_save_tip_illegal_whf"));
                        return;
                    }
                    String[][] data = ThemeEditPanel.this.getBootsCellData();
                    if (data == null) {
                        JOptionPane.showMessageDialog(null, ResourceFactory.getString("boot_config_save_tip_illegal_table"));
                        return;
                    }
                    ThemeEditPanel.this.preview.nextFrame(String.valueOf(ThemeHelper.sThemeFolderPath) + File.separator + "boots" + File.separator + "bootanimation", width, height, fps, data);
                }
            }
        });
        this.paneBoots.add(this.nextFrameBtn);
        this.paneBoots.validate();
        this.paneBoots.setVisible(true);
        this.paneBoots.repaint();
    }

    private void initModuleTable() {
        this.mModuleTableModel = new EditModuleTableModel();
        this.mModuleTable = new EditModuleTable(this.mModuleTableModel);
        this.mModuleTable.setSelectionMode(2);
        this.mModuleTable.setRowHeight(20);
    }

    private void initBoxItem() {
        this.boxItem.removeAllItems();
        this.boxItem.addItem("                             ");
        File themeFile = new File(ThemeHelper.sThemeFolderPath);
        if (themeFile == null || !themeFile.exists()) {
            return;
        }
        if (this.mHashMapApp == null) {
            try {
                this.mHashMapApp = ApkSelectDialog.getHashMapApps(null, null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        File[] fileArray = themeFile.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File eachFile = fileArray[n2];
            if (!(!eachFile.isDirectory() || MtzCompressor.isNoCompressDir(eachFile.getName()) || eachFile.getName().equals("icons") || eachFile.getName().equals("lockscreen") || eachFile.getName().equals("com.miui.home.upside"))) {
                String itemName = this.getItemNameFromPackageName(eachFile.getName());
                this.boxItem.addItem(itemName);
            }
            ++n2;
        }
    }

    private String getItemNameFromPackageName(String packageName) {
        if (this.mHashMapApp != null) {
            for (String key : this.mHashMapApp.keySet()) {
                Member member = this.mHashMapApp.get(key);
                if (!member.mPackageName.equals(packageName)) continue;
                return String.valueOf(key) + "(" + packageName + ")";
            }
        }
        return packageName;
    }

    private void readDescription() {
        String str = ThemeHelper.sThemeFolderPath;
        File themeDescFile = new File(String.valueOf(str) + File.separator + "description.xml");
        if (!themeDescFile.exists() || !themeDescFile.isFile()) {
            return;
        }
        try {
            DocumentBuilderFactory domfac = DocumentBuilderFactory.newInstance();
            DocumentBuilder dombuilder = domfac.newDocumentBuilder();
            FileInputStream is = new FileInputStream(themeDescFile);
            Document doc = dombuilder.parse(is);
            String title = "";
            String designer = "";
            String author = "";
            String version = "";
            String uiVersion = "";
            if (doc.getFirstChild() == null || !doc.getFirstChild().getNodeName().equals("MIUI-Theme")) {
                JOptionPane.showMessageDialog(this.mEditThemePane, "\u4e3b\u9898\u5305\u4e2d\u7684description.xml\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u6839\u5143\u7d20\u5fc5\u987b\u662fMIUI-Theme,\u8bf7\u4fee\u6539\u540e\u518d\u6253\u5305\uff01");
            }
            NodeList titles = doc.getElementsByTagName("title");
            NodeList designers = doc.getElementsByTagName("designer");
            NodeList authors = doc.getElementsByTagName("author");
            NodeList versions = doc.getElementsByTagName("version");
            NodeList uiVersions = doc.getElementsByTagName("uiVersion");
            if (titles == null || titles.item(0) == null) {
                JOptionPane.showMessageDialog(this.mEditThemePane, "\u4e3b\u9898\u5305\u4e2d\u7684description.xml\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u5176\u4e2dMIUI-Theme\u4e0b\u4e0d\u5b58\u5728title\u5143\u7d20");
            } else if (titles.item(0).getFirstChild() != null) {
                title = titles.item(0).getFirstChild().getNodeValue().trim();
            }
            if (designers != null && designers.item(0) != null && designers.item(0).getFirstChild() != null) {
                designer = designers.item(0).getFirstChild().getNodeValue().trim();
            }
            if (authors == null || authors.item(0) == null) {
                JOptionPane.showMessageDialog(this.mEditThemePane, "\u4e3b\u9898\u5305\u4e2d\u7684description.xml\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u5176\u4e2dMIUI-Theme\u4e0b\u4e0d\u5b58\u5728author\u5143\u7d20");
            } else if (authors.item(0).getFirstChild() != null) {
                author = authors.item(0).getFirstChild().getNodeValue().trim();
            }
            if (versions == null || versions.item(0) == null) {
                JOptionPane.showMessageDialog(this.mEditThemePane, "\u4e3b\u9898\u5305\u4e2d\u7684description.xml\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u5176\u4e2dMIUI-Theme\u4e0b\u4e0d\u5b58\u5728version\u5143\u7d20");
            } else if (versions.item(0).getFirstChild() != null) {
                version = versions.item(0).getFirstChild().getNodeValue().trim();
            }
            if (uiVersions == null || uiVersions.item(0) == null) {
                uiVersion = "1";
            } else if (uiVersions.item(0).getFirstChild() != null) {
                uiVersion = uiVersions.item(0).getFirstChild().getNodeValue().trim();
            }
            this.textTitle.setText(title);
            this.textDesigner.setText(designer);
            this.textAuthor.setText(author);
            this.textVersion.setText(version);
            if (!ThemeHelper.sUiVersionMap.containsKey(uiVersion)) {
                uiVersion = "1";
            }
            this.textUIVersion.setSelectedItem(ThemeHelper.sUiVersionMap.get(uiVersion));
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.mEditThemePane, "\u89e3\u6790\u4e3b\u9898\u5305\u4e2d\u7684description.xml\u51fa\u73b0\u9519\u8bef\uff0c\u8be5xml\u6587\u4ef6\u6839\u5143\u7d20\u5fc5\u987b\u662fMIUI-Theme,\u5b50\u5143\u7d20\u5305\u62ectitle,designer,author,version,uiVersion\u8bf7\u4fee\u6539\u540e\u518d\u6253\u5305\uff01");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.mOpenThemeButton) {
            this.jfc = new JFileChooser();
            this.jfc.setDialogTitle("\u9009\u62e9\u4e00\u4e2aapk\u6587\u4ef6");
            this.jfc.setCurrentDirectory(new File(ThemeHelper.sLastClosedInfo.get("apkPath")));
            this.jfc.setFileSelectionMode(0);
            this.jfc.addChoosableFileFilter(new javax.swing.filechooser.FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    return file.isFile() && file.getName().toLowerCase().endsWith(".apk");
                }

                @Override
                public String getDescription() {
                    return ".apk file";
                }
            });
            int response = this.jfc.showOpenDialog(this.mEditThemePane);
            this.jfc.addActionListener(this);
            if (response == 0) {
                logger.debug("OK");
                String apkFilePath = this.jfc.getSelectedFile().getAbsolutePath();
                if (!this.isLegalApk(apkFilePath)) {
                    JOptionPane.showMessageDialog(this.mEditThemePane, "\u8bf7\u9009\u62e9\u4e00\u4e2aapk\u6587\u4ef6\uff01");
                    return;
                }
                File apkFile = new File(apkFilePath.trim());
                if (apkFile.getParent() != null) {
                    ThemeHelper.sLastClosedInfo.put("apkPath", apkFile.getParent());
                }
                logger.debug("start unzip apk....");
                ImportOneItemThread th = new ImportOneItemThread(apkFile);
                th.start();
            }
        } else if (e.getSource() == this.mCreateModuleButton) {
            ApkSelectDialog itemSelectDialog = new ApkSelectDialog(this.mEditThemePane, true);
            itemSelectDialog.addObserver(this);
            itemSelectDialog.openDialog();
        } else if (e.getSource() == this.mChangeModeButton) {
            if (this.boxItem.getSelectedIndex() <= 0) {
                return;
            }
            String packageName = this.getSelectedPackageName();
            if (this.mResourceEditorPanel.isVisible()) {
                this.mResourceEditorPanel.setVisible(false);
                this.mThemeValuePanel.setVisible(true);
                ThemeConf.setConf("modulestate", String.valueOf(this.textTitle.getText()) + "_" + packageName, "theme_values");
            } else if (this.mThemeValuePanel.isVisible()) {
                this.mThemeValuePanel.setVisible(false);
                this.mResourceEditorPanel.setVisible(true);
                ThemeConf.setConf("modulestate", String.valueOf(this.textTitle.getText()) + "_" + packageName, "template");
            }
            ThemeConf.writeConf("modulestate");
        } else if (e.getSource() == this.mDeleteModuleButton) {
            String item = this.boxItem.getSelectedItem().toString();
            if (item.trim().length() <= 0) {
                return;
            }
            int c = JOptionPane.showConfirmDialog(this.mEditThemePane, ResourceFactory.getString("confirm_delete_item"), item, 0);
            if (c == 0) {
                item = ThemeHelper.clearDesc(item);
                File fileToDelete = new File(String.valueOf(ThemeHelper.sThemeFolderPath) + File.separator + item);
                this.deleteFile(fileToDelete);
                this.initModulePanel();
            }
        } else if (e.getSource() == this.mOpenInExplorerButton) {
            String item = this.boxItem.getSelectedItem().toString();
            if (item.trim().length() <= 0) {
                return;
            }
            item = ThemeHelper.clearDesc(item);
            File folderToOpen = new File(String.valueOf(ThemeHelper.getResourceCatalogPath()) + File.separator + item);
            ThemeHelper.openInExplorer(folderToOpen);
        } else if (e.getSource() == this.mResetThemeValuesButton) {
            this.mModuleTable.resetSelected();
            this.mResetThemeValuesButton.setEnabled(false);
        } else if (e.getSource() == this.mRefreshCatalogButton) {
            String itemName = this.boxItem.getSelectedItem().toString();
            if (itemName.trim().length() <= 0) {
                return;
            }
            ImportOneItemThread ioit = new ImportOneItemThread(itemName);
            ioit.run();
            this.onSwitchItem(this.boxItem.getSelectedItem().toString());
            int index = this.boxItem.getSelectedIndex();
            this.boxItem.setSelectedIndex(index);
        } else if (e.getSource() == this.itemDel) {
            int r = this.table.getSelectedRow();
            if (r < 0) {
                return;
            }
            this.bootsAnimationModel.removeRow(r);
            this.updateBootsData(r);
            this.table.updateUI();
            --this.folderNum;
        } else if (e.getSource() == this.itemAdd) {
            int r = this.table.getSelectedRow();
            if (r < 0) {
                return;
            }
            Object[] t = new String[3];
            this.bootsAnimationModel.insertRow(r, t);
            this.updateBootsData(r);
            ++this.folderNum;
            this.table.updateUI();
        }
    }

    @Override
    public void update(Observable observable, Object obj) {
        if (observable instanceof ApkSelectDialog && obj instanceof HashMap) {
            this.mHashMapApp = (HashMap)obj;
        } else if (observable instanceof ApkSelectDialog && obj instanceof String) {
            this.selectedItem = obj.toString();
            if (this.selectedItem != null) {
                String selectedItemStr = this.selectedItem.toString();
                if (selectedItemStr == null || selectedItemStr.trim().equals("")) {
                    return;
                }
                logger.debug(ThemeHelper.sThemeFolderPath);
                this.createThemeModule(selectedItemStr.trim());
            }
        }
    }

    public void createThemeModule(String strSelectedItem) {
        String packageName = ThemeHelper.clearDesc(strSelectedItem);
        String themePackagePath = String.valueOf(ThemeHelper.sThemeFolderPath) + File.separator + packageName;
        File themePackageDir = new File(themePackagePath);
        if (!themePackageDir.exists()) {
            themePackageDir.mkdir();
        }
        int i = 0;
        while (i < this.boxItem.getItemCount()) {
            Object item = this.boxItem.getItemAt(i);
            if (ThemeHelper.clearDesc(item.toString()).equals(packageName)) {
                this.boxItem.removeItem(item);
            }
            ++i;
        }
        String itemToAdd = null;
        if (this.mHashMapApp != null) {
            for (String key : this.mHashMapApp.keySet()) {
                Member mem = this.mHashMapApp.get(key);
                if (!mem.mPackageName.equals(packageName)) continue;
                itemToAdd = String.valueOf(key) + "(" + packageName + ")";
            }
        } else {
            itemToAdd = packageName;
        }
        this.boxItem.addItem(itemToAdd);
        final String innerUse = itemToAdd;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ThemeEditPanel.this.boxItem.setSelectedItem(innerUse);
            }
        });
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            String itemName = e.getItem().toString();
            if (itemName.equals(this.mCurrentItemPackageName)) {
                return;
            }
            this.onSwitchItem(itemName);
        }
    }

    private void onSwitchItem(String itemName) {
        this.mCurrentItemPackageName = ThemeHelper.clearDesc(itemName);
        this.setChanged();
        this.notifyObservers(itemName.trim());
        if (itemName.trim().equals("")) {
            this.paneEditModule.remove(this.mResourceEditorPanel);
            this.mModuleTableModel.resetModel();
            this.mTypeComboBox.setEnabled(false);
            this.mPackageComboBox.setEnabled(false);
            this.mThemeValuePanel.setVisible(true);
            this.mThemeValuePanel.updateUI();
            this.mThemeValuePanel.repaint();
            return;
        }
        if (!new File(String.valueOf(ThemeHelper.getResourceCatalogPath()) + File.separator + this.mCurrentItemPackageName).exists()) {
            Object[] options = new Object[]{ResourceFactory.getString("global_yes"), ResourceFactory.getString("global_no")};
            int response = JOptionPane.showOptionDialog(null, ResourceFactory.getString("import_catalog_alert"), ResourceFactory.getString("global_override_exist"), 0, 1, null, options, options[0]);
            if (response == 0) {
                new ImportOneItemThread(itemName).run();
                if (!new File(String.valueOf(ThemeHelper.getResourceCatalogPath()) + File.separator + "framework-res").exists()) {
                    new ImportOneItemThread(this.getItemNameFromPackageName("framework-res")).run();
                }
                if (!new File(String.valueOf(ThemeHelper.getResourceCatalogPath()) + File.separator + "framework-miui-res").exists()) {
                    new ImportOneItemThread(this.getItemNameFromPackageName("framework-miui-res")).run();
                }
            }
        }
        if (this.boxItemSelectedAction(itemName)) {
            this.mTypeComboBox.removeActionListener(this.mFilterChangeListener);
            this.mPackageComboBox.removeActionListener(this.mFilterChangeListener);
            this.mTypeComboBox.setSelectedItem("color");
            this.mPackageComboBox.setSelectedItem("");
            this.mTypeComboBox.addActionListener(this.mFilterChangeListener);
            this.mPackageComboBox.addActionListener(this.mFilterChangeListener);
            this.mTypeComboBox.setEnabled(true);
            this.mPackageComboBox.setEnabled(true);
            if (this.mResourceEditorPanel != null) {
                this.paneEditModule.remove(this.mResourceEditorPanel);
            }
        }
        this.mResourceEditorPanel = new ResourceMainPanel(itemName);
        GridBagHelper.addComponent(this.paneEditModule, this.mResourceEditorPanel, 0, 2, 5, 1, 0, 1, 10, 10, 1.0, 0.5, 1, 10);
        this.showPanel(this.mCurrentItemPackageName);
        this.paneEditModule.validate();
        this.paneEditModule.repaint();
        this.mModuleTable.updateUI();
    }

    private void showPanel(String packageName) {
        String state = ThemeConf.getConf("modulestate", String.valueOf(this.textTitle.getText()) + "_" + packageName);
        if (state.equals("theme_values")) {
            this.mResourceEditorPanel.setVisible(false);
            this.mThemeValuePanel.setVisible(true);
            return;
        }
        if (state.equals("template")) {
            this.mResourceEditorPanel.setVisible(true);
            this.mThemeValuePanel.setVisible(false);
            return;
        }
        if (this.mResourceEditorPanel.hasScreenshot()) {
            this.mThemeValuePanel.setVisible(false);
        } else {
            this.mThemeValuePanel.setVisible(true);
            this.mResourceEditorPanel.setVisible(false);
        }
    }

    private void initBootsEditPane() {
        this.bootsAnimationModel = new DefaultTableModel();
        this.bootsPopupMenu = new JPopupMenu();
        this.itemDel = new JMenuItem(ResourceFactory.getString("boot_config_delete_line"));
        this.itemAdd = new JMenuItem(ResourceFactory.getString("boot_config_add_line"));
        this.bootsPopupMenu.add(this.itemDel);
        this.bootsPopupMenu.add(this.itemAdd);
        this.itemDel.addActionListener(this);
        this.itemAdd.addActionListener(this);
        String srcPath = String.valueOf(ThemeHelper.sThemeFolderPath) + File.separator + "boots" + File.separator + "bootanimation";
        String str = String.valueOf(srcPath) + File.separator + "desc.txt";
        File ff = new File(str);
        boolean loadFlag = false;
        if (ff.exists()) {
            FileInputStream in = null;
            String s = "";
            try {
                in = new FileInputStream(ff);
                BufferedReader inr = new BufferedReader(new InputStreamReader(in));
                String line = null;
                do {
                    if ((line = inr.readLine()) == null || line.trim().isEmpty() || line.startsWith("#")) continue;
                    s = String.valueOf(s) + line + "\n";
                } while (line != null);
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String[] ss = s.split("\\s{1,}");
            this.textWidth.setText(ss[0]);
            this.textHeight.setText(ss[1]);
            this.textFrameNumPerSec.setText(ss[2]);
            if (ss.length > 0 && (ss.length - 3) % 4 == 0) {
                int j = 0;
                int i = 3;
                while (i < ss.length) {
                    i += 4;
                    ++j;
                }
                this.folderNum = j;
                this.data = new String[this.folderNum][3];
                int k = 0;
                int i2 = 3;
                while (i2 < ss.length) {
                    this.data[k][i2 % 4 - 2] = ss[i2 + 1];
                    this.data[k][i2 % 4 - 1] = ss[i2 + 2];
                    this.data[k][i2 % 4 - 3] = ss[i2 + 3];
                    i2 += 4;
                    ++k;
                }
                this.bootsAnimationModel.setDataVector(this.data, this.colums_name);
                this.table = new JTable(this.bootsAnimationModel);
                this.table.setComponentPopupMenu(this.bootsPopupMenu);
                this.table.addKeyListener(this.myKeyFolderLetter);
                this.bootsEditPanel = new JScrollPane();
                this.bootsEditPanel.setViewportView(this.table);
                loadFlag = true;
            }
        }
        if (!loadFlag) {
            File f = new File(srcPath);
            Object[] fList = f.listFiles(new DirectoryFileFilter());
            Arrays.sort(fList);
            this.folderNum = fList.length;
            this.data = new String[this.folderNum][3];
            int r = 0;
            Object[] objectArray = fList;
            int n = fList.length;
            int n2 = 0;
            while (n2 < n) {
                Object eachFile = objectArray[n2];
                this.data[r][0] = ((File)eachFile).getName();
                ++r;
                ++n2;
            }
            this.bootsAnimationModel.setDataVector(this.data, this.colums_name);
            this.table = new JTable(this.bootsAnimationModel);
            this.table.setComponentPopupMenu(this.bootsPopupMenu);
            this.bootsEditPanel = new JScrollPane(this.table);
        }
        this.table.setSelectionMode(0);
        this.table.getTableHeader().setReorderingAllowed(false);
    }

    private String upCapital(String str) {
        return String.valueOf(str.substring(0, 1).toUpperCase()) + str.substring(1);
    }

    private void saveXml(String xmlFile) {
        HashMap<String, Vector<String>> dhm = this.mModuleTableModel.getDataHashMap();
        Vector<Vector<String>> themeValues = new Vector<Vector<String>>();
        for (String key : dhm.keySet()) {
            Vector<String> vs = dhm.get(key);
            Vector<String> vs1 = new Vector<String>();
            vs1.add(0, vs.get(1));
            vs1.add(1, vs.get(2));
            vs1.add(2, vs.get(4));
            vs1.add(3, vs.get(5));
            themeValues.add(vs1);
        }
        MIUIThemeValues mtv = new MIUIThemeValues();
        mtv.setXmlFile(new File(xmlFile));
        mtv.setAll(themeValues);
        mtv.save();
    }

    private boolean boxItemSelectedAction(String itemName) {
        itemName = ThemeHelper.clearDesc(itemName.toString());
        this.initThemeValues(itemName);
        this.showInTable(itemName);
        if (this.firstAdjustFlag) {
            this.mModuleTable.adjustColumnsWidth();
            this.firstAdjustFlag = false;
        }
        return true;
    }

    private void initThemeValues(String itemName) {
        String modulePath = String.valueOf(ThemeHelper.sThemeFolderPath) + File.separator + itemName;
        String catalogPath = String.valueOf(ThemeHelper.getResourceCatalogPath()) + File.separator + itemName;
        File file = new File(modulePath);
        if (!itemName.equals("") && !file.exists()) {
            file.mkdir();
        }
        File xmlValueFile = new File(String.valueOf(modulePath) + File.separator + "theme_values.xml");
        File catalogXmlValueFile = new File(String.valueOf(catalogPath) + File.separator + "theme_values.xml");
        File frameworkXmlValueFile = new File(String.valueOf(ThemeHelper.getResourceCatalogPath()) + File.separator + "framework-res" + File.separator + "theme_values.xml");
        File frameworkMiuiXmlValueFile = new File(String.valueOf(ThemeHelper.getResourceCatalogPath()) + File.separator + "framework-miui-res" + File.separator + "theme_values.xml");
        this.mThemeValues = this.getTableValueFromThemeValueFile(xmlValueFile);
        this.mCatalogThemeValues = this.getTableValueFromThemeValueFile(catalogXmlValueFile);
        this.mFrameworkThemeValues = this.getTableValueFromThemeValueFile(frameworkXmlValueFile);
        this.mFrameworkMiuiThemeValues = this.getTableValueFromThemeValueFile(frameworkMiuiXmlValueFile);
        this.mThemeHashMap = new HashMap();
        for (Vector<String> vector : this.mThemeValues) {
            this.mThemeHashMap.put(EditModuleTableModel.getMapKey(vector), vector);
        }
        this.mCatalogHashMap = new HashMap();
        this.mCatalogThemeData = this.mCatalogThemeValues;
        for (Vector<String> vector : this.mCatalogThemeData) {
            this.mCatalogHashMap.put(EditModuleTableModel.getMapKey(vector), vector);
        }
        if (!itemName.equals("framework-res") && !itemName.equals("framework-miui-res")) {
            for (Vector vector : this.mFrameworkThemeValues) {
                vector.set(5, "android");
                this.mCatalogThemeData.add(vector);
                this.mCatalogHashMap.put(EditModuleTableModel.getMapKey(vector), vector);
            }
            for (Vector vector : this.mFrameworkMiuiThemeValues) {
                vector.set(5, "miui");
                this.mCatalogThemeData.add(vector);
                this.mCatalogHashMap.put(EditModuleTableModel.getMapKey(vector), vector);
            }
        }
        for (String string : this.mThemeHashMap.keySet()) {
            if (!this.mCatalogHashMap.containsKey(string)) {
                this.mThemeHashMap.get(string).set(3, "");
                Vector<String> v = EditModuleTableModel.cloneRow(this.mThemeHashMap.get(string));
                v.set(4, "");
                this.mCatalogThemeData.add(v);
                continue;
            }
            this.mThemeHashMap.get(string).set(3, this.mCatalogHashMap.get(string).get(3));
        }
    }

    private Vector<Vector<String>> getTableValueFromThemeValueFile(File xmlValueFile) {
        Vector<Vector<String>> themeValues = MIUIThemeValues.getThemeValuesFromFile(xmlValueFile);
        Vector<Vector<String>> tableValues = new Vector<Vector<String>>();
        for (Vector<String> vs : themeValues) {
            Vector<String> vs1 = new Vector<String>();
            vs1.add(0, "");
            vs1.add(1, vs.get(0));
            vs1.add(2, vs.get(1));
            vs1.add(3, vs.get(2));
            vs1.add(4, vs.get(2));
            vs1.add(5, vs.get(3));
            tableValues.add(vs1);
        }
        return tableValues;
    }

    private void showInTable(String itemName) {
        Collections.sort(this.mCatalogThemeData, new Comparator<Vector<String>>(){

            @Override
            public int compare(Vector<String> arg0, Vector<String> arg1) {
                String type1;
                String type0 = arg0.get(1);
                if (!type0.equals(type1 = arg1.get(1))) {
                    return type0.compareTo(type1);
                }
                String name0 = arg0.get(2);
                String name1 = arg1.get(2);
                return name0.compareTo(name1);
            }
        });
        this.mModuleTableModel.mPackageName = this.getSelectedPackageName();
        this.mModuleTableModel.setCatalogDataVector(this.mCatalogThemeData);
        this.mModuleTableModel.setDataHashMap(this.mThemeHashMap);
        this.mModuleTableModel.setFilter("color", "");
        this.mModuleTable.fillComments();
        this.mModuleTableModel.checkUnchanged();
    }

    private boolean isLegalApk(String filePath) {
        if (filePath == null) {
            return false;
        }
        File apkFile = new File(filePath = filePath.trim());
        if (!apkFile.exists()) {
            return false;
        }
        return apkFile.isFile() && apkFile.getName().toLowerCase().endsWith(".apk");
    }

    public String[][] getBootsCellData() {
        if (this.textWidth.getText() == null || this.textWidth.getText().trim().equals("") || this.textHeight.getText() == null || this.textHeight.getText().trim().equals("") || this.textFrameNumPerSec.getText() == null || this.textFrameNumPerSec.getText().trim().equals("")) {
            return null;
        }
        int x = this.table.getRowCount();
        int y = this.table.getColumnCount();
        String[][] data = new String[x][y];
        int i = 0;
        while (i < x) {
            int j = 0;
            while (j < y) {
                String str = (String)this.table.getModel().getValueAt(i, j);
                if (str == null || str.equals("")) {
                    return null;
                }
                if (!(j != 1 && j != 2 || this.isAllDigit(str))) {
                    return null;
                }
                data[i][j] = str;
                ++j;
            }
            ++i;
        }
        return data;
    }

    private boolean checkwhf() {
        if (this.textWidth.getText() == null || this.textWidth.getText().trim().equals("") || this.textHeight.getText() == null || this.textHeight.getText().trim().equals("") || this.textFrameNumPerSec.getText() == null || this.textFrameNumPerSec.getText().trim().equals("")) {
            return false;
        }
        try {
            Integer.parseInt(this.textWidth.getText().trim());
            Integer.parseInt(this.textHeight.getText().trim());
            Integer.parseInt(this.textFrameNumPerSec.getText().trim());
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private boolean checkAllCells() {
        int x = this.table.getRowCount();
        int y = this.table.getColumnCount();
        int i = 0;
        while (i < x) {
            int j = 0;
            while (j < y) {
                String str = (String)this.table.getModel().getValueAt(i, j);
                if (str == null || str.equals("")) {
                    return false;
                }
                if (!(j != 1 && j != 2 || this.isAllDigit(str))) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    private void updateBootsData(int r) {
        int rCnt = this.table.getRowCount();
        int colCnt = this.table.getColumnCount();
        String[][] d = new String[rCnt][colCnt];
        int i = 0;
        while (i < rCnt) {
            int j = 0;
            while (j < colCnt) {
                d[i][j] = (String)this.bootsAnimationModel.getValueAt(i, j);
                ++j;
            }
            ++i;
        }
        this.data = d;
    }

    private void saveBootsData() {
        int x = this.table.getRowCount();
        int y = this.table.getColumnCount();
        int i = 0;
        while (i < x) {
            int j = 0;
            while (j < y) {
                this.data[i][j] = (String)this.table.getModel().getValueAt(i, j);
                ++j;
            }
            ++i;
        }
    }

    private void writeToBootsDescFile(FileOutputStream out) throws IOException {
        out.write(this.textWidth.getText().trim().getBytes());
        out.write(32);
        out.write(this.textHeight.getText().trim().getBytes());
        out.write(32);
        out.write(this.textFrameNumPerSec.getText().trim().getBytes());
        out.write(13);
        out.write(10);
        int i = 0;
        while (i < this.folderNum) {
            out.write(112);
            out.write(32);
            out.write(this.data[i][1].getBytes());
            out.write(32);
            out.write(this.data[i][2].getBytes());
            out.write(32);
            out.write(this.data[i][0].getBytes());
            out.write(13);
            out.write(10);
            ++i;
        }
        out.close();
    }

    private boolean isAllDigit(String str) {
        if (str == null || str.trim().equals("")) {
            return false;
        }
        char[] arr = str.toCharArray();
        int i = 0;
        while (i < arr.length) {
            if (!Character.isDigit(arr[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean saveDescriptionPane() throws TransformerFactoryConfigurationError {
        String str = ThemeHelper.sThemeFolderPath.trim();
        if (!new File(str).exists() || !new File(str).isDirectory()) {
            JOptionPane.showMessageDialog(this.mEditThemePane, ResourceFactory.getString("global_no_theme"));
            return false;
        }
        String title = this.textTitle.getText().trim();
        String designer = this.textDesigner.getText().trim();
        String author = this.textAuthor.getText().trim();
        String version = this.textVersion.getText().trim();
        String uiVersion = ThemeHelper.UI_VERSION_VALUE[this.textUIVersion.getSelectedIndex()];
        if (title.equals("") || designer.equals("") || author.equals("") || version.equals("") || uiVersion.equals("")) {
            this.mEditThemePane.setSelectedIndex(0);
            JOptionPane.showMessageDialog(this.mEditThemePane, ResourceFactory.getString("desc_no_black"));
            return false;
        }
        try {
            File descFile = new File(String.valueOf(str) + File.separator + "description.xml");
            if (!descFile.exists()) {
                descFile.createNewFile();
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.newDocument();
            Element root = doc.createElement("MIUI-Theme");
            doc.appendChild(root);
            Element e1 = doc.createElement("title");
            e1.appendChild(doc.createTextNode(title));
            root.appendChild(e1);
            Element e2 = doc.createElement("designer");
            e2.appendChild(doc.createTextNode(designer));
            root.appendChild(e2);
            Element e3 = doc.createElement("author");
            e3.appendChild(doc.createTextNode(author));
            root.appendChild(e3);
            Element e4 = doc.createElement("version");
            e4.appendChild(doc.createTextNode(version));
            root.appendChild(e4);
            Element e5 = doc.createElement("uiVersion");
            e5.appendChild(doc.createTextNode(uiVersion));
            root.appendChild(e5);
            TransformerFactory tfFac = TransformerFactory.newInstance();
            Transformer tf = tfFac.newTransformer();
            StreamResult result = new StreamResult(descFile);
            DOMSource source = new DOMSource(doc);
            tf.setOutputProperty("version", "1.0");
            tf.setOutputProperty("encoding", "utf-8");
            tf.transform(source, result);
            ThemeHelper.sThemeVersion = Integer.parseInt(uiVersion);
            return true;
        }
        catch (Exception ee) {
            ee.printStackTrace();
            return false;
        }
    }

    private String getSelectedPackageName() {
        return ThemeHelper.clearDesc(this.boxItem.getSelectedItem().toString());
    }

    private boolean saveEditItemPane() {
        String packageName = this.getSelectedPackageName();
        if (packageName.trim().equals("")) {
            return true;
        }
        File theme_value_file = new File(String.valueOf(ThemeHelper.sThemeFolderPath) + File.separator + packageName + File.separator + "theme_values.xml");
        if (packageName == null || "".equals(packageName.trim())) {
            return true;
        }
        if (packageName != null && !"".equals(packageName)) {
            packageName = ThemeHelper.clearDesc(packageName);
        }
        logger.info(theme_value_file.getAbsolutePath());
        if (this.mModuleTable.getCellEditor() != null) {
            this.mModuleTable.getCellEditor().stopCellEditing();
        }
        this.saveXml(theme_value_file.getAbsolutePath());
        return true;
    }

    private boolean saveBootsPane() {
        if (!this.bootsExist) {
            return true;
        }
        if (this.mEditThemePane.getSelectedIndex() != 3) {
            return true;
        }
        if (this.table.getModel().getRowCount() <= 0) {
            return true;
        }
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().stopCellEditing();
        }
        if (!this.checkwhf()) {
            JOptionPane.showMessageDialog(null, ResourceFactory.getString("boot_config_save_tip_illegal_whf"));
            return false;
        }
        if (!this.checkAllCells()) {
            this.mEditThemePane.setSelectedIndex(3);
            JOptionPane.showMessageDialog(null, ResourceFactory.getString("boot_config_save_tip_illegal_table"));
            return false;
        }
        this.saveBootsData();
        boolean flag = true;
        try {
            try {
                FileOutputStream out = new FileOutputStream(String.valueOf(ThemeHelper.sThemeFolderPath) + File.separator + "boots" + File.separator + "bootanimation" + File.separator + "desc.txt");
                this.writeToBootsDescFile(out);
            }
            catch (IOException e1) {
                flag = false;
                e1.printStackTrace();
            }
        }
        catch (Throwable throwable) {}
        if (flag) {
            return true;
        }
        this.bootsSaveState.setText(ResourceFactory.getString("global_saved_failed"));
        return false;
    }

    public boolean saveAllData() {
        boolean flag0 = this.saveDescriptionPane();
        boolean flag2 = this.saveEditItemPane();
        boolean flag3 = this.saveBootsPane();
        boolean flag4 = this.saveScenePane();
        if (!flag4) {
            this.mEditThemePane.setSelectedIndex(4);
        }
        if (!flag3) {
            this.mEditThemePane.setSelectedIndex(3);
        }
        if (!flag2) {
            this.mEditThemePane.setSelectedIndex(2);
        }
        if (!flag0) {
            this.mEditThemePane.setSelectedIndex(0);
        }
        return flag0 && flag2 && flag3 && flag4;
    }

    private boolean saveScenePane() {
        block5: {
            try {
                if (this.mEditThemePane.getSelectedIndex() == 4) break block5;
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        if (this.mScenePane instanceof TextEditorView) {
            ((TextEditorView)this.mScenePane).save();
        }
        if (this.mScenePane instanceof FreeStylePanel) {
            ((FreeStylePanel)this.mScenePane).save();
        }
        return true;
    }

    class DirectoryFileFilter
    implements FileFilter {
        DirectoryFileFilter() {
        }

        @Override
        public boolean accept(File arg0) {
            return arg0.isDirectory();
        }
    }

    private class ImportOneItemThread
    extends Thread {
        protected File mApkFile;
        protected String mPackageName;
        private boolean isFromComputerApk = false;
        private Member mMember;

        public ImportOneItemThread(String itemName) {
            String sKey = null;
            if (ThemeEditPanel.this.mHashMapApp == null) {
                try {
                    ThemeEditPanel.this.mHashMapApp = ApkSelectDialog.getHashMapApps(null, null);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            sKey = itemName.substring(0, itemName.indexOf(40));
            sKey = sKey.trim();
            this.mMember = (Member)ThemeEditPanel.this.mHashMapApp.get(sKey);
            this.mPackageName = this.mMember.mPackageName;
        }

        private void loadPackageName() {
            CmdUtils.aapt_dump_resources(this.mApkFile);
            this.mPackageName = CmdUtils.aapt_get_package_name(this.mApkFile);
            if ("android".equals(this.mPackageName)) {
                this.mPackageName = "framework-res";
            }
            if ("miui".equals(this.mPackageName)) {
                this.mPackageName = "framework-miui-res";
            }
            logger.debug("package name:" + this.mPackageName);
        }

        public ImportOneItemThread(File apkFile) {
            this.mApkFile = apkFile;
            this.loadPackageName();
        }

        @Override
        public void run() {
            ThemeEditPanel.this.mEditThemePane.setCursor(new Cursor(3));
            ThemeEditPanel.this.mModuleState.setText(ResourceFactory.getString("item_edit_import_fetching"));
            if (!this.importApkToCatalog(this.isFromComputerApk)) {
                return;
            }
            ThemeEditPanel.this.mEditThemePane.setCursor(new Cursor(0));
            if (!this.isFromComputerApk) {
                OS.rmFile(String.valueOf(ThemeEditPanel.this.userDir) + File.separator + new File(this.mMember.mLocation).getName());
            }
            ThemeEditPanel.this.mEditThemePane.setCursor(new Cursor(0));
        }

        private boolean importApkToCatalog(boolean isFromComputerApk) {
            String resourceLibPath = ThemeHelper.getImportResourceCatalogPath();
            if (!isFromComputerApk) {
                String name = new File(this.mMember.mLocation).getName();
                ThemeEditPanel.this.mModuleState.setText(String.valueOf(ResourceFactory.getString("item_edit_import_from_phone")) + name);
                boolean flag = CmdUtils.adb_pull(this.mMember.mLocation);
                this.mApkFile = new File(String.valueOf(ThemeEditPanel.this.userDir) + File.separator + name);
                if (!flag) {
                    logger.error("adb pull apk file error.");
                    ThemeEditPanel.this.mModuleState.setText("adb pull error.");
                    ThemeEditPanel.this.mEditThemePane.setCursor(new Cursor(0));
                    return false;
                }
                CmdUtils.aapt_dump_resources(this.mApkFile);
                ThemeEditPanel.this.mModuleState.setText(ResourceFactory.getString("item_edit_import_apk_ok"));
            }
            String resourceLibPackagePath = String.valueOf(resourceLibPath) + File.separator + this.mPackageName;
            Extractor ext = new Extractor(this.mApkFile.getAbsolutePath(), resourceLibPackagePath);
            ext.unzipApkRes();
            ThemeEditPanel.this.mModuleState.setText(ResourceFactory.getString("item_edit_import_decoding_png"));
            NinePatchUtils.decompile(resourceLibPackagePath);
            String catalogName = new File(resourceLibPath).getName();
            ThemeEditPanel.this.mModuleState.setText(String.valueOf(catalogName) + File.separator + this.mPackageName + " " + ResourceFactory.getString("item_edit_import_complete"));
            ThemeValue valueUtil = new ThemeValue(String.valueOf(ThemeEditPanel.this.userDir) + File.separator + "values.txt", String.valueOf(resourceLibPackagePath) + File.separator + "theme_values.xml");
            valueUtil.generateThemeValuesXml();
            OS.rmFile(String.valueOf(ThemeEditPanel.this.userDir) + File.separator + "values.txt");
            OS.rmFile(this.mApkFile.getAbsolutePath());
            return true;
        }
    }

    class MyKeyListener
    implements KeyListener {
        private boolean flag = true;

        public MyKeyListener() {
        }

        public MyKeyListener(boolean f) {
            this.flag = f;
        }

        @Override
        public void keyPressed(KeyEvent arg0) {
        }

        @Override
        public void keyReleased(KeyEvent arg0) {
        }

        @Override
        public void keyTyped(KeyEvent event) {
            char ch = event.getKeyChar();
            if (this.flag) {
                if (ch < '0' || ch > '9') {
                    event.consume();
                }
            } else if (ch != ' ') {
                event.consume();
            }
        }
    }
}

