/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.gui;

import com.miui.theme.tool.gui.MainFrame;
import com.miui.theme.tool.init.ColorFile;
import com.miui.theme.tool.init.InitData;
import com.miui.theme.tool.init.ThemeInitHelperManager;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.util.GridBagHelper;
import com.miui.theme.tool.util.ThemeHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class ThemeInitHelperDialog
extends JDialog
implements ActionListener {
    public static final int DIALOG_WIDTH = 900;
    public static final int DIALOG_HEIGHT = 600;
    private JButton mTestButton;
    private JButton mGenerateButton;
    private JTabbedPane mPreviewTab;
    private JPanel mMainPanel;
    private JPanel mEditPanel;
    private InitData mInitData;
    private HashMap<String, JTextField> mColorField;
    private JButton mCancelButton;

    public ThemeInitHelperDialog() {
        this.setModal(true);
        MainFrame mainFrame = MainFrame.getInstance();
        this.setTitle(ResourceFactory.getString("theme_init_helper"));
        this.setBounds(mainFrame.getX() + (mainFrame.getWidth() - 900) / 2, mainFrame.getY() + (mainFrame.getHeight() - 600) / 2, 900, 600);
        this.initData();
        this.mTestButton = new JButton(ResourceFactory.getString("apply_to_phone_test"));
        this.mTestButton.addActionListener(this);
        this.mGenerateButton = new JButton(ResourceFactory.getString("generate"));
        this.mGenerateButton.addActionListener(this);
        this.mCancelButton = new JButton(ResourceFactory.getString("global_cancel"));
        this.mCancelButton.addActionListener(this);
        this.mMainPanel = new JPanel();
        this.initMainPanel();
        this.setLayout(new GridBagLayout());
        int x = 0;
        int y = 0;
        int gap = 0;
        int len = 2;
        GridBagHelper.addComponent(this.getContentPane(), this.mMainPanel, x, y, len, 1, 0, 0, gap, gap, 1.0, 1.0, 1, 10);
        GridBagHelper.addComponent(this.getContentPane(), this.mTestButton, x, ++y, len, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 10);
        GridBagHelper.addComponent(this.getContentPane(), this.mGenerateButton, x, ++y, 1, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 10);
        GridBagHelper.addComponent(this.getContentPane(), this.mCancelButton, ++x, y, 1, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 10);
        this.setVisible(true);
    }

    private void initData() {
        this.mInitData = ThemeInitHelperManager.getInitData();
    }

    private void initMainPanel() {
        int x = 0;
        int y = 0;
        int gap = 20;
        this.mMainPanel.setLayout(new GridBagLayout());
        this.mPreviewTab = new JTabbedPane();
        for (String key : this.mInitData.mPreview.keySet()) {
            this.mPreviewTab.addTab(key, new ShowPreviewPanel(this.mInitData.mPreview.get(key)));
        }
        this.initEditPanel();
        GridBagHelper.addComponent(this.mMainPanel, this.mPreviewTab, x, y, 1, 1, 0, 0, gap, gap, 1.0, 1.0, 0, 17);
        GridBagHelper.addComponent(this.mMainPanel, this.mEditPanel, ++x, y, 1, 1, 0, 0, gap, gap, 1.0, 1.0, 1, 10);
    }

    private void initEditPanel() {
        this.mEditPanel = new JPanel();
        this.mEditPanel.setLayout(new GridBagLayout());
        int x = 0;
        int y = 0;
        int gap = 20;
        this.mColorField = new HashMap();
        for (String key : this.mInitData.mColorFileMap.keySet()) {
            ColorFile cf = this.mInitData.mColorFileMap.get(key);
            JTextField jtf = new JTextField();
            jtf.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getClickCount() > 1) {
                        return;
                    }
                    JTextField source = (JTextField)e.getSource();
                    Color color = JColorChooser.showDialog(MainFrame.getInstance(), "change color", GUIUtil.hex2color(source.getText()));
                    if (color != null) {
                        source.setText(GUIUtil.color2hexNoAlpha(color));
                    }
                }
            });
            JLabel jl = new JLabel(cf.mName);
            jl.setBackground(GUIUtil.hex2color(cf.mShowColor));
            jtf.setText(cf.mShowColor);
            jl.setOpaque(true);
            this.mColorField.put(cf.mColor, jtf);
            x = 0;
            GridBagHelper.addComponent(this.mEditPanel, jl, x, y, 1, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 17);
            GridBagHelper.addComponent(this.mEditPanel, jtf, ++x, y, 1, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 10);
            ++y;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.mTestButton)) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.generateThemePackage();
            MainFrame.getInstance().applyTheme(true);
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        if (e.getSource().equals(this.mGenerateButton)) {
            this.generateThemePackage();
            this.dispose();
        }
        if (e.getSource().equals(this.mCancelButton)) {
            this.dispose();
        }
    }

    public void generateThemePackage() {
        HashMap<String, String> colorMap = new HashMap<String, String>();
        for (String key : this.mColorField.keySet()) {
            String colorString = this.mColorField.get(key).getText();
            Color color = GUIUtil.hex2color(colorString);
            if (color == null) continue;
            colorMap.put(key, colorString);
        }
        ThemeInitHelperManager.generateInitPackage(ThemeHelper.getS_themeFolderPath(), colorMap, this.mInitData);
    }

    class ShowPreviewPanel
    extends JPanel {
        public ShowPreviewPanel(String name) {
            File f = new File(String.valueOf(ThemeInitHelperManager.getDataInitFolder()) + File.separator + name);
            this.setLayout(new BorderLayout());
            this.add((Component)new JLabel(GUIUtil.getIcon(f, 480, 4)), "Center");
        }
    }
}

