/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.init;

import com.miui.theme.tool.util.JPEGOutputUtil;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.HashSet;
import javax.imageio.ImageIO;

public class ThemeInitUtil {
    public static void getFileSet(File replaceFolder, HashSet<String> fileSet) {
        File[] files = replaceFolder.listFiles();
        if (files == null) {
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            fileSet.add(file.getAbsolutePath());
            if (file.isDirectory()) {
                ThemeInitUtil.getFileSet(file, fileSet);
            }
            ++n2;
        }
    }

    public static String assurePath(String path) {
        return ThemeInitUtil.assurePath(path, File.separator);
    }

    public static String assurePath(String path, String sep) {
        path = path.replace("\\", sep);
        path = path.replace("/", sep);
        return path;
    }

    public static void copyFile(File sourceFile, File targetFile) throws IOException {
        BufferedInputStream inBuff = null;
        FilterOutputStream outBuff = null;
        FileInputStream fis = null;
        FileOutputStream fos = null;
        targetFile.getParentFile().mkdirs();
        try {
            int len;
            fis = new FileInputStream(sourceFile);
            inBuff = new BufferedInputStream(fis);
            fos = new FileOutputStream(targetFile);
            outBuff = new BufferedOutputStream(fos);
            byte[] b = new byte[5120];
            while ((len = inBuff.read(b)) != -1) {
                ((BufferedOutputStream)outBuff).write(b, 0, len);
            }
            ((BufferedOutputStream)outBuff).flush();
            fos.close();
        }
        finally {
            if (inBuff != null) {
                inBuff.close();
                fis.close();
            }
            if (outBuff != null) {
                outBuff.close();
                fos.close();
            }
        }
    }

    public static Color hex2color(String colorStr) {
        if (colorStr == null) {
            return null;
        }
        if (!colorStr.startsWith("#")) {
            return null;
        }
        if (colorStr.length() == 7) {
            return new Color(Integer.valueOf(colorStr.substring(1, 3), 16), Integer.valueOf(colorStr.substring(3, 5), 16), Integer.valueOf(colorStr.substring(5, 7), 16));
        }
        if (colorStr.length() == 9) {
            return new Color(Integer.valueOf(colorStr.substring(3, 5), 16), Integer.valueOf(colorStr.substring(5, 7), 16), Integer.valueOf(colorStr.substring(7, 9), 16), Integer.valueOf(colorStr.substring(1, 3), 16));
        }
        return null;
    }

    public static String color2hex(Color color) {
        StringBuffer sb = new StringBuffer();
        String A = Integer.toHexString(color.getAlpha());
        String R = Integer.toHexString(color.getRed());
        String G = Integer.toHexString(color.getGreen());
        String B = Integer.toHexString(color.getBlue());
        A = A.length() == 1 ? "0" + A : A;
        R = R.length() == 1 ? "0" + R : R;
        G = G.length() == 1 ? "0" + G : G;
        B = B.length() == 1 ? "0" + B : B;
        sb.append("#");
        sb.append(A);
        sb.append(R);
        sb.append(G);
        sb.append(B);
        return sb.toString();
    }

    public static String color2hexNoAlpha(Color color) {
        StringBuffer sb = new StringBuffer();
        String R = Integer.toHexString(color.getRed());
        String G = Integer.toHexString(color.getGreen());
        String B = Integer.toHexString(color.getBlue());
        R = R.length() == 1 ? "0" + R : R;
        G = G.length() == 1 ? "0" + G : G;
        B = B.length() == 1 ? "0" + B : B;
        sb.append("#");
        sb.append(R);
        sb.append(G);
        sb.append(B);
        return sb.toString();
    }

    public static void saveImage(BufferedImage bi, File f) {
        ThemeInitUtil.saveImage(bi, f, 1.0f);
    }

    public static void saveImage(BufferedImage bi, File f, float quality) {
        try {
            f.getParentFile().mkdirs();
            String filePath = f.getAbsolutePath();
            if (filePath.endsWith(".jpg")) {
                JPEGOutputUtil.compressJpegFile(f, bi, quality);
            } else if (filePath.endsWith(".png")) {
                FileOutputStream fos = new FileOutputStream(f);
                if (!ImageIO.write((RenderedImage)bi, "PNG", fos)) {
                    fos.close();
                    throw new IOException("Failed to find png writer");
                }
                fos.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static BufferedImage getImage(File f) {
        if (!f.exists()) {
            return null;
        }
        try {
            FileInputStream fis = new FileInputStream(f);
            BufferedImage image = ImageIO.read(fis);
            fis.close();
            return image;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

