/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.schema;

import com.miui.theme.tool.schema.Attribute;
import com.miui.theme.tool.schema.Description;
import com.miui.theme.tool.schema.SchemaElement;
import com.miui.theme.tool.schema.Variable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Schema {
    private String mContextFile = new String("data" + File.separator + "schema.xml");
    private ArrayList<SchemaElement> mTable = new ArrayList();
    private ArrayList<Variable> mVariableList = new ArrayList();
    private Description mDescription;
    private static Schema mSchema = null;

    public static Schema getInstance() {
        if (mSchema == null) {
            mSchema = new Schema();
            return mSchema;
        }
        return mSchema;
    }

    private Schema() {
        this.load_Element();
        this.load_Variables();
        this.mDescription = Description.getInstance();
    }

    private void load_Element() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Element theElem = null;
        Element root = null;
        try {
            factory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder db = factory.newDocumentBuilder();
            Document xmldoc = db.parse(new File(this.mContextFile));
            root = xmldoc.getDocumentElement();
            NodeList elements = root.getElementsByTagName("Elements");
            Element rootElement = (Element)elements.item(0);
            NodeList roots = rootElement.getElementsByTagName("Element");
            int i = 0;
            while (i < roots.getLength()) {
                theElem = (Element)roots.item(i);
                this.loadElement(theElem);
                ++i;
            }
            for (SchemaElement anEle : this.mTable) {
                for (SchemaElement.Childs child : anEle.getChilds()) {
                    boolean hasAlias = child.getAlias() == null;
                    for (SchemaElement schema : this.mTable) {
                        if (!schema.getName().equals(child.getName()) || !hasAlias && !schema.getAlias().equals(child.getAlias())) continue;
                        schema.setMaxCount(child.getMaxCount());
                        schema.setMinCount(child.getMinCount());
                        schema.setParentTag(anEle.getName());
                    }
                }
            }
            for (SchemaElement anEle : this.mTable) {
                if (anEle.getParent() == null) continue;
                this.addParent(anEle);
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void load_Variables() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Element theElem = null;
        Element root = null;
        factory.setIgnoringElementContentWhitespace(true);
        try {
            DocumentBuilder db = factory.newDocumentBuilder();
            Document xmldoc = db.parse(new File(this.mContextFile));
            root = xmldoc.getDocumentElement();
            NodeList elements = root.getElementsByTagName("Variables");
            Element rootElement = (Element)elements.item(0);
            NodeList list = rootElement.getElementsByTagName("Variable");
            int length = list.getLength();
            int i = 0;
            while (i < length) {
                theElem = (Element)list.item(i);
                String name = theElem.getAttribute("name");
                String isAttribute = theElem.getAttribute("isAttribute");
                Variable var = new Variable(name);
                if (isAttribute.equals("true")) {
                    var.setAttribute(true);
                }
                this.mVariableList.add(var);
                ++i;
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ArrayList<SchemaElement> getTable() {
        return this.mTable;
    }

    public void setTable(ArrayList<SchemaElement> mTable) {
        this.mTable = mTable;
    }

    private void loadElement(Element theElem) {
        String eleName = theElem.getAttribute("name");
        String eleParent = theElem.getAttribute("parent");
        String alias = theElem.getAttribute("alias");
        SchemaElement ele = null;
        ele = new SchemaElement(eleName, eleParent);
        if (!alias.equals("")) {
            ele.setAlias(alias);
        }
        NodeList attributes = theElem.getElementsByTagName("Attribute");
        int attributeCount = attributes.getLength();
        int j = 0;
        while (j < attributeCount) {
            Element attribute = (Element)attributes.item(j);
            String name = attribute.getAttribute("name");
            String type = attribute.getAttribute("type");
            String necessary = attribute.getAttribute("isNecessary");
            String id = attribute.getAttribute("id");
            String options = attribute.getAttribute("options");
            String rely_on_type = attribute.getAttribute("rely_on_type");
            Attribute atr = new Attribute(name, type);
            if (necessary.equals("true")) {
                atr.setNecessary(true);
            }
            if (!options.equals("")) {
                atr.setOptions(options.split("\\|"));
            }
            if (!rely_on_type.equals("")) {
                atr.setRely_on_type(rely_on_type.split("\\|"));
            }
            atr.setId(id);
            ele.addAtribute(atr);
            ++j;
        }
        NodeList childs = theElem.getElementsByTagName("SubElement");
        int childsCount = childs.getLength();
        int z = 0;
        while (z < childsCount) {
            Element child = (Element)childs.item(z);
            String childName = child.getAttribute("name");
            String subAlias = child.getAttribute("alias");
            String max = child.getAttribute("maxCount");
            String min = child.getAttribute("minCount");
            String id = child.getAttribute("id");
            SchemaElement.Childs achild = null;
            achild = new SchemaElement.Childs(childName, subAlias);
            if (!max.equals("")) {
                achild.setMaxCount(Integer.valueOf(max));
            }
            if (!min.equals("")) {
                achild.setMinCount(Integer.valueOf(min));
            }
            achild.setId(id);
            ele.addChilds(achild);
            ++z;
        }
        this.mTable.add(ele);
    }

    private void addParent(SchemaElement anEle) {
        if (anEle == null || anEle.getParent() == null) {
            return;
        }
        if (!anEle.getmFlag()) {
            SchemaElement parent = null;
            String parentName = anEle.getParent();
            for (SchemaElement schemaElement : this.mTable) {
                if (parentName != schemaElement.getName()) continue;
                parent = schemaElement;
                break;
            }
            this.addParent(parent);
        }
        ArrayList<Object> atrs = new ArrayList();
        ArrayList<Object> childs = new ArrayList();
        atrs = this.fetchAtributes(anEle.getParent());
        for (Attribute attribute : atrs) {
            anEle.getAtributes().add(attribute);
        }
        childs = this.fetchChilds(anEle.getParent());
        for (SchemaElement.Childs childs2 : childs) {
            anEle.getChilds().add(childs2);
        }
    }

    public ArrayList<Attribute> fetchAtributes(String name) {
        ArrayList<Attribute> atrs = new ArrayList<Attribute>();
        for (SchemaElement ele : this.mTable) {
            if (!ele.getName().equals(name)) continue;
            return ele.getAtributes();
        }
        if (atrs.size() == 0) {
            return null;
        }
        return atrs;
    }

    public ArrayList<Attribute> fetchAtributes(String name, String parent) {
        ArrayList<Attribute> atrs = new ArrayList<Attribute>();
        for (SchemaElement ele : this.mTable) {
            if (ele.getParentTag() == null || !ele.getName().equals(name) || !this.fetchParentTag(ele.getParentTag(), null).equals(this.fetchParentTag(parent, null))) continue;
            return ele.getAtributes();
        }
        if (atrs.size() == 0) {
            return null;
        }
        return atrs;
    }

    public ArrayList<SchemaElement.Childs> fetchChilds(String name, String parent) {
        ArrayList<SchemaElement.Childs> childs = new ArrayList<SchemaElement.Childs>();
        for (SchemaElement ele : this.mTable) {
            if (ele.getParentTag() == null || !ele.getName().equals(name) || !ele.getParentTag().equals(parent)) continue;
            for (SchemaElement.Childs child : ele.getChilds()) {
                childs.add(child);
            }
        }
        return childs;
    }

    public ArrayList<SchemaElement.Childs> fetchChilds(String name) {
        ArrayList<SchemaElement.Childs> childs = new ArrayList<SchemaElement.Childs>();
        int i = 0;
        while (i < this.mTable.size()) {
            SchemaElement ele = this.mTable.get(i);
            if (ele.getName().equals(name)) {
                for (SchemaElement.Childs child : ele.getChilds()) {
                    childs.add(child);
                }
            }
            ++i;
        }
        return childs;
    }

    public int tagLength(String name) {
        int count = 0;
        for (SchemaElement sch : this.mTable) {
            if (!sch.getName().equals(name)) continue;
            ++count;
        }
        return count;
    }

    public String fetchAttrDescription(String name, String atr) {
        for (SchemaElement ele : this.mTable) {
            if (!ele.getName().equals(name)) continue;
            for (Attribute attr : ele.getAtributes()) {
                if (!attr.getName().equals(atr)) continue;
                return this.mDescription.fetchDescription(attr.getId());
            }
        }
        return null;
    }

    public String fetchChildDescription(String name, String parent, String child) {
        for (SchemaElement ele : this.mTable) {
            if (!ele.getName().equals(name) || !ele.getParentTag().equals(parent)) continue;
            for (SchemaElement.Childs achild : ele.getChilds()) {
                if (!achild.getName().equals(child)) continue;
                return this.mDescription.fetchDescription(achild.getId());
            }
        }
        return null;
    }

    public String fetchChildDescription(String name, String child) {
        for (SchemaElement ele : this.mTable) {
            if (!ele.getName().equals(name)) continue;
            for (SchemaElement.Childs achild : ele.getChilds()) {
                if (!achild.getName().equals(child)) continue;
                return this.mDescription.fetchDescription(achild.getId());
            }
        }
        return null;
    }

    public boolean inSchema(String name) {
        if (this.mTable == null || name == null) {
            return false;
        }
        for (SchemaElement ele : this.mTable) {
            if (!ele.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private String fetchParentTag(String name, String alias) {
        for (SchemaElement ele : this.mTable) {
            if (!name.equals(ele.getName()) || alias != null && !alias.equals(ele.getAlias())) continue;
            if (ele.getParent() != null) {
                return this.fetchParentTag(ele.getParent(), null);
            }
            return name;
        }
        return null;
    }

    public void display() {
        int i = 0;
        while (i < this.mTable.size()) {
            System.out.println();
            System.out.println();
            System.out.println(this.mTable.get(i).getName());
            if (this.mTable.get(i).getAlias() != null) {
                System.out.println("alias:  " + this.mTable.get(i).getAlias());
            }
            System.out.println("parrent:  " + this.mTable.get(i).getParent());
            System.out.println("parrentTag:  " + this.mTable.get(i).getParentTag());
            System.out.println("maxCount:  " + this.mTable.get(i).getMaxCount());
            System.out.println("minCount:  " + this.mTable.get(i).getMinCount());
            System.out.print("      ");
            System.out.println("Atributes");
            for (Attribute atr : this.mTable.get(i).getAtributes()) {
                System.out.print("      ");
                System.out.println(String.valueOf(atr.getName()) + "  :  " + atr.getType());
            }
            System.out.println();
            System.out.print("      ");
            System.out.println("Childs");
            for (SchemaElement.Childs child : this.mTable.get(i).getChilds()) {
                System.out.print("      ");
                System.out.println(child.getName());
            }
            ++i;
        }
    }

    public ArrayList<Variable> getmVariableList() {
        return this.mVariableList;
    }

    public static void main(String[] args) {
        Schema mSchema = new Schema();
        mSchema.display();
    }
}

